/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-11-19 09:11:14 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;

CREATE TABLE IF NOT EXISTS `mod119_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `mod119_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=105 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `mod119_actionscheduler_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint unsigned NOT NULL DEFAULT '10',
  `args` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint unsigned NOT NULL DEFAULT '0',
  `attempts` int NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_priority_scheduled_date_gmt` (`claim_id`,`status`,`priority`,`scheduled_date_gmt`),
  KEY `status_last_attempt_gmt` (`status`,`last_attempt_gmt`),
  KEY `status_claim_id` (`status`,`claim_id`)
) ENGINE=InnoDB AUTO_INCREMENT=311 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `mod119_actionscheduler_claims` (
  `claim_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=29892 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `mod119_actionscheduler_groups` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `mod119_actionscheduler_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint unsigned NOT NULL,
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=254 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `mod119_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `mod119_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `mod119_duplicator_activity_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `sub_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `severity` int NOT NULL,
  `title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `version` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `sub_type_idx` (`sub_type`),
  KEY `severity_idx` (`severity`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `mod119_duplicator_backups` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `archive_name` varchar(350) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `status` int NOT NULL,
  `flags` set('MANUAL','SCHEDULE','SCHEDULE_RUN_NOW','DB_ONLY','MEDIA_ONLY','HAVE_LOCAL','HAVE_REMOTE','DISASTER_AVAIABLE','DISASTER_SET','CREATED_AFTER_RESTORE','ACTIVE','TEMPLATE','ZIP_ARCHIVE','DUP_ARCHIVE','TEMPORARY') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `package` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `version` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `hash` (`hash`),
  KEY `flags` (`flags`),
  KEY `version` (`version`),
  KEY `created` (`created`),
  KEY `updated_at` (`updated_at`),
  KEY `status` (`status`),
  KEY `name` (`name`(191)),
  KEY `archive_name` (`archive_name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `mod119_duplicator_entities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value_1` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_3` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_4` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_5` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `version` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`),
  KEY `value_1` (`value_1`(191)),
  KEY `value_2` (`value_2`(191)),
  KEY `value_3` (`value_3`(191)),
  KEY `value_4` (`value_4`(191)),
  KEY `value_5` (`value_5`(191))
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `mod119_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `mod119_masterslider_options` (
  `ID` smallint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `option_value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `mod119_masterslider_sliders` (
  `ID` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `alias` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `slides_num` smallint unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `params` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `custom_styles` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `custom_fonts` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'draft',
  PRIMARY KEY (`ID`),
  KEY `date_created` (`date_created`),
  KEY `alias` (`alias`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `mod119_maxbuttons_collections` (
  `meta_id` int NOT NULL AUTO_INCREMENT,
  `collection_id` int NOT NULL,
  `collection_key` varchar(255) DEFAULT NULL,
  `collection_value` text,
  PRIMARY KEY (`meta_id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE IF NOT EXISTS `mod119_maxbuttons_collections_trans` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(1000) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `expire` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE IF NOT EXISTS `mod119_maxbuttonsv3` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `status` varchar(10) NOT NULL DEFAULT 'publish',
  `cache` text,
  `responsive` text,
  `color` text,
  `basic` text,
  `dimension` text,
  `border` text,
  `gradient` text,
  `text` text,
  `container` text,
  `advanced` text,
  `meta` text,
  `updated` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE IF NOT EXISTS `mod119_nextend2_image_storage` (
  `id` int NOT NULL AUTO_INCREMENT,
  `hash` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `image` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `mod119_nextend2_section_storage` (
  `id` int NOT NULL AUTO_INCREMENT,
  `application` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `section` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `referencekey` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `isSystem` int NOT NULL DEFAULT '0',
  `editable` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `isSystem` (`isSystem`),
  KEY `editable` (`editable`),
  KEY `application` (`application`,`section`(50),`referencekey`(50)),
  KEY `application_2` (`application`,`section`(50))
) ENGINE=InnoDB AUTO_INCREMENT=12069 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `mod119_nextend2_smartslider3_generators` (
  `id` int NOT NULL AUTO_INCREMENT,
  `group` varchar(254) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(254) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `mod119_nextend2_smartslider3_sliders` (
  `id` int NOT NULL AUTO_INCREMENT,
  `alias` text COLLATE utf8mb4_unicode_520_ci,
  `title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `params` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `slider_status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'published',
  `time` datetime NOT NULL,
  `thumbnail` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `ordering` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `slider_status` (`slider_status`),
  KEY `time` (`time`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `mod119_nextend2_smartslider3_sliders_xref` (
  `group_id` int NOT NULL,
  `slider_id` int NOT NULL,
  `ordering` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`group_id`,`slider_id`),
  KEY `ordering` (`ordering`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `mod119_nextend2_smartslider3_slides` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` text COLLATE utf8mb4_unicode_520_ci,
  `slider` int NOT NULL,
  `publish_up` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `published` tinyint(1) NOT NULL,
  `first` int NOT NULL,
  `slide` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `thumbnail` text COLLATE utf8mb4_unicode_520_ci,
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `ordering` int NOT NULL,
  `generator_id` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `published` (`published`),
  KEY `publish_up` (`publish_up`),
  KEY `publish_down` (`publish_down`),
  KEY `generator_id` (`generator_id`),
  KEY `ordering` (`ordering`),
  KEY `slider` (`slider`),
  KEY `thumbnail` (`thumbnail`(100))
) ENGINE=InnoDB AUTO_INCREMENT=57 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `mod119_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=103453 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `mod119_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=1428 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `mod119_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=559 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `mod119_rank_math_internal_links` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  `target_post_id` bigint unsigned NOT NULL,
  `type` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `target_post_id` (`target_post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `mod119_rank_math_internal_meta` (
  `object_id` bigint unsigned NOT NULL,
  `internal_link_count` int unsigned DEFAULT '0',
  `external_link_count` int unsigned DEFAULT '0',
  `incoming_link_count` int unsigned DEFAULT '0',
  PRIMARY KEY (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `mod119_redirection_404` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL,
  `url` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `domain` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `agent` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `referrer` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `http_code` int unsigned NOT NULL DEFAULT '0',
  `request_method` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `request_data` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `ip` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `created` (`created`),
  KEY `referrer` (`referrer`(191)),
  KEY `ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `mod119_redirection_groups` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tracking` int NOT NULL DEFAULT '1',
  `module_id` int unsigned NOT NULL DEFAULT '0',
  `status` enum('enabled','disabled') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'enabled',
  `position` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `module_id` (`module_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `mod119_redirection_items` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `url` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `match_url` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `match_data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `regex` int unsigned NOT NULL DEFAULT '0',
  `position` int unsigned NOT NULL DEFAULT '0',
  `last_count` int unsigned NOT NULL DEFAULT '0',
  `last_access` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `group_id` int NOT NULL DEFAULT '0',
  `status` enum('enabled','disabled') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'enabled',
  `action_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `action_code` int unsigned NOT NULL,
  `action_data` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `match_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `url` (`url`(191)),
  KEY `status` (`status`),
  KEY `regex` (`regex`),
  KEY `group_idpos` (`group_id`,`position`),
  KEY `group` (`group_id`),
  KEY `match_url` (`match_url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `mod119_redirection_logs` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL,
  `url` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `domain` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `sent_to` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `agent` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `referrer` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `http_code` int unsigned NOT NULL DEFAULT '0',
  `request_method` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `request_data` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `redirect_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `redirection_id` int unsigned DEFAULT NULL,
  `ip` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `created` (`created`),
  KEY `redirection_id` (`redirection_id`),
  KEY `ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `mod119_revslider_css` (
  `id` int NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext,
  `hover` longtext,
  `advanced` longtext,
  `params` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=InnoDB AUTO_INCREMENT=110 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE IF NOT EXISTS `mod119_revslider_layer_animations` (
  `id` int NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE IF NOT EXISTS `mod119_revslider_navigations` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE IF NOT EXISTS `mod119_revslider_sliders` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` longtext NOT NULL,
  `settings` text,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE IF NOT EXISTS `mod119_revslider_sliders7` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` longtext NOT NULL,
  `settings` text,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE IF NOT EXISTS `mod119_revslider_slides` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slider_id` int NOT NULL,
  `slide_order` int NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE IF NOT EXISTS `mod119_revslider_slides7` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slider_id` int NOT NULL,
  `slide_order` int NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  `static` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE IF NOT EXISTS `mod119_revslider_static_slides` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slider_id` int NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE IF NOT EXISTS `mod119_sib_model_forms` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(120) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `html` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `css` longtext,
  `dependTheme` int NOT NULL DEFAULT '1',
  `listID` longtext,
  `templateID` int NOT NULL DEFAULT '-1',
  `confirmID` int NOT NULL DEFAULT '-1',
  `isDopt` int NOT NULL DEFAULT '0',
  `isOpt` int NOT NULL DEFAULT '0',
  `redirectInEmail` varchar(255) DEFAULT NULL,
  `redirectInForm` varchar(255) DEFAULT NULL,
  `successMsg` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `errorMsg` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `existMsg` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `invalidMsg` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `requiredMsg` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `attributes` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `date` date NOT NULL,
  `isDefault` int NOT NULL DEFAULT '0',
  `gCaptcha` int NOT NULL DEFAULT '0',
  `gCaptcha_secret` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `gCaptcha_site` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `selectCaptchaType` int NOT NULL DEFAULT '0',
  `cCaptchaType` int NOT NULL DEFAULT '0',
  `cCaptcha_secret` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `cCaptcha_site` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `cCaptchaStyle` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `termAccept` int NOT NULL DEFAULT '0',
  `termsURL` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE IF NOT EXISTS `mod119_sib_model_users` (
  `id` int NOT NULL AUTO_INCREMENT,
  `email` varchar(255) DEFAULT NULL,
  `code` varchar(100) DEFAULT NULL,
  `listIDs` longtext,
  `redirectUrl` varchar(255) DEFAULT NULL,
  `info` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `frmid` int DEFAULT NULL,
  `user_added_date` datetime NOT NULL,
  `doi_sent` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE IF NOT EXISTS `mod119_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `mod119_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `mod119_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `mod119_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/
INSERT IGNORE INTO `mod119_users` VALUES 
("1","admin4118","$wp$2y$12$mCeWXtlN73ON.k0.bjDr/./NqltGfFTDOr.SuiDU5mziibjvJCz7.","admin4118","mathias@hikory.fr","https://www.bowatts-beaujolais.fr","2025-09-03 20:26:48","","0","admin4118"),
("2","Admin_Sct","$wp$2y$12$P40b8ZUg/SfDfXkkntu/eOOvlgbdpNf6V5p8Ra7ld6rkrzkixkXba","admin_sct","marie@lasocietesecrete.fr","","2025-09-18 07:23:01","","0","Marie Coulomb"),
("3","BoWatts","$wp$2y$12$9Bt6pMh0Tbp4ZNrHB7nN2el/Ly5Kn5/9hHZMHayY9vP60uaKJmnTq","bowatts","info@bowatts.fr","","2025-09-18 07:27:14","","0","Marie-Maud Bonnet"),
("4","admin_ricom","$wp$2y$12$p2AGQaLAvTuEPySyOupdJ.IAjG5eFkg.RU4UFeD5bwWrQ7tfeJphS","admin_ricom","m.bonnet@ccsb-saonebeaujolais.fr","","2025-09-18 07:33:09","1758180789:$generic$nRwrbVRg0NkOev8SrmQ-CTPNLfjfbJ5fruEHwIcp","0","Marie-Maud Bonnet");

INSERT IGNORE INTO `mod119_usermeta` VALUES 
("1","1","nickname","admin4118"),
("2","1","first_name",""),
("3","1","last_name",""),
("4","1","description",""),
("5","1","rich_editing","true"),
("6","1","syntax_highlighting","true"),
("7","1","comment_shortcuts","false"),
("8","1","admin_color","fresh"),
("9","1","use_ssl","0"),
("10","1","show_admin_bar_front","true"),
("11","1","locale",""),
("12","1","mod119_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("13","1","mod119_user_level","10"),
("14","1","dismissed_wp_pointers","tp20_edit_context_menu,theme_editor_notice"),
("15","1","show_welcome_panel","1"),
("17","1","mod119_dashboard_quick_press_last_post_id","539"),
("18","1","community-events-location","a:1:{s:2:\"ip\";s:11:\"51.15.225.0\";}"),
("19","1","mod119_persisted_preferences","a:3:{s:4:\"core\";a:1:{s:26:\"isComplementaryAreaVisible\";b:1;}s:14:\"core/edit-post\";a:1:{s:12:\"welcomeGuide\";b:0;}s:9:\"_modified\";s:24:\"2025-09-04T12:43:24.637Z\";}"),
("20","1","mod119_user-settings","hidetb=1&libraryContent=browse&editor=tinymce"),
("21","1","mod119_user-settings-time","1757022214"),
("22","1","managenav-menuscolumnshidden","a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}"),
("23","1","metaboxhidden_nav-menus","a:7:{i:0;s:23:\"add-post-type-portfolio\";i:1;s:29:\"add-post-type-tatsu_gsections\";i:2;s:26:\"add-post-type-tatsu_header\";i:3;s:12:\"add-post_tag\";i:4;s:15:\"add-post_format\";i:5;s:24:\"add-portfolio_categories\";i:6;s:18:\"add-portfolio_tags\";}"),
("24","1","nav_menu_recently_edited","2"),
("26","1","closedpostboxes_wd_button","a:0:{}"),
("27","1","metaboxhidden_wd_button","a:1:{i:0;s:7:\"slugdiv\";}"),
("28","1","maxbuttons_review_notice","off"),
("29","1","mbsocial_review_notice","1757952625"),
("30","1","mod119_tablepress_user_options","{\"user_options_db_version\":119,\"admin_menu_parent_page\":\"middle\",\"message_first_visit\":true,\"message_superseded_extensions\":true,\"table_editor_column_width\":\"170\",\"table_editor_line_clamp\":\"5\"}"),
("31","1","managetablepress_listcolumnshidden","a:1:{i:0;s:22:\"table_last_modified_by\";}"),
("35","1","session_tokens","a:1:{s:64:\"d768ff519d38be1059b47105beea166dc3f3162c1b8745d58b123bef223531fd\";a:4:{s:10:\"expiration\";i:1763713985;s:2:\"ip\";s:13:\"51.15.225.198\";s:2:\"ua\";s:119:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/26.0.1 Safari/605.1.15\";s:5:\"login\";i:1763541185;}}"),
("36","2","nickname","Admin_Sct"),
("37","2","first_name","Marie"),
("38","2","last_name","Coulomb"),
("39","2","description",""),
("40","2","rich_editing","true"),
("41","2","syntax_highlighting","true"),
("42","2","comment_shortcuts","false"),
("43","2","admin_color","fresh"),
("44","2","use_ssl","0"),
("45","2","show_admin_bar_front","true"),
("46","2","locale",""),
("47","2","mod119_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("48","2","mod119_user_level","10"),
("49","2","dismissed_wp_pointers",""),
("51","2","maxbuttons_review_notice","1758266760"),
("52","2","mod119_dashboard_quick_press_last_post_id","431"),
("53","2","community-events-location","a:1:{s:2:\"ip\";s:20:\"2001:861:43c3:c690::\";}"),
("54","3","nickname","BoWatts"),
("55","3","first_name","Marie-Maud"),
("56","3","last_name","Bonnet"),
("57","3","description",""),
("58","3","rich_editing","true"),
("59","3","syntax_highlighting","true"),
("60","3","comment_shortcuts","false"),
("61","3","admin_color","fresh"),
("62","3","use_ssl","0"),
("63","3","show_admin_bar_front","true"),
("64","3","locale","fr_FR"),
("65","3","mod119_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("66","3","mod119_user_level","10"),
("67","3","dismissed_wp_pointers","msp_1_4_3__25samples,tp20_edit_context_menu"),
("68","2","session_tokens","a:1:{s:64:\"e60e94b10c0fdd299512fdbd4774f4d79721e338bd330ecf661197cf1381c76a\";a:4:{s:10:\"expiration\";i:1759909819;s:2:\"ip\";s:38:\"2001:861:43c3:c690:f5ed:196a:3eec:4b47\";s:2:\"ua\";s:117:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36\";s:5:\"login\";i:1759737019;}}"),
("69","4","nickname","admin_ricom"),
("70","4","first_name","Marie-Maud"),
("71","4","last_name","Bonnet"),
("72","4","description",""),
("73","4","rich_editing","true"),
("74","4","syntax_highlighting","true"),
("75","4","comment_shortcuts","false"),
("76","4","admin_color","fresh"),
("77","4","use_ssl","0"),
("78","4","show_admin_bar_front","true"),
("79","4","locale","fr_FR"),
("80","4","mod119_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("81","4","mod119_user_level","10"),
("82","4","dismissed_wp_pointers",""),
("83","3","session_tokens","a:2:{s:64:\"42e3422f95d6dfd7eb567987cb5eb0f0ae9f557e9951ccf848dd46672b5590b1\";a:4:{s:10:\"expiration\";i:1761220064;s:2:\"ip\";s:13:\"51.15.229.199\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36\";s:5:\"login\";i:1761047264;}s:64:\"a1e91eba954d37035449a38a5bad9ea37280f6c5585ac41758e015d75d8bbe35\";a:4:{s:10:\"expiration\";i:1761220074;s:2:\"ip\";s:13:\"51.15.229.199\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36\";s:5:\"login\";i:1761047274;}}"),
("84","3","maxbuttons_review_notice","1758289169"),
("85","3","mod119_dashboard_quick_press_last_post_id","487"),
("86","3","community-events-location","a:1:{s:2:\"ip\";s:11:\"51.15.229.0\";}"),
("87","3","mod119_persisted_preferences","a:3:{s:4:\"core\";a:1:{s:26:\"isComplementaryAreaVisible\";b:1;}s:9:\"_modified\";s:24:\"2025-09-18T13:55:15.601Z\";s:14:\"core/edit-post\";a:1:{s:12:\"welcomeGuide\";b:0;}}"),
("88","3","mod119_user-settings","editor=html&hidetb=1&libraryContent=browse"),
("89","3","mod119_user-settings-time","1761201328"),
("90","3","mod119_tablepress_user_options","{\"user_options_db_version\":117,\"admin_menu_parent_page\":\"middle\",\"message_first_visit\":true,\"message_superseded_extensions\":true,\"table_editor_column_width\":\"170\",\"table_editor_line_clamp\":\"5\"}"),
("91","3","managetablepress_listcolumnshidden","a:1:{i:0;s:22:\"table_last_modified_by\";}"),
("92","1","mod119_googlesitekit_tracking_optin","1"),
("93","1","mod119_googlesitekit_redirect_url","https://www.bowatts-beaujolais.fr/wp-admin/admin.php?page=googlesitekit-dashboard&slug=analytics-4&reAuth=true"),
("94","2","mod119_googlesitekit_access_token","576EmhQ4QLKQWmis9O2ad21Eclk2ZEFWNG9KOWl0d2QyOHBLVDIvc2hhUUV2Rmx4UGNxb2lXUTUwVy9YNlZHZFZxWmhPVTh3NFZwVXNjZjlyNnd2YUY3MkdzVmUyWExDZFFYT2Z0ZlZxVGNWRXczUlVKNUQ2U0hZeXdyczUyMENxeWJSYlVGVU1ObVllcWVqS2hLMkdQWThXZGg4cG5tbldMdkpNeVgrNWZZTnI4NkZnNTdMM25XYSs4M21zQnAvZWFPMUxyRE5vQkpzcGFZZWZIejl2NEczQldUUWZIRjJJZHdjcHNBSEpLMjZVcEIxZUVJTVlWRGNML0R6Vkp2WkRyY2l5VDJzUzEvKy9PTEN2MFBDSWI2YTBEWk10ZnN4dm5yQ2wvdXdDUEU4TlRuRDdmNW91aFBhWCs2WGhPak5HUHlWa1pCejMvUkRsTTduZWFRS3JodEs1clhNNXdGQzJFSXI4WW5qR0VnYWVmNXJTV24zS1p0RUxSYXo2VW9HRzg5YlhmWEFaM1g2Y3REcFcxWXFuL01FUEw0S2xmYTNRTkRCS0VzRUNCNnhaUkM5UHJVPQ=="),
("95","2","mod119_googlesitekit_access_token_expires_in","3599"),
("96","2","mod119_googlesitekit_access_token_created_at","1759823472"),
("97","2","mod119_googlesitekit_refresh_token","DPKSlDVcDtXzu8GYCIzD5E4rQzA4MTFmZWJydG1CNTJMWFdzeDhFYUViYXZDNTY0bW5VTndSN216MFBIUkFIcy94MUVFdzdKMUMyZFhqRXR2LzRpZTB6THlFVmxUR0htUXgzS0tlYnRmc3NsU1VpNHBveXVkN096dmdEajNVdmd4Q3dkRzVuODI3RE5UOUNxSmpsQjBWMFhJdmRlaUJyazJ1MjZUa2lYbjJTejZ3S3VIdURtUkRCQmcrYlFnZUpaVGw3UU5Ea1kreHdFMjh6dEttM295eDl3WmJrOFBqOFB5aGlXdmp1M1J0ZHhzcnhDRXM0akV6S0prWXE2Sm9BZ2drQ2I2dkVzYzNDb2pnNWdLTUFrQTVpVGUvSzBsbHdlUklIdzBjekZ1QmdDWTd4dDRLZnEwSldOVjgrWlR0Vy9SYStwU1JVZkovND0="),
("98","2","mod119_googlesitekit_auth_scopes","a:7:{i:0;s:51:\"https://www.googleapis.com/auth/tagmanager.readonly\";i:1;s:46:\"https://www.googleapis.com/auth/userinfo.email\";i:2;s:48:\"https://www.googleapis.com/auth/siteverification\";i:3;s:42:\"https://www.googleapis.com/auth/webmasters\";i:4;s:50:\"https://www.googleapis.com/auth/analytics.readonly\";i:5;s:6:\"openid\";i:6;s:48:\"https://www.googleapis.com/auth/userinfo.profile\";}"),
("99","2","mod119_googlesitekit_additional_auth_scopes","a:0:{}"),
("100","2","mod119_googlesitekit_profile","a:4:{s:5:\"email\";s:17:\"lssstat@gmail.com\";s:5:\"photo\";s:95:\"https://lh3.googleusercontent.com/a/ACg8ocIg3NRAmCtY2JiQWzi7eBW0k63TObpSZDdpYAMQewtg-h3Gzg=s100\";s:9:\"full_name\";s:15:\"Raphaël MARTIN\";s:12:\"last_updated\";i:1759823473;}"),
("101","2","mod119_googlesitekitpersistent_initial_version","1.162.1"),
("102","2","mod119_googlesitekit_site_verified_meta","verified"),
("103","2","mod119_googlesitekit_survey_timeouts","a:4:{s:14:\"view_dashboard\";i:1759251117;s:18:\"view_ads_setup_cta\";i:1759251118;s:18:\"view_ga4_dashboard\";i:1759251215;s:18:\"view_kmw_setup_cta\";i:1760341844;}"),
("104","2","mod119_googlesitekitpersistent_dismissed_items","a:1:{s:15:\"auto-update-cta\";i:1759165319;}");

INSERT IGNORE INTO `mod119_actionscheduler_actions` VALUES 
("229","action_scheduler/migration_hook","failed","2025-09-07 13:41:43","2025-09-07 15:41:43","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757252503;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757252503;}","2","1","2025-09-07 13:41:43","2025-09-07 15:41:43","6",NULL),
("232","action_scheduler/migration_hook","failed","2025-09-08 14:14:00","2025-09-08 16:14:00","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757340840;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757340840;}","2","1","2025-09-08 14:15:00","2025-09-08 16:15:00","170",NULL),
("234","action_scheduler/migration_hook","failed","2025-09-08 16:31:50","2025-09-08 18:31:50","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757349110;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757349110;}","2","1","2025-09-08 16:31:52","2025-09-08 18:31:52","270",NULL),
("259","action_scheduler/migration_hook","failed","2025-10-01 15:19:21","2025-10-01 17:19:21","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759331961;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759331961;}","2","1","2025-10-01 15:20:26","2025-10-01 17:20:26","3781",NULL),
("262","action_scheduler/migration_hook","failed","2025-10-02 12:55:59","2025-10-02 14:55:59","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759409759;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759409759;}","2","1","2025-10-02 12:55:59","2025-10-02 14:55:59","4529",NULL),
("279","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-10-19 17:06:18","2025-10-19 19:06:18","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760893578;s:18:\"\0*\0first_timestamp\";i:1757252380;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760893578;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-10-19 17:07:14","2025-10-19 19:07:14","16332",NULL),
("280","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-10-20 17:07:14","2025-10-20 19:07:14","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760980034;s:18:\"\0*\0first_timestamp\";i:1757252380;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760980034;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-10-20 17:08:45","2025-10-20 19:08:45","17055",NULL),
("281","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-10-21 17:08:45","2025-10-21 19:08:45","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761066525;s:18:\"\0*\0first_timestamp\";i:1757252380;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761066525;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-10-21 17:15:02","2025-10-21 19:15:02","17780",NULL),
("282","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-10-22 17:15:02","2025-10-22 19:15:02","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761153302;s:18:\"\0*\0first_timestamp\";i:1757252380;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761153302;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-10-22 17:17:03","2025-10-22 19:17:03","18618",NULL),
("283","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-10-23 17:17:03","2025-10-23 19:17:03","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761239823;s:18:\"\0*\0first_timestamp\";i:1757252380;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761239823;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-10-23 17:19:16","2025-10-23 19:19:16","19415",NULL),
("284","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-10-24 17:19:16","2025-10-24 19:19:16","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761326356;s:18:\"\0*\0first_timestamp\";i:1757252380;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761326356;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-10-24 17:20:52","2025-10-24 19:20:52","20028",NULL),
("285","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-10-25 17:20:52","2025-10-25 19:20:52","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761412852;s:18:\"\0*\0first_timestamp\";i:1757252380;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761412852;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-10-25 17:26:08","2025-10-25 19:26:08","20609",NULL),
("286","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-10-26 17:26:08","2025-10-26 18:26:08","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761499568;s:18:\"\0*\0first_timestamp\";i:1757252380;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761499568;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-10-26 17:29:35","2025-10-26 18:29:35","21216",NULL),
("287","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-10-27 17:29:35","2025-10-27 18:29:35","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761586175;s:18:\"\0*\0first_timestamp\";i:1757252380;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761586175;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-10-27 17:33:19","2025-10-27 18:33:19","21831",NULL),
("288","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-10-28 17:33:19","2025-10-28 18:33:19","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761672799;s:18:\"\0*\0first_timestamp\";i:1757252380;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761672799;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-10-28 17:35:33","2025-10-28 18:35:33","22431",NULL),
("289","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-10-29 17:35:33","2025-10-29 18:35:33","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761759333;s:18:\"\0*\0first_timestamp\";i:1757252380;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761759333;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-10-29 17:35:44","2025-10-29 18:35:44","23048",NULL),
("290","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-10-30 17:35:44","2025-10-30 18:35:44","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761845744;s:18:\"\0*\0first_timestamp\";i:1757252380;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761845744;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-10-30 17:38:37","2025-10-30 18:38:37","23669",NULL),
("291","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-10-31 17:38:37","2025-10-31 18:38:37","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761932317;s:18:\"\0*\0first_timestamp\";i:1757252380;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761932317;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-10-31 17:39:55","2025-10-31 18:39:55","24227",NULL),
("292","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-11-01 17:39:55","2025-11-01 18:39:55","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762018795;s:18:\"\0*\0first_timestamp\";i:1757252380;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762018795;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-11-01 17:40:39","2025-11-01 18:40:39","24818",NULL),
("293","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-11-02 17:40:39","2025-11-02 18:40:39","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762105239;s:18:\"\0*\0first_timestamp\";i:1757252380;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762105239;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-11-02 17:40:44","2025-11-02 18:40:44","25446",NULL),
("294","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-11-03 17:40:44","2025-11-03 18:40:44","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762191644;s:18:\"\0*\0first_timestamp\";i:1757252380;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762191644;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-11-03 17:41:52","2025-11-03 18:41:52","26046",NULL),
("295","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-11-04 17:41:52","2025-11-04 18:41:52","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762278112;s:18:\"\0*\0first_timestamp\";i:1757252380;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762278112;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-11-04 17:42:32","2025-11-04 18:42:32","26627",NULL),
("296","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-11-05 17:42:32","2025-11-05 18:42:32","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762364552;s:18:\"\0*\0first_timestamp\";i:1757252380;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762364552;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-11-05 17:42:43","2025-11-05 18:42:43","27248",NULL),
("297","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-11-06 17:42:43","2025-11-06 18:42:43","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762450963;s:18:\"\0*\0first_timestamp\";i:1757252380;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762450963;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-11-06 17:45:53","2025-11-06 18:45:53","27565",NULL),
("298","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-11-07 17:45:53","2025-11-07 18:45:53","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762537553;s:18:\"\0*\0first_timestamp\";i:1757252380;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762537553;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-11-07 17:51:04","2025-11-07 18:51:04","27761",NULL),
("299","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-11-08 17:51:04","2025-11-08 18:51:04","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762624264;s:18:\"\0*\0first_timestamp\";i:1757252380;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762624264;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-11-08 18:05:17","2025-11-08 19:05:17","27918",NULL),
("300","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-11-09 18:05:17","2025-11-09 19:05:17","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762711517;s:18:\"\0*\0first_timestamp\";i:1757252380;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762711517;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-11-09 18:07:11","2025-11-09 19:07:11","28055",NULL),
("301","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-11-10 18:07:11","2025-11-10 19:07:11","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762798031;s:18:\"\0*\0first_timestamp\";i:1757252380;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762798031;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-11-10 18:11:03","2025-11-10 19:11:03","28220",NULL),
("302","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-11-11 18:11:03","2025-11-11 19:11:03","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762884663;s:18:\"\0*\0first_timestamp\";i:1757252380;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762884663;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-11-11 18:24:14","2025-11-11 19:24:14","28376",NULL),
("303","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-11-12 18:24:14","2025-11-12 19:24:14","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762971854;s:18:\"\0*\0first_timestamp\";i:1757252380;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762971854;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-11-12 18:24:38","2025-11-12 19:24:38","28552",NULL),
("304","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-11-13 18:24:38","2025-11-13 19:24:38","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763058278;s:18:\"\0*\0first_timestamp\";i:1757252380;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763058278;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-11-13 18:25:04","2025-11-13 19:25:04","28756",NULL),
("305","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-11-14 18:25:04","2025-11-14 19:25:04","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763144704;s:18:\"\0*\0first_timestamp\";i:1757252380;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763144704;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-11-14 18:25:46","2025-11-14 19:25:46","28972",NULL),
("306","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-11-15 18:25:46","2025-11-15 19:25:46","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763231146;s:18:\"\0*\0first_timestamp\";i:1757252380;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763231146;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-11-15 18:27:23","2025-11-15 19:27:23","29155",NULL),
("307","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-11-16 18:27:23","2025-11-16 19:27:23","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763317643;s:18:\"\0*\0first_timestamp\";i:1757252380;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763317643;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-11-16 18:31:11","2025-11-16 19:31:11","29383",NULL),
("308","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-11-17 18:31:11","2025-11-17 19:31:11","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763404271;s:18:\"\0*\0first_timestamp\";i:1757252380;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763404271;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-11-17 18:34:52","2025-11-17 19:34:52","29564",NULL),
("309","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-11-18 18:34:52","2025-11-18 19:34:52","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763490892;s:18:\"\0*\0first_timestamp\";i:1757252380;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763490892;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2025-11-18 18:42:11","2025-11-18 19:42:11","29764",NULL),
("310","action_scheduler_run_recurring_actions_schedule_hook","pending","2025-11-19 18:42:11","2025-11-19 19:42:11","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763577731;s:18:\"\0*\0first_timestamp\";i:1757252380;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763577731;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL);

INSERT IGNORE INTO `mod119_actionscheduler_groups` VALUES 
("1","ActionScheduler"),
("2","action-scheduler-migration");

INSERT IGNORE INTO `mod119_actionscheduler_logs` VALUES 
("8","229","action created","2025-09-07 13:40:43","2025-09-07 15:40:43"),
("9","229","action started via WP Cron","2025-09-07 13:41:43","2025-09-07 15:41:43"),
("10","229","action failed via WP Cron: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2025-09-07 13:41:43","2025-09-07 15:41:43"),
("17","232","action created","2025-09-08 14:13:00","2025-09-08 16:13:00"),
("18","232","action started via WP Cron","2025-09-08 14:15:00","2025-09-08 16:15:00"),
("19","232","action failed via WP Cron: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2025-09-08 14:15:00","2025-09-08 16:15:00"),
("23","234","action created","2025-09-08 16:30:50","2025-09-08 18:30:50"),
("24","234","action started via Async Request","2025-09-08 16:31:52","2025-09-08 18:31:52"),
("25","234","action failed via Async Request: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2025-09-08 16:31:52","2025-09-08 18:31:52"),
("98","259","action created","2025-10-01 15:18:21","2025-10-01 17:18:21"),
("99","259","action started via WP Cron","2025-10-01 15:20:26","2025-10-01 17:20:26"),
("100","259","action failed via WP Cron: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2025-10-01 15:20:26","2025-10-01 17:20:26"),
("107","262","action created","2025-10-02 12:54:59","2025-10-02 14:54:59"),
("108","262","action started via WP Cron","2025-10-02 12:55:59","2025-10-02 14:55:59"),
("109","262","action failed via WP Cron: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2025-10-02 12:55:59","2025-10-02 14:55:59"),
("160","279","action created","2025-10-18 17:06:18","2025-10-18 19:06:18"),
("161","279","action started via WP Cron","2025-10-19 17:07:14","2025-10-19 19:07:14"),
("162","279","action complete via WP Cron","2025-10-19 17:07:14","2025-10-19 19:07:14"),
("163","280","action created","2025-10-19 17:07:14","2025-10-19 19:07:14"),
("164","280","action started via WP Cron","2025-10-20 17:08:45","2025-10-20 19:08:45"),
("165","280","action complete via WP Cron","2025-10-20 17:08:45","2025-10-20 19:08:45"),
("166","281","action created","2025-10-20 17:08:45","2025-10-20 19:08:45"),
("167","281","action started via WP Cron","2025-10-21 17:15:02","2025-10-21 19:15:02"),
("168","281","action complete via WP Cron","2025-10-21 17:15:02","2025-10-21 19:15:02"),
("169","282","action created","2025-10-21 17:15:02","2025-10-21 19:15:02"),
("170","282","action started via WP Cron","2025-10-22 17:17:03","2025-10-22 19:17:03"),
("171","282","action complete via WP Cron","2025-10-22 17:17:03","2025-10-22 19:17:03"),
("172","283","action created","2025-10-22 17:17:03","2025-10-22 19:17:03"),
("173","283","action started via WP Cron","2025-10-23 17:19:16","2025-10-23 19:19:16"),
("174","283","action complete via WP Cron","2025-10-23 17:19:16","2025-10-23 19:19:16"),
("175","284","action created","2025-10-23 17:19:16","2025-10-23 19:19:16"),
("176","284","action started via WP Cron","2025-10-24 17:20:52","2025-10-24 19:20:52"),
("177","284","action complete via WP Cron","2025-10-24 17:20:52","2025-10-24 19:20:52"),
("178","285","action created","2025-10-24 17:20:52","2025-10-24 19:20:52"),
("179","285","action started via WP Cron","2025-10-25 17:26:08","2025-10-25 19:26:08"),
("180","285","action complete via WP Cron","2025-10-25 17:26:08","2025-10-25 19:26:08"),
("181","286","action created","2025-10-25 17:26:08","2025-10-25 19:26:08"),
("182","286","action started via WP Cron","2025-10-26 17:29:35","2025-10-26 18:29:35"),
("183","286","action complete via WP Cron","2025-10-26 17:29:35","2025-10-26 18:29:35"),
("184","287","action created","2025-10-26 17:29:35","2025-10-26 18:29:35"),
("185","287","action started via WP Cron","2025-10-27 17:33:19","2025-10-27 18:33:19"),
("186","287","action complete via WP Cron","2025-10-27 17:33:19","2025-10-27 18:33:19"),
("187","288","action created","2025-10-27 17:33:19","2025-10-27 18:33:19"),
("188","288","action started via WP Cron","2025-10-28 17:35:33","2025-10-28 18:35:33"),
("189","288","action complete via WP Cron","2025-10-28 17:35:33","2025-10-28 18:35:33"),
("190","289","action created","2025-10-28 17:35:33","2025-10-28 18:35:33"),
("191","289","action started via WP Cron","2025-10-29 17:35:44","2025-10-29 18:35:44"),
("192","289","action complete via WP Cron","2025-10-29 17:35:44","2025-10-29 18:35:44"),
("193","290","action created","2025-10-29 17:35:44","2025-10-29 18:35:44"),
("194","290","action started via WP Cron","2025-10-30 17:38:37","2025-10-30 18:38:37"),
("195","290","action complete via WP Cron","2025-10-30 17:38:37","2025-10-30 18:38:37"),
("196","291","action created","2025-10-30 17:38:37","2025-10-30 18:38:37"),
("197","291","action started via WP Cron","2025-10-31 17:39:55","2025-10-31 18:39:55"),
("198","291","action complete via WP Cron","2025-10-31 17:39:55","2025-10-31 18:39:55"),
("199","292","action created","2025-10-31 17:39:55","2025-10-31 18:39:55"),
("200","292","action started via WP Cron","2025-11-01 17:40:39","2025-11-01 18:40:39"),
("201","292","action complete via WP Cron","2025-11-01 17:40:39","2025-11-01 18:40:39"),
("202","293","action created","2025-11-01 17:40:39","2025-11-01 18:40:39"),
("203","293","action started via WP Cron","2025-11-02 17:40:44","2025-11-02 18:40:44"),
("204","293","action complete via WP Cron","2025-11-02 17:40:44","2025-11-02 18:40:44"),
("205","294","action created","2025-11-02 17:40:44","2025-11-02 18:40:44"),
("206","294","action started via WP Cron","2025-11-03 17:41:52","2025-11-03 18:41:52"),
("207","294","action complete via WP Cron","2025-11-03 17:41:52","2025-11-03 18:41:52"),
("208","295","action created","2025-11-03 17:41:52","2025-11-03 18:41:52"),
("209","295","action started via WP Cron","2025-11-04 17:42:32","2025-11-04 18:42:32"),
("210","295","action complete via WP Cron","2025-11-04 17:42:32","2025-11-04 18:42:32"),
("211","296","action created","2025-11-04 17:42:32","2025-11-04 18:42:32"),
("212","296","action started via WP Cron","2025-11-05 17:42:43","2025-11-05 18:42:43"),
("213","296","action complete via WP Cron","2025-11-05 17:42:43","2025-11-05 18:42:43"),
("214","297","action created","2025-11-05 17:42:43","2025-11-05 18:42:43"),
("215","297","action started via WP Cron","2025-11-06 17:45:53","2025-11-06 18:45:53"),
("216","297","action complete via WP Cron","2025-11-06 17:45:53","2025-11-06 18:45:53"),
("217","298","action created","2025-11-06 17:45:53","2025-11-06 18:45:53"),
("218","298","action started via WP Cron","2025-11-07 17:51:04","2025-11-07 18:51:04"),
("219","298","action complete via WP Cron","2025-11-07 17:51:04","2025-11-07 18:51:04"),
("220","299","action created","2025-11-07 17:51:04","2025-11-07 18:51:04"),
("221","299","action started via WP Cron","2025-11-08 18:05:17","2025-11-08 19:05:17"),
("222","299","action complete via WP Cron","2025-11-08 18:05:17","2025-11-08 19:05:17"),
("223","300","action created","2025-11-08 18:05:17","2025-11-08 19:05:17"),
("224","300","action started via WP Cron","2025-11-09 18:07:11","2025-11-09 19:07:11"),
("225","300","action complete via WP Cron","2025-11-09 18:07:11","2025-11-09 19:07:11"),
("226","301","action created","2025-11-09 18:07:11","2025-11-09 19:07:11"),
("227","301","action started via WP Cron","2025-11-10 18:11:03","2025-11-10 19:11:03"),
("228","301","action complete via WP Cron","2025-11-10 18:11:03","2025-11-10 19:11:03"),
("229","302","action created","2025-11-10 18:11:03","2025-11-10 19:11:03"),
("230","302","action started via WP Cron","2025-11-11 18:24:14","2025-11-11 19:24:14"),
("231","302","action complete via WP Cron","2025-11-11 18:24:14","2025-11-11 19:24:14"),
("232","303","action created","2025-11-11 18:24:14","2025-11-11 19:24:14"),
("233","303","action started via WP Cron","2025-11-12 18:24:38","2025-11-12 19:24:38"),
("234","303","action complete via WP Cron","2025-11-12 18:24:38","2025-11-12 19:24:38"),
("235","304","action created","2025-11-12 18:24:38","2025-11-12 19:24:38"),
("236","304","action started via WP Cron","2025-11-13 18:25:04","2025-11-13 19:25:04"),
("237","304","action complete via WP Cron","2025-11-13 18:25:04","2025-11-13 19:25:04"),
("238","305","action created","2025-11-13 18:25:04","2025-11-13 19:25:04"),
("239","305","action started via WP Cron","2025-11-14 18:25:46","2025-11-14 19:25:46"),
("240","305","action complete via WP Cron","2025-11-14 18:25:46","2025-11-14 19:25:46"),
("241","306","action created","2025-11-14 18:25:46","2025-11-14 19:25:46"),
("242","306","action started via WP Cron","2025-11-15 18:27:23","2025-11-15 19:27:23"),
("243","306","action complete via WP Cron","2025-11-15 18:27:23","2025-11-15 19:27:23"),
("244","307","action created","2025-11-15 18:27:23","2025-11-15 19:27:23"),
("245","307","action started via WP Cron","2025-11-16 18:31:11","2025-11-16 19:31:11"),
("246","307","action complete via WP Cron","2025-11-16 18:31:11","2025-11-16 19:31:11"),
("247","308","action created","2025-11-16 18:31:11","2025-11-16 19:31:11"),
("248","308","action started via WP Cron","2025-11-17 18:34:52","2025-11-17 19:34:52"),
("249","308","action complete via WP Cron","2025-11-17 18:34:52","2025-11-17 19:34:52"),
("250","309","action created","2025-11-17 18:34:52","2025-11-17 19:34:52"),
("251","309","action started via WP Cron","2025-11-18 18:42:11","2025-11-18 19:42:11"),
("252","309","action complete via WP Cron","2025-11-18 18:42:11","2025-11-18 19:42:11"),
("253","310","action created","2025-11-18 18:42:11","2025-11-18 19:42:11");

INSERT IGNORE INTO `mod119_duplicator_activity_logs` VALUES 
("12","websites_scan","scan_start","10","Scan","{\n    \"packageId\": 5,\n    \"packageName\": \"251006_BowattsDev\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 0,\n    \"dirCount\": 0,\n    \"size\": 0\n}","0","4.5.22.6","2025-10-06 13:51:18","2025-10-06 13:51:18"),
("13","websites_scan","scan_end","10","Scan Completed","{\n    \"packageId\": 5,\n    \"packageName\": \"251006_BowattsDev\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 17701,\n    \"dirCount\": 2629,\n    \"size\": 576931553\n}","12","4.5.22.6","2025-10-06 13:51:23","2025-10-06 13:51:23"),
("14","backup_create","start","10","Backup create: 251006_BowattsDev","{\n    \"packageId\": 6,\n    \"packageName\": \"251006_BowattsDev\",\n    \"packageStatus\": 10,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 17701,\n    \"dirCount\": 2629,\n    \"size\": 576931553,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"dbPrefixSubFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\"\n}","0","4.5.22.6","2025-10-06 13:53:15","2025-10-06 13:53:15"),
("15","backup_create","db_dump","10","Backup create: 251006_BowattsDev - DB Dump","{\n    \"packageId\": 6,\n    \"packageName\": \"251006_BowattsDev\",\n    \"packageStatus\": 20,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 17701,\n    \"dirCount\": 2629,\n    \"size\": 576931553,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"dbPrefixSubFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\"\n}","14","4.5.22.6","2025-10-06 13:53:15","2025-10-06 13:53:15"),
("16","backup_create","file_dump","10","Backup create: 251006_BowattsDev - File Dump","{\n    \"packageId\": 6,\n    \"packageName\": \"251006_BowattsDev\",\n    \"packageStatus\": 40,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 17701,\n    \"dirCount\": 2629,\n    \"size\": 576931553,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"dbPrefixSubFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\"\n}","14","4.5.22.6","2025-10-06 13:53:19","2025-10-06 13:53:19"),
("17","backup_create","transfer","10","Backup create: 251006_BowattsDev - Transfer","{\n    \"packageId\": 6,\n    \"packageName\": \"251006_BowattsDev\",\n    \"packageStatus\": 75,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 17701,\n    \"dirCount\": 2629,\n    \"size\": 283177316,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"dbPrefixSubFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\"\n}","14","4.5.22.6","2025-10-06 13:54:03","2025-10-06 13:54:03"),
("18","backup_create","end","10","Backup create: 251006_BowattsDev - Completed","{\n    \"packageId\": 6,\n    \"packageName\": \"251006_BowattsDev\",\n    \"packageStatus\": 100,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 17701,\n    \"dirCount\": 2629,\n    \"size\": 283177316,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"dbPrefixSubFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\"\n}","14","4.5.22.6","2025-10-06 13:54:03","2025-10-06 13:54:03"),
("19","websites_scan","scan_start","10","Scan","{\n    \"packageId\": 7,\n    \"packageName\": \"251119_Bowatts\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 0,\n    \"dirCount\": 0,\n    \"size\": 0\n}","0","4.5.22.6","2025-11-19 09:10:45","2025-11-19 09:10:45"),
("20","websites_scan","scan_end","10","Scan Completed","{\n    \"packageId\": 7,\n    \"packageName\": \"251119_Bowatts\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 17801,\n    \"dirCount\": 2637,\n    \"size\": 672758315\n}","19","4.5.22.6","2025-11-19 09:10:51","2025-11-19 09:10:51"),
("21","backup_create","start","10","Backup create: 251119_Bowatts","{\n    \"packageId\": 8,\n    \"packageName\": \"251119_Bowatts\",\n    \"packageStatus\": 10,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 17801,\n    \"dirCount\": 2637,\n    \"size\": 672758315,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"dbPrefixSubFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\"\n}","0","4.5.22.6","2025-11-19 09:11:12","2025-11-19 09:11:12"),
("22","backup_create","db_dump","10","Backup create: 251119_Bowatts - DB Dump","{\n    \"packageId\": 8,\n    \"packageName\": \"251119_Bowatts\",\n    \"packageStatus\": 20,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 17801,\n    \"dirCount\": 2637,\n    \"size\": 672758315,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"dbPrefixSubFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\"\n}","21","4.5.22.6","2025-11-19 09:11:12","2025-11-19 09:11:12");

INSERT IGNORE INTO `mod119_duplicator_backups` VALUES 
("7","Standard","251119_Bowatts","038479e39d6aad427662_20251119091044","251119_Bowatts_038479e39d6aad427662_20251119091044_archive.zip","5","MANUAL,ZIP_ARCHIVE,TEMPORARY","{\n    \"ID\": 7,\n    \"VersionWP\": \"6.8.3\",\n    \"VersionDB\": \"8.0.43\",\n    \"VersionPHP\": \"8.4.10\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"251119_Bowatts\",\n    \"hash\": \"038479e39d6aad427662_20251119091044\",\n    \"execType\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/bowattu\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"251119_Bowatts_038479e39d6aad427662_20251119091044_scan.json\",\n    \"timer_start\": -1,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/bowattu\\/www\\/.opcache\",\n            \"\\/home\\/bowattu\\/www\\/.tmb\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/bowattu\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/bowattu\\/www\\/.htaccess\",\n            \"\\/home\\/bowattu\\/www\\/.user.ini\",\n            \"\\/home\\/bowattu\\/www\\/php.ini\",\n            \"\\/home\\/bowattu\\/www\\/web.config\",\n            \"\\/home\\/bowattu\\/www\\/wp-config.php\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"251119_Bowatts_038479e39d6aad427662_20251119091044_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/bowattu\\/www\\/\",\n        \"Size\": 672758315,\n        \"Dirs\": [],\n        \"DirCount\": 2637,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 17801,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [\n                    {\n                        \"ubytes\": 314391424,\n                        \"bytes\": \"299.83MB\",\n                        \"nodes\": 14928,\n                        \"name\": \"plugins\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/plugins\"\n                    },\n                    {\n                        \"ubytes\": 140720153,\n                        \"bytes\": \"134.2MB\",\n                        \"nodes\": 665,\n                        \"name\": \"09\",\n                        \"dir\": \"wp-content\\/uploads\\/2025\",\n                        \"path\": \"wp-content\\/uploads\\/2025\\/09\"\n                    },\n                    {\n                        \"ubytes\": 233604260,\n                        \"bytes\": \"222.78MB\",\n                        \"nodes\": 746,\n                        \"name\": \"2025\",\n                        \"dir\": \"wp-content\\/uploads\",\n                        \"path\": \"wp-content\\/uploads\\/2025\"\n                    },\n                    {\n                        \"ubytes\": 240257331,\n                        \"bytes\": \"229.13MB\",\n                        \"nodes\": 834,\n                        \"name\": \"uploads\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/uploads\"\n                    },\n                    {\n                        \"ubytes\": 583440324,\n                        \"bytes\": \"556.41MB\",\n                        \"nodes\": 17336,\n                        \"name\": \"wp-content\",\n                        \"dir\": \".\",\n                        \"path\": \"wp-content\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"\\/home\\/bowattu\\/www\\/wp-snapshots\",\n                    \"\\/home\\/bowattu\\/www\\/.opcache\",\n                    \"\\/home\\/bowattu\\/www\\/.tmb\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/backups-dup-lite\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/backups-dup-pro\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/ai1wm-backups\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/backupwordpress\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/content\\/cache\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/contents\\/cache\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/infinitewp\\/backups\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/managewp\\/backups\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/old-cache\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/updraft\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/wpvividbackups\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/wishlist-backup\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/wfcache\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/bps-backup\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/cache\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/snapshots\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/sucuri\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/wp-clone\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/backup-guard\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [\n                    {\n                        \"ubytes\": 11382589,\n                        \"bytes\": \"10.86MB\",\n                        \"nodes\": 1,\n                        \"name\": \"CCSB-BOWATTS-DP-20230505.pdf\",\n                        \"dir\": \"pdf\",\n                        \"path\": \"pdf\\/CCSB-BOWATTS-DP-20230505.pdf\"\n                    },\n                    {\n                        \"ubytes\": 7143439,\n                        \"bytes\": \"6.81MB\",\n                        \"nodes\": 1,\n                        \"name\": \"GUIDE-INSTALLATION-NRLINK.pdf\",\n                        \"dir\": \"pdf\",\n                        \"path\": \"pdf\\/GUIDE-INSTALLATION-NRLINK.pdf\"\n                    },\n                    {\n                        \"ubytes\": 11481352,\n                        \"bytes\": \"10.95MB\",\n                        \"nodes\": 1,\n                        \"name\": \"content.xml\",\n                        \"dir\": \"wp-content\\/plugins\\/oshine-core\\/inc\\/importer\\/demo-files\\/v1\",\n                        \"path\": \"wp-content\\/plugins\\/oshine-core\\/inc\\/importer\\/demo-files\\/v1\\/content.xml\"\n                    },\n                    {\n                        \"ubytes\": 5884758,\n                        \"bytes\": \"5.61MB\",\n                        \"nodes\": 1,\n                        \"name\": \"bundle.js\",\n                        \"dir\": \"wp-content\\/plugins\\/tatsu\\/builder\\/js\",\n                        \"path\": \"wp-content\\/plugins\\/tatsu\\/builder\\/js\\/bundle.js\"\n                    },\n                    {\n                        \"ubytes\": 5275313,\n                        \"bytes\": \"5.03MB\",\n                        \"nodes\": 1,\n                        \"name\": \"content.xml\",\n                        \"dir\": \"wp-content\\/plugins\\/tatsu\\/includes\\/demo-import\\/inc\\/importer\\/demo-files\\/seo-agency\",\n                        \"path\": \"wp-content\\/plugins\\/tatsu\\/includes\\/demo-import\\/inc\\/importer\\/demo-files\\/seo-agency\\/content.xml\"\n                    },\n                    {\n                        \"ubytes\": 17417495,\n                        \"bytes\": \"16.61MB\",\n                        \"nodes\": 1,\n                        \"name\": \"stats.json\",\n                        \"dir\": \"wp-content\\/plugins\\/tatsu\\/includes\\/typehub\",\n                        \"path\": \"wp-content\\/plugins\\/tatsu\\/includes\\/typehub\\/stats.json\"\n                    },\n                    {\n                        \"ubytes\": 5634017,\n                        \"bytes\": \"5.37MB\",\n                        \"nodes\": 1,\n                        \"name\": \"Bowatts_Header-PRO-1.jpg\",\n                        \"dir\": \"wp-content\\/uploads\\/2025\\/09\",\n                        \"path\": \"wp-content\\/uploads\\/2025\\/09\\/Bowatts_Header-PRO-1.jpg\"\n                    },\n                    {\n                        \"ubytes\": 4635273,\n                        \"bytes\": \"4.42MB\",\n                        \"nodes\": 1,\n                        \"name\": \"Bowatts_Header-Particulier-1.jpg\",\n                        \"dir\": \"wp-content\\/uploads\\/2025\\/09\",\n                        \"path\": \"wp-content\\/uploads\\/2025\\/09\\/Bowatts_Header-Particulier-1.jpg\"\n                    },\n                    {\n                        \"ubytes\": 66541019,\n                        \"bytes\": \"63.46MB\",\n                        \"nodes\": 1,\n                        \"name\": \"CCSB-BoWatts-Teaser.mp4\",\n                        \"dir\": \"wp-content\\/uploads\\/2025\\/09\",\n                        \"path\": \"wp-content\\/uploads\\/2025\\/09\\/CCSB-BoWatts-Teaser.mp4\"\n                    },\n                    {\n                        \"ubytes\": 89703380,\n                        \"bytes\": \"85.55MB\",\n                        \"nodes\": 1,\n                        \"name\": \"INSTALLATION_NRLINK_video_BoWatts.mp4\",\n                        \"dir\": \"wp-content\\/uploads\\/2025\\/10\",\n                        \"path\": \"wp-content\\/uploads\\/2025\\/10\\/INSTALLATION_NRLINK_video_BoWatts.mp4\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"error_log\",\n                    \"debug_log\",\n                    \"ws_ftp.log\",\n                    \"dbcache\",\n                    \"pgcache\",\n                    \"objectcache\",\n                    \".DS_Store\",\n                    \"\\/home\\/bowattu\\/www\\/.htaccess\",\n                    \"\\/home\\/bowattu\\/www\\/.user.ini\",\n                    \"\\/home\\/bowattu\\/www\\/php.ini\",\n                    \"\\/home\\/bowattu\\/www\\/web.config\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/debug.log\",\n                    \"\\/home\\/bowattu\\/www\\/wp-config.php\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": {\n                \"text\": \"\\/home\\/bowattu\\/www <span class=\\\"size\\\" >641.59MB<\\/span> <span class=\\\"nodes\\\" >20438<\\/span>\",\n                \"fullPath\": \"\\/home\\/bowattu\\/www\",\n                \"type\": \"folder\",\n                \"state\": {\n                    \"opened\": true,\n                    \"disabled\": false,\n                    \"selected\": false,\n                    \"checked\": false,\n                    \"checkbox_disabled\": true\n                },\n                \"children\": [\n                    {\n                        \"text\": \"wp-content <span class=\\\"size\\\" >556.41MB<\\/span> <span class=\\\"nodes\\\" >17336<\\/span>\",\n                        \"fullPath\": \"\\/home\\/bowattu\\/www\\/wp-content\",\n                        \"type\": \"folder\",\n                        \"state\": {\n                            \"opened\": true,\n                            \"disabled\": false,\n                            \"selected\": false,\n                            \"checked\": false,\n                            \"checkbox_disabled\": false\n                        },\n                        \"children\": [\n                            {\n                                \"text\": \"plugins <span class=\\\"size\\\" >299.83MB<\\/span> <span class=\\\"nodes\\\" >14928<\\/span>\",\n                                \"fullPath\": \"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\",\n                                \"type\": \"folder\",\n                                \"state\": {\n                                    \"opened\": true,\n                                    \"disabled\": false,\n                                    \"selected\": false,\n                                    \"checked\": false,\n                                    \"checkbox_disabled\": false\n                                },\n                                \"children\": [\n                                    {\n                                        \"text\": \"oshine-core <span class=\\\"size\\\" >95.08MB<\\/span> <span class=\\\"nodes\\\" >535<\\/span>\",\n                                        \"fullPath\": \"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/oshine-core\",\n                                        \"type\": \"folder\",\n                                        \"state\": {\n                                            \"opened\": true,\n                                            \"disabled\": false,\n                                            \"selected\": false,\n                                            \"checked\": false,\n                                            \"checkbox_disabled\": false\n                                        },\n                                        \"children\": [\n                                            {\n                                                \"text\": \"inc <span class=\\\"size\\\" >94.91MB<\\/span> <span class=\\\"nodes\\\" >507<\\/span>\",\n                                                \"fullPath\": \"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/oshine-core\\/inc\",\n                                                \"type\": \"folder\",\n                                                \"state\": {\n                                                    \"opened\": true,\n                                                    \"disabled\": false,\n                                                    \"selected\": false,\n                                                    \"checked\": false,\n                                                    \"checkbox_disabled\": false\n                                                },\n                                                \"children\": [\n                                                    {\n                                                        \"text\": \"importer <span class=\\\"size\\\" >94.89MB<\\/span> <span class=\\\"nodes\\\" >504<\\/span>\",\n                                                        \"fullPath\": \"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/oshine-core\\/inc\\/importer\",\n                                                        \"type\": \"folder\",\n                                                        \"state\": {\n                                                            \"opened\": true,\n                                                            \"disabled\": false,\n                                                            \"selected\": false,\n                                                            \"checked\": false,\n                                                            \"checkbox_disabled\": false\n                                                        },\n                                                        \"children\": [\n                                                            {\n                                                                \"text\": \"demo-files <span class=\\\"size\\\" >94.74MB<\\/span> <span class=\\\"nodes\\\" >495<\\/span>\",\n                                                                \"fullPath\": \"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/oshine-core\\/inc\\/importer\\/demo-files\",\n                                                                \"type\": \"folder\",\n                                                                \"state\": {\n                                                                    \"opened\": true,\n                                                                    \"disabled\": false,\n                                                                    \"selected\": false,\n                                                                    \"checked\": false,\n                                                                    \"checkbox_disabled\": false\n                                                                },\n                                                                \"children\": [\n                                                                    {\n                                                                        \"text\": \"v1 <span class=\\\"size\\\" >11.11MB<\\/span> <span class=\\\"nodes\\\" >10<\\/span>\",\n                                                                        \"fullPath\": \"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/oshine-core\\/inc\\/importer\\/demo-files\\/v1\",\n                                                                        \"type\": \"folder\",\n                                                                        \"state\": {\n                                                                            \"opened\": true,\n                                                                            \"disabled\": false,\n                                                                            \"selected\": false,\n                                                                            \"checked\": false,\n                                                                            \"checkbox_disabled\": false\n                                                                        },\n                                                                        \"children\": [\n                                                                            {\n                                                                                \"text\": \"content.xml <span class=\\\"size\\\" >10.95MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                                                \"fullPath\": \"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/oshine-core\\/inc\\/importer\\/demo-files\\/v1\\/content.xml\",\n                                                                                \"type\": \"file\",\n                                                                                \"state\": {\n                                                                                    \"opened\": false,\n                                                                                    \"disabled\": false,\n                                                                                    \"selected\": false,\n                                                                                    \"checked\": false,\n                                                                                    \"checkbox_disabled\": false\n                                                                                },\n                                                                                \"children\": null,\n                                                                                \"li_attr\": {\n                                                                                    \"class\": \" warning-node\"\n                                                                                },\n                                                                                \"a_attr\": []\n                                                                            }\n                                                                        ],\n                                                                        \"li_attr\": {\n                                                                            \"data-full-loaded\": false,\n                                                                            \"class\": \" warning-childs\"\n                                                                        },\n                                                                        \"a_attr\": []\n                                                                    }\n                                                                ],\n                                                                \"li_attr\": {\n                                                                    \"data-full-loaded\": false,\n                                                                    \"class\": \" warning-childs\"\n                                                                },\n                                                                \"a_attr\": []\n                                                            }\n                                                        ],\n                                                        \"li_attr\": {\n                                                            \"data-full-loaded\": false,\n                                                            \"class\": \" warning-childs\"\n                                                        },\n                                                        \"a_attr\": []\n                                                    }\n                                                ],\n                                                \"li_attr\": {\n                                                    \"data-full-loaded\": false,\n                                                    \"class\": \" warning-childs\"\n                                                },\n                                                \"a_attr\": []\n                                            }\n                                        ],\n                                        \"li_attr\": {\n                                            \"data-full-loaded\": false,\n                                            \"class\": \" warning-childs\"\n                                        },\n                                        \"a_attr\": []\n                                    },\n                                    {\n                                        \"text\": \"tatsu <span class=\\\"size\\\" >78.75MB<\\/span> <span class=\\\"nodes\\\" >1411<\\/span>\",\n                                        \"fullPath\": \"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/tatsu\",\n                                        \"type\": \"folder\",\n                                        \"state\": {\n                                            \"opened\": true,\n                                            \"disabled\": false,\n                                            \"selected\": false,\n                                            \"checked\": false,\n                                            \"checkbox_disabled\": false\n                                        },\n                                        \"children\": [\n                                            {\n                                                \"text\": \"builder <span class=\\\"size\\\" >8.48MB<\\/span> <span class=\\\"nodes\\\" >30<\\/span>\",\n                                                \"fullPath\": \"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/tatsu\\/builder\",\n                                                \"type\": \"folder\",\n                                                \"state\": {\n                                                    \"opened\": true,\n                                                    \"disabled\": false,\n                                                    \"selected\": false,\n                                                    \"checked\": false,\n                                                    \"checkbox_disabled\": false\n                                                },\n                                                \"children\": [\n                                                    {\n                                                        \"text\": \"js <span class=\\\"size\\\" >7.68MB<\\/span> <span class=\\\"nodes\\\" >4<\\/span>\",\n                                                        \"fullPath\": \"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/tatsu\\/builder\\/js\",\n                                                        \"type\": \"folder\",\n                                                        \"state\": {\n                                                            \"opened\": true,\n                                                            \"disabled\": false,\n                                                            \"selected\": false,\n                                                            \"checked\": false,\n                                                            \"checkbox_disabled\": false\n                                                        },\n                                                        \"children\": [\n                                                            {\n                                                                \"text\": \"bundle.js <span class=\\\"size\\\" >5.61MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                                \"fullPath\": \"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/tatsu\\/builder\\/js\\/bundle.js\",\n                                                                \"type\": \"file\",\n                                                                \"state\": {\n                                                                    \"opened\": false,\n                                                                    \"disabled\": false,\n                                                                    \"selected\": false,\n                                                                    \"checked\": false,\n                                                                    \"checkbox_disabled\": false\n                                                                },\n                                                                \"children\": null,\n                                                                \"li_attr\": {\n                                                                    \"class\": \" warning-node\"\n                                                                },\n                                                                \"a_attr\": []\n                                                            }\n                                                        ],\n                                                        \"li_attr\": {\n                                                            \"data-full-loaded\": false,\n                                                            \"class\": \" warning-childs\"\n                                                        },\n                                                        \"a_attr\": []\n                                                    }\n                                                ],\n                                                \"li_attr\": {\n                                                    \"data-full-loaded\": false,\n                                                    \"class\": \" warning-childs\"\n                                                },\n                                                \"a_attr\": []\n                                            },\n                                            {\n                                                \"text\": \"includes <span class=\\\"size\\\" >68.01MB<\\/span> <span class=\\\"nodes\\\" >1241<\\/span>\",\n                                                \"fullPath\": \"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/tatsu\\/includes\",\n                                                \"type\": \"folder\",\n                                                \"state\": {\n                                                    \"opened\": true,\n                                                    \"disabled\": false,\n                                                    \"selected\": false,\n                                                    \"checked\": false,\n                                                    \"checkbox_disabled\": false\n                                                },\n                                                \"children\": [\n                                                    {\n                                                        \"text\": \"demo-import <span class=\\\"size\\\" >36.87MB<\\/span> <span class=\\\"nodes\\\" >183<\\/span>\",\n                                                        \"fullPath\": \"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/tatsu\\/includes\\/demo-import\",\n                                                        \"type\": \"folder\",\n                                                        \"state\": {\n                                                            \"opened\": true,\n                                                            \"disabled\": false,\n                                                            \"selected\": false,\n                                                            \"checked\": false,\n                                                            \"checkbox_disabled\": false\n                                                        },\n                                                        \"children\": [\n                                                            {\n                                                                \"text\": \"inc <span class=\\\"size\\\" >36.7MB<\\/span> <span class=\\\"nodes\\\" >148<\\/span>\",\n                                                                \"fullPath\": \"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/tatsu\\/includes\\/demo-import\\/inc\",\n                                                                \"type\": \"folder\",\n                                                                \"state\": {\n                                                                    \"opened\": true,\n                                                                    \"disabled\": false,\n                                                                    \"selected\": false,\n                                                                    \"checked\": false,\n                                                                    \"checkbox_disabled\": false\n                                                                },\n                                                                \"children\": [\n                                                                    {\n                                                                        \"text\": \"importer <span class=\\\"size\\\" >36.69MB<\\/span> <span class=\\\"nodes\\\" >145<\\/span>\",\n                                                                        \"fullPath\": \"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/tatsu\\/includes\\/demo-import\\/inc\\/importer\",\n                                                                        \"type\": \"folder\",\n                                                                        \"state\": {\n                                                                            \"opened\": true,\n                                                                            \"disabled\": false,\n                                                                            \"selected\": false,\n                                                                            \"checked\": false,\n                                                                            \"checkbox_disabled\": false\n                                                                        },\n                                                                        \"children\": [\n                                                                            {\n                                                                                \"text\": \"demo-files <span class=\\\"size\\\" >36.58MB<\\/span> <span class=\\\"nodes\\\" >138<\\/span>\",\n                                                                                \"fullPath\": \"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/tatsu\\/includes\\/demo-import\\/inc\\/importer\\/demo-files\",\n                                                                                \"type\": \"folder\",\n                                                                                \"state\": {\n                                                                                    \"opened\": true,\n                                                                                    \"disabled\": false,\n                                                                                    \"selected\": false,\n                                                                                    \"checked\": false,\n                                                                                    \"checkbox_disabled\": false\n                                                                                },\n                                                                                \"children\": [\n                                                                                    {\n                                                                                        \"text\": \"seo-agency <span class=\\\"size\\\" >5.11MB<\\/span> <span class=\\\"nodes\\\" >9<\\/span>\",\n                                                                                        \"fullPath\": \"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/tatsu\\/includes\\/demo-import\\/inc\\/importer\\/demo-files\\/seo-agency\",\n                                                                                        \"type\": \"folder\",\n                                                                                        \"state\": {\n                                                                                            \"opened\": true,\n                                                                                            \"disabled\": false,\n                                                                                            \"selected\": false,\n                                                                                            \"checked\": false,\n                                                                                            \"checkbox_disabled\": false\n                                                                                        },\n                                                                                        \"children\": [\n                                                                                            {\n                                                                                                \"text\": \"content.xml <span class=\\\"size\\\" >5.03MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                                                                \"fullPath\": \"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/tatsu\\/includes\\/demo-import\\/inc\\/importer\\/demo-files\\/seo-agency\\/content.xml\",\n                                                                                                \"type\": \"file\",\n                                                                                                \"state\": {\n                                                                                                    \"opened\": false,\n                                                                                                    \"disabled\": false,\n                                                                                                    \"selected\": false,\n                                                                                                    \"checked\": false,\n                                                                                                    \"checkbox_disabled\": false\n                                                                                                },\n                                                                                                \"children\": null,\n                                                                                                \"li_attr\": {\n                                                                                                    \"class\": \" warning-node\"\n                                                                                                },\n                                                                                                \"a_attr\": []\n                                                                                            }\n                                                                                        ],\n                                                                                        \"li_attr\": {\n                                                                                            \"data-full-loaded\": false,\n                                                                                            \"class\": \" warning-childs\"\n                                                                                        },\n                                                                                        \"a_attr\": []\n                                                                                    }\n                                                                                ],\n                                                                                \"li_attr\": {\n                                                                                    \"data-full-loaded\": false,\n                                                                                    \"class\": \" warning-childs\"\n                                                                                },\n                                                                                \"a_attr\": []\n                                                                            }\n                                                                        ],\n                                                                        \"li_attr\": {\n                                                                            \"data-full-loaded\": false,\n                                                                            \"class\": \" warning-childs\"\n                                                                        },\n                                                                        \"a_attr\": []\n                                                                    }\n                                                                ],\n                                                                \"li_attr\": {\n                                                                    \"data-full-loaded\": false,\n                                                                    \"class\": \" warning-childs\"\n                                                                },\n                                                                \"a_attr\": []\n                                                            }\n                                                        ],\n                                                        \"li_attr\": {\n                                                            \"data-full-loaded\": false,\n                                                            \"class\": \" warning-childs\"\n                                                        },\n                                                        \"a_attr\": []\n                                                    },\n                                                    {\n                                                        \"text\": \"typehub <span class=\\\"size\\\" >21.06MB<\\/span> <span class=\\\"nodes\\\" >57<\\/span>\",\n                                                        \"fullPath\": \"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/tatsu\\/includes\\/typehub\",\n                                                        \"type\": \"folder\",\n                                                        \"state\": {\n                                                            \"opened\": true,\n                                                            \"disabled\": false,\n                                                            \"selected\": false,\n                                                            \"checked\": false,\n                                                            \"checkbox_disabled\": false\n                                                        },\n                                                        \"children\": [\n                                                            {\n                                                                \"text\": \"stats.json <span class=\\\"size\\\" >16.61MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                                \"fullPath\": \"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/tatsu\\/includes\\/typehub\\/stats.json\",\n                                                                \"type\": \"file\",\n                                                                \"state\": {\n                                                                    \"opened\": false,\n                                                                    \"disabled\": false,\n                                                                    \"selected\": false,\n                                                                    \"checked\": false,\n                                                                    \"checkbox_disabled\": false\n                                                                },\n                                                                \"children\": null,\n                                                                \"li_attr\": {\n                                                                    \"class\": \" warning-node\"\n                                                                },\n                                                                \"a_attr\": []\n                                                            }\n                                                        ],\n                                                        \"li_attr\": {\n                                                            \"data-full-loaded\": false,\n                                                            \"class\": \" warning-childs\"\n                                                        },\n                                                        \"a_attr\": []\n                                                    }\n                                                ],\n                                                \"li_attr\": {\n                                                    \"data-full-loaded\": false,\n                                                    \"class\": \" warning-childs\"\n                                                },\n                                                \"a_attr\": []\n                                            }\n                                        ],\n                                        \"li_attr\": {\n                                            \"data-full-loaded\": false,\n                                            \"class\": \" warning-childs\"\n                                        },\n                                        \"a_attr\": []\n                                    }\n                                ],\n                                \"li_attr\": {\n                                    \"data-full-loaded\": false,\n                                    \"class\": \" warning-node\"\n                                },\n                                \"a_attr\": []\n                            },\n                            {\n                                \"text\": \"uploads <span class=\\\"size\\\" >229.13MB<\\/span> <span class=\\\"nodes\\\" >834<\\/span>\",\n                                \"fullPath\": \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\",\n                                \"type\": \"folder\",\n                                \"state\": {\n                                    \"opened\": true,\n                                    \"disabled\": false,\n                                    \"selected\": false,\n                                    \"checked\": false,\n                                    \"checkbox_disabled\": false\n                                },\n                                \"children\": [\n                                    {\n                                        \"text\": \"2025 <span class=\\\"size\\\" >222.78MB<\\/span> <span class=\\\"nodes\\\" >746<\\/span>\",\n                                        \"fullPath\": \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/2025\",\n                                        \"type\": \"folder\",\n                                        \"state\": {\n                                            \"opened\": true,\n                                            \"disabled\": false,\n                                            \"selected\": false,\n                                            \"checked\": false,\n                                            \"checkbox_disabled\": false\n                                        },\n                                        \"children\": [\n                                            {\n                                                \"text\": \"09 <span class=\\\"size\\\" >134.2MB<\\/span> <span class=\\\"nodes\\\" >665<\\/span>\",\n                                                \"fullPath\": \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/2025\\/09\",\n                                                \"type\": \"folder\",\n                                                \"state\": {\n                                                    \"opened\": true,\n                                                    \"disabled\": false,\n                                                    \"selected\": false,\n                                                    \"checked\": false,\n                                                    \"checkbox_disabled\": false\n                                                },\n                                                \"children\": [\n                                                    {\n                                                        \"text\": \"Bowatts_Header-PRO-1.jpg <span class=\\\"size\\\" >5.37MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                        \"fullPath\": \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/2025\\/09\\/Bowatts_Header-PRO-1.jpg\",\n                                                        \"type\": \"file\",\n                                                        \"state\": {\n                                                            \"opened\": false,\n                                                            \"disabled\": false,\n                                                            \"selected\": false,\n                                                            \"checked\": false,\n                                                            \"checkbox_disabled\": false\n                                                        },\n                                                        \"children\": null,\n                                                        \"li_attr\": {\n                                                            \"class\": \" warning-node\"\n                                                        },\n                                                        \"a_attr\": []\n                                                    },\n                                                    {\n                                                        \"text\": \"Bowatts_Header-Particulier-1.jpg <span class=\\\"size\\\" >4.42MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                        \"fullPath\": \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/2025\\/09\\/Bowatts_Header-Particulier-1.jpg\",\n                                                        \"type\": \"file\",\n                                                        \"state\": {\n                                                            \"opened\": false,\n                                                            \"disabled\": false,\n                                                            \"selected\": false,\n                                                            \"checked\": false,\n                                                            \"checkbox_disabled\": false\n                                                        },\n                                                        \"children\": null,\n                                                        \"li_attr\": {\n                                                            \"class\": \" warning-node\"\n                                                        },\n                                                        \"a_attr\": []\n                                                    },\n                                                    {\n                                                        \"text\": \"CCSB-BoWatts-Teaser.mp4 <span class=\\\"size\\\" >63.46MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                        \"fullPath\": \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/2025\\/09\\/CCSB-BoWatts-Teaser.mp4\",\n                                                        \"type\": \"file\",\n                                                        \"state\": {\n                                                            \"opened\": false,\n                                                            \"disabled\": false,\n                                                            \"selected\": false,\n                                                            \"checked\": false,\n                                                            \"checkbox_disabled\": false\n                                                        },\n                                                        \"children\": null,\n                                                        \"li_attr\": {\n                                                            \"class\": \" warning-node\"\n                                                        },\n                                                        \"a_attr\": []\n                                                    }\n                                                ],\n                                                \"li_attr\": {\n                                                    \"data-full-loaded\": false,\n                                                    \"class\": \" warning-node\"\n                                                },\n                                                \"a_attr\": []\n                                            },\n                                            {\n                                                \"text\": \"10 <span class=\\\"size\\\" >86.2MB<\\/span> <span class=\\\"nodes\\\" >33<\\/span>\",\n                                                \"fullPath\": \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/2025\\/10\",\n                                                \"type\": \"folder\",\n                                                \"state\": {\n                                                    \"opened\": true,\n                                                    \"disabled\": false,\n                                                    \"selected\": false,\n                                                    \"checked\": false,\n                                                    \"checkbox_disabled\": false\n                                                },\n                                                \"children\": [\n                                                    {\n                                                        \"text\": \"INSTALLATION_NRLINK_video_BoWatts.mp4 <span class=\\\"size\\\" >85.55MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                        \"fullPath\": \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/2025\\/10\\/INSTALLATION_NRLINK_video_BoWatts.mp4\",\n                                                        \"type\": \"file\",\n                                                        \"state\": {\n                                                            \"opened\": false,\n                                                            \"disabled\": false,\n                                                            \"selected\": false,\n                                                            \"checked\": false,\n                                                            \"checkbox_disabled\": false\n                                                        },\n                                                        \"children\": null,\n                                                        \"li_attr\": {\n                                                            \"class\": \" warning-node\"\n                                                        },\n                                                        \"a_attr\": []\n                                                    }\n                                                ],\n                                                \"li_attr\": {\n                                                    \"data-full-loaded\": false,\n                                                    \"class\": \" warning-childs\"\n                                                },\n                                                \"a_attr\": []\n                                            }\n                                        ],\n                                        \"li_attr\": {\n                                            \"data-full-loaded\": false,\n                                            \"class\": \" warning-node\"\n                                        },\n                                        \"a_attr\": []\n                                    }\n                                ],\n                                \"li_attr\": {\n                                    \"data-full-loaded\": false,\n                                    \"class\": \" warning-node\"\n                                },\n                                \"a_attr\": []\n                            }\n                        ],\n                        \"li_attr\": {\n                            \"data-full-loaded\": false,\n                            \"class\": \" warning-node\"\n                        },\n                        \"a_attr\": []\n                    },\n                    {\n                        \"text\": \"pdf <span class=\\\"size\\\" >27.63MB<\\/span> <span class=\\\"nodes\\\" >14<\\/span>\",\n                        \"fullPath\": \"\\/home\\/bowattu\\/www\\/pdf\",\n                        \"type\": \"folder\",\n                        \"state\": {\n                            \"opened\": true,\n                            \"disabled\": false,\n                            \"selected\": false,\n                            \"checked\": false,\n                            \"checkbox_disabled\": false\n                        },\n                        \"children\": [\n                            {\n                                \"text\": \"CCSB-BOWATTS-DP-20230505.pdf <span class=\\\"size\\\" >10.86MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                \"fullPath\": \"\\/home\\/bowattu\\/www\\/pdf\\/CCSB-BOWATTS-DP-20230505.pdf\",\n                                \"type\": \"file\",\n                                \"state\": {\n                                    \"opened\": false,\n                                    \"disabled\": false,\n                                    \"selected\": false,\n                                    \"checked\": false,\n                                    \"checkbox_disabled\": false\n                                },\n                                \"children\": null,\n                                \"li_attr\": {\n                                    \"class\": \" warning-node\"\n                                },\n                                \"a_attr\": []\n                            },\n                            {\n                                \"text\": \"GUIDE-INSTALLATION-NRLINK.pdf <span class=\\\"size\\\" >6.81MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                \"fullPath\": \"\\/home\\/bowattu\\/www\\/pdf\\/GUIDE-INSTALLATION-NRLINK.pdf\",\n                                \"type\": \"file\",\n                                \"state\": {\n                                    \"opened\": false,\n                                    \"disabled\": false,\n                                    \"selected\": false,\n                                    \"checked\": false,\n                                    \"checkbox_disabled\": false\n                                },\n                                \"children\": null,\n                                \"li_attr\": {\n                                    \"class\": \" warning-node\"\n                                },\n                                \"a_attr\": []\n                            }\n                        ],\n                        \"li_attr\": {\n                            \"data-full-loaded\": false,\n                            \"class\": \" warning-childs\"\n                        },\n                        \"a_attr\": []\n                    }\n                ],\n                \"li_attr\": {\n                    \"data-full-loaded\": false,\n                    \"class\": \" root-node core-node warning-childs\"\n                },\n                \"a_attr\": {\n                    \"title\": \"Core WordPress directories should not be filtered. Use caution when excluding files.\"\n                }\n            }\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"251119_Bowatts_038479e39d6aad427662_20251119091044_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"A\\/S1kqMCMPcf4vlEUrIujqRfctbyl9oQXKQiGdH4nSz0VYTizKXsS\\/kGAZYk92fQQF8Rq6OQBHFM+Sgj6L\\/7IdwZs0xgPFFFlj6OaApXORw7OC9Q7b9E23Se3vbgD6ZI\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_unicode_ci\",\n                \"utf8mb4_0900_ai_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"bowattu919\",\n            \"tablesBaseCount\": 46,\n            \"tablesFinalCount\": 46,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 2393,\n            \"tablesSizeOnDisk\": 61915136,\n            \"tablesList\": {\n                \"mod119_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"37\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"mod119_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"mod119_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"mod119_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"109\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"mod119_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"mod119_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"mod119_duplicator_activity_logs\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"mod119_duplicator_backups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 245760\n                },\n                \"mod119_duplicator_entities\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"mod119_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"mod119_masterslider_options\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"mod119_masterslider_sliders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"mod119_maxbuttons_collections\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"mod119_maxbuttons_collections_trans\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"mod119_maxbuttonsv3\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"mod119_nextend2_image_storage\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"mod119_nextend2_section_storage\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 0,\n                    \"size\": 442368\n                },\n                \"mod119_nextend2_smartslider3_generators\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"mod119_nextend2_smartslider3_sliders\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"mod119_nextend2_smartslider3_sliders_xref\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"mod119_nextend2_smartslider3_slides\": {\n                    \"inaccurateRows\": \"50\",\n                    \"insertedRows\": 0,\n                    \"size\": 1687552\n                },\n                \"mod119_options\": {\n                    \"inaccurateRows\": \"331\",\n                    \"insertedRows\": 0,\n                    \"size\": 2670592\n                },\n                \"mod119_postmeta\": {\n                    \"inaccurateRows\": \"1091\",\n                    \"insertedRows\": 0,\n                    \"size\": 26853376\n                },\n                \"mod119_posts\": {\n                    \"inaccurateRows\": \"469\",\n                    \"insertedRows\": 0,\n                    \"size\": 27869184\n                },\n                \"mod119_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"mod119_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"mod119_redirection_404\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"mod119_redirection_groups\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"mod119_redirection_items\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"mod119_redirection_logs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"mod119_revslider_css\": {\n                    \"inaccurateRows\": \"109\",\n                    \"insertedRows\": 0,\n                    \"size\": 147456\n                },\n                \"mod119_revslider_layer_animations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"mod119_revslider_navigations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"mod119_revslider_sliders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"mod119_revslider_sliders7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"mod119_revslider_slides\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"mod119_revslider_slides7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"mod119_revslider_static_slides\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"mod119_sib_model_forms\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"mod119_sib_model_users\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"mod119_term_relationships\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"mod119_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"mod119_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"mod119_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"mod119_usermeta\": {\n                    \"inaccurateRows\": \"98\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"mod119_users\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.43\",\n            \"versionComment\": \"Percona Server (GPL), Release \'34\', Revision \'e2841f91\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"251119_Bowatts_038479e39d6aad427662_20251119091044_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;34&#039;, Revision &#039;e2841f91&#039;\",\n        \"dbStorePathPublic\": \"\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 5,\n    \"progressPercent\": 5,\n    \"schedule_id\": -1,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 3,\n            \"storageClass\": \"Duplicator\\\\Models\\\\Storages\\\\AbstractStorageEntity\",\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.22.6\",\n    \"created\": \"2025-11-19 09:10:44\",\n    \"updated\": \"2025-11-19 09:10:51\",\n    \"flags\": [\n        \"MANUAL\",\n        \"ZIP_ARCHIVE\",\n        \"TEMPORARY\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 19,\n    \"mainActivityLogId\": 0\n}","4.5.22.6","2025-11-19 09:10:44","2025-11-19 09:10:51"),
("8","Standard","251119_Bowatts","038479e39d6aad427662_20251119091044","251119_Bowatts_038479e39d6aad427662_20251119091044_archive.zip","20","MANUAL,ZIP_ARCHIVE","{\n    \"ID\": 8,\n    \"VersionWP\": \"6.8.3\",\n    \"VersionDB\": \"8.0.43\",\n    \"VersionPHP\": \"8.4.10\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"251119_Bowatts\",\n    \"hash\": \"038479e39d6aad427662_20251119091044\",\n    \"execType\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/bowattu\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"251119_Bowatts_038479e39d6aad427662_20251119091044_scan.json\",\n    \"timer_start\": 1763543472.741006,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/bowattu\\/www\\/.opcache\",\n            \"\\/home\\/bowattu\\/www\\/.tmb\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/bowattu\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/bowattu\\/www\\/.htaccess\",\n            \"\\/home\\/bowattu\\/www\\/.user.ini\",\n            \"\\/home\\/bowattu\\/www\\/php.ini\",\n            \"\\/home\\/bowattu\\/www\\/web.config\",\n            \"\\/home\\/bowattu\\/www\\/wp-config.php\",\n            \"\\/home\\/bowattu\\/www\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"251119_Bowatts_038479e39d6aad427662_20251119091044_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/bowattu\\/www\\/\",\n        \"Size\": 672758315,\n        \"Dirs\": [],\n        \"DirCount\": 2637,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 17801,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [\n                    {\n                        \"ubytes\": 314391424,\n                        \"bytes\": \"299.83MB\",\n                        \"nodes\": 14928,\n                        \"name\": \"plugins\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/plugins\"\n                    },\n                    {\n                        \"ubytes\": 140720153,\n                        \"bytes\": \"134.2MB\",\n                        \"nodes\": 665,\n                        \"name\": \"09\",\n                        \"dir\": \"wp-content\\/uploads\\/2025\",\n                        \"path\": \"wp-content\\/uploads\\/2025\\/09\"\n                    },\n                    {\n                        \"ubytes\": 233604260,\n                        \"bytes\": \"222.78MB\",\n                        \"nodes\": 746,\n                        \"name\": \"2025\",\n                        \"dir\": \"wp-content\\/uploads\",\n                        \"path\": \"wp-content\\/uploads\\/2025\"\n                    },\n                    {\n                        \"ubytes\": 240257331,\n                        \"bytes\": \"229.13MB\",\n                        \"nodes\": 834,\n                        \"name\": \"uploads\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/uploads\"\n                    },\n                    {\n                        \"ubytes\": 583440324,\n                        \"bytes\": \"556.41MB\",\n                        \"nodes\": 17336,\n                        \"name\": \"wp-content\",\n                        \"dir\": \".\",\n                        \"path\": \"wp-content\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"\\/home\\/bowattu\\/www\\/wp-snapshots\",\n                    \"\\/home\\/bowattu\\/www\\/.opcache\",\n                    \"\\/home\\/bowattu\\/www\\/.tmb\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/backups-dup-lite\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/backups-dup-pro\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/ai1wm-backups\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/backupwordpress\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/content\\/cache\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/contents\\/cache\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/infinitewp\\/backups\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/managewp\\/backups\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/old-cache\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/updraft\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/wpvividbackups\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/wishlist-backup\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/wfcache\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/bps-backup\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/cache\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/snapshots\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/sucuri\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/wp-clone\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/uploads\\/backup-guard\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [\n                    {\n                        \"ubytes\": 11382589,\n                        \"bytes\": \"10.86MB\",\n                        \"nodes\": 1,\n                        \"name\": \"CCSB-BOWATTS-DP-20230505.pdf\",\n                        \"dir\": \"pdf\",\n                        \"path\": \"pdf\\/CCSB-BOWATTS-DP-20230505.pdf\"\n                    },\n                    {\n                        \"ubytes\": 7143439,\n                        \"bytes\": \"6.81MB\",\n                        \"nodes\": 1,\n                        \"name\": \"GUIDE-INSTALLATION-NRLINK.pdf\",\n                        \"dir\": \"pdf\",\n                        \"path\": \"pdf\\/GUIDE-INSTALLATION-NRLINK.pdf\"\n                    },\n                    {\n                        \"ubytes\": 11481352,\n                        \"bytes\": \"10.95MB\",\n                        \"nodes\": 1,\n                        \"name\": \"content.xml\",\n                        \"dir\": \"wp-content\\/plugins\\/oshine-core\\/inc\\/importer\\/demo-files\\/v1\",\n                        \"path\": \"wp-content\\/plugins\\/oshine-core\\/inc\\/importer\\/demo-files\\/v1\\/content.xml\"\n                    },\n                    {\n                        \"ubytes\": 5884758,\n                        \"bytes\": \"5.61MB\",\n                        \"nodes\": 1,\n                        \"name\": \"bundle.js\",\n                        \"dir\": \"wp-content\\/plugins\\/tatsu\\/builder\\/js\",\n                        \"path\": \"wp-content\\/plugins\\/tatsu\\/builder\\/js\\/bundle.js\"\n                    },\n                    {\n                        \"ubytes\": 5275313,\n                        \"bytes\": \"5.03MB\",\n                        \"nodes\": 1,\n                        \"name\": \"content.xml\",\n                        \"dir\": \"wp-content\\/plugins\\/tatsu\\/includes\\/demo-import\\/inc\\/importer\\/demo-files\\/seo-agency\",\n                        \"path\": \"wp-content\\/plugins\\/tatsu\\/includes\\/demo-import\\/inc\\/importer\\/demo-files\\/seo-agency\\/content.xml\"\n                    },\n                    {\n                        \"ubytes\": 17417495,\n                        \"bytes\": \"16.61MB\",\n                        \"nodes\": 1,\n                        \"name\": \"stats.json\",\n                        \"dir\": \"wp-content\\/plugins\\/tatsu\\/includes\\/typehub\",\n                        \"path\": \"wp-content\\/plugins\\/tatsu\\/includes\\/typehub\\/stats.json\"\n                    },\n                    {\n                        \"ubytes\": 5634017,\n                        \"bytes\": \"5.37MB\",\n                        \"nodes\": 1,\n                        \"name\": \"Bowatts_Header-PRO-1.jpg\",\n                        \"dir\": \"wp-content\\/uploads\\/2025\\/09\",\n                        \"path\": \"wp-content\\/uploads\\/2025\\/09\\/Bowatts_Header-PRO-1.jpg\"\n                    },\n                    {\n                        \"ubytes\": 4635273,\n                        \"bytes\": \"4.42MB\",\n                        \"nodes\": 1,\n                        \"name\": \"Bowatts_Header-Particulier-1.jpg\",\n                        \"dir\": \"wp-content\\/uploads\\/2025\\/09\",\n                        \"path\": \"wp-content\\/uploads\\/2025\\/09\\/Bowatts_Header-Particulier-1.jpg\"\n                    },\n                    {\n                        \"ubytes\": 66541019,\n                        \"bytes\": \"63.46MB\",\n                        \"nodes\": 1,\n                        \"name\": \"CCSB-BoWatts-Teaser.mp4\",\n                        \"dir\": \"wp-content\\/uploads\\/2025\\/09\",\n                        \"path\": \"wp-content\\/uploads\\/2025\\/09\\/CCSB-BoWatts-Teaser.mp4\"\n                    },\n                    {\n                        \"ubytes\": 89703380,\n                        \"bytes\": \"85.55MB\",\n                        \"nodes\": 1,\n                        \"name\": \"INSTALLATION_NRLINK_video_BoWatts.mp4\",\n                        \"dir\": \"wp-content\\/uploads\\/2025\\/10\",\n                        \"path\": \"wp-content\\/uploads\\/2025\\/10\\/INSTALLATION_NRLINK_video_BoWatts.mp4\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"error_log\",\n                    \"debug_log\",\n                    \"ws_ftp.log\",\n                    \"dbcache\",\n                    \"pgcache\",\n                    \"objectcache\",\n                    \".DS_Store\",\n                    \"\\/home\\/bowattu\\/www\\/.htaccess\",\n                    \"\\/home\\/bowattu\\/www\\/.user.ini\",\n                    \"\\/home\\/bowattu\\/www\\/php.ini\",\n                    \"\\/home\\/bowattu\\/www\\/web.config\",\n                    \"\\/home\\/bowattu\\/www\\/wp-content\\/debug.log\",\n                    \"\\/home\\/bowattu\\/www\\/wp-config.php\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": {\n                \"treeList\": []\n            }\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"251119_Bowatts_038479e39d6aad427662_20251119091044_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"IkLlLpXb7YB5tTLsFIbDEJnocvP\\/y4n7iEcIlpgrcs30VYTizKXsS\\/kGAZYk92fQQF8Rq6OQBHHOE+Jcx1uuARIetXgspjZnlgtqFypz55YGhsjRMw5x9Kr7sGxSBci3\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_unicode_ci\",\n                \"utf8mb4_0900_ai_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"bowattu919\",\n            \"tablesBaseCount\": 46,\n            \"tablesFinalCount\": 46,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 2393,\n            \"tablesSizeOnDisk\": 61915136,\n            \"tablesList\": {\n                \"mod119_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"37\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"mod119_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"mod119_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"mod119_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"109\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"mod119_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"mod119_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"mod119_duplicator_activity_logs\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"mod119_duplicator_backups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 245760\n                },\n                \"mod119_duplicator_entities\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"mod119_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"mod119_masterslider_options\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"mod119_masterslider_sliders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"mod119_maxbuttons_collections\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"mod119_maxbuttons_collections_trans\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"mod119_maxbuttonsv3\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"mod119_nextend2_image_storage\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"mod119_nextend2_section_storage\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 0,\n                    \"size\": 442368\n                },\n                \"mod119_nextend2_smartslider3_generators\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"mod119_nextend2_smartslider3_sliders\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"mod119_nextend2_smartslider3_sliders_xref\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"mod119_nextend2_smartslider3_slides\": {\n                    \"inaccurateRows\": \"50\",\n                    \"insertedRows\": 0,\n                    \"size\": 1687552\n                },\n                \"mod119_options\": {\n                    \"inaccurateRows\": \"331\",\n                    \"insertedRows\": 0,\n                    \"size\": 2670592\n                },\n                \"mod119_postmeta\": {\n                    \"inaccurateRows\": \"1091\",\n                    \"insertedRows\": 0,\n                    \"size\": 26853376\n                },\n                \"mod119_posts\": {\n                    \"inaccurateRows\": \"469\",\n                    \"insertedRows\": 0,\n                    \"size\": 27869184\n                },\n                \"mod119_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"mod119_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"mod119_redirection_404\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"mod119_redirection_groups\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"mod119_redirection_items\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"mod119_redirection_logs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"mod119_revslider_css\": {\n                    \"inaccurateRows\": \"109\",\n                    \"insertedRows\": 0,\n                    \"size\": 147456\n                },\n                \"mod119_revslider_layer_animations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"mod119_revslider_navigations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"mod119_revslider_sliders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"mod119_revslider_sliders7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"mod119_revslider_slides\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"mod119_revslider_slides7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"mod119_revslider_static_slides\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"mod119_sib_model_forms\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"mod119_sib_model_users\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"mod119_term_relationships\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"mod119_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"mod119_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"mod119_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"mod119_usermeta\": {\n                    \"inaccurateRows\": \"98\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"mod119_users\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.43\",\n            \"versionComment\": \"Percona Server (GPL), Release \'34\', Revision \'e2841f91\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"251119_Bowatts_038479e39d6aad427662_20251119091044_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;34&#039;, Revision &#039;e2841f91&#039;\",\n        \"dbStorePathPublic\": \"\\/home\\/bowattu\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/251119_Bowatts_038479e39d6aad427662_20251119091044_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 20,\n    \"progressPercent\": 20,\n    \"schedule_id\": -1,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 1763543474,\n        \"initialized\": true,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [\n            \"mod119_users\",\n            \"mod119_usermeta\",\n            \"mod119_actionscheduler_actions\",\n            \"mod119_actionscheduler_claims\",\n            \"mod119_actionscheduler_groups\",\n            \"mod119_actionscheduler_logs\",\n            \"mod119_commentmeta\",\n            \"mod119_comments\",\n            \"mod119_duplicator_activity_logs\",\n            \"mod119_duplicator_backups\",\n            \"mod119_duplicator_entities\",\n            \"mod119_links\",\n            \"mod119_masterslider_options\",\n            \"mod119_masterslider_sliders\",\n            \"mod119_maxbuttons_collections\",\n            \"mod119_maxbuttons_collections_trans\",\n            \"mod119_maxbuttonsv3\",\n            \"mod119_nextend2_image_storage\",\n            \"mod119_nextend2_section_storage\",\n            \"mod119_nextend2_smartslider3_generators\",\n            \"mod119_nextend2_smartslider3_sliders\",\n            \"mod119_nextend2_smartslider3_sliders_xref\",\n            \"mod119_nextend2_smartslider3_slides\",\n            \"mod119_options\",\n            \"mod119_postmeta\",\n            \"mod119_posts\",\n            \"mod119_rank_math_internal_links\",\n            \"mod119_rank_math_internal_meta\",\n            \"mod119_redirection_404\",\n            \"mod119_redirection_groups\",\n            \"mod119_redirection_items\",\n            \"mod119_redirection_logs\",\n            \"mod119_revslider_css\",\n            \"mod119_revslider_layer_animations\",\n            \"mod119_revslider_navigations\",\n            \"mod119_revslider_sliders\",\n            \"mod119_revslider_sliders7\",\n            \"mod119_revslider_slides\",\n            \"mod119_revslider_slides7\",\n            \"mod119_revslider_static_slides\",\n            \"mod119_sib_model_forms\",\n            \"mod119_sib_model_users\",\n            \"mod119_term_relationships\",\n            \"mod119_term_taxonomy\",\n            \"mod119_termmeta\",\n            \"mod119_terms\"\n        ],\n        \"validationStage1\": false,\n        \"doneInit\": true,\n        \"doneFiltering\": true,\n        \"doneCreates\": true,\n        \"completed\": false,\n        \"startTime\": 1763543472.754724,\n        \"wasInterrupted\": true,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"countTotal\": 0,\n            \"impreciseTotalRows\": 2393,\n            \"tables\": {\n                \"mod119_users\": {\n                    \"start\": \"4\",\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_usermeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_actionscheduler_actions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_actionscheduler_claims\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_actionscheduler_groups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_actionscheduler_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_commentmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_comments\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_duplicator_activity_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_duplicator_backups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_duplicator_entities\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_masterslider_options\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_masterslider_sliders\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_maxbuttons_collections\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_maxbuttons_collections_trans\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_maxbuttonsv3\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_nextend2_image_storage\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_nextend2_section_storage\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_nextend2_smartslider3_generators\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_nextend2_smartslider3_sliders\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_nextend2_smartslider3_sliders_xref\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_nextend2_smartslider3_slides\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_options\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_postmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_posts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_rank_math_internal_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_rank_math_internal_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_redirection_404\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_redirection_groups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_redirection_items\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_redirection_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_revslider_css\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_revslider_layer_animations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_revslider_navigations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_revslider_sliders\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_revslider_sliders7\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_revslider_slides\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_revslider_slides7\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_revslider_static_slides\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_sib_model_forms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_sib_model_users\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_term_relationships\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_term_taxonomy\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_termmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"mod119_terms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                }\n            }\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 3,\n            \"storageClass\": \"Duplicator\\\\Models\\\\Storages\\\\AbstractStorageEntity\",\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.22.6\",\n    \"created\": \"2025-11-19 09:10:44\",\n    \"updated\": \"2025-11-19 09:11:14\",\n    \"flags\": [\n        \"MANUAL\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 19,\n    \"mainActivityLogId\": 21\n}","4.5.22.6","2025-11-19 09:10:44","2025-11-19 09:11:14");

INSERT IGNORE INTO `mod119_duplicator_entities` VALUES 
("1","DUP_PRO_Global_Entity","","","","","","{\n    \"uninstall_settings\": false,\n    \"uninstall_packages\": false,\n    \"crypt\": true,\n    \"email_summary_frequency\": \"never\",\n    \"email_summary_recipients\": [],\n    \"usageTracking\": true,\n    \"amNotices\": true,\n    \"package_mysqldump\": false,\n    \"package_mysqldump_path\": \"\",\n    \"package_phpdump_mode\": 0,\n    \"package_mysqldump_qrylimit\": 131072,\n    \"packageMysqldumpOptions\": [\n        {\n            \"option\": \"quick\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"extended-insert\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"routines\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": true,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"disable-keys\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"compact\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        }\n    ],\n    \"archive_build_mode\": 2,\n    \"archive_compression\": true,\n    \"ziparchive_validation\": false,\n    \"ziparchive_mode\": 0,\n    \"ziparchive_chunk_size_in_mb\": 32,\n    \"homepath_as_abspath\": false,\n    \"server_load_reduction\": 0,\n    \"max_package_runtime_in_min\": 90,\n    \"max_package_transfer_time_in_min\": 90,\n    \"php_max_worker_time_in_sec\": 20,\n    \"cleanup_mode\": 0,\n    \"cleanup_email\": \"mathias@hikory.fr\",\n    \"auto_cleanup_hours\": 24,\n    \"lock_mode\": 1,\n    \"ajax_protocol\": \"admin\",\n    \"custom_ajax_url\": \"https:\\/\\/www.dev.bowatts-beaujolais.fr\\/wp-admin\\/admin-ajax.php\",\n    \"clientside_kickoff\": false,\n    \"basic_auth_enabled\": false,\n    \"basic_auth_user\": \"\",\n    \"basic_auth_password\": \"\",\n    \"installer_name_mode\": \"simple\",\n    \"installer_base_name\": \"installer.php\",\n    \"skip_archive_scan\": false,\n    \"send_email_on_build_mode\": 1,\n    \"notification_email_address\": \"\",\n    \"storage_htaccess_off\": false,\n    \"max_storage_retries\": 10,\n    \"purgeBackupRecords\": 0,\n    \"manual_mode_storage_ids\": [\n        3\n    ],\n    \"license_key_visible\": 1,\n    \"lkp\": \"\",\n    \"last_system_check_timestamp\": 0,\n    \"initial_activation_timestamp\": 1757497114,\n    \"ssl_useservercerts\": true,\n    \"ssl_disableverify\": true,\n    \"import_chunk_size\": 1024,\n    \"import_custom_path\": \"\",\n    \"ipv4_only\": false,\n    \"unhook_third_party_js\": false,\n    \"unhook_third_party_css\": false,\n    \"recoveryCustomPath\": \"\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 1,\n    \"version\": \"4.5.22.6\",\n    \"created\": \"2025-09-10 09:38:33\",\n    \"updated\": \"2025-11-19 09:10:44\"\n}","4.5.22.6","2025-09-10 09:38:33","2025-11-19 09:10:44"),
("2","Dynamic_Entity","","","","","","{\n    \"data\": \"X+UGZrbXNE1gbze39YeUWYQibpe5bgbxErzGvV9Gd2\\/BFaHeRXJk23tyY9Ea+ShqmwkmqiQXOahgzAJ0quMHJ3tyY9Ea+Shq\\/AZ2sSUkxglHWFqDisiMWSWUhixJnJLP1ljmHnyB1m6mUo52gg4jxZyYBhBlEqWYrfZ8fRlHJ8pZps+KiYb+JJkQSSuE7r7+gHDTxghX1Klg4Ye4bonhohFwzNG9+dNAy0DUzoXsW5D0UQfx7dyFvjrZ2HHGGzLmPrB6MdHGRKYtEiZZGmfx5Q==\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 2,\n    \"version\": \"4.5.22.6\",\n    \"created\": \"2025-09-10 09:38:33\",\n    \"updated\": \"2025-11-19 09:09:40\",\n    \"dataIsEncrypted\": true\n}","4.5.22.6","2025-09-10 09:38:33","2025-11-19 09:09:40"),
("3","DUP_PRO_Storage_Entity","","","","","","{\n    \"name\": \"Default\",\n    \"notes\": \"The default location for storage on this server.\",\n    \"storage_type\": -2,\n    \"config\": \"n7hSVOd9liFWblHb6GHJYfuTdm4jdtopauYAIl6wszSaC53O4ATRVaidtNBDcOXvZMe3GdMmPobe+Isrx+TCgwjq1htDPNaTNXwm2UPUE3TFg5ZrOa61tkpZrk7CTeI0yJ3nKdBHjcm+dWcYPxpKDbhkDL6fLfoNB8sP\\/xRTWUAfzZMLZHZrX5RrGDneDx9N8P3HpINdJ59nFuPH2\\/SlOPVuPhS+PZCMVaFPYZqVt1dGE3Ac35p\\/gg==\",\n    \"legacyEntity\": false,\n    \"local_storage_folder\": \"\",\n    \"local_max_files\": 10,\n    \"local_filter_protection\": true,\n    \"purge_package_record\": true,\n    \"dropbox_access_token\": \"\",\n    \"dropbox_access_token_secret\": \"\",\n    \"dropbox_v2_access_token\": \"\",\n    \"dropbox_storage_folder\": \"\",\n    \"dropbox_max_files\": 10,\n    \"dropbox_authorization_state\": 0,\n    \"onedrive_endpoint_url\": \"\",\n    \"onedrive_resource_id\": \"\",\n    \"onedrive_access_token\": \"\",\n    \"onedrive_refresh_token\": \"\",\n    \"onedrive_token_obtained\": 0,\n    \"onedrive_user_id\": \"\",\n    \"onedrive_storage_folder\": \"\",\n    \"onedrive_max_files\": 10,\n    \"onedrive_storage_folder_id\": \"\",\n    \"onedrive_authorization_state\": 0,\n    \"onedrive_storage_folder_web_url\": \"\",\n    \"ftp_server\": \"\",\n    \"ftp_port\": 21,\n    \"ftp_username\": \"\",\n    \"ftp_password\": \"\",\n    \"ftp_use_curl\": false,\n    \"ftp_storage_folder\": \"\",\n    \"ftp_max_files\": 10,\n    \"ftp_timeout_in_secs\": 15,\n    \"ftp_ssl\": false,\n    \"ftp_passive_mode\": false,\n    \"sftp_server\": \"\",\n    \"sftp_port\": 22,\n    \"sftp_username\": \"\",\n    \"sftp_password\": \"\",\n    \"sftp_private_key\": \"\",\n    \"sftp_private_key_password\": \"\",\n    \"sftp_storage_folder\": \"\",\n    \"sftp_timeout_in_secs\": 15,\n    \"sftp_max_files\": 10,\n    \"sftp_disable_chunking_mode\": false,\n    \"gdrive_access_token_set_json\": \"\",\n    \"gdrive_refresh_token\": \"\",\n    \"gdrive_storage_folder\": \"\",\n    \"gdrive_max_files\": 10,\n    \"gdrive_authorization_state\": 0,\n    \"gdrive_client_number\": -1,\n    \"s3_access_key\": \"\",\n    \"s3_bucket\": \"\",\n    \"s3_max_files\": 10,\n    \"s3_provider\": \"amazon\",\n    \"s3_region\": \"\",\n    \"s3_endpoint\": \"\",\n    \"s3_secret_key\": \"\",\n    \"s3_storage_class\": \"STANDARD\",\n    \"s3_storage_folder\": \"\",\n    \"s3_ACL_full_control\": true,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 3,\n    \"version\": \"4.5.22.6\",\n    \"created\": \"2025-09-10 09:38:33\",\n    \"updated\": \"2025-09-17 16:03:06\"\n}","4.5.22.6","2025-09-10 09:38:33","2025-09-17 16:03:06"),
("4","EmailSummary","","","","","","{\n    \"manualPackageIds\": [],\n    \"scheduledPackageIds\": [],\n    \"failedPackageIds\": [],\n    \"failedUploads\": [],\n    \"cancelledUploads\": [],\n    \"successfulUploads\": [],\n    \"scheduleIds\": [],\n    \"storageIds\": [],\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 4,\n    \"version\": \"4.5.22.6\",\n    \"created\": \"\",\n    \"updated\": \"2025-11-17 12:05:09\"\n}","4.5.22.6","2025-09-10 09:38:33","2025-11-17 12:05:09"),
("5","DUP_PRO_Package_Template_Entity","","","","","","{\n    \"name\": \"Default\",\n    \"package_name_format\": \"%year%%month%%day%_%sitetitle%\",\n    \"notes\": \"The default template.\",\n    \"filter_sites\": [],\n    \"archive_export_onlydb\": false,\n    \"archive_filter_on\": false,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": false,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installerPassowrd\": \"c0Fw7JponJPS4RC7HemE2EmoVVhJDuSv5CeZDBEJBoWRakk4r7NkNc5wPROJTdpgMNlzIBHeTSe\\/SiLkNCalXw==\",\n    \"installer_opts_skip_scan\": false,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": true,\n    \"is_manual\": false,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 5,\n    \"version\": \"4.5.22.5\",\n    \"created\": \"2025-09-10 09:38:33\",\n    \"updated\": \"2025-09-10 09:38:33\"\n}","4.5.22.5","2025-09-10 09:38:33","2025-09-10 09:38:33"),
("6","DUP_PRO_Package_Template_Entity","","","","","","{\n    \"name\": \"[Manual Mode]\",\n    \"package_name_format\": \"251119_Bowatts\",\n    \"notes\": \"\",\n    \"filter_sites\": \"\",\n    \"archive_export_onlydb\": false,\n    \"archive_filter_on\": false,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": false,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installerPassowrd\": \"H1t20av5UjGpNTL3Xq9nNnA4TLkIcLuuaBByCQh+TyT0VYTizKXsS\\/kGAZYk92fQQF8Rq6OQBHHnY4DAWPRsTpWhGI6cPM6cfOp8WoYM84tgT23BvTstORdCEvuNfT0w\",\n    \"installer_opts_skip_scan\": false,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -1,\n    \"is_default\": false,\n    \"is_manual\": true,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 6,\n    \"version\": \"4.5.22.6\",\n    \"created\": \"2025-09-10 09:38:33\",\n    \"updated\": \"2025-11-19 09:10:44\"\n}","4.5.22.6","2025-09-10 09:38:33","2025-11-19 09:10:44"),
("7","LicenseDataEntity","","","","","","{\n    \"licenseKey\": \"+XFbtjlQgKg9Gh9oa0qroV+Y90lsYmX59xarnwPel9xXUG58QK9+8rkXdXNUZNjSftXt9l50wYgBIxlwt2U0\\/\\/9kGDSTRXjsotrQeDMAhSqC22EZqgux4JDBEkx2Y+BK\",\n    \"status\": \"0\\/4vmwDw3Ss51uFxB\\/ewaHFTwlX0HULz5xBDB2Aqh3rNty0RCRSp\\/PWPzZANgw48HnU9EuzVdV+k48wPcYUcdS\\/KlDvgXS3Y\",\n    \"type\": \"M29kENU9FLoJWIBDpouSCsndqenZ2Qp+sQWFlBmRUjcWBX28A+OY2hioR\\/s27zr+3nU+9FKKoSUNPTUVAigFfLL\\/h+yMX3hb\",\n    \"data\": \"VGHu3k8lNB\\/90uJxpg7VXcXCSbENm1Qu7eVR6hNRBSykrWJGqYXxRarvh\\/VdY3G1+CLGyUuO9YDJA76Y3dkzanNARSADqzuDuStUQTmsCtDdqSyb\\/muCSrA9uH6t35XI7+oOmuh2pUjGCrW6owxa\\/JaK4VcSOzW+VG+i+8Ge8egYy8aFmo65XxUSReZBzYcpVgmuRmYxwHlNs+2A\\/hFrD5FYRxT3FFf+Ns7DwlmgJRQ0VmZpZtnL+kgkuk8ewjt\\/dXryRO1bjfDlH2XLPYAOGUz7\\/uMUz2VTQJqe5VE4TZn4IsbJS471gOq+CFvMRQ0T92io1MTgwTOnbvmOteOQog\\/JX0zls7YW456ul3fgC0cYMGW6upaAyaP14DEFvyVCeQ4Wn+9Easi3MNwc1EfGvxq9Q2oyHdjVRm5FQLORIkyGGKz8iicAcsgYsbHQSf6Sz50zJblnHhry\\/O5fMBZ6fCvXvcEXX1gs\",\n    \"lastRemoteUpdate\": \"2025-11-19 09:06:49\",\n    \"lastFailureTime\": \"\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 7,\n    \"version\": \"4.5.22.6\",\n    \"created\": \"2025-09-10 09:38:33\",\n    \"updated\": \"2025-11-19 09:06:49\"\n}","4.5.22.6","2025-09-10 09:38:33","2025-11-19 09:06:49"),
("8","DUP_PRO_System_Global_Entity","","","","","","{\n    \"recommended_fixes\": [],\n    \"schedule_failed\": false,\n    \"package_check_ts\": 1763543472,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 8,\n    \"version\": \"4.5.22.6\",\n    \"created\": \"2025-09-10 09:38:34\",\n    \"updated\": \"2025-11-19 09:11:12\"\n}","4.5.22.6","2025-09-10 09:38:34","2025-11-19 09:11:12");

INSERT IGNORE INTO `mod119_masterslider_options` VALUES 
("1","preset_effect","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"),
("2","buttons_style","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"),
("3","masterslider_custom_css_ver","1.1");

INSERT IGNORE INTO `mod119_maxbuttons_collections` VALUES 
("1","1","general","{\"name\":\"\",\"active\":\"1\"}"),
("2","1","network","{\"network_active\":{\"1\":\"facebook\",\"2\":\"instagram\",\"3\":\"linkedin\"},\"mbcustom\":[]}"),
("3","1","display","{\"display_page_options\":[],\"display_post_options\":[],\"display_homepage_options\":[],\"display_archive_options\":[],\"show_desktop\":1,\"show_mobile\":1}"),
("4","1","display_page","after"),
("5","1","display_post","after"),
("6","1","display_homepage","hidden"),
("7","1","display_archive","after"),
("8","1","style","{\"mbs-style\":\"round\",\"mbs-width\":\"45\",\"mbs-height\":\"45\"}"),
("9","1","layout","{\"margin_left\":\"0\",\"margin_right\":\"0\",\"margin_top\":\"0\",\"margin_bottom\":\"0\",\"orientation\":\"auto\",\"font\":\"\",\"font_label_size\":\"12\",\"font_label_style\":\"normal\",\"font_label_weight\":\"normal\",\"font_label_upper\":\"none\",\"font_icon_size\":\"20\",\"font_icon_style\":\"normal\",\"font_icon_weight\":\"normal\",\"use_background\":\"1\",\"background_color\":\"#bfe79c\",\"background_color_hover\":\"#bfe79c\",\"color\":\"#ffffff\",\"color_hover\":\"#1b2127\",\"button_spacing\":\"10\",\"ignore_container\":0,\"webfonts\":null}"),
("10","1","count","{\"count_active\":0,\"share_min_count\":\"5\",\"show_total_count\":\"0\",\"total_count_label\":\"Shares\",\"font_count_size\":\"16\",\"font_count_style\":\"normal\",\"font_count_weight\":\"normal\",\"total_count_color\":\"\"}"),
("11","1","effect","{\"effect_type\":\"transform\",\"scale\":\"120\"}"),
("12","1","profile","{\"profile_twitter\":\"\",\"useprofile_twitter\":0,\"profile_facebook\":\"\",\"useprofile_facebook\":0,\"profile_linkedin\":\"\",\"useprofile_linkedin\":0,\"use_alternate_linkedin\":0,\"profile_reddit\":\"\",\"useprofile_reddit\":0,\"profile_instagram\":\"\",\"profile_youtube\":\"\",\"profile_snapchat\":\"\",\"profile_rss\":\"\",\"profile_vimeo\":\"\",\"profile_tiktok\":\"\",\"profile_phone\":\"\",\"profile_pinterest\":\"\",\"useprofile_pinterest\":0}"),
("13","1","twitter","{\"twitter_handle\":\"\",\"twitter_hash\":\"\"}"),
("14","1","email","{\"email_subject\":\"\",\"email_content\":\"\"}"),
("16","1","collection_type","social_share");

INSERT IGNORE INTO `mod119_maxbuttonsv3` VALUES 
("1","Bouton Particulier","publish",".maxbutton-1.maxbutton.maxbutton-bouton-particulier{position:relative;text-decoration:none;display:inline-block;vertical-align:middle;width:255px;height:58px;border-width:0px;border-radius:0px 0px 30px 30px;background-color:#bfe79c;box-shadow:0px 0px 0px 0px #333333}.maxbutton-1.maxbutton.maxbutton-bouton-particulier:hover{background-color:#bfe79c;box-shadow:0px 0px 0px 0px #333333}.maxbutton-1.maxbutton.maxbutton-bouton-particulier .mb-text{color:#ffffff;font-family:Verdana;font-size:18px;text-align:center;font-style:normal;font-weight:bold;line-height:1em;box-sizing:border-box;display:block;background-color:unset;padding:20px 0px 0px 0px;text-shadow:0px 0px 0px rgba(80, 90, 199, 0)}.maxbutton-1.maxbutton.maxbutton-bouton-particulier:hover .mb-text{color:#1b2127;text-shadow:0px 0px 0px rgba(51, 51, 51, 0)}@media only screen and (min-width:0px) and (max-width:480px){.maxbutton-1.maxbutton.maxbutton-bouton-particulier{width:90%}.maxbutton-1.maxbutton.maxbutton-bouton-particulier .mb-text{font-size:14px}}","{\"min_width\":0,\"max_width\":0,\"hide_screen\":0,\"screen_name\":\"\",\"screens\":[]}","{\"text_color\":\"#ffffff\",\"text_shadow_color\":\"rgba(80, 90, 199, 0)\",\"gradient_start_color\":\"#bfe79c\",\"gradient_end_color\":\"#505ac7\",\"border_color\":\"#bfe79c\",\"box_shadow_color\":\"#333333\",\"text_color_hover\":\"#1b2127\",\"text_shadow_color_hover\":\"rgba(51, 51, 51, 0)\",\"gradient_start_color_hover\":\"#bfe79c\",\"gradient_end_color_hover\":\"#ffffff\",\"border_color_hover\":\"#bfe79c\",\"box_shadow_color_hover\":\"#333333\",\"icon_color\":\"#ffffff\",\"icon_color_hover\":\"#2b469e\"}","{\"name\":\"Bouton Particulier\",\"status\":\"publish\",\"description\":\"\",\"url\":\"\\/offre-particulier\\/\",\"link_title\":\"Offre Particulier\",\"new_window\":\"0\",\"nofollow\":\"0\",\"is_download\":\"0\"}","{\"button_width\":255,\"button_height\":58,\"button_size_unit_width\":\"pixel\",\"button_size_unit_height\":\"pixel\"}","{\"radius_top_left\":0,\"radius_top_right\":0,\"radius_bottom_left\":30,\"radius_bottom_right\":30,\"border_style\":\"solid\",\"border_width\":0,\"box_shadow_offset_left\":0,\"box_shadow_offset_top\":0,\"box_shadow_width\":0,\"box_shadow_spread\":0}","{\"gradient_stop\":\"45\",\"gradient_start_opacity\":\"100\",\"gradient_end_opacity\":\"100\",\"gradient_start_opacity_hover\":\"100\",\"gradient_end_opacity_hover\":\"100\",\"use_gradient\":\"0\"}","{\"text\":\"PARTICULIER\",\"font\":\"Verdana\",\"font_size\":18,\"text_align\":\"center\",\"font_style\":\"normal\",\"font_weight\":\"bold\",\"text_shadow_offset_left\":0,\"text_shadow_offset_top\":0,\"text_shadow_width\":0,\"padding_top\":20,\"padding_right\":0,\"padding_bottom\":0,\"padding_left\":0}","{\"container_enabled\":\"0\",\"container_center_div_wrap\":\"1\",\"container_width\":\"0\",\"container_width_unit\":\"pixel\",\"container_margin_top\":0,\"container_margin_right\":0,\"container_margin_bottom\":0,\"container_margin_left\":0,\"container_alignment\":\"\"}","{\"important_css\":\"0\",\"custom_rel\":\"\",\"extra_classes\":\"\",\"external_css\":\"0\"}","{\"created\":\"1757343501\",\"modified\":1757345878,\"user_created\":\"admin4118\",\"user_modified\":\"admin4118\",\"created_source\":\"editor\",\"user_edited\":\"true\",\"in_collections\":[],\"is_virtual\":\"\"}","2025-09-16 16:13:24","2025-09-08 14:58:21"),
("2","Bouton PRO","publish",".maxbutton-2.maxbutton.maxbutton-bouton-pro{position:relative;text-decoration:none;display:inline-block;vertical-align:middle;width:255px;height:58px;border-width:0px;border-radius:0px 0px 30px 30px;background-color:#83e0c7;box-shadow:0px 0px 0px 0px #333333}.maxbutton-2.maxbutton.maxbutton-bouton-pro:hover{background-color:#83e0c7;box-shadow:0px 0px 0px 0px #333333}.maxbutton-2.maxbutton.maxbutton-bouton-pro .mb-text{color:#ffffff;font-family:Verdana;font-size:18px;text-align:center;font-style:normal;font-weight:bold;line-height:1em;box-sizing:border-box;display:block;background-color:unset;padding:20px 0px 0px 0px;text-shadow:0px 0px 0px rgba(80, 90, 199, 0)}.maxbutton-2.maxbutton.maxbutton-bouton-pro:hover .mb-text{color:#1b2127;text-shadow:0px 0px 0px rgba(51, 51, 51, 0)}@media only screen and (min-width:0px) and (max-width:480px){.maxbutton-2.maxbutton.maxbutton-bouton-pro{width:90%}.maxbutton-2.maxbutton.maxbutton-bouton-pro .mb-text{font-size:14px}}","{\"min_width\":0,\"max_width\":0,\"hide_screen\":0,\"screen_name\":\"\",\"screens\":[]}","{\"text_color\":\"#ffffff\",\"text_shadow_color\":\"rgba(80, 90, 199, 0)\",\"gradient_start_color\":\"#83e0c7\",\"gradient_end_color\":\"#505ac7\",\"border_color\":\"#83e0c7\",\"box_shadow_color\":\"#333333\",\"text_color_hover\":\"#1b2127\",\"text_shadow_color_hover\":\"rgba(51, 51, 51, 0)\",\"gradient_start_color_hover\":\"#83e0c7\",\"gradient_end_color_hover\":\"#ffffff\",\"border_color_hover\":\"#83e0c7\",\"box_shadow_color_hover\":\"#333333\",\"icon_color\":\"#ffffff\",\"icon_color_hover\":\"#2b469e\"}","{\"name\":\"Bouton PRO\",\"status\":\"publish\",\"description\":\"\",\"url\":\"\\/offre-pro\\/\",\"link_title\":\"Offre PRO\",\"new_window\":\"0\",\"nofollow\":\"0\",\"is_download\":\"0\"}","{\"button_width\":255,\"button_height\":58,\"button_size_unit_width\":\"pixel\",\"button_size_unit_height\":\"pixel\"}","{\"radius_top_left\":0,\"radius_top_right\":0,\"radius_bottom_left\":30,\"radius_bottom_right\":30,\"border_style\":\"solid\",\"border_width\":0,\"box_shadow_offset_left\":0,\"box_shadow_offset_top\":0,\"box_shadow_width\":0,\"box_shadow_spread\":0}","{\"gradient_stop\":\"45\",\"gradient_start_opacity\":\"100\",\"gradient_end_opacity\":\"100\",\"gradient_start_opacity_hover\":\"100\",\"gradient_end_opacity_hover\":\"100\",\"use_gradient\":\"0\"}","{\"text\":\"PRO\",\"font\":\"Verdana\",\"font_size\":18,\"text_align\":\"center\",\"font_style\":\"normal\",\"font_weight\":\"bold\",\"text_shadow_offset_left\":0,\"text_shadow_offset_top\":0,\"text_shadow_width\":0,\"padding_top\":20,\"padding_right\":0,\"padding_bottom\":0,\"padding_left\":0}","{\"container_enabled\":\"0\",\"container_center_div_wrap\":\"1\",\"container_width\":\"0\",\"container_width_unit\":\"pixel\",\"container_margin_top\":0,\"container_margin_right\":0,\"container_margin_bottom\":0,\"container_margin_left\":0,\"container_alignment\":\"\"}","{\"important_css\":\"0\",\"custom_rel\":\"\",\"extra_classes\":\"\",\"external_css\":\"0\"}","{\"created\":\"1757343501\",\"modified\":1757345852,\"user_created\":\"admin4118\",\"user_modified\":\"admin4118\",\"created_source\":\"editor\",\"user_edited\":\"true\",\"in_collections\":[],\"is_virtual\":\"\"}","2025-09-16 16:13:24","2025-09-08 15:04:23");

INSERT IGNORE INTO `mod119_nextend2_image_storage` VALUES 
("1","fd47a888a7e3db1b97c9db0e9da36162","$upload$/2025/09/Bulle-temoignage-large.png","eyJkZXNrdG9wLXJldGluYSI6eyJpbWFnZSI6IiJ9LCJ0YWJsZXQiOnsiaW1hZ2UiOiIifSwibW9iaWxlIjp7ImltYWdlIjoiIn19");

INSERT IGNORE INTO `mod119_nextend2_section_storage` VALUES 
("10000","smartslider","settings","","{\"n2_ss3_version\":\"3.5.1.30\\/b:release-3.5.1.30\\/r:5ea20ab392ca2dc373e75a7bbc7698907363db57\"}","0","1"),
("11194","smartslider","tutorial","GettingStarted","1","0","1"),
("12047","cache","notweb/n2-ss-3","data.manifest","{\"generator\":[]}","0","1"),
("12048","cache","notweb/n2-ss-3","variations.manifest","1","0","1"),
("12049","cache","notweb/n2-ss-3","sliderfr_FR1.manifest","{\"hash\":\"\",\"nextCacheRefresh\":2145916800,\"currentPath\":\"c9f4aa5ef7d688ff9a456f13107835ed\",\"version\":\"3.5.1.30\"}","0","1"),
("12050","cache","notweb/n2-ss-3","sliderfr_FR1","{\"html\":\"<div class=\\\"n2-section-smartslider fitvidsignore  n2_clear\\\" data-ssid=\\\"3\\\"><div id=\\\"n2-ss-3-align\\\" class=\\\"n2-ss-align\\\"><div class=\\\"n2-padding\\\"><div id=\\\"n2-ss-3\\\" data-creator=\\\"Smart Slider 3\\\" data-responsive=\\\"auto\\\" class=\\\"n2-ss-slider n2-ow n2-has-hover n2notransition  \\\">\\n        <div class=\\\"n2-ss-slider-1 n2_ss__touch_element n2-ow\\\">\\n            <div class=\\\"n2-ss-slider-2 n2-ow\\\">\\n                                                <div class=\\\"n2-ss-slider-3 n2-ow\\\">\\n\\n                    <div class=\\\"n2-ss-slide-backgrounds n2-ow-all\\\"><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"1\\\" data-mode=\\\"fill\\\"><div class=\\\"n2-ss-slide-background-image\\\" data-blur=\\\"0\\\" data-opacity=\\\"100\\\" data-x=\\\"40\\\" data-y=\\\"41\\\" data-alt=\\\"\\\" data-title=\\\"\\\" style=\\\"--ss-o-pos-x:40%;--ss-o-pos-y:41%\\\"><picture class=\\\"skip-lazy\\\" data-skip-lazy=\\\"1\\\"><img src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/2025\\/09\\/Bulle-temoignage-large.png\\\" alt=\\\"\\\" title=\\\"\\\" loading=\\\"lazy\\\" class=\\\"skip-lazy\\\" data-skip-lazy=\\\"1\\\"><\\/picture><\\/div><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><\\/div>                    <div class=\\\"n2-ss-slider-4 n2-ow\\\">\\n                        <svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 1200 480\\\" data-related-device=\\\"desktopPortrait\\\" class=\\\"n2-ow n2-ss-preserve-size n2-ss-preserve-size--slider n2-ss-slide-limiter\\\"><\\/svg><div data-first=\\\"1\\\" data-slide-duration=\\\"0\\\" data-id=\\\"16\\\" data-slide-public-id=\\\"1\\\" data-title=\\\"Jonathan\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-16\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">Jonathan<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-QVQyBI0bBbx9\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-vv24EkXdn4Kk\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-vv24EkXdn4Kk-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-redmqLyBnZ8V\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-redmqLyBnZ8V-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-qygGxRTn7Vd2\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-qygGxRTn7Vd2-inner\\\"><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-zuCxfw7WUDXC\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-zuCxfw7WUDXC-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-f1oRKMFRgVV2\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-dad50b8a2b6270960678cdc5b68e144f-paragraph   \\\">\\u00ab J\'ai d\\u00e9m\\u00e9nag\\u00e9 mon entreprise le 3 f\\u00e9vrier et j\'ai pu b\\u00e9n\\u00e9ficier d\'un contrat d\'\\u00e9lectricit\\u00e9 chez B\\u00f4Watts PRO directement. Tout s\'est pass\\u00e9 tr\\u00e8s facilement par \\u00e9changes de mails et par t\\u00e9l\\u00e9phone. \\u00bb<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-sKUpuebqF7yM\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-3item2\\\" class=\\\"n2-font-2e9ef9dd17faf2972f5d9899fcf89f7a-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-F7pDPpxpA0nx\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-3item3\\\" class=\\\"n2-font-0b268a7ea04eec4c075b907ab8fc07e9-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">Jonathan, Entreprise L.A.C.S. \\u00e0 Saint-Lager<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-fvS2TwHyBmwz\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-3item4\\\" class=\\\"n2-font-9d2efb481e52329af3ce476067fef4f9-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-nbX37i8UspqY\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">abonn\\u00e9 B\\u00f4Watts PRO depuis le 03\\/02\\/2025<\\/p>\\n<\\/div><\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-kzRm7pp17G2M\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-kzRm7pp17G2M-inner\\\"><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div>                    <\\/div>\\n\\n                                    <\\/div>\\n            <\\/div>\\n        <\\/div>\\n        <\\/div><ss3-loader><\\/ss3-loader><\\/div><\\/div><div class=\\\"n2_clear\\\"><\\/div><\\/div>\",\"assets\":{\"css\":{\"staticGroupPreload\":{\"smartslider\":\"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/smart-slider-3\\/Public\\/SmartSlider3\\/Application\\/Frontend\\/Assets\\/dist\\/smartslider.min.css\"},\"staticGroup\":[],\"files\":[],\"urls\":[],\"codes\":[],\"firstCodes\":[],\"inline\":{\"n2-ss-3\":\"div#n2-ss-3 .n2-ss-slider-1{display:grid;position:relative;}div#n2-ss-3 .n2-ss-slider-2{display:grid;position:relative;overflow:hidden;padding:0px 0px 0px 0px;border:0px solid RGBA(62,62,62,1);border-radius:0px;background-clip:padding-box;background-repeat:repeat;background-position:50% 50%;background-size:cover;background-attachment:scroll;z-index:1;}div#n2-ss-3:not(.n2-ss-loaded) .n2-ss-slider-2{background-image:none !important;}div#n2-ss-3 .n2-ss-slider-3{display:grid;grid-template-areas:\'cover\';position:relative;overflow:hidden;z-index:10;}div#n2-ss-3 .n2-ss-slider-3 > *{grid-area:cover;}div#n2-ss-3 .n2-ss-slide-backgrounds,div#n2-ss-3 .n2-ss-slider-3 > .n2-ss-divider{position:relative;}div#n2-ss-3 .n2-ss-slide-backgrounds{z-index:10;}div#n2-ss-3 .n2-ss-slide-backgrounds > *{overflow:hidden;}div#n2-ss-3 .n2-ss-slide-background{transform:translateX(-100000px);}div#n2-ss-3 .n2-ss-slider-4{place-self:center;position:relative;width:100%;height:100%;z-index:20;display:grid;grid-template-areas:\'slide\';}div#n2-ss-3 .n2-ss-slider-4 > *{grid-area:slide;}div#n2-ss-3.n2-ss-full-page--constrain-ratio .n2-ss-slider-4{height:auto;}div#n2-ss-3 .n2-ss-slide{display:grid;place-items:center;grid-auto-columns:100%;position:relative;z-index:20;-webkit-backface-visibility:hidden;transform:translateX(-100000px);}div#n2-ss-3 .n2-ss-slide{perspective:1500px;}div#n2-ss-3 .n2-ss-slide-active{z-index:21;}.n2-ss-background-animation{position:absolute;top:0;left:0;width:100%;height:100%;z-index:3;}div#n2-ss-3 .n-uc-redmqLyBnZ8V-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-3 .n-uc-redmqLyBnZ8V-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-3 .n-uc-qygGxRTn7Vd2-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-3 .n-uc-qygGxRTn7Vd2-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-3 .n-uc-zuCxfw7WUDXC-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-3 .n-uc-zuCxfw7WUDXC-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-3 .n2-font-dad50b8a2b6270960678cdc5b68e144f-paragraph{font-family: \'Roboto\',\'Arial\';color: #000000;font-size:131.25%;text-shadow: none;line-height: 1.2;font-weight: normal;font-style: normal;text-decoration: none;text-align: left;letter-spacing: normal;word-spacing: normal;text-transform: none;font-weight: 400;}div#n2-ss-3 .n2-font-dad50b8a2b6270960678cdc5b68e144f-paragraph a, div#n2-ss-3 .n2-font-dad50b8a2b6270960678cdc5b68e144f-paragraph a:FOCUS{font-family: \'Roboto\',\'Arial\';color: #1890d7;font-size:100%;text-shadow: none;line-height: 1.2;font-weight: normal;font-style: normal;text-decoration: none;text-align: left;letter-spacing: normal;word-spacing: normal;text-transform: none;font-weight: 400;}div#n2-ss-3 .n2-font-dad50b8a2b6270960678cdc5b68e144f-paragraph a:HOVER, div#n2-ss-3 .n2-font-dad50b8a2b6270960678cdc5b68e144f-paragraph a:ACTIVE{font-family: \'Roboto\',\'Arial\';color: #1890d7;font-size:100%;text-shadow: none;line-height: 1.2;font-weight: normal;font-style: normal;text-decoration: none;text-align: left;letter-spacing: normal;word-spacing: normal;text-transform: none;font-weight: 400;}div#n2-ss-3 .n2-font-2e9ef9dd17faf2972f5d9899fcf89f7a-hover{font-family: \'Arial\';color: RGBA(255,255,255,0);font-size:93.75%;text-shadow: none;line-height: 1.5;font-weight: normal;font-style: normal;text-decoration: none;text-align: left;letter-spacing: normal;word-spacing: normal;text-transform: none;font-weight: 800;}div#n2-ss-3 .n2-font-0b268a7ea04eec4c075b907ab8fc07e9-hover{font-family: \'Arial\';color: RGBA(27,33,39,0.35);font-size:125%;text-shadow: none;line-height: 1;font-weight: normal;font-style: normal;text-decoration: none;text-align: left;letter-spacing: normal;word-spacing: normal;text-transform: none;font-weight: 800;}div#n2-ss-3 .n2-font-9d2efb481e52329af3ce476067fef4f9-hover{font-family: \'Arial\';color: RGBA(255,255,255,0);font-size:31.25%;text-shadow: none;line-height: 1.5;font-weight: normal;font-style: normal;text-decoration: none;text-align: left;letter-spacing: normal;word-spacing: normal;text-transform: none;font-weight: 800;}div#n2-ss-3 .n2-font-d6aeaf43397239de015a2431922a57ce-paragraph{font-family: \'Roboto\',\'Arial\';color: #000000;font-size:100%;text-shadow: none;line-height: 1.5;font-weight: normal;font-style: normal;text-decoration: none;text-align: left;letter-spacing: normal;word-spacing: normal;text-transform: none;font-weight: 400;}div#n2-ss-3 .n2-font-d6aeaf43397239de015a2431922a57ce-paragraph a, div#n2-ss-3 .n2-font-d6aeaf43397239de015a2431922a57ce-paragraph a:FOCUS{font-family: \'Roboto\',\'Arial\';color: #1890d7;font-size:100%;text-shadow: none;line-height: 1.5;font-weight: normal;font-style: normal;text-decoration: none;text-align: left;letter-spacing: normal;word-spacing: normal;text-transform: none;font-weight: 400;}div#n2-ss-3 .n2-font-d6aeaf43397239de015a2431922a57ce-paragraph a:HOVER, div#n2-ss-3 .n2-font-d6aeaf43397239de015a2431922a57ce-paragraph a:ACTIVE{font-family: \'Roboto\',\'Arial\';color: #1890d7;font-size:100%;text-shadow: none;line-height: 1.5;font-weight: normal;font-style: normal;text-decoration: none;text-align: left;letter-spacing: normal;word-spacing: normal;text-transform: none;font-weight: 400;}div#n2-ss-3 .n-uc-kzRm7pp17G2M-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-3 .n-uc-kzRm7pp17G2M-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-3 .n2-ss-slide-limiter{max-width:1200px;}div#n2-ss-3 .n-uc-QVQyBI0bBbx9{padding:10px 10px 10px 10px}div#n2-ss-3 .n-uc-vv24EkXdn4Kk-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-3 .n-uc-vv24EkXdn4Kk{align-self:center;}div#n2-ss-3 .n-uc-redmqLyBnZ8V-inner{padding:30px 30px 30px 30px}div#n2-ss-3 .n-uc-redmqLyBnZ8V-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-3 .n-uc-redmqLyBnZ8V-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-3 .n-uc-qygGxRTn7Vd2-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-3 .n-uc-qygGxRTn7Vd2{max-width: 90px;width:10.4%}div#n2-ss-3 .n-uc-zuCxfw7WUDXC-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-3 .n-uc-zuCxfw7WUDXC{max-width: 875px;width:79.1%}div#n2-ss-3 .n-uc-kzRm7pp17G2M-inner{padding:10px 10px 10px 10px;justify-content:center}div#n2-ss-3 .n-uc-kzRm7pp17G2M{width:10.4%}@media (min-width: 1200px){div#n2-ss-3 [data-hide-desktopportrait=\\\"1\\\"]{display: none !important;}}@media (orientation: landscape) and (max-width: 1199px) and (min-width: 901px),(orientation: portrait) and (max-width: 1199px) and (min-width: 701px){div#n2-ss-3 .n-uc-redmqLyBnZ8V-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-3 .n-uc-qygGxRTn7Vd2{width:10.4%}div#n2-ss-3 .n-uc-zuCxfw7WUDXC{width:79.1%}div#n2-ss-3 .n-uc-kzRm7pp17G2M{width:10.4%}div#n2-ss-3 [data-hide-tabletportrait=\\\"1\\\"]{display: none !important;}}@media (orientation: landscape) and (max-width: 900px),(orientation: portrait) and (max-width: 700px){div#n2-ss-3 .n-uc-redmqLyBnZ8V-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-3 .n-uc-qygGxRTn7Vd2{width:calc(100% - 20px)}div#n2-ss-3 .n-uc-zuCxfw7WUDXC{width:calc(100% - 20px)}div#n2-ss-3 .n-uc-kzRm7pp17G2M{width:calc(100% - 20px)}div#n2-ss-3 [data-hide-mobileportrait=\\\"1\\\"]{display: none !important;}}\"},\"globalInline\":[]},\"less\":{\"staticGroupPreload\":[],\"staticGroup\":[],\"files\":[],\"urls\":[],\"codes\":[],\"firstCodes\":[],\"inline\":[],\"globalInline\":[]},\"js\":{\"staticGroupPreload\":[],\"staticGroup\":{\"smartslider-frontend\":\"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/smart-slider-3\\/Public\\/SmartSlider3\\/Application\\/Frontend\\/Assets\\/dist\\/smartslider-frontend.min.js\",\"ss-simple\":\"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/smart-slider-3\\/Public\\/SmartSlider3\\/Slider\\/SliderType\\/Simple\\/Assets\\/dist\\/ss-simple.min.js\"},\"files\":[],\"urls\":[],\"codes\":[],\"firstCodes\":[],\"inline\":[\"_N2.r([\\\"documentReady\\\",\\\"smartslider-frontend\\\",\\\"ss-simple\\\"],function(){new _N2.SmartSliderSimple(\'n2-ss-3\', {\\\"admin\\\":false,\\\"background.video.mobile\\\":1,\\\"loadingTime\\\":2000,\\\"alias\\\":{\\\"id\\\":0,\\\"smoothScroll\\\":0,\\\"slideSwitch\\\":0,\\\"scroll\\\":1},\\\"align\\\":\\\"normal\\\",\\\"isDelayed\\\":0,\\\"responsive\\\":{\\\"mediaQueries\\\":{\\\"all\\\":false,\\\"desktopportrait\\\":[\\\"(min-width: 1200px)\\\"],\\\"tabletportrait\\\":[\\\"(orientation: landscape) and (max-width: 1199px) and (min-width: 901px)\\\",\\\"(orientation: portrait) and (max-width: 1199px) and (min-width: 701px)\\\"],\\\"mobileportrait\\\":[\\\"(orientation: landscape) and (max-width: 900px)\\\",\\\"(orientation: portrait) and (max-width: 700px)\\\"]},\\\"base\\\":{\\\"slideOuterWidth\\\":1200,\\\"slideOuterHeight\\\":480,\\\"sliderWidth\\\":1200,\\\"sliderHeight\\\":480,\\\"slideWidth\\\":1200,\\\"slideHeight\\\":480},\\\"hideOn\\\":{\\\"desktopLandscape\\\":false,\\\"desktopPortrait\\\":false,\\\"tabletLandscape\\\":false,\\\"tabletPortrait\\\":false,\\\"mobileLandscape\\\":false,\\\"mobilePortrait\\\":false},\\\"onResizeEnabled\\\":true,\\\"type\\\":\\\"auto\\\",\\\"sliderHeightBasedOn\\\":\\\"real\\\",\\\"focusUser\\\":1,\\\"focusEdge\\\":\\\"auto\\\",\\\"breakpoints\\\":[{\\\"device\\\":\\\"tabletPortrait\\\",\\\"type\\\":\\\"max-screen-width\\\",\\\"portraitWidth\\\":1199,\\\"landscapeWidth\\\":1199},{\\\"device\\\":\\\"mobilePortrait\\\",\\\"type\\\":\\\"max-screen-width\\\",\\\"portraitWidth\\\":700,\\\"landscapeWidth\\\":900}],\\\"enabledDevices\\\":{\\\"desktopLandscape\\\":0,\\\"desktopPortrait\\\":1,\\\"tabletLandscape\\\":0,\\\"tabletPortrait\\\":1,\\\"mobileLandscape\\\":0,\\\"mobilePortrait\\\":1},\\\"sizes\\\":{\\\"desktopPortrait\\\":{\\\"width\\\":1200,\\\"height\\\":480,\\\"max\\\":3000,\\\"min\\\":1200},\\\"tabletPortrait\\\":{\\\"width\\\":701,\\\"height\\\":280,\\\"customHeight\\\":false,\\\"max\\\":1199,\\\"min\\\":701},\\\"mobilePortrait\\\":{\\\"width\\\":320,\\\"height\\\":128,\\\"customHeight\\\":false,\\\"max\\\":900,\\\"min\\\":320}},\\\"overflowHiddenPage\\\":0,\\\"focus\\\":{\\\"offsetTop\\\":\\\"#wpadminbar\\\",\\\"offsetBottom\\\":\\\"\\\"}},\\\"controls\\\":{\\\"mousewheel\\\":0,\\\"touch\\\":0,\\\"keyboard\\\":1,\\\"blockCarouselInteraction\\\":1},\\\"playWhenVisible\\\":1,\\\"playWhenVisibleAt\\\":0.5,\\\"lazyLoad\\\":0,\\\"lazyLoadNeighbor\\\":0,\\\"blockrightclick\\\":0,\\\"maintainSession\\\":0,\\\"autoplay\\\":{\\\"enabled\\\":0,\\\"start\\\":1,\\\"duration\\\":8000,\\\"autoplayLoop\\\":1,\\\"allowReStart\\\":0,\\\"pause\\\":{\\\"click\\\":1,\\\"mouse\\\":\\\"0\\\",\\\"mediaStarted\\\":1},\\\"resume\\\":{\\\"click\\\":0,\\\"mouse\\\":\\\"0\\\",\\\"mediaEnded\\\":1,\\\"slidechanged\\\":0},\\\"interval\\\":1,\\\"intervalModifier\\\":\\\"loop\\\",\\\"intervalSlide\\\":\\\"current\\\"},\\\"perspective\\\":1500,\\\"layerMode\\\":{\\\"playOnce\\\":0,\\\"playFirstLayer\\\":1,\\\"mode\\\":\\\"skippable\\\",\\\"inAnimation\\\":\\\"mainInEnd\\\"},\\\"bgAnimations\\\":0,\\\"mainanimation\\\":{\\\"type\\\":\\\"horizontal\\\",\\\"duration\\\":800,\\\"delay\\\":0,\\\"ease\\\":\\\"easeOutQuad\\\",\\\"shiftedBackgroundAnimation\\\":0},\\\"carousel\\\":1,\\\"initCallbacks\\\":function(){}});});\"],\"globalInline\":[]},\"googleFonts\":{\"staticGroupPreload\":[],\"staticGroup\":[],\"files\":{\"Roboto\":[\"300\",\"400\"]},\"urls\":[],\"codes\":[],\"firstCodes\":[],\"inline\":[],\"globalInline\":[]},\"image\":{\"images\":[\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/2025\\/09\\/Bulle-temoignage-large.png\"]}}}","0","1"),
("12055","smartslider","sliderChanged","4","0","0","1"),
("12056","cache","notweb/n2-ss-4","data.manifest","{\"generator\":[]}","0","1"),
("12057","cache","notweb/n2-ss-4","variations.manifest","1","0","1"),
("12058","cache","notweb/n2-ss-4","sliderfr_FR1.manifest","{\"hash\":\"\",\"nextCacheRefresh\":2145916800,\"currentPath\":\"c9f4aa5ef7d688ff9a456f13107835ed\",\"version\":\"3.5.1.30\"}","0","1"),
("12059","cache","notweb/n2-ss-4","sliderfr_FR1","{\"html\":\"<div class=\\\"n2-section-smartslider fitvidsignore  n2_clear\\\" data-ssid=\\\"4\\\"><div id=\\\"n2-ss-4-align\\\" class=\\\"n2-ss-align\\\"><div class=\\\"n2-padding\\\"><div id=\\\"n2-ss-4\\\" data-creator=\\\"Smart Slider 3\\\" data-responsive=\\\"auto\\\" class=\\\"n2-ss-slider n2-ow n2-has-hover n2notransition  \\\">\\n\\n\\n\\n\\n\\n\\n\\n<div class=\\\"n2-ss-slider-wrapper-inside\\\">\\n        <div class=\\\"n2-ss-slider-1 n2_ss__touch_element n2-ow\\\">\\n            <div class=\\\"n2-ss-slider-2 n2-ow\\\">\\n                                                <div class=\\\"n2-ss-slider-3 n2-ow\\\">\\n\\n                    <div class=\\\"n2-ss-slide-backgrounds n2-ow-all\\\"><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"1\\\" data-mode=\\\"fill\\\"><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"2\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"3\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"4\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"5\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"6\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"7\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"8\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"9\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"10\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"11\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"12\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"13\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"14\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"15\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"16\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"17\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"18\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"19\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"20\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"21\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"22\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"23\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"24\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"25\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"26\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"27\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"28\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"29\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"30\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"31\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"32\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"33\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"34\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"35\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"36\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"37\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><\\/div>                    <div class=\\\"n2-ss-slider-4 n2-ow\\\">\\n                        <svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 1200 480\\\" data-related-device=\\\"desktopPortrait\\\" class=\\\"n2-ow n2-ss-preserve-size n2-ss-preserve-size--slider n2-ss-slide-limiter\\\"><\\/svg><div data-first=\\\"1\\\" data-slide-duration=\\\"0\\\" data-id=\\\"19\\\" data-slide-public-id=\\\"1\\\" data-title=\\\"Le Patriote Beaujolais\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-19\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">Le Patriote Beaujolais<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-yrwh1DeAsGj9\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-Jusw96xYSoGe\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-Jusw96xYSoGe-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-wzPL84mmwFaD\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-wzPL84mmwFaD-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-ShosrPydObk2\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-ShosrPydObk2-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-170b88588adcc\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\" n2-ss-item-image-content n2-ss-item-content n2-ow-all\\\"><img id=\\\"n2-ss-4item1\\\" alt=\\\"\\\" class=\\\"skip-lazy\\\" width=\\\"600\\\" height=\\\"300\\\" data-skip-lazy=\\\"1\\\" src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/2025\\/10\\/Banque-des-territoires-600x300-1.webp\\\" \\/><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-bwUJF98DK2nL\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item2\\\" class=\\\"n2-font-7eedf6b6e29e60e29f27c4c032e5621f-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4Watts, une marque d\\u2019\\u00e9lectricit\\u00e9 verte intercommunale<\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-ORECRe2u8DYI\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-ORECRe2u8DYI-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-jsUVCoNIkYMQ\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\"><b>B\\u00f4Watts, une marque d\\u2019\\u00e9lectricit\\u00e9 verte intercommunale<\\/b><br \\/>\\nTerritoire \\u00e0 \\u00e9nergie positive depuis 2016, engag\\u00e9e dans la r\\u00e9novation \\u00e9nerg\\u00e9tique des logements particuliers et des b\\u00e2timents publics et dans la production d\\u2019\\u00e9nergie photovolta\\u00efque, la communaut\\u00e9 de communes Sa\\u00f4ne Beaujolais a lanc\\u00e9 en 2024 B\\u00f4Watts, sa marque maison d\\u2019\\u00e9nergie verte. Les habitants abonn\\u00e9s b\\u00e9n\\u00e9ficient d\\u2019un tarif tr\\u00e8s avantageux. <\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-lwG2MoN13KNw\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item4\\\" class=\\\"n2-font-af22882ab952b3fd03df5e33cecc3df6-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-x8I7RffUc2CH n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-176464dee0eea5b1ac11b21dab9b24d2-link  n2-ss-nowrap n2-ss-button-container--non-full-width\\\"><a class=\\\"n2-style-a7955f0b6f56e3d42e693047ea366dc1-heading  n2-ow \\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/www.banquedesterritoires.fr\\/experience\\/belleville-en-beaujolais-une-marque-delectricite-verte-intercommunale-69\\\"><div><div>LIRE L\'ARTICLE<\\/div><\\/div><\\/a><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"56\\\" data-slide-public-id=\\\"2\\\" aria-hidden=\\\"true\\\" data-title=\\\"Le Patriote Beaujolais\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-56\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">Le Patriote Beaujolais<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-znHCRPn6DFoD\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-DnSCSkd9764D\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-DnSCSkd9764D-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-V5cPfAJLd50m\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-V5cPfAJLd50m-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-nwc2v257Y6FG\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-nwc2v257Y6FG-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-XoMZpG0HDFdX\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\" n2-ss-item-image-content n2-ss-item-content n2-ow-all\\\"><img id=\\\"n2-ss-4item6\\\" alt=\\\"\\\" class=\\\"skip-lazy\\\" loading=\\\"lazy\\\" width=\\\"318\\\" height=\\\"159\\\" data-skip-lazy=\\\"1\\\" src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/logo-le-patriote.png\\\" \\/><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-rQwGajhxqY63\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item7\\\" class=\\\"n2-font-7eedf6b6e29e60e29f27c4c032e5621f-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4Watts, marque d\\u00e9pos\\u00e9e<\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-ywlHUKb9CanX\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-ywlHUKb9CanX-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-qwH8VeKRVHgI\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\"><b>\\u00c9lectricit\\u00e9 verte : le courant passe bien pour B\\u00f4Watts<\\/b><br \\/>\\nDepuis janvier 2024, le nombre d\'abonn\\u00e9s \\u00e0 B\\u00f4Watts, la marque d\'\\u00e9lectricit\\u00e9 verte de la Communaut\\u00e9 de communes Sa\\u00f4ne Beaujolais, a connu une progression constante pour atteindre le millier \\u00e0 la fin de ce mois de mars.<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-pOZyf0oeReFk\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item9\\\" class=\\\"n2-font-af22882ab952b3fd03df5e33cecc3df6-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-2SuuhX7fWI9r n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-176464dee0eea5b1ac11b21dab9b24d2-link  n2-ss-nowrap n2-ss-button-container--non-full-width\\\"><a class=\\\"n2-style-a7955f0b6f56e3d42e693047ea366dc1-heading  n2-ow \\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/mesinfos.fr\\/69220-belleville\\/electricite-verte-le-courant-passe-bien-pour-bowatts-218960.html\\\"><div><div>LIRE L\'ARTICLE<\\/div><\\/div><\\/a><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"20\\\" data-slide-public-id=\\\"3\\\" aria-hidden=\\\"true\\\" data-title=\\\"Le Progr\\u00e8s\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-20\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">Le Progr\\u00e8s<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-IxStecUEr7V7\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-NYorwtFsfIg2\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-NYorwtFsfIg2-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-6iWktuDWUTUT\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-6iWktuDWUTUT-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-O5hKrhfJRsL9\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-O5hKrhfJRsL9-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-eOvzlZOiSZ4X\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\" n2-ss-item-image-content n2-ss-item-content n2-ow-all\\\"><img id=\\\"n2-ss-4item11\\\" alt=\\\"\\\" class=\\\"skip-lazy\\\" loading=\\\"lazy\\\" width=\\\"318\\\" height=\\\"159\\\" data-skip-lazy=\\\"1\\\" src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/logo-le-progres.png\\\" \\/><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-KRnqrtyIVnLU\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item12\\\" class=\\\"n2-font-7eedf6b6e29e60e29f27c4c032e5621f-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">DEVENEZ CLIENT DE B\\u00d4WATTS,  LA MARQUE LOCALE D\'\\u00c9LECTRICIT\\u00c9 VERTE<\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-yD0hFF5H3aJb\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-yD0hFF5H3aJb-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-CLtd4yqKhMkw\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\"><b>B\\u00f4Watts : la marque locale d\\u2019\\u00e9lectricit\\u00e9 verte baisse ses tarifs<\\/b><br \\/>\\n974 abonn\\u00e9s, B\\u00f4Watts esp\\u00e8re bien les multiplier par deux d\\u2019ici la fin de l\\u2019ann\\u00e9e 2025. Chez les professionnels, Corcelles a \\u00e9t\\u00e9 la premi\\u00e8re mairie test.<\\/p>\\n<p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">https:\\/\\/www.leprogres.fr\\/societe\\/2025\\/03\\/23\\/bowatts-la-marque-locale-d-electricite-verte-baisse-ses-tarifs<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-u5l4ARAhiEZg\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item14\\\" class=\\\"n2-font-af22882ab952b3fd03df5e33cecc3df6-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-tXSsZT4bAblq n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-176464dee0eea5b1ac11b21dab9b24d2-link  n2-ss-nowrap n2-ss-button-container--non-full-width\\\"><a class=\\\"n2-style-a7955f0b6f56e3d42e693047ea366dc1-heading  n2-ow \\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/2025\\/03\\/Capture-decran-2025-03-25-181015.png\\\"><div><div>LIRE L\'ARTICLE<\\/div><\\/div><\\/a><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"21\\\" data-slide-public-id=\\\"4\\\" aria-hidden=\\\"true\\\" data-title=\\\"Le Patriote Beaujolais\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-21\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">Le Patriote Beaujolais<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-yqDYKFnWjrqf\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-QGsvr4nKnhxV\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-QGsvr4nKnhxV-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-8jWkyo145xk4\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-8jWkyo145xk4-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-tfInrQkuYeyB\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-tfInrQkuYeyB-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-9IFmUlf4XbGn\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\" n2-ss-item-image-content n2-ss-item-content n2-ow-all\\\"><img id=\\\"n2-ss-4item16\\\" alt=\\\"\\\" class=\\\"skip-lazy\\\" loading=\\\"lazy\\\" width=\\\"318\\\" height=\\\"159\\\" data-skip-lazy=\\\"1\\\" src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/logo-le-patriote.png\\\" \\/><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-WyaVS4VEHJpC\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item17\\\" class=\\\"n2-font-7eedf6b6e29e60e29f27c4c032e5621f-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4Watts, marque d\\u00e9pos\\u00e9e<\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-oUTqtu5Bx0m9\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-oUTqtu5Bx0m9-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-lVf56OgOv2jE\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">Cette marque d\'\\u00e9lectricit\\u00e9 verte, lanc\\u00e9e en mai 2023 dans le Beaujolais, a \\u00e9t\\u00e9 d\\u00e9pos\\u00e9e aupr\\u00e8s de l\'Institu national de la propri\\u00e9t\\u00e9 industrielle (Inpi).<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-fW0HpDfT6EEk\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item19\\\" class=\\\"n2-font-af22882ab952b3fd03df5e33cecc3df6-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-6DvM3twj8dJa n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-176464dee0eea5b1ac11b21dab9b24d2-link  n2-ss-nowrap n2-ss-button-container--non-full-width\\\"><a class=\\\"n2-style-a7955f0b6f56e3d42e693047ea366dc1-heading  n2-ow \\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/2024\\/01\\/2023-12-28_BoWatts_Le_Patriote.pdf\\\"><div><div>LIRE L\'ARTICLE<\\/div><\\/div><\\/a><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"22\\\" data-slide-public-id=\\\"5\\\" aria-hidden=\\\"true\\\" data-title=\\\"Le Progr\\u00e8s\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-22\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">Le Progr\\u00e8s<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-h0uDOg0zLx8P\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-HzISys8QTySd\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-HzISys8QTySd-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-8Q6WQLiNXqjv\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-8Q6WQLiNXqjv-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-gQUuNwHW7NwW\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-gQUuNwHW7NwW-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-kZA5FKK36NpU\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\" n2-ss-item-image-content n2-ss-item-content n2-ow-all\\\"><img id=\\\"n2-ss-4item21\\\" alt=\\\"\\\" class=\\\"skip-lazy\\\" loading=\\\"lazy\\\" width=\\\"318\\\" height=\\\"159\\\" data-skip-lazy=\\\"1\\\" src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/logo-le-progres.png\\\" \\/><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-DteoNMZaf8BU\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item22\\\" class=\\\"n2-font-7eedf6b6e29e60e29f27c4c032e5621f-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">DEVENEZ CLIENT DE B\\u00d4WATTS,  LA MARQUE LOCALE D\'\\u00c9LECTRICIT\\u00c9 VERTE<\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-VHIxZkm97nGW\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-VHIxZkm97nGW-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-nAn3uxwkPfOD\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">La Communaut\\u00e9 de Communes Sa\\u00f4ne Beaujolais a mis en place une marque locale d\'\\u00e9lectricit\\u00e9 verte pour les 35 communes de son secteur, en partenariat avec la start-up lyonnaise My Energy Manager et le fournisseur d\'\\u00e9lectricit\\u00e9 Alpiq.<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-EaErqGGo1FTv\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item24\\\" class=\\\"n2-font-af22882ab952b3fd03df5e33cecc3df6-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-ToDNf5T7VQXr n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-176464dee0eea5b1ac11b21dab9b24d2-link  n2-ss-nowrap n2-ss-button-container--non-full-width\\\"><a class=\\\"n2-style-a7955f0b6f56e3d42e693047ea366dc1-heading  n2-ow \\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/2024\\/01\\/20240101_BoWatts_LeProgres.pdf\\\"><div><div>LIRE L\'ARTICLE<\\/div><\\/div><\\/a><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"23\\\" data-slide-public-id=\\\"6\\\" aria-hidden=\\\"true\\\" data-title=\\\"Tribune de Lyon\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-23\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">Tribune de Lyon<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-mVJV9VVxCPoZ\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-Dq0fAWQhWFPL\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-Dq0fAWQhWFPL-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-ftGPoJPnvEPx\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-ftGPoJPnvEPx-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-6IWaBI9MWbyr\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-6IWaBI9MWbyr-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-ENRBE3qSLSKD\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\" n2-ss-item-image-content n2-ss-item-content n2-ow-all\\\"><img id=\\\"n2-ss-4item26\\\" alt=\\\"\\\" class=\\\"skip-lazy\\\" loading=\\\"lazy\\\" width=\\\"240\\\" height=\\\"240\\\" data-skip-lazy=\\\"1\\\" src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0002_tribunedelyon.jpg\\\" \\/><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-yohnPdQiAvSE\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item27\\\" class=\\\"n2-font-7eedf6b6e29e60e29f27c4c032e5621f-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">LE BEAUJOLAIS LANCE B\\u00d4WATTS, SA MARQUE D\'\\u00c9LECTRICIT\\u00c9 VERTE<\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-8DbpjM8yUThq\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-8DbpjM8yUThq-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-42XiIgrar6Gm\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">La communaut\\u00e9 de communes Sa\\u00f4ne Beaujolais a lanc\\u00e9 ce mardi 9 mai la commercialisation de B\\u00f4watts, sa propre marque d\\u2019\\u00e9nergie \\u00e0 destination de ses habitants. La promesse : \\u00ab un tarif 7\\u2009% inf\\u00e9rieur \\u00e0 n\\u2019importe quelle offre verte actuellement, et le m\\u00eame prix que n\\u2019importe quelle \\u00e9nergie grise, r\\u00e9sume Fr\\u00e9d\\u00e9ric Pronchery, vice-pr\\u00e9sident de la collectivit\\u00e9 et maire de Belleville-en-Beaujolais. Et ceux qui disposent d\\u2019un compteur Linky se verront fournir un bo\\u00eetier de donn\\u00e9es connect\\u00e9 qui permet de suivre sa consommation en temps r\\u00e9el et d\\u2019esp\\u00e9rer effectuer des \\u00e9conomies de 20\\u2009%. \\u00bb<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-pJMLvxwVCGz8\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item29\\\" class=\\\"n2-font-af22882ab952b3fd03df5e33cecc3df6-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-Wc6v9TMMyqE0 n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-176464dee0eea5b1ac11b21dab9b24d2-link  n2-ss-nowrap n2-ss-button-container--non-full-width\\\"><a class=\\\"n2-style-a7955f0b6f56e3d42e693047ea366dc1-heading  n2-ow \\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/cdn.reputation.onclusive.com\\/t\\/snxTwJqrl-f9HExBc4sEC93Gi8rQXKKw-pdf-zC\\/FR80078440_986526790_src\\\"><div><div>LIRE L\'ARTICLE<\\/div><\\/div><\\/a><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"24\\\" data-slide-public-id=\\\"7\\\" aria-hidden=\\\"true\\\" data-title=\\\"Lemoniteur.fr\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-24\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">Lemoniteur.fr<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-5blBfGugBrf8\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-QPAxjmSPz3pP\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-QPAxjmSPz3pP-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-sJpu30IwJmP6\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-sJpu30IwJmP6-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-RfdLt5uvaKRv\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-RfdLt5uvaKRv-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-ocG84Ak7DWgb\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\" n2-ss-item-image-content n2-ss-item-content n2-ow-all\\\"><img id=\\\"n2-ss-4item31\\\" alt=\\\"\\\" class=\\\"skip-lazy\\\" style=\\\"width:180px;height:180px\\\" loading=\\\"lazy\\\" width=\\\"240\\\" height=\\\"240\\\" data-skip-lazy=\\\"1\\\" src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0030_lemoniteur.jpg\\\" \\/><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-gNiRfK7NASQf\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item32\\\" class=\\\"n2-font-b1a8424a63cc3bffe257d59b9e5a639c-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\"><br>Rh\\u00f4ne : \\u00e9lectricit\\u00e9 verte<\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-COwEvHIHNKBd\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-COwEvHIHNKBd-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-oLQcCoqVVjFC\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">La communaut\\u00e9 de communes Sa\\u00f4ne-Beaujolais, qui repr\\u00e9sente 35 communes totalisant 45 000 habitants, a cr\\u00e9\\u00e9 sa boucle locale d\'\\u00e9lectricit\\u00e9 verte en partenariat avec la start-up lyonnaise My Energy Manager. Elle ambitionne ainsi de proposer aux administr\\u00e9s d\'acheter l\'\\u00e9lectricit\\u00e9 produite \\u00e0 un tarif n\\u00e9goci\\u00e9 et de devenir un territoire \\u00e0 \\u00e9nergie positive.<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-tt2SkxsLcCdx\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item34\\\" class=\\\"n2-font-af22882ab952b3fd03df5e33cecc3df6-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-SiZ3TgDeCU6I n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-176464dee0eea5b1ac11b21dab9b24d2-link  n2-ss-nowrap n2-ss-button-container--non-full-width\\\"><a class=\\\"n2-style-a7955f0b6f56e3d42e693047ea366dc1-heading  n2-ow \\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/www.lemoniteur.fr\\/article\\/rhone-electricite-verte.2272602\\\"><div><div>LIRE L\'ARTICLE<\\/div><\\/div><\\/a><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"25\\\" data-slide-public-id=\\\"8\\\" aria-hidden=\\\"true\\\" data-title=\\\"M6\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-25\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">M6<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-NKuDvP8t9y42\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-NaYkMjqM49SN\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-NaYkMjqM49SN-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-KbSFYzu5wgDO\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-KbSFYzu5wgDO-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-UUss8im1qUxE\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-UUss8im1qUxE-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-ey4DfnaEHmNx\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\" n2-ss-item-image-content n2-ss-item-content n2-ow-all\\\"><img id=\\\"n2-ss-4item36\\\" alt=\\\"\\\" class=\\\"skip-lazy\\\" loading=\\\"lazy\\\" width=\\\"240\\\" height=\\\"240\\\" data-skip-lazy=\\\"1\\\" src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0017_m6.jpg\\\" \\/><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-5ENqwdYiYuon\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item37\\\" class=\\\"n2-font-b1a8424a63cc3bffe257d59b9e5a639c-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">Le 12H45<\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-BQZpX8cuPbq1\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-BQZpX8cuPbq1-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-oxsPCv2iBEiB\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">Un projet de loi sur l\'industrie verte a \\u00e9t\\u00e9 pr\\u00e9sent\\u00e9 en conseil des ministres. Pour la premi\\u00e8re fois en France, une collectivit\\u00e9 lance sa marque locale d\'\\u00e9lectricit\\u00e9 verte, le tout \\u00e0 des tarifs tr\\u00e8s attractifs.<br \\/>\\nReportage d\'Eric Herv\\u00e9.<br \\/>\\nInterview de Fr\\u00e9d\\u00e9ric Pronch\\u00e9ry, vice-pr\\u00e9sident de la communaut\\u00e9 de communes de Belleville-en-Beaujolais. Pr\\u00e8s des autoroutes, il souhaite massifier les panneaux photovolta\\u00efques.<br \\/>\\nInterview d\'Anthony Parsons, directeur My Energy Manager.<br \\/>\\nInterview de Patrick Nasl\\u00e8s, testeur de Bowatts.<br \\/>\\nInterview d\' Olivier Puit, pr\\u00e9sident d\'Alpiq France.<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-2ixWwKobJY9j\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item39\\\" class=\\\"n2-font-af22882ab952b3fd03df5e33cecc3df6-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-SS2SDV3lgG98 n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-176464dee0eea5b1ac11b21dab9b24d2-link  n2-ss-nowrap n2-ss-button-container--non-full-width\\\"><a class=\\\"n2-style-a7955f0b6f56e3d42e693047ea366dc1-heading  n2-ow \\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/media.reputation.onclusive.com\\/stream?vdmcrypt=KIea9k0rYXrRPN2eso0XN3jf4JHpBWwCuqk%2f%2f%2bf7G1Ee9x2Owzd69SKGpQQsM0TZ%2flNAEzUM%2bAQLrlUc22HH51PgkUuYkRYd4YLivc2HYOPkm9%2bD1xNicaV%2fp9Ao4BwdVXtlIKbxZyog%2fSAXpfC%2fsP%2bv38XPai4ldx8dkfpMGT0BELMOYB5oh4hXaO%2bpFAP17DI3mFCf9GhVMgnvITsuxU8tZ1Ur8sFaO4xcpnheq85F1kB68Kl59abmh0y2y7HJU3Sl45p9gCO7wbArU37lOX7xDzBCuwqdp0O6Zeg1vO%2fDqi1gFMbyBmN8EwllbT0A\\\"><div><div>LIRE L\'ARTICLE<\\/div><\\/div><\\/a><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"26\\\" data-slide-public-id=\\\"9\\\" aria-hidden=\\\"true\\\" data-title=\\\"La Provence\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-26\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">La Provence<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-YGPALNfTBhcr\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-ixVTkdV7ehzm\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-ixVTkdV7ehzm-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-AprBa6jj1Lfk\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-AprBa6jj1Lfk-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-8r8DVCj9SmXL\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-8r8DVCj9SmXL-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-uzBEYhpHcHsU\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\" n2-ss-item-image-content n2-ss-item-content n2-ow-all\\\"><img id=\\\"n2-ss-4item41\\\" alt=\\\"\\\" class=\\\"skip-lazy\\\" loading=\\\"lazy\\\" width=\\\"240\\\" height=\\\"240\\\" data-skip-lazy=\\\"1\\\" src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0016_laprovence.jpg\\\" \\/><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-100YRBrHbyYL\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item42\\\" class=\\\"n2-font-4e534fd9fd00660129bfe59b3cad03ab-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">R\\u00e9duire la consommation des particuliers en s\\u2019adressant \\u00e0 une cible BtoB\\u202f: l\'exemple de la start-up My Energy Manager<\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-pYCVCMJquvor\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-pYCVCMJquvor-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-jdsakxyAIO8F\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">Lanc\\u00e9e en 2020 \\u00e0 Lyon, My Energy Manager rend le suivi \\u00e9nerg\\u00e9tique accessible \\u00e0 tous et<br \\/>\\naccompagne les utilisateurs dans l\'optimisation de leur consommation d\'\\u00e9nergie. La start-up<br \\/>\\nlabellis\\u00e9e Coq Vert s\'adresse notamment \\u00e0 des cibles BtoB et BtoC.<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-EzhrV0H9ekqB\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item44\\\" class=\\\"n2-font-af22882ab952b3fd03df5e33cecc3df6-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-H2KJi5GVUyH2 n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-176464dee0eea5b1ac11b21dab9b24d2-link  n2-ss-nowrap n2-ss-button-container--non-full-width\\\"><a class=\\\"n2-style-a7955f0b6f56e3d42e693047ea366dc1-heading  n2-ow \\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/www.laprovence.com\\/article\\/economie\\/35059724775734\\/reduire-la-consommation-des-particuliers-en-s-adressant-a-une-cible-btob-lexemple-de-la-start-up-my-energy-manager\\\"><div><div>LIRE L\'ARTICLE<\\/div><\\/div><\\/a><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"27\\\" data-slide-public-id=\\\"10\\\" aria-hidden=\\\"true\\\" data-title=\\\"L\'\\u00e9veil de la Haute-Loire\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-27\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">L\'\\u00e9veil de la Haute-Loire<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-FQ8d0B3LZbKh\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-EDxa1SIBmV4Z\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-EDxa1SIBmV4Z-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-FO1MI8Z8EUAZ\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-FO1MI8Z8EUAZ-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-JJ5d9ehQXDJD\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-JJ5d9ehQXDJD-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-mOR8vyEHmiI9\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\" n2-ss-item-image-content n2-ss-item-content n2-ow-all\\\"><img id=\\\"n2-ss-4item46\\\" alt=\\\"\\\" class=\\\"skip-lazy\\\" loading=\\\"lazy\\\" width=\\\"240\\\" height=\\\"240\\\" data-skip-lazy=\\\"1\\\" src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0015_leveildehauteloire.jpg\\\" \\/><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-OI2yktaAB7Nr\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item47\\\" class=\\\"n2-font-4e534fd9fd00660129bfe59b3cad03ab-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">R\\u00e9duire la consommation des particuliers en s\'adressant \\u00e0 une cible BtoB : l\'exemple de la startup My Energy Manager <\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-smeWQDtbltkd\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-smeWQDtbltkd-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-Ydcw9eFdaoWo\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">36, 4 millions. C\'est le nombre de compteurs Linky install\\u00e9s en France d\'apr\\u00e8s Enedis, la filiale<br \\/>\\nd\'EDF d\\u00e9di\\u00e9e \\u00e0 l\'am\\u00e9nagement du r\\u00e9seau d\'\\u00e9lectricit\\u00e9 sur le territoire.<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-6ywzQjKxs5kQ\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item49\\\" class=\\\"n2-font-af22882ab952b3fd03df5e33cecc3df6-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-4AhHPjOJsMNi n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-176464dee0eea5b1ac11b21dab9b24d2-link  n2-ss-nowrap n2-ss-button-container--non-full-width\\\"><a class=\\\"n2-style-a7955f0b6f56e3d42e693047ea366dc1-heading  n2-ow \\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/www.leveil.fr\\/france-monde\\/entreprendre\\/reduire-la-consommation-des-particuliers-en-s-adressant-a-une-cible-btob-l-039-exemple-de-la-startup-my-energy-manager_14308497\\/\\\"><div><div>LIRE L\'ARTICLE<\\/div><\\/div><\\/a><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"28\\\" data-slide-public-id=\\\"11\\\" aria-hidden=\\\"true\\\" data-title=\\\"L\'Echo R\\u00e9publicain\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-28\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">L\'Echo R\\u00e9publicain<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-zch6OXRnnacS\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-tki8tavEFDhR\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-tki8tavEFDhR-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-FPDWjr7UT0aX\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-FPDWjr7UT0aX-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-ImqstluJpNnZ\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-ImqstluJpNnZ-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-endA9UGGs2HQ\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\" n2-ss-item-image-content n2-ss-item-content n2-ow-all\\\"><img id=\\\"n2-ss-4item51\\\" alt=\\\"\\\" class=\\\"skip-lazy\\\" loading=\\\"lazy\\\" width=\\\"240\\\" height=\\\"240\\\" data-skip-lazy=\\\"1\\\" src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0010_lechorepublicain.jpg\\\" \\/><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-ovPNN1GgsEcz\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item52\\\" class=\\\"n2-font-4e534fd9fd00660129bfe59b3cad03ab-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">R\\u00e9duire la consommation des particuliers en s\'adressant \\u00e0 une cible BtoB : l\'exemple de la startup My Energy Manager<\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-VrtZa4E8kwJR\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-VrtZa4E8kwJR-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-Zn2yePHpqwW6\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">Lanc\\u00e9e en 2020 \\u00e0 Lyon, My Energy Manager rend le suivi \\u00e9nerg\\u00e9tique accessible \\u00e0 tous etaccompagne les utilisateurs dans l\'optimisation de leur consommation d\'\\u00e9nergie.<br \\/>\\nLa startup labellis\\u00e9e Coq Vert s\'adresse notamment \\u00e0 des cibles BtoB et BtoC.<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-YhnlykrBs0vG\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item54\\\" class=\\\"n2-font-af22882ab952b3fd03df5e33cecc3df6-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-ZKjg73rWzsKa n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-176464dee0eea5b1ac11b21dab9b24d2-link  n2-ss-nowrap n2-ss-button-container--non-full-width\\\"><a class=\\\"n2-style-a7955f0b6f56e3d42e693047ea366dc1-heading  n2-ow \\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/www.lechorepublicain.fr\\/france-monde\\/entreprendre\\/reduire-la-consommation-des-particuliers-en-s-adressant-a-une-cible-btob-l-039-exemple-de-la-startup-my-energy-manager_14308497\\/\\\"><div><div>LIRE L\'ARTICLE<\\/div><\\/div><\\/a><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"29\\\" data-slide-public-id=\\\"12\\\" aria-hidden=\\\"true\\\" data-title=\\\"L\'Yonne R\\u00e9publicaine\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-29\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">L\'Yonne R\\u00e9publicaine<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-oIQgBdtJmmQd\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-AYBSGVIoQqMx\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-AYBSGVIoQqMx-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-3hhNkdqxZM8D\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-3hhNkdqxZM8D-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-RFHTlXodGO4p\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-RFHTlXodGO4p-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-dDO5R9UqPuIG\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\" n2-ss-item-image-content n2-ss-item-content n2-ow-all\\\"><img id=\\\"n2-ss-4item56\\\" alt=\\\"\\\" class=\\\"skip-lazy\\\" loading=\\\"lazy\\\" width=\\\"240\\\" height=\\\"240\\\" data-skip-lazy=\\\"1\\\" src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0014_lyonnerepublicaine.jpg\\\" \\/><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-AzBt6w9vhQoW\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item57\\\" class=\\\"n2-font-4e534fd9fd00660129bfe59b3cad03ab-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">R\\u00e9duire la consommation des particuliers en s\'adressant \\u00e0 une cible BtoB : l\'exemple de la startup My Energy Manager<\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-GCWYzXMliGnz\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-GCWYzXMliGnz-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-0RsTkjyorDpk\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">Lanc\\u00e9e en 2020 \\u00e0 Lyon, My Energy Manager rend le suivi \\u00e9nerg\\u00e9tique accessible \\u00e0 tous etaccompagne les utilisateurs dans l\'optimisation de leur consommation d\'\\u00e9nergie.<br \\/>\\nLa startup labellis\\u00e9e Coq Vert s\'adresse notamment \\u00e0 des cibles BtoB et BtoC.<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-Svpep3d3T2JL\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item59\\\" class=\\\"n2-font-af22882ab952b3fd03df5e33cecc3df6-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-Wktw7XYINzoe n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-176464dee0eea5b1ac11b21dab9b24d2-link  n2-ss-nowrap n2-ss-button-container--non-full-width\\\"><a class=\\\"n2-style-a7955f0b6f56e3d42e693047ea366dc1-heading  n2-ow \\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/www.lyonne.fr\\/france-monde\\/entreprendre\\/reduire-la-consommation-des-particuliers-en-s-adressant-a-une-cible-btob-l-039-exemple-de-la-startup-my-energy-manager_14308497\\/\\\"><div><div>LIRE L\'ARTICLE<\\/div><\\/div><\\/a><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"30\\\" data-slide-public-id=\\\"13\\\" aria-hidden=\\\"true\\\" data-title=\\\"Le journal du Centre\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-30\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">Le journal du Centre<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-DQCnU4tC5pYD\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-LpDQAGjjnsJo\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-LpDQAGjjnsJo-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-0Repk35azKKq\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-0Repk35azKKq-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-mD7m4e3K9R2h\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-mD7m4e3K9R2h-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-GzGzrfdClca1\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\" n2-ss-item-image-content n2-ss-item-content n2-ow-all\\\"><img id=\\\"n2-ss-4item61\\\" alt=\\\"\\\" class=\\\"skip-lazy\\\" loading=\\\"lazy\\\" width=\\\"240\\\" height=\\\"240\\\" data-skip-lazy=\\\"1\\\" src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0012_lejournalducentre.jpg\\\" \\/><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-wzbtoqFC1lhW\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item62\\\" class=\\\"n2-font-4e534fd9fd00660129bfe59b3cad03ab-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">R\\u00e9duire la consommation des particuliers en s\'adressant \\u00e0 une cible BtoB : l\'exemple de la startup My Energy Manager<\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-NrLso0QROiSv\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-NrLso0QROiSv-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-9jjde4Ffbh0K\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">Lanc\\u00e9e en 2020 \\u00e0 Lyon, My Energy Manager rend le suivi \\u00e9nerg\\u00e9tique accessible \\u00e0 tous etaccompagne les utilisateurs dans l\'optimisation de leur consommation d\'\\u00e9nergie.<br \\/>\\nLa startup labellis\\u00e9e Coq Vert s\'adresse notamment \\u00e0 des cibles BtoB et BtoC.<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-57bGLYlkwQBI\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item64\\\" class=\\\"n2-font-af22882ab952b3fd03df5e33cecc3df6-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-JTP9qaEpJKMh n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-176464dee0eea5b1ac11b21dab9b24d2-link  n2-ss-nowrap n2-ss-button-container--non-full-width\\\"><a class=\\\"n2-style-a7955f0b6f56e3d42e693047ea366dc1-heading  n2-ow \\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/www.lejdc.fr\\/france-monde\\/entreprendre\\/reduire-la-consommation-des-particuliers-en-s-adressant-a-une-cible-btob-l-039-exemple-de-la-startup-my-energy-manager_14308497\\/\\\"><div><div>LIRE L\'ARTICLE<\\/div><\\/div><\\/a><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"31\\\" data-slide-public-id=\\\"14\\\" aria-hidden=\\\"true\\\" data-title=\\\"Le Pays\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-31\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">Le Pays<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-6IrUxfgrWOkf\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-5BJqvoMaE1za\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-5BJqvoMaE1za-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-dxdiRg1uPIMN\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-dxdiRg1uPIMN-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-f7IQDzSL7G7f\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-f7IQDzSL7G7f-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-dhC0wcxDiauz\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\" n2-ss-item-image-content n2-ss-item-content n2-ow-all\\\"><img id=\\\"n2-ss-4item66\\\" alt=\\\"\\\" class=\\\"skip-lazy\\\" loading=\\\"lazy\\\" width=\\\"240\\\" height=\\\"240\\\" data-skip-lazy=\\\"1\\\" src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0001_lepays.jpg\\\" \\/><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-ADtg6C2Onc7b\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item67\\\" class=\\\"n2-font-4e534fd9fd00660129bfe59b3cad03ab-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">Un bo\\u00eetier qui r\\u00e9pond aux enjeux de sobri\\u00e9t\\u00e9 \\u00e9nerg\\u00e9tique <\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-bYEKNlSSIT36\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-bYEKNlSSIT36-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-7fPJkfZlK5n6\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">GPS. Energ\\u00e9tique. Mardi 9 mai, Antony Parsons, directeur g\\u00e9n\\u00e9ral et fondateur de My Energy Manager, a pr\\u00e9sent\\u00e9 nrLINK, un capteur connect\\u00e9, certifi\\u00e9 Enedis, qui permet de surveiller en temps r\\u00e9el la consommation \\u00e9lectrique. Un petit bo\\u00eetier \\u00e0 affichage d\\u00e9port\\u00e9 et directement branch\\u00e9 au compteur Linky permet de suivre sa consommation \\u00e9lectrique en temps r\\u00e9el, en euro et en kWh. Ce bo\\u00eetier permettrait de r\\u00e9aliser des \\u00e9conomies estim\\u00e9es entre 10 et 23 % (Etudes CNRS et Ademe).<br \\/>\\nN\\u00e9e au Royaume-Uni, la solution a \\u00e9t\\u00e9 con\\u00e7ue par Chameleon Technology, qui a d\\u00e9j\\u00e0 distribu\\u00e9 pr\\u00e8s de 9 millions d\'unit\\u00e9s sur le territoire britannique.<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-H46j3kD5aRSA\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item69\\\" class=\\\"n2-font-af22882ab952b3fd03df5e33cecc3df6-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-wj6HSAsWcoMl n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-176464dee0eea5b1ac11b21dab9b24d2-link  n2-ss-nowrap n2-ss-button-container--non-full-width\\\"><a class=\\\"n2-style-a7955f0b6f56e3d42e693047ea366dc1-heading  n2-ow \\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/cdn.reputation.onclusive.com\\/t\\/oAIDKKqrl-1286Q0Ekqz9FMRqWD9Ig-pdf-zC\\/FR80078440_986840300_src\\\"><div><div>LIRE L\'ARTICLE<\\/div><\\/div><\\/a><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"32\\\" data-slide-public-id=\\\"15\\\" aria-hidden=\\\"true\\\" data-title=\\\"Le Berry R\\u00e9publicain\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-32\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">Le Berry R\\u00e9publicain<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-Z0ufnBb8SNSB\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-Xu2tyLjK4gjQ\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-Xu2tyLjK4gjQ-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-Z0lYsJQgc2Es\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-Z0lYsJQgc2Es-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-lyJpD5pXzzT8\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-lyJpD5pXzzT8-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-WK6Lkaww59YV\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\" n2-ss-item-image-content n2-ss-item-content n2-ow-all\\\"><img id=\\\"n2-ss-4item71\\\" alt=\\\"\\\" class=\\\"skip-lazy\\\" loading=\\\"lazy\\\" width=\\\"240\\\" height=\\\"240\\\" data-skip-lazy=\\\"1\\\" src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0008_leberryrepublicain.jpg\\\" \\/><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-tzHqkUgc2Ned\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item72\\\" class=\\\"n2-font-4e534fd9fd00660129bfe59b3cad03ab-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">R\\u00e9duire la consommation des particuliers en s\'adressant \\u00e0 une cible BtoB : l\'exemple de la startup My Energy Manager<\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-Zl9MZMRdfeYN\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-Zl9MZMRdfeYN-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-Shkba5IjJ8n8\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">Lanc\\u00e9e en 2020 \\u00e0 Lyon, My Energy Manager rend le suivi \\u00e9nerg\\u00e9tique accessible \\u00e0 tous etaccompagne les utilisateurs dans l\'optimisation de leur consommation d\'\\u00e9nergie.<br \\/>\\nLa startup labellis\\u00e9e Coq Vert s\'adresse notamment \\u00e0 des cibles BtoB et BtoC.<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-an0t86g0kCVR\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item74\\\" class=\\\"n2-font-af22882ab952b3fd03df5e33cecc3df6-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-GGticY6tnT5K n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-176464dee0eea5b1ac11b21dab9b24d2-link  n2-ss-nowrap n2-ss-button-container--non-full-width\\\"><a class=\\\"n2-style-a7955f0b6f56e3d42e693047ea366dc1-heading  n2-ow \\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/www.leberry.fr\\/france-monde\\/entreprendre\\/reduire-la-consommation-des-particuliers-en-s-adressant-a-une-cible-btob-l-039-exemple-de-la-startup-my-energy-manager_14308497\\/\\\"><div><div>LIRE L\'ARTICLE<\\/div><\\/div><\\/a><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"33\\\" data-slide-public-id=\\\"16\\\" aria-hidden=\\\"true\\\" data-title=\\\"franceinfo\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-33\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">franceinfo<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-xX1Vz7eUvUMG\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-FGw1tXIWnNIJ\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-FGw1tXIWnNIJ-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-lvmvtwrahyTU\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-lvmvtwrahyTU-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-KB89vhAYl5yM\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-KB89vhAYl5yM-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-WlF1IFjBItIb\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\" n2-ss-item-image-content n2-ss-item-content n2-ow-all\\\"><img id=\\\"n2-ss-4item76\\\" alt=\\\"\\\" class=\\\"skip-lazy\\\" loading=\\\"lazy\\\" width=\\\"240\\\" height=\\\"240\\\" data-skip-lazy=\\\"1\\\" src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0013_franceinfo.jpg\\\" \\/><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-MRqwVngo2BZC\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item77\\\" class=\\\"n2-font-b1a8424a63cc3bffe257d59b9e5a639c-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">Une collectivit\\u00e9 du Beaujolais lance sa propre marque d\'\\u00e9lectricit\\u00e9 verte<\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-8KIGxJJ3B5EB\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-8KIGxJJ3B5EB-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-dKsEpRPytO5Z\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">Le dispositif mis en place par la Communaut\\u00e9 de communes permettrait d\'\\u00e9conomiser<br \\/>\\n20% d\'\\u00e9nergie. \\u2022 \\u00a9 MARJORIE NADAL \\/ FTV<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-kfkUIiDu5BRY\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item79\\\" class=\\\"n2-font-af22882ab952b3fd03df5e33cecc3df6-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-BW1GtoNONOXv n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-176464dee0eea5b1ac11b21dab9b24d2-link  n2-ss-nowrap n2-ss-button-container--non-full-width\\\"><a class=\\\"n2-style-a7955f0b6f56e3d42e693047ea366dc1-heading  n2-ow \\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/france3-regions.francetvinfo.fr\\/auvergne-rhone-alpes\\/rhone\\/lyon\\/une-collectivite-du-beaujolais-lance-sa-propre-marque-d-electricite-verte-2771006.html\\\"><div><div>LIRE L\'ARTICLE<\\/div><\\/div><\\/a><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"34\\\" data-slide-public-id=\\\"17\\\" aria-hidden=\\\"true\\\" data-title=\\\"Le Populaire du Centre\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-34\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">Le Populaire du Centre<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-ckJP6jeLN9IZ\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-30oldsUcdJM4\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-30oldsUcdJM4-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-I00QuPruknUD\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-I00QuPruknUD-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-gQN5KXBvoWt5\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-gQN5KXBvoWt5-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-xjEEk2IbEWRl\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\" n2-ss-item-image-content n2-ss-item-content n2-ow-all\\\"><img id=\\\"n2-ss-4item81\\\" alt=\\\"\\\" class=\\\"skip-lazy\\\" loading=\\\"lazy\\\" width=\\\"240\\\" height=\\\"240\\\" data-skip-lazy=\\\"1\\\" src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0011_lepopulaireducentre.jpg\\\" \\/><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-XYyhRLeZlqt5\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item82\\\" class=\\\"n2-font-4e534fd9fd00660129bfe59b3cad03ab-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">R\\u00e9duire la consommation des particuliers en s\'adressant \\u00e0 une cible BtoB : l\'exemple de la startup My Energy Manager<\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-b0lOt9gOEbaK\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-b0lOt9gOEbaK-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-yl4WhwIu5ZD2\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">Lanc\\u00e9e en 2020 \\u00e0 Lyon, My Energy Manager rend le suivi \\u00e9nerg\\u00e9tique accessible \\u00e0 tous etaccompagne les utilisateurs dans l\'optimisation de leur consommation d\'\\u00e9nergie.<br \\/>\\nLa startup labellis\\u00e9e Coq Vert s\'adresse notamment \\u00e0 des cibles BtoB et BtoC.<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-LoUCZh0kwF59\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item84\\\" class=\\\"n2-font-af22882ab952b3fd03df5e33cecc3df6-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-q88kQfNZY7ZL n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-176464dee0eea5b1ac11b21dab9b24d2-link  n2-ss-nowrap n2-ss-button-container--non-full-width\\\"><a class=\\\"n2-style-a7955f0b6f56e3d42e693047ea366dc1-heading  n2-ow \\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/www.lepopulaire.fr\\/france-monde\\/entreprendre\\/reduire-la-consommation-des-particuliers-en-s-adressant-a-une-cible-btob-l-039-exemple-de-la-startup-my-energy-manager_14308497\\/\\\"><div><div>LIRE L\'ARTICLE<\\/div><\\/div><\\/a><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"35\\\" data-slide-public-id=\\\"18\\\" aria-hidden=\\\"true\\\" data-title=\\\"La R\\u00e9publique du Centre\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-35\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">La R\\u00e9publique du Centre<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-MwaOaSj7RvCu\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-TGbl5UgRLVqI\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-TGbl5UgRLVqI-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-NkKW8HyUuBfT\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-NkKW8HyUuBfT-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-qY8w9wMYun8o\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-qY8w9wMYun8o-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-OWw1VrRk5O4E\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\" n2-ss-item-image-content n2-ss-item-content n2-ow-all\\\"><img id=\\\"n2-ss-4item86\\\" alt=\\\"\\\" class=\\\"skip-lazy\\\" loading=\\\"lazy\\\" width=\\\"240\\\" height=\\\"240\\\" data-skip-lazy=\\\"1\\\" src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0009_larepubliqueducentre.jpg\\\" \\/><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-iAOJiyafmLTJ\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item87\\\" class=\\\"n2-font-4e534fd9fd00660129bfe59b3cad03ab-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">R\\u00e9duire la consommation des particuliers en s\'adressant \\u00e0 une cible BtoB : l\'exemple de la startup My Energy Manager<\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-WCJ5U3JD1WaO\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-WCJ5U3JD1WaO-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-LhQqV8s4GbgD\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">Lanc\\u00e9e en 2020 \\u00e0 Lyon, My Energy Manager rend le suivi \\u00e9nerg\\u00e9tique accessible \\u00e0 tous etaccompagne les utilisateurs dans l\'optimisation de leur consommation d\'\\u00e9nergie.<br \\/>\\nLa startup labellis\\u00e9e Coq Vert s\'adresse notamment \\u00e0 des cibles BtoB et BtoC.<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-ZMLBMBEJQvYR\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item89\\\" class=\\\"n2-font-af22882ab952b3fd03df5e33cecc3df6-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-paIlcCNeIPo5 n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-176464dee0eea5b1ac11b21dab9b24d2-link  n2-ss-nowrap n2-ss-button-container--non-full-width\\\"><a class=\\\"n2-style-a7955f0b6f56e3d42e693047ea366dc1-heading  n2-ow \\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/www.larep.fr\\/france-monde\\/entreprendre\\/reduire-la-consommation-des-particuliers-en-s-adressant-a-une-cible-btob-l-039-exemple-de-la-startup-my-energy-manager_14308497\\/\\\"><div><div>LIRE L\'ARTICLE<\\/div><\\/div><\\/a><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"36\\\" data-slide-public-id=\\\"19\\\" aria-hidden=\\\"true\\\" data-title=\\\"Le Pays 2\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-36\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">Le Pays 2<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-u00sLonnXmGo\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-MasnP2Xvcv3O\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-MasnP2Xvcv3O-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-YZY14ervd8PN\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-YZY14ervd8PN-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-fb3gcQJN0YM3\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-fb3gcQJN0YM3-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-5DQjZg8tEOCY\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\" n2-ss-item-image-content n2-ss-item-content n2-ow-all\\\"><img id=\\\"n2-ss-4item91\\\" alt=\\\"\\\" class=\\\"skip-lazy\\\" loading=\\\"lazy\\\" width=\\\"240\\\" height=\\\"240\\\" data-skip-lazy=\\\"1\\\" src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0001_lepays.jpg\\\" \\/><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-EGtBINaSaUjP\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item92\\\" class=\\\"n2-font-b1a8424a63cc3bffe257d59b9e5a639c-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">Le Beaujolais, c\'est aussi de l\'\\u00e9lectricit\\u00e9<\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-nw8F1GSazAZr\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-nw8F1GSazAZr-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-DRKd6FN1FkMF\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">La communaut\\u00e9 de communes Sa\\u00f4ne Beaujolais a lanc\\u00e9, mardi 9 mai \\u00e0 Belleville, la commercialisation de B\\u00f4watts, sa propre marque d\\u2019\\u00e9nergie \\u00e0 destination de ses habitants.<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-K5lHi87y5rwP\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item94\\\" class=\\\"n2-font-af22882ab952b3fd03df5e33cecc3df6-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-SBcUiNhutDSx n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-176464dee0eea5b1ac11b21dab9b24d2-link  n2-ss-nowrap n2-ss-button-container--non-full-width\\\"><a class=\\\"n2-style-a7955f0b6f56e3d42e693047ea366dc1-heading  n2-ow \\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/www.le-pays.fr\\/belleville-en-beaujolais-69220\\/economie\\/le-beaujolais-cest-aussi-de-lelectricite_14307300\\/\\\"><div><div>LIRE L\'ARTICLE<\\/div><\\/div><\\/a><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"37\\\" data-slide-public-id=\\\"20\\\" aria-hidden=\\\"true\\\" data-title=\\\"bpifrance\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-37\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">bpifrance<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-MEcC6ib2P01C\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-WpxVlB5afFq3\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-WpxVlB5afFq3-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-5EUcCesvNgR2\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-5EUcCesvNgR2-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-iAyaPsn5WHF4\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-iAyaPsn5WHF4-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-Cq94zGtkjXdn\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\" n2-ss-item-image-content n2-ss-item-content n2-ow-all\\\"><img id=\\\"n2-ss-4item96\\\" alt=\\\"\\\" class=\\\"skip-lazy\\\" loading=\\\"lazy\\\" width=\\\"240\\\" height=\\\"240\\\" data-skip-lazy=\\\"1\\\" src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0007_bpifrance.jpg\\\" \\/><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-fAAJJ5koGRK3\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item97\\\" class=\\\"n2-font-4e534fd9fd00660129bfe59b3cad03ab-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">R\\u00e9duire la consommation des particuliers en s\'adressant \\u00e0 une cible BtoB : l\'exemple de la start-up My Energy Manager<\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-McSrJhE7lD8q\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-McSrJhE7lD8q-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-9j82NbgB7QW6\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">Lanc\\u00e9e en 2020 \\u00e0 Lyon, My Energy Manager rend le suivi \\u00e9nerg\\u00e9tique accessible \\u00e0 tous et accompagne les utilisateurs dans l\\u2019optimisation de leur consommation d\\u2019\\u00e9nergie. La start-up membre de la communaut\\u00e9 Coq Vert s\\u2019adresse notamment \\u00e0 des cibles BtoB et BtoC. <\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-bO6o9WMbFlME\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item99\\\" class=\\\"n2-font-af22882ab952b3fd03df5e33cecc3df6-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-BuTP1UuxZcan n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-176464dee0eea5b1ac11b21dab9b24d2-link  n2-ss-nowrap n2-ss-button-container--non-full-width\\\"><a class=\\\"n2-style-a7955f0b6f56e3d42e693047ea366dc1-heading  n2-ow \\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/bigmedia.bpifrance.fr\\/portraits\\/reduire-la-consommation-des-particuliers-en-sadressant-a-une-cible-btob-lexemple-de-la-start-my-energy-manager\\\"><div><div>LIRE L\'ARTICLE<\\/div><\\/div><\\/a><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"38\\\" data-slide-public-id=\\\"21\\\" aria-hidden=\\\"true\\\" data-title=\\\"Le Pays 3\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-38\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">Le Pays 3<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-fJ0nkS3oPEw7\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-dg9IDmm70zM5\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-dg9IDmm70zM5-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-RJTVGGt0Qou2\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-RJTVGGt0Qou2-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-Mj25QXAc8XQl\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-Mj25QXAc8XQl-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-Ki6JLZ2Xeody\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\" n2-ss-item-image-content n2-ss-item-content n2-ow-all\\\"><img id=\\\"n2-ss-4item101\\\" alt=\\\"\\\" class=\\\"skip-lazy\\\" loading=\\\"lazy\\\" width=\\\"240\\\" height=\\\"240\\\" data-skip-lazy=\\\"1\\\" src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0001_lepays.jpg\\\" \\/><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-kZHXxVcevfCq\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item102\\\" class=\\\"n2-font-b1a8424a63cc3bffe257d59b9e5a639c-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">Antony Parsons : \\u00ab Notre premier projet d\'aussi grande envergure \\u00bb<\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-Nkikq6rgGrrO\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-Nkikq6rgGrrO-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-OnXHi4d1UkFT\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">Fond\\u00e9e en 2020 \\u00e0 Lyon par Antony Parsons et Pierre-Emmanuel Martin, experts en \\u00e9nergie, la<br \\/>\\nstart-up lyonnaise My Energy Manager (20 collaborateurs) travaillait jusqu\\u2019\\u00e0 pr\\u00e9sent avec des<br \\/>\\nentreprises auxquelles elle apportait des solutions techniques.<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-1yYcovq7cedH\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item104\\\" class=\\\"n2-font-af22882ab952b3fd03df5e33cecc3df6-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-ZaefCYm4zX4H n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-176464dee0eea5b1ac11b21dab9b24d2-link  n2-ss-nowrap n2-ss-button-container--non-full-width\\\"><a class=\\\"n2-style-a7955f0b6f56e3d42e693047ea366dc1-heading  n2-ow \\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/cdn.reputation.onclusive.com\\/t\\/oAIDKKqrl-QjeL1EXIkUqcuRoJ4lhuZg-pdf-zC\\/FR80078440_986840218_src\\\"><div><div>LIRE L\'ARTICLE<\\/div><\\/div><\\/a><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"39\\\" data-slide-public-id=\\\"22\\\" aria-hidden=\\\"true\\\" data-title=\\\"batiactu\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-39\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">batiactu<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-z41usbi36lFk\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-W1lXIY0AtXHM\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-W1lXIY0AtXHM-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-ZCR0LYMQudRb\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-ZCR0LYMQudRb-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-eLdnEU4w7uns\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-eLdnEU4w7uns-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-6vjgPJJ14WUt\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\" n2-ss-item-image-content n2-ss-item-content n2-ow-all\\\"><img id=\\\"n2-ss-4item106\\\" alt=\\\"\\\" class=\\\"skip-lazy\\\" loading=\\\"lazy\\\" width=\\\"240\\\" height=\\\"240\\\" data-skip-lazy=\\\"1\\\" src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0006_batiactu.jpg\\\" \\/><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-6hE5wN7JOZNW\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item107\\\" class=\\\"n2-font-b1a8424a63cc3bffe257d59b9e5a639c-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">L\'intercommunalit\\u00e9 Sa\\u00f4ne Beaujolais d\\u00e9ploie sa marque locale d\'\\u00e9lectricit\\u00e9<\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-UZKxuFxdNHL8\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-UZKxuFxdNHL8-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-Tui2sHpRARFU\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">\\u00c9NERGIE. La communaut\\u00e9 de communes Sa\\u00f4ne Beaujolais a lanc\\u00e9 mardi 9 mai sa marque locale \\u00e9nerg\\u00e9tique B\\u00f4Watts \\u00e0 destination de 35 communes. Objectif : permettre aux habitants de r\\u00e9aliser des \\u00e9conomies d\'\\u00e9nergie.<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-Y57Ok8S6YANG\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item109\\\" class=\\\"n2-font-af22882ab952b3fd03df5e33cecc3df6-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-hJNcZhAmKz1E n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-176464dee0eea5b1ac11b21dab9b24d2-link  n2-ss-nowrap n2-ss-button-container--non-full-width\\\"><a class=\\\"n2-style-a7955f0b6f56e3d42e693047ea366dc1-heading  n2-ow \\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/www.batiactu.com\\/edito\\/intercommunalite-saone-beaujolais-deploie-sa-marque-66257.php\\\"><div><div>LIRE L\'ARTICLE<\\/div><\\/div><\\/a><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"40\\\" data-slide-public-id=\\\"23\\\" aria-hidden=\\\"true\\\" data-title=\\\"La Montagne\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-40\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">La Montagne<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-8T4W6pCV6nZb\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-rZeoHrcH5oJO\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-rZeoHrcH5oJO-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-ipOhhBOqUb7z\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-ipOhhBOqUb7z-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-54389S9gdiyf\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-54389S9gdiyf-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-cuKmGe1grhzH\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\" n2-ss-item-image-content n2-ss-item-content n2-ow-all\\\"><img id=\\\"n2-ss-4item111\\\" alt=\\\"\\\" class=\\\"skip-lazy\\\" loading=\\\"lazy\\\" width=\\\"240\\\" height=\\\"240\\\" data-skip-lazy=\\\"1\\\" src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0005_lamontagne.jpg\\\" \\/><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-kCTiK8zGhdWG\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item112\\\" class=\\\"n2-font-4e534fd9fd00660129bfe59b3cad03ab-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">R\\u00e9duire la consommation des particuliers en s\'adressant \\u00e0 une cible BtoB : l\'exemple de la startup My Energy Manager<\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-N3zQCWawTGWS\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-N3zQCWawTGWS-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-lxzJ6cle076j\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">Lanc\\u00e9e en 2020 \\u00e0 Lyon, My Energy Manager rend le suivi \\u00e9nerg\\u00e9tique accessible \\u00e0 tous et accompagne les utilisateurs dans l\'optimisation de leur consommation d\'\\u00e9nergie.<br \\/>\\nLa startup labellis\\u00e9e Coq Vert s\'adresse notamment \\u00e0 des cibles BtoB et BtoC.<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-dIBkI7xTVCqE\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item114\\\" class=\\\"n2-font-af22882ab952b3fd03df5e33cecc3df6-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-NNdXpQdX1ACR n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-176464dee0eea5b1ac11b21dab9b24d2-link  n2-ss-nowrap n2-ss-button-container--non-full-width\\\"><a class=\\\"n2-style-a7955f0b6f56e3d42e693047ea366dc1-heading  n2-ow \\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/www.lamontagne.fr\\/france-monde\\/entreprendre\\/reduire-la-consommation-des-particuliers-en-s-adressant-a-une-cible-btob-l-039-exemple-de-la-startup-my-energy-manager_14308497\\/\\\"><div><div>LIRE L\'ARTICLE<\\/div><\\/div><\\/a><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"41\\\" data-slide-public-id=\\\"24\\\" aria-hidden=\\\"true\\\" data-title=\\\"le Journal du b\\u00e2timent et des TP\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-41\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">le Journal du b\\u00e2timent et des TP<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-E2xgYukOVuTL\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-7Ftxt0hBElAb\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-7Ftxt0hBElAb-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-aNfuejH2Qld2\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-aNfuejH2Qld2-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-BRd7jplpwwMK\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-BRd7jplpwwMK-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-stijYGBeaxpx\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\" n2-ss-item-image-content n2-ss-item-content n2-ow-all\\\"><img id=\\\"n2-ss-4item116\\\" alt=\\\"\\\" class=\\\"skip-lazy\\\" loading=\\\"lazy\\\" width=\\\"240\\\" height=\\\"240\\\" data-skip-lazy=\\\"1\\\" src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0004_journaldubatimentetdestp.jpg\\\" \\/><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-O4xiPMyn0pvf\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item117\\\" class=\\\"n2-font-4e534fd9fd00660129bfe59b3cad03ab-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">Sa\\u00f4ne-Beaujolais, premi\\u00e8re collectivit\\u00e9 \\u00e0 lancer sa propre marque d\'\\u00e9lectricit\\u00e9 verte <\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-lVGnA6L0HxsP\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-lVGnA6L0HxsP-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-Cv3LREaPQcSp\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">Bowatts devrait permettre aux habitants de Sa\\u00f4ne Beaujolais de b\\u00e9n\\u00e9ficier d\'une \\u00e9nergie propre \\u00e0 tarif pr\\u00e9f\\u00e9rentiel. La collectivit\\u00e9 en a pr\\u00e9sent\\u00e9 les contours en grandes pompes \\u00e0  Belleville.<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-BtGZMrrEaC85\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item119\\\" class=\\\"n2-font-af22882ab952b3fd03df5e33cecc3df6-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-8JDptWCKXEdv n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-176464dee0eea5b1ac11b21dab9b24d2-link  n2-ss-nowrap n2-ss-button-container--non-full-width\\\"><a class=\\\"n2-style-a7955f0b6f56e3d42e693047ea366dc1-heading  n2-ow \\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/cdn.reputation.onclusive.com\\/t\\/snxTwJqrl-M41452dTq0qbFY6mJ6AOwA-pdf-zC\\/FR80078440_986605970_src\\\"><div><div>LIRE L\'ARTICLE<\\/div><\\/div><\\/a><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"42\\\" data-slide-public-id=\\\"25\\\" aria-hidden=\\\"true\\\" data-title=\\\"France 3 Rh\\u00f4ne-Alpes\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-42\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">France 3 Rh\\u00f4ne-Alpes<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-rMljXGaUhdkO\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-naHzBD1SEoL9\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-naHzBD1SEoL9-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-i7crtXLapjEG\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-i7crtXLapjEG-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-ezPk8PEcukE4\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-ezPk8PEcukE4-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-zQjaP7j6Uq2T\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\" n2-ss-item-image-content n2-ss-item-content n2-ow-all\\\"><img id=\\\"n2-ss-4item121\\\" alt=\\\"\\\" class=\\\"skip-lazy\\\" loading=\\\"lazy\\\" width=\\\"240\\\" height=\\\"240\\\" data-skip-lazy=\\\"1\\\" src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0003_3rhonealpes.jpg\\\" \\/><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-dwSBukMpoVLi\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item122\\\" class=\\\"n2-font-4e534fd9fd00660129bfe59b3cad03ab-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">19-20 RHONE-ALPES<\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-XBrxPavqXG2L\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-XBrxPavqXG2L-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-5iicimqeATDA\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">Electricit\\u00e9 verte du Beaujolais<br \\/>\\nReportage de Marjorie Nadal.<br \\/>\\nInterview d\'habitants de Belleville-en-Beaujolais.<br \\/>\\nCitation Linky.<br \\/>\\nInterview de Jacky Menichon, pr\\u00e9sident de la communaut\\u00e9 de communes Sa\\u00f4ne Beaujolais (CCSB).<br \\/>\\nInterview d\'Antony Parsons, DG de My Energy manager. Il \\u00e9voque les collectivit\\u00e9s de France qui veulent se lancer.<br \\/>\\nCitation photovolta\\u00efque.<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-E5XOn37kI9hw\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item124\\\" class=\\\"n2-font-af22882ab952b3fd03df5e33cecc3df6-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-t1BmLU6WdWXM n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-176464dee0eea5b1ac11b21dab9b24d2-link  n2-ss-nowrap n2-ss-button-container--non-full-width\\\"><a class=\\\"n2-style-a7955f0b6f56e3d42e693047ea366dc1-heading  n2-ow \\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/media.reputation.onclusive.com\\/stream?vdmcrypt=KIea9k0rYXrRPN2eso0XN3jf4JHpBWwCuqk%2f%2f%2bf7G1Ee9x2Owzd69SKGpQQsM0TZ%2flNAEzUM%2bAQLrlUc22HH540iE2sWO9VuM6k5MJV2OCT67yJP2ajmxiQcWl9DCES6gq8%2fYdacH9kGPZ1t1nYAov%2bCzaKHY1EK1h7g%2fN%2fZQ7FvV8%2ftPxaC1efdcEIznk63oimmOrFcMzgpgtys1debUg3zW8i3FK1bZNkibLJ4ON91ndTXyEzd0MdEiObDHzw3%2bGgY8KlgZK4ywayanLUo8u7dGR3p82jjyqVhzF0FriTXjeIP1VNVEPLQwE%2bnZ1x2uoHYwLnl8NF3oUUnyne%2bF4V%2bFBSl5%2fxMfYspsTDf6sw%3d\\\"><div><div>REGARDER<\\/div><\\/div><\\/a><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"43\\\" data-slide-public-id=\\\"26\\\" aria-hidden=\\\"true\\\" data-title=\\\"RTL\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-43\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">RTL<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-OUoFxmjUojdk\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-eSQRFye0H1nl\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-eSQRFye0H1nl-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-jP6MSgxwDLFL\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-jP6MSgxwDLFL-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-YqUyQJdhDg5B\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-YqUyQJdhDg5B-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-zI4ULJUwd7bj\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\" n2-ss-item-image-content n2-ss-item-content n2-ow-all\\\"><img id=\\\"n2-ss-4item126\\\" alt=\\\"\\\" class=\\\"skip-lazy\\\" style=\\\"width:200px;height:200px\\\" loading=\\\"lazy\\\" width=\\\"240\\\" height=\\\"240\\\" data-skip-lazy=\\\"1\\\" src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0028_rtl.jpg\\\" \\/><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-xpcUk8GrmjoI\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item127\\\" class=\\\"n2-font-2f335da3feca1c4bf14c3987e0ba7f90-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\"><br>Beaujolais : qu\\u2019est-ce que B\\u00f4watts, la nouvelle marque d\'\\u00e9lectricit\\u00e9 verte ?<\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-6NexyAH5dpfT\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-6NexyAH5dpfT-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-r3nIrWr3Tbe2\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">Avec B\\u00f4watts, la communaut\\u00e9 de communes Sa\\u00f4ne-Beaujolais veut fournir une \\u00e9lectricit\\u00e9 moins ch\\u00e8re \\u00e0 ses habitants.<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-sw3HRMHu7a1j\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item129\\\" class=\\\"n2-font-af22882ab952b3fd03df5e33cecc3df6-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-v2HTotHYZF3L n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-176464dee0eea5b1ac11b21dab9b24d2-link  n2-ss-nowrap n2-ss-button-container--non-full-width\\\"><a class=\\\"n2-style-a7955f0b6f56e3d42e693047ea366dc1-heading  n2-ow \\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/www.rtl.fr\\/actu\\/economie-consommation\\/beaujolais-qu-est-ce-que-bowatts-la-nouvelle-marque-d-electricite-verte-7900263411\\\"><div><div>LIRE L\'ARTICLE<\\/div><\\/div><\\/a><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"44\\\" data-slide-public-id=\\\"27\\\" aria-hidden=\\\"true\\\" data-title=\\\"Le Figaro\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-44\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">Le Figaro<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-Va3clFCaUJYD\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-xUEh9XVs4yDD\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-xUEh9XVs4yDD-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-CUMtyWrPvyBe\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-CUMtyWrPvyBe-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-hHVg0vJQZ66k\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-hHVg0vJQZ66k-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-QiaQnrtIXNpN\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\" n2-ss-item-image-content n2-ss-item-content n2-ow-all\\\"><img id=\\\"n2-ss-4item131\\\" alt=\\\"\\\" class=\\\"skip-lazy\\\" style=\\\"width:200px;height:200px\\\" loading=\\\"lazy\\\" width=\\\"240\\\" height=\\\"240\\\" data-skip-lazy=\\\"1\\\" src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0019_lefigaro.jpg\\\" \\/><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-xMLETy4xoAvS\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item132\\\" class=\\\"n2-font-2f335da3feca1c4bf14c3987e0ba7f90-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">Dans le Beaujolais, une collectivit\\u00e9 lance sa marque d\'\\u00e9lectricit\\u00e9 verte avec une start-up lyonnaise<\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-x8JWTpaPH0sx\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-x8JWTpaPH0sx-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-uc5ryh1LcOwB\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">En plus de co\\u00fbt fixes, la communaut\\u00e9 de communes Sa\\u00f4ne-Beaujolais, qui regroupe 45.000 habitants, proposera un outil permettant aux abonn\\u00e9s de Bowatts de r\\u00e9duire leur consommation, en attendant de produire sa propre \\u00e9lectricit\\u00e9 d\'ici 2027.<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-RslrxH4gsaSO\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item134\\\" class=\\\"n2-font-af22882ab952b3fd03df5e33cecc3df6-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-SUyPx9ZUBnkO n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-176464dee0eea5b1ac11b21dab9b24d2-link  n2-ss-nowrap n2-ss-button-container--non-full-width\\\"><a class=\\\"n2-style-a7955f0b6f56e3d42e693047ea366dc1-heading  n2-ow \\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/www.lefigaro.fr\\/lyon\\/dans-le-beaujolais-une-collectivite-lance-sa-marque-d-electricite-verte-avec-une-start-up-lyonnaise-20230510\\\"><div><div>LIRE L\'ARTICLE<\\/div><\\/div><\\/a><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"45\\\" data-slide-public-id=\\\"28\\\" aria-hidden=\\\"true\\\" data-title=\\\"Le progr\\u00e8s \\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-45\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">Le progr\\u00e8s <\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-ryoRf7jxjTNR\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-f39BSQcXHsAs\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-f39BSQcXHsAs-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-MEPy6N2qeFKf\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-MEPy6N2qeFKf-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-Dj4oOzET76nX\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-Dj4oOzET76nX-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-6bQ52cEWBFBv\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\" n2-ss-item-image-content n2-ss-item-content n2-ow-all\\\"><img id=\\\"n2-ss-4item136\\\" alt=\\\"\\\" class=\\\"skip-lazy\\\" style=\\\"width:180px;height:180px\\\" loading=\\\"lazy\\\" width=\\\"240\\\" height=\\\"240\\\" data-skip-lazy=\\\"1\\\" src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0020_leprogres.jpg\\\" \\/><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-8rl5PLPuVnCv\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item137\\\" class=\\\"n2-font-2f335da3feca1c4bf14c3987e0ba7f90-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\"><br>L\'interco Sa\\u00f4ne Beaujolais lance sa propre marque d\'\\u00e9lectricit\\u00e9 verte<\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-FmmNZKvRsria\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-FmmNZKvRsria-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-BOqiNeZnIwYp\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">Ce mardi 9 mai, la Communaut\\u00e9 de communes Sa\\u00f4ne Beaujolais (CCSB) a lanc\\u00e9 officiellement B\\u00f4Watts, sa propre marque d\'\\u00e9lectricit\\u00e9 verte. Destin\\u00e9e d\'abord aux particuliers, son objectif est multiple : leur fournir de l\'\\u00e9lectricit\\u00e9 verte \\u00e0 un tarif n\\u00e9goci\\u00e9 et les aider \\u00e0 r\\u00e9duire leur consommation.<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-zDypPrutynLW\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item139\\\" class=\\\"n2-font-af22882ab952b3fd03df5e33cecc3df6-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-xC8Q2rIDAOQk n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-176464dee0eea5b1ac11b21dab9b24d2-link  n2-ss-nowrap n2-ss-button-container--non-full-width\\\"><a class=\\\"n2-style-a7955f0b6f56e3d42e693047ea366dc1-heading  n2-ow \\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/cdn.reputation.onclusive.com\\/t\\/wankiJqrl-CzOsv8k0O2mpw9oLKMgA-pdf-zC\\/FR80078440_986256212_src\\\"><div><div>LIRE L\'ARTICLE<\\/div><\\/div><\\/a><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"46\\\" data-slide-public-id=\\\"29\\\" aria-hidden=\\\"true\\\" data-title=\\\"Le progr\\u00e8s 2\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-46\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">Le progr\\u00e8s 2<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-wd25VTdiKxoz\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-foT1WjwaX7IV\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-foT1WjwaX7IV-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-9lsx3wqx1JYM\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-9lsx3wqx1JYM-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-RytOoyb9myss\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-RytOoyb9myss-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-sU6t3YPFUDCx\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\" n2-ss-item-image-content n2-ss-item-content n2-ow-all\\\"><img id=\\\"n2-ss-4item141\\\" alt=\\\"\\\" class=\\\"skip-lazy\\\" style=\\\"width:180px;height:180px\\\" loading=\\\"lazy\\\" width=\\\"240\\\" height=\\\"240\\\" data-skip-lazy=\\\"1\\\" src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0020_leprogres.jpg\\\" \\/><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-px7X6QGuZU4W\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item142\\\" class=\\\"n2-font-2f335da3feca1c4bf14c3987e0ba7f90-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\"><br>Un capteur intelligent <br>pour r\\u00e9duire ses consommations d\'\\u00e9nergie<\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-26fhB4IHNCYu\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-26fhB4IHNCYu-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-mfnABLGjeALJ\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">Il y a un mois, Patrick et Ir\\u00e8ne Nasles ont chang\\u00e9 de fournisseur d\'\\u00e9lectricit\\u00e9. Et  c\'est aupr\\u00e8s de B\\u00f4watts qu\'ils ont souscrit un contrat. Ils ont re\\u00e7u un bo\\u00eetier \\\"nrLINK\\\" branch\\u00e9 directement sur leur compteur Linky. Avec l\'\\u00e9cran d\\u00e9port\\u00e9, qu\'ils ont pos\\u00e9 \\u00e0 c\\u00f4t\\u00e9 de la machine \\u00e0 caf\\u00e9, \\u00ab on voit tout de suite les exc\\u00e8s \\u00bb, indiquent ces habitants de Belleville-en-Beaujolais.<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-qSC4d1XrU6Ag\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item144\\\" class=\\\"n2-font-af22882ab952b3fd03df5e33cecc3df6-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-BJvO2tfAjAL9 n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-176464dee0eea5b1ac11b21dab9b24d2-link  n2-ss-nowrap n2-ss-button-container--non-full-width\\\"><a class=\\\"n2-style-a7955f0b6f56e3d42e693047ea366dc1-heading  n2-ow \\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/cdn.reputation.onclusive.com\\/t\\/wankiJqrl-18O9gqHDOkiMX5u3kj7GQ-pdf-zC\\/FR80078440_986256204_src\\\"><div><div>LIRE L\'ARTICLE<\\/div><\\/div><\\/a><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"47\\\" data-slide-public-id=\\\"30\\\" aria-hidden=\\\"true\\\" data-title=\\\"Actualit\\u00e9s des territoires\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-47\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">Actualit\\u00e9s des territoires<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-K3ea73uIWypl\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-iTg5YmtiJpHN\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-iTg5YmtiJpHN-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-HgGESXx4y5y8\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-HgGESXx4y5y8-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-UGuHnCp1qJuk\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-UGuHnCp1qJuk-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-nDhItWSlAKxY\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\" n2-ss-item-image-content n2-ss-item-content n2-ow-all\\\"><img id=\\\"n2-ss-4item146\\\" alt=\\\"\\\" class=\\\"skip-lazy\\\" style=\\\"width:180px;height:180px\\\" loading=\\\"lazy\\\" width=\\\"240\\\" height=\\\"240\\\" data-skip-lazy=\\\"1\\\" src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0026_actualitesdesterritoires.jpg\\\" \\/><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-QXjILCJuAgWL\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item147\\\" class=\\\"n2-font-4e534fd9fd00660129bfe59b3cad03ab-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\"><br>La Communaut\\u00e9 de Communes<br>Sa\\u00f4ne-Beaujolais est la premi\\u00e8re \\u00e0 lancer sa marque d\'\\u00e9lectricit\\u00e9 verte <\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-4GqtCRJF3aDS\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-4GqtCRJF3aDS-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-N56SsHGQTmzi\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">Pour la premi\\u00e8re fois en France, une communaut\\u00e9 de commune lance sa marque locale d\'\\u00e9lectricit\\u00e9 verte et proposera \\u00e0 l\'ensemble de ses administr\\u00e9s un service d\'\\u00e9nergie complet : un tarif d\'achat n\\u00e9goci\\u00e9 avec un fournisseur partenaire proposant l\'offre verte la moins ch\\u00e8re du march\\u00e9 et des outils interactifs et innovants permettant de r\\u00e9duire leur consommation d\'\\u00e9lectricit\\u00e9.<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-xtapjfZAGi5g\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item149\\\" class=\\\"n2-font-af22882ab952b3fd03df5e33cecc3df6-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-SkIGeg7jMeOd n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-176464dee0eea5b1ac11b21dab9b24d2-link  n2-ss-nowrap n2-ss-button-container--non-full-width\\\"><a class=\\\"n2-style-a7955f0b6f56e3d42e693047ea366dc1-heading  n2-ow \\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/www.actualites-territoires.fr\\/La-Communaute-de-Communes-Saone-Beaujolais-est-la-premiere-a-lancer-sa-marque-d\\\"><div><div>LIRE L\'ARTICLE<\\/div><\\/div><\\/a><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"48\\\" data-slide-public-id=\\\"31\\\" aria-hidden=\\\"true\\\" data-title=\\\"Le R\\u00e9publicain d\'Uz\\u00e8s et du Gard \\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-48\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">Le R\\u00e9publicain d\'Uz\\u00e8s et du Gard <\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-soeBuOU2ZgtU\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-aXOBRW3clUVS\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-aXOBRW3clUVS-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-7U4NgAySI8n5\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-7U4NgAySI8n5-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-wf7hfekxuzCT\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-wf7hfekxuzCT-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-LLcCl2w7IhvR\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\" n2-ss-item-image-content n2-ss-item-content n2-ow-all\\\"><img id=\\\"n2-ss-4item151\\\" alt=\\\"\\\" class=\\\"skip-lazy\\\" style=\\\"width:180px;height:180px\\\" loading=\\\"lazy\\\" width=\\\"240\\\" height=\\\"240\\\" data-skip-lazy=\\\"1\\\" src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0024_lerepublicain.jpg\\\" \\/><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-ciH28pEhbtsi\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item152\\\" class=\\\"n2-font-4e534fd9fd00660129bfe59b3cad03ab-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\"><br>La CCSB, premi\\u00e8re collectivit\\u00e9 <br>de France \\u00e0 lancer sa propre marque d\'\\u00e9lectricit\\u00e9 vert<\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-aMpT8LpatDO0\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-aMpT8LpatDO0-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-Hj5Dh83uHVR3\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">Bowatts devrait permettre aux habitants de Sa\\u00f4ne Beaujolais de b\\u00e9n\\u00e9ficier d\'une \\u00e9nergie propre \\u00e0 tarif pr\\u00e9f\\u00e9rentiel. La collectivit\\u00e9 en a pr\\u00e9sent\\u00e9 les contours en grandes pompes \\u00e0 Belleville, mardi 9 mai.<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-ELvXtXr3esg6\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item154\\\" class=\\\"n2-font-af22882ab952b3fd03df5e33cecc3df6-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-GkAyFMutnKzn n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-176464dee0eea5b1ac11b21dab9b24d2-link  n2-ss-nowrap n2-ss-button-container--non-full-width\\\"><a class=\\\"n2-style-a7955f0b6f56e3d42e693047ea366dc1-heading  n2-ow \\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/mesinfos.fr\\/69220-belleville\\/la-ccsb-premiere-collectivite-de-france-a-lancer-sa-propre-marque-delectricite-verte-151577.html\\\"><div><div>LIRE L\'ARTICLE<\\/div><\\/div><\\/a><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"49\\\" data-slide-public-id=\\\"32\\\" aria-hidden=\\\"true\\\" data-title=\\\"Le journal de Sa\\u00f4ne et Loire\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-49\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">Le journal de Sa\\u00f4ne et Loire<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-TomrtZSuER1j\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-6RUpvE1bVuM2\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-6RUpvE1bVuM2-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-0yRcWbYIimed\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-0yRcWbYIimed-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-vXRoyEcIu6Jq\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-vXRoyEcIu6Jq-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-IKeayhazkCJh\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\" n2-ss-item-image-content n2-ss-item-content n2-ow-all\\\"><img id=\\\"n2-ss-4item156\\\" alt=\\\"\\\" class=\\\"skip-lazy\\\" style=\\\"width:180px;height:180px\\\" loading=\\\"lazy\\\" width=\\\"240\\\" height=\\\"240\\\" data-skip-lazy=\\\"1\\\" src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0022_lejournal.jpg\\\" \\/><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-vhxnaPma9EH4\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item157\\\" class=\\\"n2-font-4e534fd9fd00660129bfe59b3cad03ab-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\"><br>L\\u2019interco Sa\\u00f4ne Beaujolais lance sa propre marque d\\u2019\\u00e9lectricit\\u00e9 verte<\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-O49HlzcAPHpG\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-O49HlzcAPHpG-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-I1EAlDD42Bri\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">Ce mardi 9 mai, la Communaut\\u00e9 de communes Sa\\u00f4ne Beaujolais (CCSB) a lanc\\u00e9 officiellement B\\u00f4Watts, sa propre marque l\\u2019\\u00e9lectricit\\u00e9 verte. Destin\\u00e9e d\\u2019abord aux particuliers, son objectif est multiple : leur fournir de l\\u2019\\u00e9lectricit\\u00e9 verte \\u00e0 un tarif n\\u00e9goci\\u00e9 et les aider \\u00e0 r\\u00e9duire leur consommation.<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-ta3Gsx9i8Sp0\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item159\\\" class=\\\"n2-font-af22882ab952b3fd03df5e33cecc3df6-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-eeImp0iNRJpu n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-176464dee0eea5b1ac11b21dab9b24d2-link  n2-ss-nowrap n2-ss-button-container--non-full-width\\\"><a class=\\\"n2-style-a7955f0b6f56e3d42e693047ea366dc1-heading  n2-ow \\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/www.lejsl.com\\/environnement\\/2023\\/05\\/09\\/l-interco-saone-beaujolais-lance-sa-propre-marque-d-electricite-verte\\\"><div><div>LIRE L\'ARTICLE<\\/div><\\/div><\\/a><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"50\\\" data-slide-public-id=\\\"33\\\" aria-hidden=\\\"true\\\" data-title=\\\"zepros\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-50\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">zepros<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-zGiFp3SCGKIA\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-cWIXLqRlFcHh\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-cWIXLqRlFcHh-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-tI4rPO5jqpLZ\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-tI4rPO5jqpLZ-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-kQNY0ed07HGg\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-kQNY0ed07HGg-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-NT0mb9YuUwKl\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\" n2-ss-item-image-content n2-ss-item-content n2-ow-all\\\"><img id=\\\"n2-ss-4item161\\\" alt=\\\"\\\" class=\\\"skip-lazy\\\" style=\\\"width:180px;height:180px\\\" loading=\\\"lazy\\\" width=\\\"240\\\" height=\\\"240\\\" data-skip-lazy=\\\"1\\\" src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0000_zepros.jpg\\\" \\/><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-L08bVkuMurc5\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item162\\\" class=\\\"n2-font-cb8fb5954a7cf7d3a313224c5f2e1bf4-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">La CC Sa\\u00f4ne-Beaujolais lance une marque locale d\'\\u00e9lectricit\\u00e9 verte<\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-2iSA4HRJQdrT\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-2iSA4HRJQdrT-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-IP2HOCY5nIL2\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">En cr\\u00e9ant \\u00e0 B\\u00f4Watts, l\'intercommunalit\\u00e9 propose une offre d\'\\u00e9lectricit\\u00e9 verte moins ch\\u00e8re \\u00e0 ses habitants, gr\\u00e2ce \\u00e0 contrat d\\u2019achat group\\u00e9 et n\\u00e9goci\\u00e9, mais aussi un service d\\u00e9di\\u00e9 leur permettant de r\\u00e9duire leurs d\\u00e9penses. D\\u2019ici 2027, elle pr\\u00e9voit de produire la moiti\\u00e9 de sa consommation en massifiant le recours aux \\u00e9nergies renouvelables.<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-qwOpOET6H1Do\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item164\\\" class=\\\"n2-font-af22882ab952b3fd03df5e33cecc3df6-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-8ADg4EMUW3Zb n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-176464dee0eea5b1ac11b21dab9b24d2-link  n2-ss-nowrap n2-ss-button-container--non-full-width\\\"><a class=\\\"n2-style-a7955f0b6f56e3d42e693047ea366dc1-heading  n2-ow \\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/territorial.zepros.fr\\/innovations-locales\\/cc-saone-beaujolais-lance-marque-locale-electricite-verte\\\"><div><div>LIRE L\'ARTICLE<\\/div><\\/div><\\/a><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"51\\\" data-slide-public-id=\\\"34\\\" aria-hidden=\\\"true\\\" data-title=\\\"zepros\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-51\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">zepros<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-5tjARbz61iSN\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-bh6sM88UK9T3\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-bh6sM88UK9T3-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-XK0sqq37Jydp\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-XK0sqq37Jydp-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-cx7K4UWk7bzt\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-cx7K4UWk7bzt-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-FvZ4GnMTt1At\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\" n2-ss-item-image-content n2-ss-item-content n2-ow-all\\\"><img id=\\\"n2-ss-4item166\\\" alt=\\\"\\\" class=\\\"skip-lazy\\\" style=\\\"width:180px;height:180px\\\" loading=\\\"lazy\\\" width=\\\"240\\\" height=\\\"240\\\" data-skip-lazy=\\\"1\\\" src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0000_zepros.jpg\\\" \\/><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-sdJizqG0R6hl\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item167\\\" class=\\\"n2-font-cb8fb5954a7cf7d3a313224c5f2e1bf4-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">La CC Sa\\u00f4ne-Beaujolais lance une marque locale d\'\\u00e9lectricit\\u00e9 verte<\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-VBf9CTCZhV9U\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-VBf9CTCZhV9U-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-ZBbu4r6dGkQz\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">En cr\\u00e9ant \\u00e0 B\\u00f4Watts, l\'intercommunalit\\u00e9 propose une offre d\'\\u00e9lectricit\\u00e9 verte moins ch\\u00e8re \\u00e0 ses habitants, gr\\u00e2ce \\u00e0 contrat d\\u2019achat group\\u00e9 et n\\u00e9goci\\u00e9, mais aussi un service d\\u00e9di\\u00e9 leur permettant de r\\u00e9duire leurs d\\u00e9penses. D\\u2019ici 2027, elle pr\\u00e9voit de produire la moiti\\u00e9 de sa consommation en massifiant le recours aux \\u00e9nergies renouvelables.<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-pgyB246aX75d\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item169\\\" class=\\\"n2-font-af22882ab952b3fd03df5e33cecc3df6-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-HhI9bH4a3hGF n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-176464dee0eea5b1ac11b21dab9b24d2-link  n2-ss-nowrap n2-ss-button-container--non-full-width\\\"><a class=\\\"n2-style-a7955f0b6f56e3d42e693047ea366dc1-heading  n2-ow \\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/territorial.zepros.fr\\/innovations-locales\\/cc-saone-beaujolais-lance-marque-locale-electricite-verte\\\"><div><div>LIRE L\'ARTICLE<\\/div><\\/div><\\/a><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"52\\\" data-slide-public-id=\\\"35\\\" aria-hidden=\\\"true\\\" data-title=\\\"Le progr\\u00e8s\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-52\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">Le progr\\u00e8s<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-G2duU3gmbUc3\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-xFgNaafGLuSS\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-xFgNaafGLuSS-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-DFD2oOkaMz7q\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-DFD2oOkaMz7q-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-RabxOFoGnmbu\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-RabxOFoGnmbu-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-ULE35U7zxaHi\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\" n2-ss-item-image-content n2-ss-item-content n2-ow-all\\\"><img id=\\\"n2-ss-4item171\\\" alt=\\\"\\\" class=\\\"skip-lazy\\\" style=\\\"width:180px;height:180px\\\" loading=\\\"lazy\\\" width=\\\"240\\\" height=\\\"240\\\" data-skip-lazy=\\\"1\\\" src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0020_leprogres.jpg\\\" \\/><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-yWJ5WXxgnMqN\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item172\\\" class=\\\"n2-font-4e534fd9fd00660129bfe59b3cad03ab-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\"><br>La communaut\\u00e9 de communes lance sa marque locale d\\u2019\\u00e9lectricit\\u00e9 verte: <br>une premi\\u00e8re en France<\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-5VDwSbjcp0JN\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-5VDwSbjcp0JN-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-5oODO8pEgxJM\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">Pour la premi\\u00e8re fois en France, une communaut\\u00e9 de communes lance sa marque locale d\\u2019\\u00e9lectricit\\u00e9 verte et proposera \\u00e0 l\\u2019ensemble des administr\\u00e9s un service d\\u2019\\u00e9nergie complet : un tarif d\\u2019achat n\\u00e9goci\\u00e9 avec un fournisseur partenaire proposant l\\u2019offre verte la moins ch\\u00e8re du march\\u00e9 et des outils interactifs et innovants permettant de r\\u00e9duire leur consommation d\\u2019\\u00e9lectricit\\u00e9\\u00bb, indique un communiqu\\u00e9.<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-ccuiScNm1lih\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item174\\\" class=\\\"n2-font-af22882ab952b3fd03df5e33cecc3df6-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-6tjUEXOcKcF2 n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-176464dee0eea5b1ac11b21dab9b24d2-link  n2-ss-nowrap n2-ss-button-container--non-full-width\\\"><a class=\\\"n2-style-a7955f0b6f56e3d42e693047ea366dc1-heading  n2-ow \\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/www.leprogres.fr\\/environnement\\/2023\\/04\\/26\\/lancement-de-la-marque-locale-d-electricite-verte-par-la-communaute-de-communes-saone-beaujolais\\\"><div><div>LIRE L\'ARTICLE<\\/div><\\/div><\\/a><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"53\\\" data-slide-public-id=\\\"36\\\" aria-hidden=\\\"true\\\" data-title=\\\"OUR(S)\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-53\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">OUR(S)<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-qBFOkVaI478U\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-Y4unNFYBDIJn\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-Y4unNFYBDIJn-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-tnoekEdI9cPj\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-tnoekEdI9cPj-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-7G5teGr0xuvk\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-7G5teGr0xuvk-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-4cbLbFqslMLP\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\" n2-ss-item-image-content n2-ss-item-content n2-ow-all\\\"><img id=\\\"n2-ss-4item176\\\" alt=\\\"\\\" class=\\\"skip-lazy\\\" loading=\\\"lazy\\\" width=\\\"240\\\" height=\\\"240\\\" data-skip-lazy=\\\"1\\\" src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0018_ours.jpg\\\" \\/><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-mA4V9s7RQtz1\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item177\\\" class=\\\"n2-font-b1a8424a63cc3bffe257d59b9e5a639c-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts se fait conna\\u00eetre avec La Soci\\u00e9t\\u00e9 Secr\\u00e8te<\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-y9FDVNWA3U6w\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-y9FDVNWA3U6w-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-qJV3Rf4XwKjM\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">La communaut\\u00e9 de communes de Sa\\u00f4ne-Beaujolais lance B\\u00f4watts, sa marque d\\u2019\\u00e9lectricit\\u00e9 verte. La Soci\\u00e9t\\u00e9 Secr\\u00e8te est \\u00e0 l\\u2019origine de la campagne de lancement de la marque.<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-tpQzz9R49BzQ\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-4item179\\\" class=\\\"n2-font-af22882ab952b3fd03df5e33cecc3df6-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-3QrhlyY50BsD n2-ss-layer--auto\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-button-container n2-ss-item-content n2-ow n2-font-176464dee0eea5b1ac11b21dab9b24d2-link  n2-ss-nowrap n2-ss-button-container--non-full-width\\\"><a class=\\\"n2-style-a7955f0b6f56e3d42e693047ea366dc1-heading  n2-ow \\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/www.ourscom.fr\\/actualites\\/agences\\/bowatts-se-fait-connaitre-avec-la-societe-secrete\\/\\\"><div><div>LIRE L\'ARTICLE<\\/div><\\/div><\\/a><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"54\\\" data-slide-public-id=\\\"37\\\" aria-hidden=\\\"true\\\" data-title=\\\"Slide\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-54\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">Slide<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-NBIOtMwjQx0w\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><\\/div><\\/div><\\/div>                    <\\/div>\\n\\n                                    <\\/div>\\n            <\\/div>\\n        <\\/div>\\n        <div class=\\\"n2-ss-slider-controls n2-ss-slider-controls-absolute-left-center\\\"><div style=\\\"--widget-offset:15px;\\\" class=\\\"n2-ss-widget n2-style-6679a19c901d61fb802720533bbad114-heading nextend-arrow n2-ow-all nextend-arrow-previous  nextend-arrow-animated-fade\\\" data-hide-mobileportrait=\\\"1\\\" id=\\\"n2-ss-4-arrow-previous\\\" role=\\\"button\\\" aria-label=\\\"previous arrow\\\" tabindex=\\\"0\\\"><img width=\\\"32\\\" height=\\\"32\\\" class=\\\"skip-lazy\\\" data-skip-lazy=\\\"1\\\" src=\\\"data:image\\/svg+xml;base64,PHN2ZyB3aWR0aD0iMzIiIGhlaWdodD0iMzIiIHZpZXdCb3g9IjAgMCAzMiAzMiIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KICAgIDxwYXRoIGQ9Ik0yMS41OCAyMy41OGwtNy45NjItNy41ODMgNy44Ni03LjQ4NWMuMzItLjI2Mi41MjItLjY1LjUyMi0xLjA4M0MyMiA2LjY0IDIxLjMyOCA2IDIwLjUgNmMtLjQwMyAwLS43NjguMTUtMS4wMzguMzk4bC0uMDA0LS4wMDQtOSA4LjU3di4wMDJjLS4yODIuMjYtLjQ1OC42MjQtLjQ1OCAxLjAyOFYxNmMwIC40MDQuMTc2Ljc3LjQ2IDEuMDNoLS4wMDJsOSA4LjU3Yy4yNy4yNDcuNjM4LjQgMS4wNDIuNC44MyAwIDEuNS0uNjQgMS41LTEuNDMgMC0uMzg0LS4xNi0uNzMzLS40Mi0uOTl6IgogICAgICAgICAgZmlsbD0iI2ZmZmZmZiIgb3BhY2l0eT0iMSIgZmlsbC1ydWxlPSJldmVub2RkIi8+Cjwvc3ZnPg==\\\" alt=\\\"previous arrow\\\"><\\/div><\\/div><div class=\\\"n2-ss-slider-controls n2-ss-slider-controls-absolute-right-center\\\"><div style=\\\"--widget-offset:15px;\\\" class=\\\"n2-ss-widget n2-style-6679a19c901d61fb802720533bbad114-heading nextend-arrow n2-ow-all nextend-arrow-next  nextend-arrow-animated-fade\\\" data-hide-mobileportrait=\\\"1\\\" id=\\\"n2-ss-4-arrow-next\\\" role=\\\"button\\\" aria-label=\\\"next arrow\\\" tabindex=\\\"0\\\"><img width=\\\"32\\\" height=\\\"32\\\" class=\\\"skip-lazy\\\" data-skip-lazy=\\\"1\\\" src=\\\"data:image\\/svg+xml;base64,PHN2ZyB3aWR0aD0iMzIiIGhlaWdodD0iMzIiIHZpZXdCb3g9IjAgMCAzMiAzMiIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KICAgIDxwYXRoIGQ9Ik0yMiAxNS45OTd2LS4wMDNjMC0uNDA0LS4xNzYtLjc2OC0uNDYtMS4wMjhoLjAwMmwtOS04LjU3Mi0uMDA0LjAwNEMxMi4yNjggNi4xNSAxMS45MDIgNiAxMS41IDZjLS44MyAwLTEuNS42NC0xLjUgMS40MyAwIC40MzIuMjAzLjgyLjUyMyAxLjA4Mmw3Ljg2IDcuNDg1LTcuOTYzIDcuNTgzYy0uMjYuMjU3LS40Mi42MDYtLjQyLjk5IDAgLjc5LjY3IDEuNDMgMS41IDEuNDMuNDA0IDAgLjc3LS4xNTMgMS4wNC0uNGw5LjAwMi04LjU3di0uMDAyYy4yODItLjI2LjQ1OC0uNjI0LjQ1OC0xLjAyOHYtLjAwM3oiCiAgICAgICAgICBmaWxsPSIjZmZmZmZmIiBvcGFjaXR5PSIxIiBmaWxsLXJ1bGU9ImV2ZW5vZGQiLz4KPC9zdmc+\\\" alt=\\\"next arrow\\\"><\\/div><\\/div><div class=\\\"n2-ss-slider-controls n2-ss-slider-controls-absolute-center-bottom\\\"><div style=\\\"--widget-offset:10px;\\\" class=\\\"n2-ss-widget n2-ss-control-bullet n2-ow-all n2-ss-control-bullet-horizontal\\\"><div class=\\\" nextend-bullet-bar n2-bar-justify-content-center\\\" role=\\\"group\\\" aria-label=\\\"Choose slide to display.\\\"><div class=\\\"n2-bullet n2-style-da7e7078bdb1d9699aa01eb6c4103812-dot \\\" style=\\\"visibility:hidden;\\\"><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><ss3-loader><\\/ss3-loader><\\/div><\\/div><div class=\\\"n2_clear\\\"><\\/div><\\/div>\",\"assets\":{\"css\":{\"staticGroupPreload\":{\"smartslider\":\"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/smart-slider-3\\/Public\\/SmartSlider3\\/Application\\/Frontend\\/Assets\\/dist\\/smartslider.min.css\"},\"staticGroup\":[],\"files\":[],\"urls\":[],\"codes\":[],\"firstCodes\":[],\"inline\":{\"n2-ss-4\":\"div#n2-ss-4 .n2-ss-slider-1{display:grid;position:relative;}div#n2-ss-4 .n2-ss-slider-2{display:grid;position:relative;overflow:hidden;padding:0px 0px 0px 0px;border:0px solid RGBA(62,62,62,1);border-radius:0px;background-clip:padding-box;background-repeat:repeat;background-position:50% 50%;background-size:cover;background-attachment:scroll;z-index:1;}div#n2-ss-4:not(.n2-ss-loaded) .n2-ss-slider-2{background-image:none !important;}div#n2-ss-4 .n2-ss-slider-3{display:grid;grid-template-areas:\'cover\';position:relative;overflow:hidden;z-index:10;}div#n2-ss-4 .n2-ss-slider-3 > *{grid-area:cover;}div#n2-ss-4 .n2-ss-slide-backgrounds,div#n2-ss-4 .n2-ss-slider-3 > .n2-ss-divider{position:relative;}div#n2-ss-4 .n2-ss-slide-backgrounds{z-index:10;}div#n2-ss-4 .n2-ss-slide-backgrounds > *{overflow:hidden;}div#n2-ss-4 .n2-ss-slide-background{transform:translateX(-100000px);}div#n2-ss-4 .n2-ss-slider-4{place-self:center;position:relative;width:100%;height:100%;z-index:20;display:grid;grid-template-areas:\'slide\';}div#n2-ss-4 .n2-ss-slider-4 > *{grid-area:slide;}div#n2-ss-4.n2-ss-full-page--constrain-ratio .n2-ss-slider-4{height:auto;}div#n2-ss-4 .n2-ss-slide{display:grid;place-items:center;grid-auto-columns:100%;position:relative;z-index:20;-webkit-backface-visibility:hidden;transform:translateX(-100000px);}div#n2-ss-4 .n2-ss-slide{perspective:1500px;}div#n2-ss-4 .n2-ss-slide-active{z-index:21;}.n2-ss-background-animation{position:absolute;top:0;left:0;width:100%;height:100%;z-index:3;}div#n2-ss-4 .n2-ss-button-container,div#n2-ss-4 .n2-ss-button-container a{display:block;}div#n2-ss-4 .n2-ss-button-container--non-full-width,div#n2-ss-4 .n2-ss-button-container--non-full-width a{display:inline-block;}div#n2-ss-4 .n2-ss-button-container.n2-ss-nowrap{white-space:nowrap;}div#n2-ss-4 .n2-ss-button-container a div{display:inline;font-size:inherit;text-decoration:inherit;color:inherit;line-height:inherit;font-family:inherit;font-weight:inherit;}div#n2-ss-4 .n2-ss-button-container a > div{display:inline-flex;align-items:center;vertical-align:top;}div#n2-ss-4 .n2-ss-button-container span{font-size:100%;vertical-align:baseline;}div#n2-ss-4 .n2-ss-button-container a[data-iconplacement=\\\"left\\\"] span{margin-right:0.3em;}div#n2-ss-4 .n2-ss-button-container a[data-iconplacement=\\\"right\\\"] span{margin-left:0.3em;}div#n2-ss-4 .nextend-arrow{cursor:pointer;overflow:hidden;line-height:0 !important;z-index:18;-webkit-user-select:none;}div#n2-ss-4 .nextend-arrow img{position:relative;display:block;}div#n2-ss-4 .nextend-arrow img.n2-arrow-hover-img{display:none;}div#n2-ss-4 .nextend-arrow:FOCUS img.n2-arrow-hover-img,div#n2-ss-4 .nextend-arrow:HOVER img.n2-arrow-hover-img{display:inline;}div#n2-ss-4 .nextend-arrow:FOCUS img.n2-arrow-normal-img,div#n2-ss-4 .nextend-arrow:HOVER img.n2-arrow-normal-img{display:none;}div#n2-ss-4 .nextend-arrow-animated{overflow:hidden;}div#n2-ss-4 .nextend-arrow-animated > div{position:relative;}div#n2-ss-4 .nextend-arrow-animated .n2-active{position:absolute;}div#n2-ss-4 .nextend-arrow-animated-fade{transition:background 0.3s, opacity 0.4s;}div#n2-ss-4 .nextend-arrow-animated-horizontal > div{transition:all 0.4s;transform:none;}div#n2-ss-4 .nextend-arrow-animated-horizontal .n2-active{top:0;}div#n2-ss-4 .nextend-arrow-previous.nextend-arrow-animated-horizontal .n2-active{left:100%;}div#n2-ss-4 .nextend-arrow-next.nextend-arrow-animated-horizontal .n2-active{right:100%;}div#n2-ss-4 .nextend-arrow-previous.nextend-arrow-animated-horizontal:HOVER > div,div#n2-ss-4 .nextend-arrow-previous.nextend-arrow-animated-horizontal:FOCUS > div{transform:translateX(-100%);}div#n2-ss-4 .nextend-arrow-next.nextend-arrow-animated-horizontal:HOVER > div,div#n2-ss-4 .nextend-arrow-next.nextend-arrow-animated-horizontal:FOCUS > div{transform:translateX(100%);}div#n2-ss-4 .nextend-arrow-animated-vertical > div{transition:all 0.4s;transform:none;}div#n2-ss-4 .nextend-arrow-animated-vertical .n2-active{left:0;}div#n2-ss-4 .nextend-arrow-previous.nextend-arrow-animated-vertical .n2-active{top:100%;}div#n2-ss-4 .nextend-arrow-next.nextend-arrow-animated-vertical .n2-active{bottom:100%;}div#n2-ss-4 .nextend-arrow-previous.nextend-arrow-animated-vertical:HOVER > div,div#n2-ss-4 .nextend-arrow-previous.nextend-arrow-animated-vertical:FOCUS > div{transform:translateY(-100%);}div#n2-ss-4 .nextend-arrow-next.nextend-arrow-animated-vertical:HOVER > div,div#n2-ss-4 .nextend-arrow-next.nextend-arrow-animated-vertical:FOCUS > div{transform:translateY(100%);}div#n2-ss-4 .n2-ss-control-bullet{visibility:hidden;text-align:center;justify-content:center;z-index:14;}div#n2-ss-4 .n2-ss-control-bullet--calculate-size{left:0 !important;}div#n2-ss-4 .n2-ss-control-bullet-horizontal.n2-ss-control-bullet-fullsize{width:100%;}div#n2-ss-4 .n2-ss-control-bullet-vertical.n2-ss-control-bullet-fullsize{height:100%;flex-flow:column;}div#n2-ss-4 .nextend-bullet-bar{display:inline-flex;vertical-align:top;visibility:visible;align-items:center;flex-wrap:wrap;}div#n2-ss-4 .n2-bar-justify-content-left{justify-content:flex-start;}div#n2-ss-4 .n2-bar-justify-content-center{justify-content:center;}div#n2-ss-4 .n2-bar-justify-content-right{justify-content:flex-end;}div#n2-ss-4 .n2-ss-control-bullet-vertical > .nextend-bullet-bar{flex-flow:column;}div#n2-ss-4 .n2-ss-control-bullet-fullsize > .nextend-bullet-bar{display:flex;}div#n2-ss-4 .n2-ss-control-bullet-horizontal.n2-ss-control-bullet-fullsize > .nextend-bullet-bar{flex:1 1 auto;}div#n2-ss-4 .n2-ss-control-bullet-vertical.n2-ss-control-bullet-fullsize > .nextend-bullet-bar{height:100%;}div#n2-ss-4 .nextend-bullet-bar .n2-bullet{cursor:pointer;transition:background-color 0.4s;}div#n2-ss-4 .nextend-bullet-bar .n2-bullet.n2-active{cursor:default;}div#n2-ss-4 div.n2-ss-bullet-thumbnail-container{position:absolute;z-index:10000000;}div#n2-ss-4 .n2-ss-bullet-thumbnail-container .n2-ss-bullet-thumbnail{background-size:cover;background-repeat:no-repeat;background-position:center;}div#n2-ss-4 .n-uc-wzPL84mmwFaD-inner{background-color:RGBA(255,255,255,1);border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-4 .n-uc-wzPL84mmwFaD-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-ShosrPydObk2-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-ShosrPydObk2-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n2-font-7eedf6b6e29e60e29f27c4c032e5621f-hover{font-family: \'Arial\';color: #83e0c7;font-size:125%;text-shadow: none;line-height: 1;font-weight: normal;font-style: normal;text-decoration: none;text-align: center;letter-spacing: normal;word-spacing: normal;text-transform: none;font-weight: 800;}div#n2-ss-4 .n-uc-ORECRe2u8DYI-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-ORECRe2u8DYI-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n2-font-d6aeaf43397239de015a2431922a57ce-paragraph{font-family: \'Roboto\',\'Arial\';color: #000000;font-size:100%;text-shadow: none;line-height: 1.5;font-weight: normal;font-style: normal;text-decoration: none;text-align: left;letter-spacing: normal;word-spacing: normal;text-transform: none;font-weight: 400;}div#n2-ss-4 .n2-font-d6aeaf43397239de015a2431922a57ce-paragraph a, div#n2-ss-4 .n2-font-d6aeaf43397239de015a2431922a57ce-paragraph a:FOCUS{font-family: \'Roboto\',\'Arial\';color: #1890d7;font-size:100%;text-shadow: none;line-height: 1.5;font-weight: normal;font-style: normal;text-decoration: none;text-align: left;letter-spacing: normal;word-spacing: normal;text-transform: none;font-weight: 400;}div#n2-ss-4 .n2-font-d6aeaf43397239de015a2431922a57ce-paragraph a:HOVER, div#n2-ss-4 .n2-font-d6aeaf43397239de015a2431922a57ce-paragraph a:ACTIVE{font-family: \'Roboto\',\'Arial\';color: #1890d7;font-size:100%;text-shadow: none;line-height: 1.5;font-weight: normal;font-style: normal;text-decoration: none;text-align: left;letter-spacing: normal;word-spacing: normal;text-transform: none;font-weight: 400;}div#n2-ss-4 .n2-font-af22882ab952b3fd03df5e33cecc3df6-hover{font-family: \'Arial\';color: RGBA(255,255,255,0.8);font-size:156.25%;text-shadow: none;line-height: 1.5;font-weight: normal;font-style: normal;text-decoration: none;text-align: left;letter-spacing: normal;word-spacing: normal;text-transform: none;font-weight: 800;}div#n2-ss-4 .n2-font-176464dee0eea5b1ac11b21dab9b24d2-link a{font-family: \'Roboto\',\'Arial\';color: #ffffff;font-size:87.5%;text-shadow: none;line-height: 1.5;font-weight: normal;font-style: normal;text-decoration: none;text-align: center;letter-spacing: normal;word-spacing: normal;text-transform: none;}div#n2-ss-4 .n2-style-a7955f0b6f56e3d42e693047ea366dc1-heading{background: #83e0c7;opacity:1;padding:10px 30px 10px 30px ;box-shadow: none;border: 0px solid RGBA(0,0,0,1);border-radius:99px;}div#n2-ss-4 .n-uc-V5cPfAJLd50m-inner{background-color:RGBA(255,255,255,1);border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-4 .n-uc-V5cPfAJLd50m-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-nwc2v257Y6FG-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-nwc2v257Y6FG-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-ywlHUKb9CanX-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-ywlHUKb9CanX-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-6iWktuDWUTUT-inner{background-color:RGBA(255,255,255,1);border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-4 .n-uc-6iWktuDWUTUT-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-O5hKrhfJRsL9-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-O5hKrhfJRsL9-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-yD0hFF5H3aJb-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-yD0hFF5H3aJb-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-8jWkyo145xk4-inner{background-color:RGBA(255,255,255,1);border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-4 .n-uc-8jWkyo145xk4-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-tfInrQkuYeyB-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-tfInrQkuYeyB-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-oUTqtu5Bx0m9-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-oUTqtu5Bx0m9-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-8Q6WQLiNXqjv-inner{background-color:RGBA(255,255,255,1);border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-4 .n-uc-8Q6WQLiNXqjv-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-gQUuNwHW7NwW-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-gQUuNwHW7NwW-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-VHIxZkm97nGW-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-VHIxZkm97nGW-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-ftGPoJPnvEPx-inner{background-color:RGBA(255,255,255,1);border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-4 .n-uc-ftGPoJPnvEPx-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-6IWaBI9MWbyr-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-6IWaBI9MWbyr-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-8DbpjM8yUThq-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-8DbpjM8yUThq-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-sJpu30IwJmP6-inner{background-color:RGBA(255,255,255,1);border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-4 .n-uc-sJpu30IwJmP6-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-RfdLt5uvaKRv-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-RfdLt5uvaKRv-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n2-font-b1a8424a63cc3bffe257d59b9e5a639c-hover{font-family: \'Arial\';color: #83e0c7;font-size:125%;text-shadow: none;line-height: 1;font-weight: normal;font-style: normal;text-decoration: none;text-align: center;letter-spacing: normal;word-spacing: normal;text-transform: uppercase;font-weight: 800;}div#n2-ss-4 .n-uc-COwEvHIHNKBd-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-COwEvHIHNKBd-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-KbSFYzu5wgDO-inner{background-color:RGBA(255,255,255,1);border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-4 .n-uc-KbSFYzu5wgDO-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-UUss8im1qUxE-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-UUss8im1qUxE-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-BQZpX8cuPbq1-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-BQZpX8cuPbq1-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-AprBa6jj1Lfk-inner{background-color:RGBA(255,255,255,1);border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-4 .n-uc-AprBa6jj1Lfk-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-8r8DVCj9SmXL-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-8r8DVCj9SmXL-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n2-font-4e534fd9fd00660129bfe59b3cad03ab-hover{font-family: \'Arial\';color: #83e0c7;font-size:93.75%;text-shadow: none;line-height: 1;font-weight: normal;font-style: normal;text-decoration: none;text-align: center;letter-spacing: normal;word-spacing: normal;text-transform: uppercase;font-weight: 800;}div#n2-ss-4 .n-uc-pYCVCMJquvor-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-pYCVCMJquvor-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-FO1MI8Z8EUAZ-inner{background-color:RGBA(255,255,255,1);border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-4 .n-uc-FO1MI8Z8EUAZ-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-JJ5d9ehQXDJD-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-JJ5d9ehQXDJD-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-smeWQDtbltkd-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-smeWQDtbltkd-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-FPDWjr7UT0aX-inner{background-color:RGBA(255,255,255,1);border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-4 .n-uc-FPDWjr7UT0aX-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-ImqstluJpNnZ-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-ImqstluJpNnZ-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-VrtZa4E8kwJR-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-VrtZa4E8kwJR-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-3hhNkdqxZM8D-inner{background-color:RGBA(255,255,255,1);border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-4 .n-uc-3hhNkdqxZM8D-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-RFHTlXodGO4p-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-RFHTlXodGO4p-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-GCWYzXMliGnz-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-GCWYzXMliGnz-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-0Repk35azKKq-inner{background-color:RGBA(255,255,255,1);border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-4 .n-uc-0Repk35azKKq-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-mD7m4e3K9R2h-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-mD7m4e3K9R2h-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-NrLso0QROiSv-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-NrLso0QROiSv-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-dxdiRg1uPIMN-inner{background-color:RGBA(255,255,255,1);border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-4 .n-uc-dxdiRg1uPIMN-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-f7IQDzSL7G7f-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-f7IQDzSL7G7f-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-bYEKNlSSIT36-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-bYEKNlSSIT36-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-Z0lYsJQgc2Es-inner{background-color:RGBA(255,255,255,1);border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-4 .n-uc-Z0lYsJQgc2Es-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-lyJpD5pXzzT8-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-lyJpD5pXzzT8-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-Zl9MZMRdfeYN-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-Zl9MZMRdfeYN-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-lvmvtwrahyTU-inner{background-color:RGBA(255,255,255,1);border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-4 .n-uc-lvmvtwrahyTU-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-KB89vhAYl5yM-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-KB89vhAYl5yM-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-8KIGxJJ3B5EB-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-8KIGxJJ3B5EB-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-I00QuPruknUD-inner{background-color:RGBA(255,255,255,1);border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-4 .n-uc-I00QuPruknUD-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-gQN5KXBvoWt5-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-gQN5KXBvoWt5-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-b0lOt9gOEbaK-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-b0lOt9gOEbaK-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-NkKW8HyUuBfT-inner{background-color:RGBA(255,255,255,1);border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-4 .n-uc-NkKW8HyUuBfT-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-qY8w9wMYun8o-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-qY8w9wMYun8o-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-WCJ5U3JD1WaO-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-WCJ5U3JD1WaO-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-YZY14ervd8PN-inner{background-color:RGBA(255,255,255,1);border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-4 .n-uc-YZY14ervd8PN-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-fb3gcQJN0YM3-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-fb3gcQJN0YM3-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-nw8F1GSazAZr-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-nw8F1GSazAZr-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-5EUcCesvNgR2-inner{background-color:RGBA(255,255,255,1);border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-4 .n-uc-5EUcCesvNgR2-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-iAyaPsn5WHF4-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-iAyaPsn5WHF4-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-McSrJhE7lD8q-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-McSrJhE7lD8q-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-RJTVGGt0Qou2-inner{background-color:RGBA(255,255,255,1);border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-4 .n-uc-RJTVGGt0Qou2-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-Mj25QXAc8XQl-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-Mj25QXAc8XQl-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-Nkikq6rgGrrO-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-Nkikq6rgGrrO-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-ZCR0LYMQudRb-inner{background-color:RGBA(255,255,255,1);border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-4 .n-uc-ZCR0LYMQudRb-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-eLdnEU4w7uns-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-eLdnEU4w7uns-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-UZKxuFxdNHL8-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-UZKxuFxdNHL8-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-ipOhhBOqUb7z-inner{background-color:RGBA(255,255,255,1);border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-4 .n-uc-ipOhhBOqUb7z-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-54389S9gdiyf-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-54389S9gdiyf-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-N3zQCWawTGWS-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-N3zQCWawTGWS-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-aNfuejH2Qld2-inner{background-color:RGBA(255,255,255,1);border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-4 .n-uc-aNfuejH2Qld2-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-BRd7jplpwwMK-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-BRd7jplpwwMK-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-lVGnA6L0HxsP-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-lVGnA6L0HxsP-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-i7crtXLapjEG-inner{background-color:RGBA(255,255,255,1);border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-4 .n-uc-i7crtXLapjEG-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-ezPk8PEcukE4-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-ezPk8PEcukE4-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-XBrxPavqXG2L-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-XBrxPavqXG2L-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-jP6MSgxwDLFL-inner{background-color:RGBA(255,255,255,1);border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-4 .n-uc-jP6MSgxwDLFL-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-YqUyQJdhDg5B-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-YqUyQJdhDg5B-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n2-font-2f335da3feca1c4bf14c3987e0ba7f90-hover{font-family: \'Arial\';color: #83e0c7;font-size:106.25%;text-shadow: none;line-height: 1;font-weight: normal;font-style: normal;text-decoration: none;text-align: center;letter-spacing: normal;word-spacing: normal;text-transform: uppercase;font-weight: 800;}div#n2-ss-4 .n-uc-6NexyAH5dpfT-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-6NexyAH5dpfT-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-CUMtyWrPvyBe-inner{background-color:RGBA(255,255,255,1);border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-4 .n-uc-CUMtyWrPvyBe-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-hHVg0vJQZ66k-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-hHVg0vJQZ66k-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-x8JWTpaPH0sx-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-x8JWTpaPH0sx-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-MEPy6N2qeFKf-inner{background-color:RGBA(255,255,255,1);border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-4 .n-uc-MEPy6N2qeFKf-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-Dj4oOzET76nX-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-Dj4oOzET76nX-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-FmmNZKvRsria-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-FmmNZKvRsria-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-9lsx3wqx1JYM-inner{background-color:RGBA(255,255,255,1);border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-4 .n-uc-9lsx3wqx1JYM-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-RytOoyb9myss-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-RytOoyb9myss-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-26fhB4IHNCYu-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-26fhB4IHNCYu-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-HgGESXx4y5y8-inner{background-color:RGBA(255,255,255,1);border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-4 .n-uc-HgGESXx4y5y8-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-UGuHnCp1qJuk-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-UGuHnCp1qJuk-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-4GqtCRJF3aDS-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-4GqtCRJF3aDS-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-7U4NgAySI8n5-inner{background-color:RGBA(255,255,255,1);border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-4 .n-uc-7U4NgAySI8n5-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-wf7hfekxuzCT-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-wf7hfekxuzCT-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-aMpT8LpatDO0-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-aMpT8LpatDO0-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-0yRcWbYIimed-inner{background-color:RGBA(255,255,255,1);border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-4 .n-uc-0yRcWbYIimed-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-vXRoyEcIu6Jq-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-vXRoyEcIu6Jq-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-O49HlzcAPHpG-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-O49HlzcAPHpG-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-tI4rPO5jqpLZ-inner{background-color:RGBA(255,255,255,1);border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-4 .n-uc-tI4rPO5jqpLZ-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-kQNY0ed07HGg-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-kQNY0ed07HGg-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n2-font-cb8fb5954a7cf7d3a313224c5f2e1bf4-hover{font-family: \'Arial\';color: #83e0c7;font-size:112.5%;text-shadow: none;line-height: 1;font-weight: normal;font-style: normal;text-decoration: none;text-align: center;letter-spacing: normal;word-spacing: normal;text-transform: uppercase;font-weight: 800;}div#n2-ss-4 .n-uc-2iSA4HRJQdrT-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-2iSA4HRJQdrT-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-XK0sqq37Jydp-inner{background-color:RGBA(255,255,255,1);border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-4 .n-uc-XK0sqq37Jydp-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-cx7K4UWk7bzt-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-cx7K4UWk7bzt-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-VBf9CTCZhV9U-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-VBf9CTCZhV9U-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-DFD2oOkaMz7q-inner{background-color:RGBA(255,255,255,1);border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-4 .n-uc-DFD2oOkaMz7q-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-RabxOFoGnmbu-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-RabxOFoGnmbu-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-5VDwSbjcp0JN-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-5VDwSbjcp0JN-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-tnoekEdI9cPj-inner{background-color:RGBA(255,255,255,1);border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-4 .n-uc-tnoekEdI9cPj-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-7G5teGr0xuvk-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-7G5teGr0xuvk-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-y9FDVNWA3U6w-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n-uc-y9FDVNWA3U6w-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-4 .n2-style-6679a19c901d61fb802720533bbad114-heading{background: RGBA(255,255,255,0);opacity:1;padding:0px 0px 0px 0px ;box-shadow: none;border: 0px solid RGBA(0,0,0,1);border-radius:0px;}div#n2-ss-4 .n2-style-da7e7078bdb1d9699aa01eb6c4103812-dot{background: RGBA(255,255,255,0);opacity:1;padding:5px 5px 5px 5px ;box-shadow: none;border: 1px solid RGBA(255,255,255,1);border-radius:50px;margin:4px;}div#n2-ss-4 .n2-style-da7e7078bdb1d9699aa01eb6c4103812-dot.n2-active, div#n2-ss-4 .n2-style-da7e7078bdb1d9699aa01eb6c4103812-dot:HOVER, div#n2-ss-4 .n2-style-da7e7078bdb1d9699aa01eb6c4103812-dot:FOCUS{background: #bfe79c;border: 1px solid RGBA(191,231,156,1);}div#n2-ss-4 .n2-ss-slide-limiter{max-width:1200px;}div#n2-ss-4 .n-uc-yrwh1DeAsGj9{padding:10px 10px 10px 10px}div#n2-ss-4 .n-uc-Jusw96xYSoGe-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-Jusw96xYSoGe{align-self:center;}div#n2-ss-4 .n-uc-wzPL84mmwFaD-inner{padding:30px 30px 30px 30px}div#n2-ss-4 .n-uc-wzPL84mmwFaD-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-4 .n-uc-wzPL84mmwFaD-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-4 .n-uc-ShosrPydObk2-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-4 .n-uc-ShosrPydObk2{width:30%}div#n2-ss-4 .n-uc-170b88588adcc{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-ORECRe2u8DYI-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-ORECRe2u8DYI{width:70%}div#n2-ss-4 .n-uc-x8I7RffUc2CH{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-znHCRPn6DFoD{padding:10px 10px 10px 10px}div#n2-ss-4 .n-uc-DnSCSkd9764D-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-DnSCSkd9764D{align-self:center;}div#n2-ss-4 .n-uc-V5cPfAJLd50m-inner{padding:30px 30px 30px 30px}div#n2-ss-4 .n-uc-V5cPfAJLd50m-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-4 .n-uc-V5cPfAJLd50m-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-4 .n-uc-nwc2v257Y6FG-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-4 .n-uc-nwc2v257Y6FG{width:30%}div#n2-ss-4 .n-uc-XoMZpG0HDFdX{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-ywlHUKb9CanX-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-ywlHUKb9CanX{width:70%}div#n2-ss-4 .n-uc-2SuuhX7fWI9r{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-IxStecUEr7V7{padding:10px 10px 10px 10px}div#n2-ss-4 .n-uc-NYorwtFsfIg2-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-NYorwtFsfIg2{align-self:center;}div#n2-ss-4 .n-uc-6iWktuDWUTUT-inner{padding:30px 30px 30px 30px}div#n2-ss-4 .n-uc-6iWktuDWUTUT-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-4 .n-uc-6iWktuDWUTUT-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-4 .n-uc-O5hKrhfJRsL9-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-4 .n-uc-O5hKrhfJRsL9{width:30%}div#n2-ss-4 .n-uc-eOvzlZOiSZ4X{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-yD0hFF5H3aJb-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-yD0hFF5H3aJb{width:70%}div#n2-ss-4 .n-uc-tXSsZT4bAblq{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-yqDYKFnWjrqf{padding:10px 10px 10px 10px}div#n2-ss-4 .n-uc-QGsvr4nKnhxV-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-QGsvr4nKnhxV{align-self:center;}div#n2-ss-4 .n-uc-8jWkyo145xk4-inner{padding:30px 30px 30px 30px}div#n2-ss-4 .n-uc-8jWkyo145xk4-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-4 .n-uc-8jWkyo145xk4-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-4 .n-uc-tfInrQkuYeyB-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-4 .n-uc-tfInrQkuYeyB{width:30%}div#n2-ss-4 .n-uc-9IFmUlf4XbGn{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-oUTqtu5Bx0m9-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-oUTqtu5Bx0m9{width:70%}div#n2-ss-4 .n-uc-6DvM3twj8dJa{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-h0uDOg0zLx8P{padding:10px 10px 10px 10px}div#n2-ss-4 .n-uc-HzISys8QTySd-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-HzISys8QTySd{align-self:center;}div#n2-ss-4 .n-uc-8Q6WQLiNXqjv-inner{padding:30px 30px 30px 30px}div#n2-ss-4 .n-uc-8Q6WQLiNXqjv-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-4 .n-uc-8Q6WQLiNXqjv-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-4 .n-uc-gQUuNwHW7NwW-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-4 .n-uc-gQUuNwHW7NwW{width:30%}div#n2-ss-4 .n-uc-kZA5FKK36NpU{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-VHIxZkm97nGW-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-VHIxZkm97nGW{width:70%}div#n2-ss-4 .n-uc-ToDNf5T7VQXr{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-mVJV9VVxCPoZ{padding:10px 10px 10px 10px}div#n2-ss-4 .n-uc-Dq0fAWQhWFPL-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-Dq0fAWQhWFPL{align-self:center;}div#n2-ss-4 .n-uc-ftGPoJPnvEPx-inner{padding:30px 30px 30px 30px}div#n2-ss-4 .n-uc-ftGPoJPnvEPx-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-4 .n-uc-ftGPoJPnvEPx-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-4 .n-uc-6IWaBI9MWbyr-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-4 .n-uc-6IWaBI9MWbyr{width:30%}div#n2-ss-4 .n-uc-ENRBE3qSLSKD{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-8DbpjM8yUThq-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-8DbpjM8yUThq{width:70%}div#n2-ss-4 .n-uc-Wc6v9TMMyqE0{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-5blBfGugBrf8{padding:10px 10px 10px 10px}div#n2-ss-4 .n-uc-QPAxjmSPz3pP-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-QPAxjmSPz3pP{align-self:center;}div#n2-ss-4 .n-uc-sJpu30IwJmP6-inner{padding:30px 30px 30px 30px}div#n2-ss-4 .n-uc-sJpu30IwJmP6-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-4 .n-uc-sJpu30IwJmP6-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-4 .n-uc-RfdLt5uvaKRv-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-4 .n-uc-RfdLt5uvaKRv{width:30%}div#n2-ss-4 .n-uc-ocG84Ak7DWgb{align-self:center;}div#n2-ss-4 .n-uc-COwEvHIHNKBd-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-COwEvHIHNKBd{width:70%}div#n2-ss-4 .n-uc-SiZ3TgDeCU6I{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-NKuDvP8t9y42{padding:10px 10px 10px 10px}div#n2-ss-4 .n-uc-NaYkMjqM49SN-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-NaYkMjqM49SN{align-self:center;}div#n2-ss-4 .n-uc-KbSFYzu5wgDO-inner{padding:30px 30px 30px 30px}div#n2-ss-4 .n-uc-KbSFYzu5wgDO-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-4 .n-uc-KbSFYzu5wgDO-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-4 .n-uc-UUss8im1qUxE-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-4 .n-uc-UUss8im1qUxE{width:30%}div#n2-ss-4 .n-uc-ey4DfnaEHmNx{align-self:center;}div#n2-ss-4 .n-uc-BQZpX8cuPbq1-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-BQZpX8cuPbq1{width:70%}div#n2-ss-4 .n-uc-SS2SDV3lgG98{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-YGPALNfTBhcr{padding:10px 10px 10px 10px}div#n2-ss-4 .n-uc-ixVTkdV7ehzm-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-ixVTkdV7ehzm{align-self:center;}div#n2-ss-4 .n-uc-AprBa6jj1Lfk-inner{padding:30px 30px 30px 30px}div#n2-ss-4 .n-uc-AprBa6jj1Lfk-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-4 .n-uc-AprBa6jj1Lfk-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-4 .n-uc-8r8DVCj9SmXL-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-4 .n-uc-8r8DVCj9SmXL{width:30%}div#n2-ss-4 .n-uc-uzBEYhpHcHsU{align-self:center;}div#n2-ss-4 .n-uc-pYCVCMJquvor-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-pYCVCMJquvor{width:70%}div#n2-ss-4 .n-uc-H2KJi5GVUyH2{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-FQ8d0B3LZbKh{padding:10px 10px 10px 10px}div#n2-ss-4 .n-uc-EDxa1SIBmV4Z-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-EDxa1SIBmV4Z{align-self:center;}div#n2-ss-4 .n-uc-FO1MI8Z8EUAZ-inner{padding:30px 30px 30px 30px}div#n2-ss-4 .n-uc-FO1MI8Z8EUAZ-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-4 .n-uc-FO1MI8Z8EUAZ-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-4 .n-uc-JJ5d9ehQXDJD-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-4 .n-uc-JJ5d9ehQXDJD{width:30%}div#n2-ss-4 .n-uc-mOR8vyEHmiI9{align-self:center;}div#n2-ss-4 .n-uc-smeWQDtbltkd-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-smeWQDtbltkd{width:70%}div#n2-ss-4 .n-uc-4AhHPjOJsMNi{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-zch6OXRnnacS{padding:10px 10px 10px 10px}div#n2-ss-4 .n-uc-tki8tavEFDhR-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-tki8tavEFDhR{align-self:center;}div#n2-ss-4 .n-uc-FPDWjr7UT0aX-inner{padding:30px 30px 30px 30px}div#n2-ss-4 .n-uc-FPDWjr7UT0aX-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-4 .n-uc-FPDWjr7UT0aX-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-4 .n-uc-ImqstluJpNnZ-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-4 .n-uc-ImqstluJpNnZ{width:30%}div#n2-ss-4 .n-uc-endA9UGGs2HQ{align-self:center;}div#n2-ss-4 .n-uc-VrtZa4E8kwJR-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-VrtZa4E8kwJR{width:70%}div#n2-ss-4 .n-uc-ZKjg73rWzsKa{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-oIQgBdtJmmQd{padding:10px 10px 10px 10px}div#n2-ss-4 .n-uc-AYBSGVIoQqMx-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-AYBSGVIoQqMx{align-self:center;}div#n2-ss-4 .n-uc-3hhNkdqxZM8D-inner{padding:30px 30px 30px 30px}div#n2-ss-4 .n-uc-3hhNkdqxZM8D-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-4 .n-uc-3hhNkdqxZM8D-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-4 .n-uc-RFHTlXodGO4p-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-4 .n-uc-RFHTlXodGO4p{width:30%}div#n2-ss-4 .n-uc-dDO5R9UqPuIG{align-self:center;}div#n2-ss-4 .n-uc-GCWYzXMliGnz-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-GCWYzXMliGnz{width:70%}div#n2-ss-4 .n-uc-Wktw7XYINzoe{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-DQCnU4tC5pYD{padding:10px 10px 10px 10px}div#n2-ss-4 .n-uc-LpDQAGjjnsJo-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-LpDQAGjjnsJo{align-self:center;}div#n2-ss-4 .n-uc-0Repk35azKKq-inner{padding:30px 30px 30px 30px}div#n2-ss-4 .n-uc-0Repk35azKKq-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-4 .n-uc-0Repk35azKKq-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-4 .n-uc-mD7m4e3K9R2h-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-4 .n-uc-mD7m4e3K9R2h{width:30%}div#n2-ss-4 .n-uc-GzGzrfdClca1{align-self:center;}div#n2-ss-4 .n-uc-NrLso0QROiSv-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-NrLso0QROiSv{width:70%}div#n2-ss-4 .n-uc-JTP9qaEpJKMh{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-6IrUxfgrWOkf{padding:10px 10px 10px 10px}div#n2-ss-4 .n-uc-5BJqvoMaE1za-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-5BJqvoMaE1za{align-self:center;}div#n2-ss-4 .n-uc-dxdiRg1uPIMN-inner{padding:30px 30px 30px 30px}div#n2-ss-4 .n-uc-dxdiRg1uPIMN-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-4 .n-uc-dxdiRg1uPIMN-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-4 .n-uc-f7IQDzSL7G7f-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-4 .n-uc-f7IQDzSL7G7f{width:30%}div#n2-ss-4 .n-uc-dhC0wcxDiauz{align-self:center;}div#n2-ss-4 .n-uc-bYEKNlSSIT36-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-bYEKNlSSIT36{width:70%}div#n2-ss-4 .n-uc-wj6HSAsWcoMl{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-Z0ufnBb8SNSB{padding:10px 10px 10px 10px}div#n2-ss-4 .n-uc-Xu2tyLjK4gjQ-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-Xu2tyLjK4gjQ{align-self:center;}div#n2-ss-4 .n-uc-Z0lYsJQgc2Es-inner{padding:30px 30px 30px 30px}div#n2-ss-4 .n-uc-Z0lYsJQgc2Es-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-4 .n-uc-Z0lYsJQgc2Es-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-4 .n-uc-lyJpD5pXzzT8-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-4 .n-uc-lyJpD5pXzzT8{width:30%}div#n2-ss-4 .n-uc-WK6Lkaww59YV{align-self:center;}div#n2-ss-4 .n-uc-Zl9MZMRdfeYN-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-Zl9MZMRdfeYN{width:70%}div#n2-ss-4 .n-uc-GGticY6tnT5K{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-xX1Vz7eUvUMG{padding:10px 10px 10px 10px}div#n2-ss-4 .n-uc-FGw1tXIWnNIJ-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-FGw1tXIWnNIJ{align-self:center;}div#n2-ss-4 .n-uc-lvmvtwrahyTU-inner{padding:30px 30px 30px 30px}div#n2-ss-4 .n-uc-lvmvtwrahyTU-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-4 .n-uc-lvmvtwrahyTU-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-4 .n-uc-KB89vhAYl5yM-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-4 .n-uc-KB89vhAYl5yM{width:30%}div#n2-ss-4 .n-uc-WlF1IFjBItIb{align-self:center;}div#n2-ss-4 .n-uc-8KIGxJJ3B5EB-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-8KIGxJJ3B5EB{width:70%}div#n2-ss-4 .n-uc-BW1GtoNONOXv{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-ckJP6jeLN9IZ{padding:10px 10px 10px 10px}div#n2-ss-4 .n-uc-30oldsUcdJM4-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-30oldsUcdJM4{align-self:center;}div#n2-ss-4 .n-uc-I00QuPruknUD-inner{padding:30px 30px 30px 30px}div#n2-ss-4 .n-uc-I00QuPruknUD-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-4 .n-uc-I00QuPruknUD-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-4 .n-uc-gQN5KXBvoWt5-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-4 .n-uc-gQN5KXBvoWt5{width:30%}div#n2-ss-4 .n-uc-xjEEk2IbEWRl{align-self:center;}div#n2-ss-4 .n-uc-b0lOt9gOEbaK-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-b0lOt9gOEbaK{width:70%}div#n2-ss-4 .n-uc-q88kQfNZY7ZL{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-MwaOaSj7RvCu{padding:10px 10px 10px 10px}div#n2-ss-4 .n-uc-TGbl5UgRLVqI-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-TGbl5UgRLVqI{align-self:center;}div#n2-ss-4 .n-uc-NkKW8HyUuBfT-inner{padding:30px 30px 30px 30px}div#n2-ss-4 .n-uc-NkKW8HyUuBfT-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-4 .n-uc-NkKW8HyUuBfT-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-4 .n-uc-qY8w9wMYun8o-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-4 .n-uc-qY8w9wMYun8o{width:30%}div#n2-ss-4 .n-uc-OWw1VrRk5O4E{align-self:center;}div#n2-ss-4 .n-uc-WCJ5U3JD1WaO-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-WCJ5U3JD1WaO{width:70%}div#n2-ss-4 .n-uc-paIlcCNeIPo5{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-u00sLonnXmGo{padding:10px 10px 10px 10px}div#n2-ss-4 .n-uc-MasnP2Xvcv3O-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-MasnP2Xvcv3O{align-self:center;}div#n2-ss-4 .n-uc-YZY14ervd8PN-inner{padding:30px 30px 30px 30px}div#n2-ss-4 .n-uc-YZY14ervd8PN-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-4 .n-uc-YZY14ervd8PN-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-4 .n-uc-fb3gcQJN0YM3-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-4 .n-uc-fb3gcQJN0YM3{width:30%}div#n2-ss-4 .n-uc-5DQjZg8tEOCY{align-self:center;}div#n2-ss-4 .n-uc-nw8F1GSazAZr-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-nw8F1GSazAZr{width:70%}div#n2-ss-4 .n-uc-SBcUiNhutDSx{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-MEcC6ib2P01C{padding:10px 10px 10px 10px}div#n2-ss-4 .n-uc-WpxVlB5afFq3-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-WpxVlB5afFq3{align-self:center;}div#n2-ss-4 .n-uc-5EUcCesvNgR2-inner{padding:30px 30px 30px 30px}div#n2-ss-4 .n-uc-5EUcCesvNgR2-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-4 .n-uc-5EUcCesvNgR2-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-4 .n-uc-iAyaPsn5WHF4-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-4 .n-uc-iAyaPsn5WHF4{width:30%}div#n2-ss-4 .n-uc-Cq94zGtkjXdn{align-self:center;}div#n2-ss-4 .n-uc-McSrJhE7lD8q-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-McSrJhE7lD8q{width:70%}div#n2-ss-4 .n-uc-BuTP1UuxZcan{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-fJ0nkS3oPEw7{padding:10px 10px 10px 10px}div#n2-ss-4 .n-uc-dg9IDmm70zM5-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-dg9IDmm70zM5{align-self:center;}div#n2-ss-4 .n-uc-RJTVGGt0Qou2-inner{padding:30px 30px 30px 30px}div#n2-ss-4 .n-uc-RJTVGGt0Qou2-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-4 .n-uc-RJTVGGt0Qou2-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-4 .n-uc-Mj25QXAc8XQl-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-4 .n-uc-Mj25QXAc8XQl{width:30%}div#n2-ss-4 .n-uc-Ki6JLZ2Xeody{align-self:center;}div#n2-ss-4 .n-uc-Nkikq6rgGrrO-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-Nkikq6rgGrrO{width:70%}div#n2-ss-4 .n-uc-ZaefCYm4zX4H{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-z41usbi36lFk{padding:10px 10px 10px 10px}div#n2-ss-4 .n-uc-W1lXIY0AtXHM-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-W1lXIY0AtXHM{align-self:center;}div#n2-ss-4 .n-uc-ZCR0LYMQudRb-inner{padding:30px 30px 30px 30px}div#n2-ss-4 .n-uc-ZCR0LYMQudRb-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-4 .n-uc-ZCR0LYMQudRb-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-4 .n-uc-eLdnEU4w7uns-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-4 .n-uc-eLdnEU4w7uns{width:30%}div#n2-ss-4 .n-uc-6vjgPJJ14WUt{align-self:center;}div#n2-ss-4 .n-uc-UZKxuFxdNHL8-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-UZKxuFxdNHL8{width:70%}div#n2-ss-4 .n-uc-hJNcZhAmKz1E{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-8T4W6pCV6nZb{padding:10px 10px 10px 10px}div#n2-ss-4 .n-uc-rZeoHrcH5oJO-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-rZeoHrcH5oJO{align-self:center;}div#n2-ss-4 .n-uc-ipOhhBOqUb7z-inner{padding:30px 30px 30px 30px}div#n2-ss-4 .n-uc-ipOhhBOqUb7z-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-4 .n-uc-ipOhhBOqUb7z-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-4 .n-uc-54389S9gdiyf-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-4 .n-uc-54389S9gdiyf{width:30%}div#n2-ss-4 .n-uc-cuKmGe1grhzH{align-self:center;}div#n2-ss-4 .n-uc-N3zQCWawTGWS-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-N3zQCWawTGWS{width:70%}div#n2-ss-4 .n-uc-NNdXpQdX1ACR{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-E2xgYukOVuTL{padding:10px 10px 10px 10px}div#n2-ss-4 .n-uc-7Ftxt0hBElAb-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-7Ftxt0hBElAb{align-self:center;}div#n2-ss-4 .n-uc-aNfuejH2Qld2-inner{padding:30px 30px 30px 30px}div#n2-ss-4 .n-uc-aNfuejH2Qld2-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-4 .n-uc-aNfuejH2Qld2-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-4 .n-uc-BRd7jplpwwMK-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-4 .n-uc-BRd7jplpwwMK{width:30%}div#n2-ss-4 .n-uc-stijYGBeaxpx{align-self:center;}div#n2-ss-4 .n-uc-lVGnA6L0HxsP-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-lVGnA6L0HxsP{width:70%}div#n2-ss-4 .n-uc-8JDptWCKXEdv{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-rMljXGaUhdkO{padding:10px 10px 10px 10px}div#n2-ss-4 .n-uc-naHzBD1SEoL9-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-naHzBD1SEoL9{align-self:center;}div#n2-ss-4 .n-uc-i7crtXLapjEG-inner{padding:30px 30px 30px 30px}div#n2-ss-4 .n-uc-i7crtXLapjEG-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-4 .n-uc-i7crtXLapjEG-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-4 .n-uc-ezPk8PEcukE4-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-4 .n-uc-ezPk8PEcukE4{width:30%}div#n2-ss-4 .n-uc-zQjaP7j6Uq2T{align-self:center;}div#n2-ss-4 .n-uc-XBrxPavqXG2L-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-XBrxPavqXG2L{width:70%}div#n2-ss-4 .n-uc-t1BmLU6WdWXM{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-OUoFxmjUojdk{padding:10px 10px 10px 10px}div#n2-ss-4 .n-uc-eSQRFye0H1nl-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-eSQRFye0H1nl{align-self:center;}div#n2-ss-4 .n-uc-jP6MSgxwDLFL-inner{padding:30px 30px 30px 30px}div#n2-ss-4 .n-uc-jP6MSgxwDLFL-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-4 .n-uc-jP6MSgxwDLFL-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-4 .n-uc-YqUyQJdhDg5B-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-4 .n-uc-YqUyQJdhDg5B{width:30%}div#n2-ss-4 .n-uc-zI4ULJUwd7bj{align-self:center;}div#n2-ss-4 .n-uc-6NexyAH5dpfT-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-6NexyAH5dpfT{width:70%}div#n2-ss-4 .n-uc-v2HTotHYZF3L{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-Va3clFCaUJYD{padding:10px 10px 10px 10px}div#n2-ss-4 .n-uc-xUEh9XVs4yDD-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-xUEh9XVs4yDD{align-self:center;}div#n2-ss-4 .n-uc-CUMtyWrPvyBe-inner{padding:30px 30px 30px 30px}div#n2-ss-4 .n-uc-CUMtyWrPvyBe-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-4 .n-uc-CUMtyWrPvyBe-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-4 .n-uc-hHVg0vJQZ66k-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-4 .n-uc-hHVg0vJQZ66k{width:30%}div#n2-ss-4 .n-uc-QiaQnrtIXNpN{align-self:center;}div#n2-ss-4 .n-uc-x8JWTpaPH0sx-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-x8JWTpaPH0sx{width:70%}div#n2-ss-4 .n-uc-SUyPx9ZUBnkO{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-ryoRf7jxjTNR{padding:10px 10px 10px 10px}div#n2-ss-4 .n-uc-f39BSQcXHsAs-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-f39BSQcXHsAs{align-self:center;}div#n2-ss-4 .n-uc-MEPy6N2qeFKf-inner{padding:30px 30px 30px 30px}div#n2-ss-4 .n-uc-MEPy6N2qeFKf-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-4 .n-uc-MEPy6N2qeFKf-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-4 .n-uc-Dj4oOzET76nX-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-4 .n-uc-Dj4oOzET76nX{width:30%}div#n2-ss-4 .n-uc-6bQ52cEWBFBv{align-self:center;}div#n2-ss-4 .n-uc-FmmNZKvRsria-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-FmmNZKvRsria{width:70%}div#n2-ss-4 .n-uc-xC8Q2rIDAOQk{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-wd25VTdiKxoz{padding:10px 10px 10px 10px}div#n2-ss-4 .n-uc-foT1WjwaX7IV-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-foT1WjwaX7IV{align-self:center;}div#n2-ss-4 .n-uc-9lsx3wqx1JYM-inner{padding:30px 30px 30px 30px}div#n2-ss-4 .n-uc-9lsx3wqx1JYM-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-4 .n-uc-9lsx3wqx1JYM-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-4 .n-uc-RytOoyb9myss-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-4 .n-uc-RytOoyb9myss{width:30%}div#n2-ss-4 .n-uc-sU6t3YPFUDCx{align-self:center;}div#n2-ss-4 .n-uc-26fhB4IHNCYu-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-26fhB4IHNCYu{width:70%}div#n2-ss-4 .n-uc-BJvO2tfAjAL9{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-K3ea73uIWypl{padding:10px 10px 10px 10px}div#n2-ss-4 .n-uc-iTg5YmtiJpHN-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-iTg5YmtiJpHN{align-self:center;}div#n2-ss-4 .n-uc-HgGESXx4y5y8-inner{padding:30px 30px 30px 30px}div#n2-ss-4 .n-uc-HgGESXx4y5y8-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-4 .n-uc-HgGESXx4y5y8-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-4 .n-uc-UGuHnCp1qJuk-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-4 .n-uc-UGuHnCp1qJuk{width:30%}div#n2-ss-4 .n-uc-nDhItWSlAKxY{align-self:center;}div#n2-ss-4 .n-uc-4GqtCRJF3aDS-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-4GqtCRJF3aDS{width:70%}div#n2-ss-4 .n-uc-SkIGeg7jMeOd{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-soeBuOU2ZgtU{padding:10px 10px 10px 10px}div#n2-ss-4 .n-uc-aXOBRW3clUVS-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-aXOBRW3clUVS{align-self:center;}div#n2-ss-4 .n-uc-7U4NgAySI8n5-inner{padding:30px 30px 30px 30px}div#n2-ss-4 .n-uc-7U4NgAySI8n5-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-4 .n-uc-7U4NgAySI8n5-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-4 .n-uc-wf7hfekxuzCT-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-4 .n-uc-wf7hfekxuzCT{width:30%}div#n2-ss-4 .n-uc-LLcCl2w7IhvR{align-self:center;}div#n2-ss-4 .n-uc-aMpT8LpatDO0-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-aMpT8LpatDO0{width:70%}div#n2-ss-4 .n-uc-GkAyFMutnKzn{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-TomrtZSuER1j{padding:10px 10px 10px 10px}div#n2-ss-4 .n-uc-6RUpvE1bVuM2-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-6RUpvE1bVuM2{align-self:center;}div#n2-ss-4 .n-uc-0yRcWbYIimed-inner{padding:30px 30px 30px 30px}div#n2-ss-4 .n-uc-0yRcWbYIimed-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-4 .n-uc-0yRcWbYIimed-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-4 .n-uc-vXRoyEcIu6Jq-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-4 .n-uc-vXRoyEcIu6Jq{width:30%}div#n2-ss-4 .n-uc-IKeayhazkCJh{align-self:center;}div#n2-ss-4 .n-uc-O49HlzcAPHpG-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-O49HlzcAPHpG{width:70%}div#n2-ss-4 .n-uc-eeImp0iNRJpu{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-zGiFp3SCGKIA{padding:10px 10px 10px 10px}div#n2-ss-4 .n-uc-cWIXLqRlFcHh-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-cWIXLqRlFcHh{align-self:center;}div#n2-ss-4 .n-uc-tI4rPO5jqpLZ-inner{padding:30px 30px 30px 30px}div#n2-ss-4 .n-uc-tI4rPO5jqpLZ-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-4 .n-uc-tI4rPO5jqpLZ-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-4 .n-uc-kQNY0ed07HGg-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-4 .n-uc-kQNY0ed07HGg{width:30%}div#n2-ss-4 .n-uc-NT0mb9YuUwKl{align-self:center;}div#n2-ss-4 .n-uc-2iSA4HRJQdrT-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-2iSA4HRJQdrT{width:70%}div#n2-ss-4 .n-uc-8ADg4EMUW3Zb{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-5tjARbz61iSN{padding:10px 10px 10px 10px}div#n2-ss-4 .n-uc-bh6sM88UK9T3-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-bh6sM88UK9T3{align-self:center;}div#n2-ss-4 .n-uc-XK0sqq37Jydp-inner{padding:30px 30px 30px 30px}div#n2-ss-4 .n-uc-XK0sqq37Jydp-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-4 .n-uc-XK0sqq37Jydp-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-4 .n-uc-cx7K4UWk7bzt-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-4 .n-uc-cx7K4UWk7bzt{width:30%}div#n2-ss-4 .n-uc-FvZ4GnMTt1At{align-self:center;}div#n2-ss-4 .n-uc-VBf9CTCZhV9U-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-VBf9CTCZhV9U{width:70%}div#n2-ss-4 .n-uc-HhI9bH4a3hGF{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-G2duU3gmbUc3{padding:10px 10px 10px 10px}div#n2-ss-4 .n-uc-xFgNaafGLuSS-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-xFgNaafGLuSS{align-self:center;}div#n2-ss-4 .n-uc-DFD2oOkaMz7q-inner{padding:30px 30px 30px 30px}div#n2-ss-4 .n-uc-DFD2oOkaMz7q-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-4 .n-uc-DFD2oOkaMz7q-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-4 .n-uc-RabxOFoGnmbu-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-4 .n-uc-RabxOFoGnmbu{width:30%}div#n2-ss-4 .n-uc-ULE35U7zxaHi{align-self:center;}div#n2-ss-4 .n-uc-5VDwSbjcp0JN-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-5VDwSbjcp0JN{width:70%}div#n2-ss-4 .n-uc-6tjUEXOcKcF2{align-self:var(--ss-fs);}div#n2-ss-4 .n-uc-qBFOkVaI478U{padding:10px 10px 10px 10px}div#n2-ss-4 .n-uc-Y4unNFYBDIJn-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-Y4unNFYBDIJn{align-self:center;}div#n2-ss-4 .n-uc-tnoekEdI9cPj-inner{padding:30px 30px 30px 30px}div#n2-ss-4 .n-uc-tnoekEdI9cPj-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-4 .n-uc-tnoekEdI9cPj-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-4 .n-uc-7G5teGr0xuvk-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-4 .n-uc-7G5teGr0xuvk{width:30%}div#n2-ss-4 .n-uc-4cbLbFqslMLP{align-self:center;}div#n2-ss-4 .n-uc-y9FDVNWA3U6w-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-4 .n-uc-y9FDVNWA3U6w{width:70%}div#n2-ss-4 .n-uc-3QrhlyY50BsD{align-self:var(--ss-fs);}div#n2-ss-4 .nextend-arrow img{width: 32px}@media (min-width: 1200px){div#n2-ss-4 [data-hide-desktopportrait=\\\"1\\\"]{display: none !important;}}@media (orientation: landscape) and (max-width: 1199px) and (min-width: 901px),(orientation: portrait) and (max-width: 1199px) and (min-width: 701px){div#n2-ss-4 .n-uc-wzPL84mmwFaD-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-4 .n-uc-ShosrPydObk2{width:30%}div#n2-ss-4 .n-uc-ORECRe2u8DYI{width:70%}div#n2-ss-4 .n-uc-V5cPfAJLd50m-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-4 .n-uc-nwc2v257Y6FG{width:30%}div#n2-ss-4 .n-uc-ywlHUKb9CanX{width:70%}div#n2-ss-4 .n-uc-6iWktuDWUTUT-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-4 .n-uc-O5hKrhfJRsL9{width:30%}div#n2-ss-4 .n-uc-yD0hFF5H3aJb{width:70%}div#n2-ss-4 .n-uc-8jWkyo145xk4-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-4 .n-uc-tfInrQkuYeyB{width:30%}div#n2-ss-4 .n-uc-oUTqtu5Bx0m9{width:70%}div#n2-ss-4 .n-uc-8Q6WQLiNXqjv-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-4 .n-uc-gQUuNwHW7NwW{width:30%}div#n2-ss-4 .n-uc-VHIxZkm97nGW{width:70%}div#n2-ss-4 .n-uc-ftGPoJPnvEPx-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-4 .n-uc-6IWaBI9MWbyr{width:30%}div#n2-ss-4 .n-uc-8DbpjM8yUThq{width:70%}div#n2-ss-4 .n-uc-sJpu30IwJmP6-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-4 .n-uc-RfdLt5uvaKRv{width:30%}div#n2-ss-4 .n-uc-COwEvHIHNKBd{width:70%}div#n2-ss-4 .n-uc-KbSFYzu5wgDO-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-4 .n-uc-UUss8im1qUxE{width:30%}div#n2-ss-4 .n-uc-BQZpX8cuPbq1{width:70%}div#n2-ss-4 .n-uc-AprBa6jj1Lfk-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-4 .n-uc-8r8DVCj9SmXL{width:30%}div#n2-ss-4 .n-uc-pYCVCMJquvor{width:70%}div#n2-ss-4 .n-uc-FO1MI8Z8EUAZ-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-4 .n-uc-JJ5d9ehQXDJD{width:30%}div#n2-ss-4 .n-uc-smeWQDtbltkd{width:70%}div#n2-ss-4 .n-uc-FPDWjr7UT0aX-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-4 .n-uc-ImqstluJpNnZ{width:30%}div#n2-ss-4 .n-uc-VrtZa4E8kwJR{width:70%}div#n2-ss-4 .n-uc-3hhNkdqxZM8D-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-4 .n-uc-RFHTlXodGO4p{width:30%}div#n2-ss-4 .n-uc-GCWYzXMliGnz{width:70%}div#n2-ss-4 .n-uc-0Repk35azKKq-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-4 .n-uc-mD7m4e3K9R2h{width:30%}div#n2-ss-4 .n-uc-NrLso0QROiSv{width:70%}div#n2-ss-4 .n-uc-dxdiRg1uPIMN-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-4 .n-uc-f7IQDzSL7G7f{width:30%}div#n2-ss-4 .n-uc-bYEKNlSSIT36{width:70%}div#n2-ss-4 .n-uc-Z0lYsJQgc2Es-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-4 .n-uc-lyJpD5pXzzT8{width:30%}div#n2-ss-4 .n-uc-Zl9MZMRdfeYN{width:70%}div#n2-ss-4 .n-uc-lvmvtwrahyTU-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-4 .n-uc-KB89vhAYl5yM{width:30%}div#n2-ss-4 .n-uc-8KIGxJJ3B5EB{width:70%}div#n2-ss-4 .n-uc-I00QuPruknUD-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-4 .n-uc-gQN5KXBvoWt5{width:30%}div#n2-ss-4 .n-uc-b0lOt9gOEbaK{width:70%}div#n2-ss-4 .n-uc-NkKW8HyUuBfT-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-4 .n-uc-qY8w9wMYun8o{width:30%}div#n2-ss-4 .n-uc-WCJ5U3JD1WaO{width:70%}div#n2-ss-4 .n-uc-YZY14ervd8PN-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-4 .n-uc-fb3gcQJN0YM3{width:30%}div#n2-ss-4 .n-uc-nw8F1GSazAZr{width:70%}div#n2-ss-4 .n-uc-5EUcCesvNgR2-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-4 .n-uc-iAyaPsn5WHF4{width:30%}div#n2-ss-4 .n-uc-McSrJhE7lD8q{width:70%}div#n2-ss-4 .n-uc-RJTVGGt0Qou2-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-4 .n-uc-Mj25QXAc8XQl{width:30%}div#n2-ss-4 .n-uc-Nkikq6rgGrrO{width:70%}div#n2-ss-4 .n-uc-ZCR0LYMQudRb-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-4 .n-uc-eLdnEU4w7uns{width:30%}div#n2-ss-4 .n-uc-UZKxuFxdNHL8{width:70%}div#n2-ss-4 .n-uc-ipOhhBOqUb7z-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-4 .n-uc-54389S9gdiyf{width:30%}div#n2-ss-4 .n-uc-N3zQCWawTGWS{width:70%}div#n2-ss-4 .n-uc-aNfuejH2Qld2-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-4 .n-uc-BRd7jplpwwMK{width:30%}div#n2-ss-4 .n-uc-lVGnA6L0HxsP{width:70%}div#n2-ss-4 .n-uc-i7crtXLapjEG-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-4 .n-uc-ezPk8PEcukE4{width:30%}div#n2-ss-4 .n-uc-XBrxPavqXG2L{width:70%}div#n2-ss-4 .n-uc-jP6MSgxwDLFL-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-4 .n-uc-YqUyQJdhDg5B{width:30%}div#n2-ss-4 .n-uc-6NexyAH5dpfT{width:70%}div#n2-ss-4 .n-uc-CUMtyWrPvyBe-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-4 .n-uc-hHVg0vJQZ66k{width:30%}div#n2-ss-4 .n-uc-x8JWTpaPH0sx{width:70%}div#n2-ss-4 .n-uc-MEPy6N2qeFKf-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-4 .n-uc-Dj4oOzET76nX{width:30%}div#n2-ss-4 .n-uc-FmmNZKvRsria{width:70%}div#n2-ss-4 .n-uc-9lsx3wqx1JYM-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-4 .n-uc-RytOoyb9myss{width:30%}div#n2-ss-4 .n-uc-26fhB4IHNCYu{width:70%}div#n2-ss-4 .n-uc-HgGESXx4y5y8-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-4 .n-uc-UGuHnCp1qJuk{width:30%}div#n2-ss-4 .n-uc-4GqtCRJF3aDS{width:70%}div#n2-ss-4 .n-uc-7U4NgAySI8n5-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-4 .n-uc-wf7hfekxuzCT{width:30%}div#n2-ss-4 .n-uc-aMpT8LpatDO0{width:70%}div#n2-ss-4 .n-uc-0yRcWbYIimed-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-4 .n-uc-vXRoyEcIu6Jq{width:30%}div#n2-ss-4 .n-uc-O49HlzcAPHpG{width:70%}div#n2-ss-4 .n-uc-tI4rPO5jqpLZ-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-4 .n-uc-kQNY0ed07HGg{width:30%}div#n2-ss-4 .n-uc-2iSA4HRJQdrT{width:70%}div#n2-ss-4 .n-uc-XK0sqq37Jydp-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-4 .n-uc-cx7K4UWk7bzt{width:30%}div#n2-ss-4 .n-uc-VBf9CTCZhV9U{width:70%}div#n2-ss-4 .n-uc-DFD2oOkaMz7q-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-4 .n-uc-RabxOFoGnmbu{width:30%}div#n2-ss-4 .n-uc-5VDwSbjcp0JN{width:70%}div#n2-ss-4 .n-uc-tnoekEdI9cPj-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-4 .n-uc-7G5teGr0xuvk{width:30%}div#n2-ss-4 .n-uc-y9FDVNWA3U6w{width:70%}div#n2-ss-4 [data-hide-tabletportrait=\\\"1\\\"]{display: none !important;}}@media (orientation: landscape) and (max-width: 900px),(orientation: portrait) and (max-width: 700px){div#n2-ss-4 .n-uc-wzPL84mmwFaD-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-4 .n-uc-ShosrPydObk2{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-ORECRe2u8DYI{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-V5cPfAJLd50m-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-4 .n-uc-nwc2v257Y6FG{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-ywlHUKb9CanX{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-6iWktuDWUTUT-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-4 .n-uc-O5hKrhfJRsL9{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-yD0hFF5H3aJb{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-8jWkyo145xk4-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-4 .n-uc-tfInrQkuYeyB{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-oUTqtu5Bx0m9{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-8Q6WQLiNXqjv-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-4 .n-uc-gQUuNwHW7NwW{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-VHIxZkm97nGW{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-ftGPoJPnvEPx-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-4 .n-uc-6IWaBI9MWbyr{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-8DbpjM8yUThq{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-sJpu30IwJmP6-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-4 .n-uc-RfdLt5uvaKRv{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-COwEvHIHNKBd{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-KbSFYzu5wgDO-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-4 .n-uc-UUss8im1qUxE{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-BQZpX8cuPbq1{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-AprBa6jj1Lfk-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-4 .n-uc-8r8DVCj9SmXL{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-pYCVCMJquvor{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-FO1MI8Z8EUAZ-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-4 .n-uc-JJ5d9ehQXDJD{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-smeWQDtbltkd{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-FPDWjr7UT0aX-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-4 .n-uc-ImqstluJpNnZ{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-VrtZa4E8kwJR{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-3hhNkdqxZM8D-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-4 .n-uc-RFHTlXodGO4p{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-GCWYzXMliGnz{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-0Repk35azKKq-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-4 .n-uc-mD7m4e3K9R2h{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-NrLso0QROiSv{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-dxdiRg1uPIMN-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-4 .n-uc-f7IQDzSL7G7f{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-bYEKNlSSIT36{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-Z0lYsJQgc2Es-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-4 .n-uc-lyJpD5pXzzT8{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-Zl9MZMRdfeYN{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-lvmvtwrahyTU-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-4 .n-uc-KB89vhAYl5yM{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-8KIGxJJ3B5EB{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-I00QuPruknUD-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-4 .n-uc-gQN5KXBvoWt5{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-b0lOt9gOEbaK{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-NkKW8HyUuBfT-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-4 .n-uc-qY8w9wMYun8o{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-WCJ5U3JD1WaO{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-YZY14ervd8PN-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-4 .n-uc-fb3gcQJN0YM3{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-nw8F1GSazAZr{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-5EUcCesvNgR2-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-4 .n-uc-iAyaPsn5WHF4{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-McSrJhE7lD8q{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-RJTVGGt0Qou2-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-4 .n-uc-Mj25QXAc8XQl{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-Nkikq6rgGrrO{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-ZCR0LYMQudRb-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-4 .n-uc-eLdnEU4w7uns{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-UZKxuFxdNHL8{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-ipOhhBOqUb7z-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-4 .n-uc-54389S9gdiyf{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-N3zQCWawTGWS{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-aNfuejH2Qld2-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-4 .n-uc-BRd7jplpwwMK{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-lVGnA6L0HxsP{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-i7crtXLapjEG-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-4 .n-uc-ezPk8PEcukE4{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-XBrxPavqXG2L{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-jP6MSgxwDLFL-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-4 .n-uc-YqUyQJdhDg5B{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-6NexyAH5dpfT{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-CUMtyWrPvyBe-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-4 .n-uc-hHVg0vJQZ66k{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-x8JWTpaPH0sx{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-MEPy6N2qeFKf-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-4 .n-uc-Dj4oOzET76nX{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-FmmNZKvRsria{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-9lsx3wqx1JYM-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-4 .n-uc-RytOoyb9myss{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-26fhB4IHNCYu{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-HgGESXx4y5y8-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-4 .n-uc-UGuHnCp1qJuk{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-4GqtCRJF3aDS{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-7U4NgAySI8n5-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-4 .n-uc-wf7hfekxuzCT{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-aMpT8LpatDO0{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-0yRcWbYIimed-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-4 .n-uc-vXRoyEcIu6Jq{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-O49HlzcAPHpG{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-tI4rPO5jqpLZ-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-4 .n-uc-kQNY0ed07HGg{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-2iSA4HRJQdrT{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-XK0sqq37Jydp-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-4 .n-uc-cx7K4UWk7bzt{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-VBf9CTCZhV9U{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-DFD2oOkaMz7q-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-4 .n-uc-RabxOFoGnmbu{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-5VDwSbjcp0JN{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-tnoekEdI9cPj-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-4 .n-uc-7G5teGr0xuvk{width:calc(100% - 20px)}div#n2-ss-4 .n-uc-y9FDVNWA3U6w{width:calc(100% - 20px)}div#n2-ss-4 [data-hide-mobileportrait=\\\"1\\\"]{display: none !important;}div#n2-ss-4 .nextend-arrow img{width: 16px}}\"},\"globalInline\":[]},\"less\":{\"staticGroupPreload\":[],\"staticGroup\":[],\"files\":[],\"urls\":[],\"codes\":[],\"firstCodes\":[],\"inline\":[],\"globalInline\":[]},\"js\":{\"staticGroupPreload\":[],\"staticGroup\":{\"smartslider-frontend\":\"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/smart-slider-3\\/Public\\/SmartSlider3\\/Application\\/Frontend\\/Assets\\/dist\\/smartslider-frontend.min.js\",\"ss-simple\":\"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/smart-slider-3\\/Public\\/SmartSlider3\\/Slider\\/SliderType\\/Simple\\/Assets\\/dist\\/ss-simple.min.js\",\"w-arrow-image\":\"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/smart-slider-3\\/Public\\/SmartSlider3\\/Widget\\/Arrow\\/ArrowImage\\/Assets\\/dist\\/w-arrow-image.min.js\",\"w-bullet\":\"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/smart-slider-3\\/Public\\/SmartSlider3\\/Widget\\/Bullet\\/Assets\\/dist\\/w-bullet.min.js\"},\"files\":[],\"urls\":[],\"codes\":[],\"firstCodes\":[],\"inline\":[\"_N2.r([\\\"documentReady\\\",\\\"smartslider-frontend\\\",\\\"SmartSliderWidgetArrowImage\\\",\\\"SmartSliderWidgetBulletTransition\\\",\\\"ss-simple\\\"],function(){new _N2.SmartSliderSimple(\'n2-ss-4\', {\\\"admin\\\":false,\\\"background.video.mobile\\\":1,\\\"loadingTime\\\":2000,\\\"alias\\\":{\\\"id\\\":0,\\\"smoothScroll\\\":0,\\\"slideSwitch\\\":0,\\\"scroll\\\":1},\\\"align\\\":\\\"normal\\\",\\\"isDelayed\\\":0,\\\"responsive\\\":{\\\"mediaQueries\\\":{\\\"all\\\":false,\\\"desktopportrait\\\":[\\\"(min-width: 1200px)\\\"],\\\"tabletportrait\\\":[\\\"(orientation: landscape) and (max-width: 1199px) and (min-width: 901px)\\\",\\\"(orientation: portrait) and (max-width: 1199px) and (min-width: 701px)\\\"],\\\"mobileportrait\\\":[\\\"(orientation: landscape) and (max-width: 900px)\\\",\\\"(orientation: portrait) and (max-width: 700px)\\\"]},\\\"base\\\":{\\\"slideOuterWidth\\\":1200,\\\"slideOuterHeight\\\":480,\\\"sliderWidth\\\":1200,\\\"sliderHeight\\\":480,\\\"slideWidth\\\":1200,\\\"slideHeight\\\":480},\\\"hideOn\\\":{\\\"desktopLandscape\\\":false,\\\"desktopPortrait\\\":false,\\\"tabletLandscape\\\":false,\\\"tabletPortrait\\\":false,\\\"mobileLandscape\\\":false,\\\"mobilePortrait\\\":false},\\\"onResizeEnabled\\\":true,\\\"type\\\":\\\"auto\\\",\\\"sliderHeightBasedOn\\\":\\\"real\\\",\\\"focusUser\\\":1,\\\"focusEdge\\\":\\\"auto\\\",\\\"breakpoints\\\":[{\\\"device\\\":\\\"tabletPortrait\\\",\\\"type\\\":\\\"max-screen-width\\\",\\\"portraitWidth\\\":1199,\\\"landscapeWidth\\\":1199},{\\\"device\\\":\\\"mobilePortrait\\\",\\\"type\\\":\\\"max-screen-width\\\",\\\"portraitWidth\\\":700,\\\"landscapeWidth\\\":900}],\\\"enabledDevices\\\":{\\\"desktopLandscape\\\":0,\\\"desktopPortrait\\\":1,\\\"tabletLandscape\\\":0,\\\"tabletPortrait\\\":1,\\\"mobileLandscape\\\":0,\\\"mobilePortrait\\\":1},\\\"sizes\\\":{\\\"desktopPortrait\\\":{\\\"width\\\":1200,\\\"height\\\":480,\\\"max\\\":3000,\\\"min\\\":1200},\\\"tabletPortrait\\\":{\\\"width\\\":701,\\\"height\\\":280,\\\"customHeight\\\":false,\\\"max\\\":1199,\\\"min\\\":701},\\\"mobilePortrait\\\":{\\\"width\\\":320,\\\"height\\\":128,\\\"customHeight\\\":false,\\\"max\\\":900,\\\"min\\\":320}},\\\"overflowHiddenPage\\\":0,\\\"focus\\\":{\\\"offsetTop\\\":\\\"#wpadminbar\\\",\\\"offsetBottom\\\":\\\"\\\"}},\\\"controls\\\":{\\\"mousewheel\\\":0,\\\"touch\\\":\\\"horizontal\\\",\\\"keyboard\\\":1,\\\"blockCarouselInteraction\\\":1},\\\"playWhenVisible\\\":1,\\\"playWhenVisibleAt\\\":0.5,\\\"lazyLoad\\\":0,\\\"lazyLoadNeighbor\\\":0,\\\"blockrightclick\\\":0,\\\"maintainSession\\\":0,\\\"autoplay\\\":{\\\"enabled\\\":0,\\\"start\\\":1,\\\"duration\\\":8000,\\\"autoplayLoop\\\":1,\\\"allowReStart\\\":0,\\\"pause\\\":{\\\"click\\\":1,\\\"mouse\\\":\\\"0\\\",\\\"mediaStarted\\\":1},\\\"resume\\\":{\\\"click\\\":0,\\\"mouse\\\":\\\"0\\\",\\\"mediaEnded\\\":1,\\\"slidechanged\\\":0},\\\"interval\\\":1,\\\"intervalModifier\\\":\\\"loop\\\",\\\"intervalSlide\\\":\\\"current\\\"},\\\"perspective\\\":1500,\\\"layerMode\\\":{\\\"playOnce\\\":0,\\\"playFirstLayer\\\":1,\\\"mode\\\":\\\"skippable\\\",\\\"inAnimation\\\":\\\"mainInEnd\\\"},\\\"bgAnimations\\\":0,\\\"mainanimation\\\":{\\\"type\\\":\\\"horizontal\\\",\\\"duration\\\":800,\\\"delay\\\":0,\\\"ease\\\":\\\"easeOutQuad\\\",\\\"shiftedBackgroundAnimation\\\":0},\\\"carousel\\\":1,\\\"initCallbacks\\\":function(){new _N2.SmartSliderWidgetArrowImage(this);new _N2.SmartSliderWidgetBulletTransition(this, {\\\"area\\\":10,\\\"dotClasses\\\":\\\"n2-style-da7e7078bdb1d9699aa01eb6c4103812-dot \\\",\\\"mode\\\":\\\"\\\",\\\"action\\\":\\\"click\\\"});}});});\"],\"globalInline\":[]},\"googleFonts\":{\"staticGroupPreload\":[],\"staticGroup\":[],\"files\":{\"Roboto\":[\"300\",\"400\"]},\"urls\":[],\"codes\":[],\"firstCodes\":[],\"inline\":[],\"globalInline\":[]},\"image\":{\"images\":{\"0\":\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/2025\\/10\\/Banque-des-territoires-600x300-1.webp\",\"1\":\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/logo-le-patriote.png\",\"2\":\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/logo-le-progres.png\",\"5\":\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0002_tribunedelyon.jpg\",\"6\":\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0030_lemoniteur.jpg\",\"7\":\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0017_m6.jpg\",\"8\":\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0016_laprovence.jpg\",\"9\":\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0015_leveildehauteloire.jpg\",\"10\":\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0010_lechorepublicain.jpg\",\"11\":\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0014_lyonnerepublicaine.jpg\",\"12\":\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0012_lejournalducentre.jpg\",\"13\":\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0001_lepays.jpg\",\"14\":\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0008_leberryrepublicain.jpg\",\"15\":\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0013_franceinfo.jpg\",\"16\":\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0011_lepopulaireducentre.jpg\",\"17\":\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0009_larepubliqueducentre.jpg\",\"19\":\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0007_bpifrance.jpg\",\"21\":\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0006_batiactu.jpg\",\"22\":\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0005_lamontagne.jpg\",\"23\":\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0004_journaldubatimentetdestp.jpg\",\"24\":\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0003_3rhonealpes.jpg\",\"25\":\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0028_rtl.jpg\",\"26\":\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0019_lefigaro.jpg\",\"27\":\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0020_leprogres.jpg\",\"29\":\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0026_actualitesdesterritoires.jpg\",\"30\":\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0024_lerepublicain.jpg\",\"31\":\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0022_lejournal.jpg\",\"32\":\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0000_zepros.jpg\",\"35\":\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/slider4\\/bowatts-_0018_ours.jpg\"}}}}","0","1");

INSERT IGNORE INTO `mod119_nextend2_section_storage` VALUES 
("12064","smartslider","sliderChanged","2","0","0","1"),
("12065","cache","notweb/n2-ss-2","data.manifest","{\"generator\":[]}","0","1"),
("12066","cache","notweb/n2-ss-2","variations.manifest","1","0","1"),
("12067","cache","notweb/n2-ss-2","sliderfr_FR1.manifest","{\"hash\":\"\",\"nextCacheRefresh\":2145916800,\"currentPath\":\"c9f4aa5ef7d688ff9a456f13107835ed\",\"version\":\"3.5.1.30\"}","0","1"),
("12068","cache","notweb/n2-ss-2","sliderfr_FR1","{\"html\":\"<div class=\\\"n2-section-smartslider fitvidsignore  n2_clear\\\" data-ssid=\\\"2\\\"><div id=\\\"n2-ss-2-align\\\" class=\\\"n2-ss-align\\\"><div class=\\\"n2-padding\\\"><div id=\\\"n2-ss-2\\\" data-creator=\\\"Smart Slider 3\\\" data-responsive=\\\"auto\\\" class=\\\"n2-ss-slider n2-ow n2-has-hover n2notransition  \\\">\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n<div class=\\\"n2-ss-slider-wrapper-inside\\\">\\n        <div class=\\\"n2-ss-slider-1 n2_ss__touch_element n2-ow\\\">\\n            <div class=\\\"n2-ss-slider-2 n2-ow\\\">\\n                                                <div class=\\\"n2-ss-slider-3 n2-ow\\\">\\n\\n                    <div class=\\\"n2-ss-slide-backgrounds n2-ow-all\\\"><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"1\\\" data-mode=\\\"fill\\\"><div class=\\\"n2-ss-slide-background-image\\\" data-blur=\\\"0\\\" data-opacity=\\\"100\\\" data-x=\\\"50\\\" data-y=\\\"50\\\" data-alt=\\\"\\\" data-title=\\\"\\\"><picture class=\\\"skip-lazy\\\" data-skip-lazy=\\\"1\\\"><img src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/2025\\/09\\/Bulle-temoignage-large.png\\\" alt=\\\"\\\" title=\\\"\\\" loading=\\\"lazy\\\" class=\\\"skip-lazy\\\" data-skip-lazy=\\\"1\\\"><\\/picture><\\/div><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"2\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div class=\\\"n2-ss-slide-background-image\\\" data-blur=\\\"0\\\" data-opacity=\\\"100\\\" data-x=\\\"50\\\" data-y=\\\"50\\\" data-alt=\\\"\\\" data-title=\\\"\\\"><picture class=\\\"skip-lazy\\\" data-skip-lazy=\\\"1\\\"><img src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/2025\\/09\\/Bulle-temoignage-large.png\\\" alt=\\\"\\\" title=\\\"\\\" loading=\\\"lazy\\\" class=\\\"skip-lazy\\\" data-skip-lazy=\\\"1\\\"><\\/picture><\\/div><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"3\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div class=\\\"n2-ss-slide-background-image\\\" data-blur=\\\"0\\\" data-opacity=\\\"100\\\" data-x=\\\"50\\\" data-y=\\\"50\\\" data-alt=\\\"\\\" data-title=\\\"\\\"><picture class=\\\"skip-lazy\\\" data-skip-lazy=\\\"1\\\"><img src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/2025\\/09\\/Bulle-temoignage-large.png\\\" alt=\\\"\\\" title=\\\"\\\" loading=\\\"lazy\\\" class=\\\"skip-lazy\\\" data-skip-lazy=\\\"1\\\"><\\/picture><\\/div><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"4\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div class=\\\"n2-ss-slide-background-image\\\" data-blur=\\\"0\\\" data-opacity=\\\"100\\\" data-x=\\\"50\\\" data-y=\\\"50\\\" data-alt=\\\"\\\" data-title=\\\"\\\"><picture class=\\\"skip-lazy\\\" data-skip-lazy=\\\"1\\\"><img src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/2025\\/09\\/Bulle-temoignage-large.png\\\" alt=\\\"\\\" title=\\\"\\\" loading=\\\"lazy\\\" class=\\\"skip-lazy\\\" data-skip-lazy=\\\"1\\\"><\\/picture><\\/div><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"5\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div class=\\\"n2-ss-slide-background-image\\\" data-blur=\\\"0\\\" data-opacity=\\\"100\\\" data-x=\\\"50\\\" data-y=\\\"50\\\" data-alt=\\\"\\\" data-title=\\\"\\\"><picture class=\\\"skip-lazy\\\" data-skip-lazy=\\\"1\\\"><img src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/2025\\/09\\/Bulle-temoignage-large.png\\\" alt=\\\"\\\" title=\\\"\\\" loading=\\\"lazy\\\" class=\\\"skip-lazy\\\" data-skip-lazy=\\\"1\\\"><\\/picture><\\/div><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"6\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div class=\\\"n2-ss-slide-background-image\\\" data-blur=\\\"0\\\" data-opacity=\\\"100\\\" data-x=\\\"50\\\" data-y=\\\"50\\\" data-alt=\\\"\\\" data-title=\\\"\\\"><picture class=\\\"skip-lazy\\\" data-skip-lazy=\\\"1\\\"><img src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/2025\\/09\\/Bulle-temoignage-large.png\\\" alt=\\\"\\\" title=\\\"\\\" loading=\\\"lazy\\\" class=\\\"skip-lazy\\\" data-skip-lazy=\\\"1\\\"><\\/picture><\\/div><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><div class=\\\"n2-ss-slide-background\\\" data-public-id=\\\"7\\\" data-mode=\\\"fill\\\" aria-hidden=\\\"true\\\"><div class=\\\"n2-ss-slide-background-image\\\" data-blur=\\\"0\\\" data-opacity=\\\"100\\\" data-x=\\\"50\\\" data-y=\\\"50\\\" data-alt=\\\"\\\" data-title=\\\"\\\"><picture class=\\\"skip-lazy\\\" data-skip-lazy=\\\"1\\\"><img src=\\\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/2025\\/09\\/Bulle-temoignage-large.png\\\" alt=\\\"\\\" title=\\\"\\\" loading=\\\"lazy\\\" class=\\\"skip-lazy\\\" data-skip-lazy=\\\"1\\\"><\\/picture><\\/div><div data-color=\\\"RGBA(255,255,255,0)\\\" style=\\\"background-color: RGBA(255,255,255,0);\\\" class=\\\"n2-ss-slide-background-color\\\"><\\/div><\\/div><\\/div>                    <div class=\\\"n2-ss-slider-4 n2-ow\\\">\\n                        <svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 1200 480\\\" data-related-device=\\\"desktopPortrait\\\" class=\\\"n2-ow n2-ss-preserve-size n2-ss-preserve-size--slider n2-ss-slide-limiter\\\"><\\/svg><div data-first=\\\"1\\\" data-slide-duration=\\\"0\\\" data-id=\\\"6\\\" data-slide-public-id=\\\"1\\\" data-title=\\\"Abonn\\u00e9e B\\u00f4Watts\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-6\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">Abonn\\u00e9e B\\u00f4Watts<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-TUL7hXMlmFK0\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-nKRCIy02H7yj\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-nKRCIy02H7yj-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-xoojVSI0adbV\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-xoojVSI0adbV-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-18884cca7b173\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-18884cca7b173-inner\\\"><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-516GNNX1WKjW\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-516GNNX1WKjW-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-0msWP5c3A1G1\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-dad50b8a2b6270960678cdc5b68e144f-paragraph   \\\">\\u00ab Le nrLINK, c\'est super pour se rendre compte de sa consommation. Cet hiver, nous avons fait une raclette entre amis et quand j\'ai vu la consommation instantan\\u00e9e alors que tout le monde avait termin\\u00e9 de manger, nous avons vite d\\u00e9branch\\u00e9 les appareils ! \\u00bb<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-1jiNZ8Z1nVhQ\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-2item2\\\" class=\\\"n2-font-2e9ef9dd17faf2972f5d9899fcf89f7a-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-fcrJcVFl69yu\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-2item3\\\" class=\\\"n2-font-381b76738aa0c646945dd4063a97277c-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">Abonn\\u00e9e B\\u00f4Watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-nej3pCS1iYGe\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-2item4\\\" class=\\\"n2-font-9d2efb481e52329af3ce476067fef4f9-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-NjMLgRyjDRS0\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">Propos recueillis devant l\'\\u00e9cole Dumoulin \\u00e0 Belleville le 9\\/06\\/2025<\\/p>\\n<\\/div><\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-18bb74596be36\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-18bb74596be36-inner\\\"><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"9\\\" data-slide-public-id=\\\"2\\\" aria-hidden=\\\"true\\\" data-title=\\\"R\\u00e9mi\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-9\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">R\\u00e9mi<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-meZ647OfuRU4\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-qu0xE6cYInXL\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-qu0xE6cYInXL-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-tOzfrgJ0YGit\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-tOzfrgJ0YGit-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-2nSst61EjB08\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-2nSst61EjB08-inner\\\"><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-4TkuKmXTMz1R\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-4TkuKmXTMz1R-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-GKFdrGFZsAP4\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-dad50b8a2b6270960678cdc5b68e144f-paragraph   \\\">\\u00ab Tr\\u00e8s heureux d\\u2019apprendre que ce projet commence \\u00e0 porter ses fruits. Avec cette annonce d\\u2019une baisse  de 10% sur la facture, clairement je ne regrette pas de faire partie de ce mouvement depuis le d\\u00e9but ! \\u00bb<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-R0o7SXBFmX3h\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-2item7\\\" class=\\\"n2-font-2e9ef9dd17faf2972f5d9899fcf89f7a-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-lmSBM12Et3es\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-2item8\\\" class=\\\"n2-font-381b76738aa0c646945dd4063a97277c-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">REMI \\u00e0 Saint-Georges-De-Reneins<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-n4TUsL7tNxAC\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-2item9\\\" class=\\\"n2-font-9d2efb481e52329af3ce476067fef4f9-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-haZ5cqwwax3m\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">adh\\u00e9rent B\\u00f4Watts depuis 20 mai 2023<\\/p>\\n<\\/div><\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-EfoewzNOJSA9\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-EfoewzNOJSA9-inner\\\"><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"10\\\" data-slide-public-id=\\\"3\\\" aria-hidden=\\\"true\\\" data-title=\\\"Patrick\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-10\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">Patrick<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-jqKC4ezJMIFQ\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-PGRWiY3TcL45\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-PGRWiY3TcL45-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-c2hKyvbaHtQi\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-c2hKyvbaHtQi-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-CxZQeHNSOHFF\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-CxZQeHNSOHFF-inner\\\"><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-1LPrIH3eRRTY\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-1LPrIH3eRRTY-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-JHrnHSx9mDBC\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-dad50b8a2b6270960678cdc5b68e144f-paragraph   \\\">\\u201cCet objet nous permet de prendre conscience de la consommation que l\\u2019on a et de faire attention, explique Patrick. Au d\\u00e9but, je trouvais \\u00e7a un peu gadget et finalement, on se prend tr\\u00e8s vite au jeu.\\u201d<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-Vj2iZyhb90BM\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-2item12\\\" class=\\\"n2-font-2e9ef9dd17faf2972f5d9899fcf89f7a-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-6hCAxmPrcZpl\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-2item13\\\" class=\\\"n2-font-381b76738aa0c646945dd4063a97277c-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">PATRICK<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-k4TVueiCYUi0\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-2item14\\\" class=\\\"n2-font-9d2efb481e52329af3ce476067fef4f9-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-RmmPyFjrMw5A\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">adh\\u00e9rent B\\u00f4Watts, utilisateur de nrLINK<br \\/>\\nFrance 3 RA<\\/p>\\n<\\/div><\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-Xo71dHLeOzf5\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-Xo71dHLeOzf5-inner\\\"><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"11\\\" data-slide-public-id=\\\"4\\\" aria-hidden=\\\"true\\\" data-title=\\\"Jacky Menichon\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-11\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">Jacky Menichon<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-WfqyA8mB1pZV\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-QcGCrwbbrXwf\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-QcGCrwbbrXwf-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-tF2d5GqZNoBN\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-tF2d5GqZNoBN-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-C61UVW5jq2Ad\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-C61UVW5jq2Ad-inner\\\"><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-X1X9OcwJV1cn\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-X1X9OcwJV1cn-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-ZAydCK6u20IZ\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-dad50b8a2b6270960678cdc5b68e144f-paragraph   \\\">\\u201cPour le consommateur, c\\u2019est la promesse d\\u2019un gain de 10 \\u00e0 20% sur la facture d\\u2019\\u00e9lectricit\\u00e9, anticipe Jacky Menichon, qui esp\\u00e8re convaincre assez rapidement 2000 familles et entreprises.\\u201d<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-GKwbLUjvkkaI\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-2item17\\\" class=\\\"n2-font-2e9ef9dd17faf2972f5d9899fcf89f7a-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-ghNUPRAx4d4I\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-2item18\\\" class=\\\"n2-font-381b76738aa0c646945dd4063a97277c-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">JACKY MENICHON<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-AwRn8trMR0gz\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-2item19\\\" class=\\\"n2-font-9d2efb481e52329af3ce476067fef4f9-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-xLu2KLsXcETE\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">Pr\\u00e9sident de la CCSB, Maire de Lanci\\u00e9<br \\/>\\nLes Echos.fr 1er juin 2023<\\/p>\\n<\\/div><\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-sbSKE1h5VfEB\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-sbSKE1h5VfEB-inner\\\"><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"12\\\" data-slide-public-id=\\\"5\\\" aria-hidden=\\\"true\\\" data-title=\\\"Fr\\u00e9d\\u00e9ric Pronch\\u00e9ry\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-12\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">Fr\\u00e9d\\u00e9ric Pronch\\u00e9ry<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-xdcb7XKGXt84\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-DZOUySzp5w5Y\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-DZOUySzp5w5Y-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-iNlf5ZMnmtHh\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-iNlf5ZMnmtHh-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-Dj1houCE1WtJ\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-Dj1houCE1WtJ-inner\\\"><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-OtEYoDQKptE7\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-OtEYoDQKptE7-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-g9CXb4EOKV0e\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-dad50b8a2b6270960678cdc5b68e144f-paragraph   \\\">\\u201cOn a bien vu \\u00e0 travers les \\u00e9v\\u00e8nements g\\u00e9opolitiques, cette derni\\u00e8re crise de l\\u2019\\u00e9nergie, on la subit totalement et \\u00e7a c\\u2019est pas supportable. Il faut que les collectivit\\u00e9s locales offrent d\\u2019autres solutions aux administr\\u00e9s.\\u201d<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-0MIic8ur7h7F\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-2item22\\\" class=\\\"n2-font-2e9ef9dd17faf2972f5d9899fcf89f7a-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-mzqHXjRbgmzx\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-2item23\\\" class=\\\"n2-font-381b76738aa0c646945dd4063a97277c-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">FR\\u00c9D\\u00c9RIC PRONCH\\u00c9RY<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-2uUYTyQREQNJ\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-2item24\\\" class=\\\"n2-font-9d2efb481e52329af3ce476067fef4f9-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-wMwUzBrA3D0d\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">Maire de Belleville-en-Beaujolais, Vice-pr\\u00e9sident de la CCSB<br \\/>\\nM6<\\/p>\\n<\\/div><\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-3FiM9XP6Wz8I\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-3FiM9XP6Wz8I-inner\\\"><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"13\\\" data-slide-public-id=\\\"6\\\" aria-hidden=\\\"true\\\" data-title=\\\"Laura Steen\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-13\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">Laura Steen<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-QBz0tGwFAOt4\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-nzqhItQFNjj7\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-nzqhItQFNjj7-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-EA9CBkBvFAh4\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-EA9CBkBvFAh4-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-1YWfEGrpoLAX\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-1YWfEGrpoLAX-inner\\\"><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-hH2nXCxlJ3Y0\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-hH2nXCxlJ3Y0-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-kourHcf3ca86\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-dad50b8a2b6270960678cdc5b68e144f-paragraph   \\\">\\u201cUn capteur intelligent pour r\\u00e9duire ses consommations d\\u2019\\u00e9nergie.\\u201d<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-cIX6Ng0IZLEW\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-2item27\\\" class=\\\"n2-font-2e9ef9dd17faf2972f5d9899fcf89f7a-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-vOiZ8JiNqqU5\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-2item28\\\" class=\\\"n2-font-381b76738aa0c646945dd4063a97277c-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">LAURA STEEN<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-y2kclte5Q7oD\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-2item29\\\" class=\\\"n2-font-9d2efb481e52329af3ce476067fef4f9-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-P9qqV4bFq6pt\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">Journaliste au Progr\\u00e8s<\\/p>\\n<\\/div><\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-tvZ0rZOWgupd\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-tvZ0rZOWgupd-inner\\\"><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><div data-slide-duration=\\\"0\\\" data-id=\\\"14\\\" data-slide-public-id=\\\"7\\\" aria-hidden=\\\"true\\\" data-title=\\\"Claire Aicardi\\\" class=\\\"n2-ss-slide n2-ow  n2-ss-slide-14\\\"><div role=\\\"note\\\" class=\\\"n2-ss-slide--focus\\\" tabindex=\\\"-1\\\">Claire Aicardi<\\/div><div class=\\\"n2-ss-layers-container n2-ss-slide-limiter n2-ow\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-tWvRxo0D3NcU\\\" data-sstype=\\\"slide\\\" data-pm=\\\"default\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-TYz0krkQcdIg\\\" data-pm=\\\"default\\\" data-sstype=\\\"content\\\" data-hasbackground=\\\"0\\\"><div class=\\\"n2-ss-section-main-content n2-ss-layer-with-background n2-ss-layer-content n2-ow n-uc-TYz0krkQcdIg-inner\\\"><div class=\\\"n2-ss-layer n2-ow n2-ss-layer--block n2-ss-has-self-align n-uc-lUiAy9EkOJGy\\\" data-pm=\\\"normal\\\" data-sstype=\\\"row\\\"><div class=\\\"n2-ss-layer-row n2-ss-layer-with-background n-uc-lUiAy9EkOJGy-inner\\\"><div class=\\\"n2-ss-layer-row-inner \\\"><div class=\\\"n2-ss-layer n2-ow n-uc-VDwb0SIWwYwC\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-VDwb0SIWwYwC-inner\\\"><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-0Tkd5Z4faFYa\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-0Tkd5Z4faFYa-inner\\\"><div class=\\\"n2-ss-layer n2-ow n-uc-MpUbyIr8BO0O\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-dad50b8a2b6270960678cdc5b68e144f-paragraph   \\\">\\u201cAu Royaume-Uni, 9 millions de foyers sont d\\u00e9j\\u00e0 \\u00e9quip\\u00e9s. En France 10 000 capteurs ont \\u00e9t\\u00e9 install\\u00e9s \\u00e0 ce jour. MyEM travaille avec des fournisseurs et nrLINK devrait notamment b\\u00e9n\\u00e9ficier aux clients en situation de pr\\u00e9carit\\u00e9.\\u201d<\\/p>\\n<\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-GlD5k25tfduP\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-2item32\\\" class=\\\"n2-font-2e9ef9dd17faf2972f5d9899fcf89f7a-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-23RMv2MvPmeU\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-2item33\\\" class=\\\"n2-font-381b76738aa0c646945dd4063a97277c-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">CLAIRE AICARDI<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-srGVogr5D5zO\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div id=\\\"n2-ss-2item34\\\" class=\\\"n2-font-9d2efb481e52329af3ce476067fef4f9-hover   n2-ss-item-content n2-ss-text n2-ow\\\" style=\\\"display:block;\\\">B\\u00f4watts<\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-mJfnEzCiUSR8\\\" data-pm=\\\"normal\\\" data-sstype=\\\"layer\\\"><div class=\\\"n2-ss-item-content n2-ss-text n2-ow-all\\\"><div class=\\\"\\\"><p class=\\\"n2-font-d6aeaf43397239de015a2431922a57ce-paragraph   \\\">Europ\'Energies<\\/p>\\n<\\/div><\\/div><\\/div><\\/div><\\/div><div class=\\\"n2-ss-layer n2-ow n-uc-XoZdal5bHZ4X\\\" data-pm=\\\"default\\\" data-sstype=\\\"col\\\"><div class=\\\"n2-ss-layer-col n2-ss-layer-with-background n2-ss-layer-content n-uc-XoZdal5bHZ4X-inner\\\"><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div>                    <\\/div>\\n\\n                                    <\\/div>\\n            <\\/div>\\n        <\\/div>\\n        <div class=\\\"n2-ss-slider-controls n2-ss-slider-controls-absolute-left-center\\\"><div style=\\\"--widget-offset:15px;\\\" class=\\\"n2-ss-widget n2-style-6679a19c901d61fb802720533bbad114-heading nextend-arrow n2-ow-all nextend-arrow-previous  nextend-arrow-animated-fade\\\" data-hide-mobileportrait=\\\"1\\\" id=\\\"n2-ss-2-arrow-previous\\\" role=\\\"button\\\" aria-label=\\\"previous arrow\\\" tabindex=\\\"0\\\"><img width=\\\"32\\\" height=\\\"32\\\" class=\\\"skip-lazy\\\" data-skip-lazy=\\\"1\\\" src=\\\"data:image\\/svg+xml;base64,PHN2ZyB3aWR0aD0iMzIiIGhlaWdodD0iMzIiIHZpZXdCb3g9IjAgMCAzMiAzMiIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KICAgIDxwYXRoIGQ9Ik0yMS41OCAyMy41OGwtNy45NjItNy41ODMgNy44Ni03LjQ4NWMuMzItLjI2Mi41MjItLjY1LjUyMi0xLjA4M0MyMiA2LjY0IDIxLjMyOCA2IDIwLjUgNmMtLjQwMyAwLS43NjguMTUtMS4wMzguMzk4bC0uMDA0LS4wMDQtOSA4LjU3di4wMDJjLS4yODIuMjYtLjQ1OC42MjQtLjQ1OCAxLjAyOFYxNmMwIC40MDQuMTc2Ljc3LjQ2IDEuMDNoLS4wMDJsOSA4LjU3Yy4yNy4yNDcuNjM4LjQgMS4wNDIuNC44MyAwIDEuNS0uNjQgMS41LTEuNDMgMC0uMzg0LS4xNi0uNzMzLS40Mi0uOTl6IgogICAgICAgICAgZmlsbD0iIzFiMjEyNyIgb3BhY2l0eT0iMC4zNSIgZmlsbC1ydWxlPSJldmVub2RkIi8+Cjwvc3ZnPg==\\\" alt=\\\"previous arrow\\\"><\\/div><\\/div><div class=\\\"n2-ss-slider-controls n2-ss-slider-controls-absolute-right-center\\\"><div style=\\\"--widget-offset:15px;\\\" class=\\\"n2-ss-widget n2-style-6679a19c901d61fb802720533bbad114-heading nextend-arrow n2-ow-all nextend-arrow-next  nextend-arrow-animated-fade\\\" data-hide-mobileportrait=\\\"1\\\" id=\\\"n2-ss-2-arrow-next\\\" role=\\\"button\\\" aria-label=\\\"next arrow\\\" tabindex=\\\"0\\\"><img width=\\\"32\\\" height=\\\"32\\\" class=\\\"skip-lazy\\\" data-skip-lazy=\\\"1\\\" src=\\\"data:image\\/svg+xml;base64,PHN2ZyB3aWR0aD0iMzIiIGhlaWdodD0iMzIiIHZpZXdCb3g9IjAgMCAzMiAzMiIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KICAgIDxwYXRoIGQ9Ik0yMiAxNS45OTd2LS4wMDNjMC0uNDA0LS4xNzYtLjc2OC0uNDYtMS4wMjhoLjAwMmwtOS04LjU3Mi0uMDA0LjAwNEMxMi4yNjggNi4xNSAxMS45MDIgNiAxMS41IDZjLS44MyAwLTEuNS42NC0xLjUgMS40MyAwIC40MzIuMjAzLjgyLjUyMyAxLjA4Mmw3Ljg2IDcuNDg1LTcuOTYzIDcuNTgzYy0uMjYuMjU3LS40Mi42MDYtLjQyLjk5IDAgLjc5LjY3IDEuNDMgMS41IDEuNDMuNDA0IDAgLjc3LS4xNTMgMS4wNC0uNGw5LjAwMi04LjU3di0uMDAyYy4yODItLjI2LjQ1OC0uNjI0LjQ1OC0xLjAyOHYtLjAwM3oiCiAgICAgICAgICBmaWxsPSIjMWIyMTI3IiBvcGFjaXR5PSIwLjM1IiBmaWxsLXJ1bGU9ImV2ZW5vZGQiLz4KPC9zdmc+\\\" alt=\\\"next arrow\\\"><\\/div><\\/div><div class=\\\"n2-ss-slider-controls n2-ss-slider-controls-absolute-center-bottom\\\"><div style=\\\"--widget-offset:10px;\\\" class=\\\"n2-ss-widget n2-ss-control-bullet n2-ow-all n2-ss-control-bullet-horizontal\\\"><div class=\\\"n2-style-89e6829493f6425211df0e3f6998e151-simple  nextend-bullet-bar n2-bar-justify-content-center\\\" role=\\\"group\\\" aria-label=\\\"Choose slide to display.\\\"><div class=\\\"n2-bullet n2-style-740810c64ca26d6de5660a795a1e1c7e-dot \\\" style=\\\"visibility:hidden;\\\"><\\/div><\\/div><\\/div><\\/div><\\/div><\\/div><ss3-loader><\\/ss3-loader><\\/div><\\/div><div class=\\\"n2_clear\\\"><\\/div><\\/div>\",\"assets\":{\"css\":{\"staticGroupPreload\":{\"smartslider\":\"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/smart-slider-3\\/Public\\/SmartSlider3\\/Application\\/Frontend\\/Assets\\/dist\\/smartslider.min.css\"},\"staticGroup\":[],\"files\":[],\"urls\":[],\"codes\":[],\"firstCodes\":[],\"inline\":{\"n2-ss-2\":\"div#n2-ss-2 .n2-ss-slider-1{display:grid;position:relative;}div#n2-ss-2 .n2-ss-slider-2{display:grid;position:relative;overflow:hidden;padding:0px 0px 0px 0px;border:0px solid RGBA(62,62,62,1);border-radius:0px;background-clip:padding-box;background-repeat:repeat;background-position:50% 50%;background-size:cover;background-attachment:scroll;z-index:1;}div#n2-ss-2:not(.n2-ss-loaded) .n2-ss-slider-2{background-image:none !important;}div#n2-ss-2 .n2-ss-slider-3{display:grid;grid-template-areas:\'cover\';position:relative;overflow:hidden;z-index:10;}div#n2-ss-2 .n2-ss-slider-3 > *{grid-area:cover;}div#n2-ss-2 .n2-ss-slide-backgrounds,div#n2-ss-2 .n2-ss-slider-3 > .n2-ss-divider{position:relative;}div#n2-ss-2 .n2-ss-slide-backgrounds{z-index:10;}div#n2-ss-2 .n2-ss-slide-backgrounds > *{overflow:hidden;}div#n2-ss-2 .n2-ss-slide-background{transform:translateX(-100000px);}div#n2-ss-2 .n2-ss-slider-4{place-self:center;position:relative;width:100%;height:100%;z-index:20;display:grid;grid-template-areas:\'slide\';}div#n2-ss-2 .n2-ss-slider-4 > *{grid-area:slide;}div#n2-ss-2.n2-ss-full-page--constrain-ratio .n2-ss-slider-4{height:auto;}div#n2-ss-2 .n2-ss-slide{display:grid;place-items:center;grid-auto-columns:100%;position:relative;z-index:20;-webkit-backface-visibility:hidden;transform:translateX(-100000px);}div#n2-ss-2 .n2-ss-slide{perspective:1500px;}div#n2-ss-2 .n2-ss-slide-active{z-index:21;}.n2-ss-background-animation{position:absolute;top:0;left:0;width:100%;height:100%;z-index:3;}div#n2-ss-2 .nextend-arrow{cursor:pointer;overflow:hidden;line-height:0 !important;z-index:18;-webkit-user-select:none;}div#n2-ss-2 .nextend-arrow img{position:relative;display:block;}div#n2-ss-2 .nextend-arrow img.n2-arrow-hover-img{display:none;}div#n2-ss-2 .nextend-arrow:FOCUS img.n2-arrow-hover-img,div#n2-ss-2 .nextend-arrow:HOVER img.n2-arrow-hover-img{display:inline;}div#n2-ss-2 .nextend-arrow:FOCUS img.n2-arrow-normal-img,div#n2-ss-2 .nextend-arrow:HOVER img.n2-arrow-normal-img{display:none;}div#n2-ss-2 .nextend-arrow-animated{overflow:hidden;}div#n2-ss-2 .nextend-arrow-animated > div{position:relative;}div#n2-ss-2 .nextend-arrow-animated .n2-active{position:absolute;}div#n2-ss-2 .nextend-arrow-animated-fade{transition:background 0.3s, opacity 0.4s;}div#n2-ss-2 .nextend-arrow-animated-horizontal > div{transition:all 0.4s;transform:none;}div#n2-ss-2 .nextend-arrow-animated-horizontal .n2-active{top:0;}div#n2-ss-2 .nextend-arrow-previous.nextend-arrow-animated-horizontal .n2-active{left:100%;}div#n2-ss-2 .nextend-arrow-next.nextend-arrow-animated-horizontal .n2-active{right:100%;}div#n2-ss-2 .nextend-arrow-previous.nextend-arrow-animated-horizontal:HOVER > div,div#n2-ss-2 .nextend-arrow-previous.nextend-arrow-animated-horizontal:FOCUS > div{transform:translateX(-100%);}div#n2-ss-2 .nextend-arrow-next.nextend-arrow-animated-horizontal:HOVER > div,div#n2-ss-2 .nextend-arrow-next.nextend-arrow-animated-horizontal:FOCUS > div{transform:translateX(100%);}div#n2-ss-2 .nextend-arrow-animated-vertical > div{transition:all 0.4s;transform:none;}div#n2-ss-2 .nextend-arrow-animated-vertical .n2-active{left:0;}div#n2-ss-2 .nextend-arrow-previous.nextend-arrow-animated-vertical .n2-active{top:100%;}div#n2-ss-2 .nextend-arrow-next.nextend-arrow-animated-vertical .n2-active{bottom:100%;}div#n2-ss-2 .nextend-arrow-previous.nextend-arrow-animated-vertical:HOVER > div,div#n2-ss-2 .nextend-arrow-previous.nextend-arrow-animated-vertical:FOCUS > div{transform:translateY(-100%);}div#n2-ss-2 .nextend-arrow-next.nextend-arrow-animated-vertical:HOVER > div,div#n2-ss-2 .nextend-arrow-next.nextend-arrow-animated-vertical:FOCUS > div{transform:translateY(100%);}div#n2-ss-2 .n2-ss-control-bullet{visibility:hidden;text-align:center;justify-content:center;z-index:14;}div#n2-ss-2 .n2-ss-control-bullet--calculate-size{left:0 !important;}div#n2-ss-2 .n2-ss-control-bullet-horizontal.n2-ss-control-bullet-fullsize{width:100%;}div#n2-ss-2 .n2-ss-control-bullet-vertical.n2-ss-control-bullet-fullsize{height:100%;flex-flow:column;}div#n2-ss-2 .nextend-bullet-bar{display:inline-flex;vertical-align:top;visibility:visible;align-items:center;flex-wrap:wrap;}div#n2-ss-2 .n2-bar-justify-content-left{justify-content:flex-start;}div#n2-ss-2 .n2-bar-justify-content-center{justify-content:center;}div#n2-ss-2 .n2-bar-justify-content-right{justify-content:flex-end;}div#n2-ss-2 .n2-ss-control-bullet-vertical > .nextend-bullet-bar{flex-flow:column;}div#n2-ss-2 .n2-ss-control-bullet-fullsize > .nextend-bullet-bar{display:flex;}div#n2-ss-2 .n2-ss-control-bullet-horizontal.n2-ss-control-bullet-fullsize > .nextend-bullet-bar{flex:1 1 auto;}div#n2-ss-2 .n2-ss-control-bullet-vertical.n2-ss-control-bullet-fullsize > .nextend-bullet-bar{height:100%;}div#n2-ss-2 .nextend-bullet-bar .n2-bullet{cursor:pointer;transition:background-color 0.4s;}div#n2-ss-2 .nextend-bullet-bar .n2-bullet.n2-active{cursor:default;}div#n2-ss-2 div.n2-ss-bullet-thumbnail-container{position:absolute;z-index:10000000;}div#n2-ss-2 .n2-ss-bullet-thumbnail-container .n2-ss-bullet-thumbnail{background-size:cover;background-repeat:no-repeat;background-position:center;}div#n2-ss-2 .n-uc-xoojVSI0adbV-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-2 .n-uc-xoojVSI0adbV-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-18884cca7b173-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-18884cca7b173-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-516GNNX1WKjW-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-516GNNX1WKjW-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n2-font-dad50b8a2b6270960678cdc5b68e144f-paragraph{font-family: \'Roboto\',\'Arial\';color: #000000;font-size:131.25%;text-shadow: none;line-height: 1.2;font-weight: normal;font-style: normal;text-decoration: none;text-align: left;letter-spacing: normal;word-spacing: normal;text-transform: none;font-weight: 400;}div#n2-ss-2 .n2-font-dad50b8a2b6270960678cdc5b68e144f-paragraph a, div#n2-ss-2 .n2-font-dad50b8a2b6270960678cdc5b68e144f-paragraph a:FOCUS{font-family: \'Roboto\',\'Arial\';color: #1890d7;font-size:100%;text-shadow: none;line-height: 1.2;font-weight: normal;font-style: normal;text-decoration: none;text-align: left;letter-spacing: normal;word-spacing: normal;text-transform: none;font-weight: 400;}div#n2-ss-2 .n2-font-dad50b8a2b6270960678cdc5b68e144f-paragraph a:HOVER, div#n2-ss-2 .n2-font-dad50b8a2b6270960678cdc5b68e144f-paragraph a:ACTIVE{font-family: \'Roboto\',\'Arial\';color: #1890d7;font-size:100%;text-shadow: none;line-height: 1.2;font-weight: normal;font-style: normal;text-decoration: none;text-align: left;letter-spacing: normal;word-spacing: normal;text-transform: none;font-weight: 400;}div#n2-ss-2 .n2-font-2e9ef9dd17faf2972f5d9899fcf89f7a-hover{font-family: \'Arial\';color: RGBA(255,255,255,0);font-size:93.75%;text-shadow: none;line-height: 1.5;font-weight: normal;font-style: normal;text-decoration: none;text-align: left;letter-spacing: normal;word-spacing: normal;text-transform: none;font-weight: 800;}div#n2-ss-2 .n2-font-381b76738aa0c646945dd4063a97277c-hover{font-family: \'Arial\';color: RGBA(0,0,0,0.5);font-size:125%;text-shadow: none;line-height: 1;font-weight: normal;font-style: normal;text-decoration: none;text-align: left;letter-spacing: normal;word-spacing: normal;text-transform: none;font-weight: 800;}div#n2-ss-2 .n2-font-9d2efb481e52329af3ce476067fef4f9-hover{font-family: \'Arial\';color: RGBA(255,255,255,0);font-size:31.25%;text-shadow: none;line-height: 1.5;font-weight: normal;font-style: normal;text-decoration: none;text-align: left;letter-spacing: normal;word-spacing: normal;text-transform: none;font-weight: 800;}div#n2-ss-2 .n2-font-d6aeaf43397239de015a2431922a57ce-paragraph{font-family: \'Roboto\',\'Arial\';color: #000000;font-size:100%;text-shadow: none;line-height: 1.5;font-weight: normal;font-style: normal;text-decoration: none;text-align: left;letter-spacing: normal;word-spacing: normal;text-transform: none;font-weight: 400;}div#n2-ss-2 .n2-font-d6aeaf43397239de015a2431922a57ce-paragraph a, div#n2-ss-2 .n2-font-d6aeaf43397239de015a2431922a57ce-paragraph a:FOCUS{font-family: \'Roboto\',\'Arial\';color: #1890d7;font-size:100%;text-shadow: none;line-height: 1.5;font-weight: normal;font-style: normal;text-decoration: none;text-align: left;letter-spacing: normal;word-spacing: normal;text-transform: none;font-weight: 400;}div#n2-ss-2 .n2-font-d6aeaf43397239de015a2431922a57ce-paragraph a:HOVER, div#n2-ss-2 .n2-font-d6aeaf43397239de015a2431922a57ce-paragraph a:ACTIVE{font-family: \'Roboto\',\'Arial\';color: #1890d7;font-size:100%;text-shadow: none;line-height: 1.5;font-weight: normal;font-style: normal;text-decoration: none;text-align: left;letter-spacing: normal;word-spacing: normal;text-transform: none;font-weight: 400;}div#n2-ss-2 .n-uc-18bb74596be36-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-18bb74596be36-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-tOzfrgJ0YGit-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-2 .n-uc-tOzfrgJ0YGit-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-2nSst61EjB08-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-2nSst61EjB08-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-4TkuKmXTMz1R-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-4TkuKmXTMz1R-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-EfoewzNOJSA9-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-EfoewzNOJSA9-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-c2hKyvbaHtQi-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-2 .n-uc-c2hKyvbaHtQi-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-CxZQeHNSOHFF-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-CxZQeHNSOHFF-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-1LPrIH3eRRTY-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-1LPrIH3eRRTY-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-Xo71dHLeOzf5-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-Xo71dHLeOzf5-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-tF2d5GqZNoBN-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-2 .n-uc-tF2d5GqZNoBN-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-C61UVW5jq2Ad-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-C61UVW5jq2Ad-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-X1X9OcwJV1cn-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-X1X9OcwJV1cn-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-sbSKE1h5VfEB-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-sbSKE1h5VfEB-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-iNlf5ZMnmtHh-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-2 .n-uc-iNlf5ZMnmtHh-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-Dj1houCE1WtJ-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-Dj1houCE1WtJ-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-OtEYoDQKptE7-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-OtEYoDQKptE7-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-3FiM9XP6Wz8I-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-3FiM9XP6Wz8I-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-EA9CBkBvFAh4-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-2 .n-uc-EA9CBkBvFAh4-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-1YWfEGrpoLAX-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-1YWfEGrpoLAX-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-hH2nXCxlJ3Y0-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-hH2nXCxlJ3Y0-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-tvZ0rZOWgupd-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-tvZ0rZOWgupd-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-lUiAy9EkOJGy-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);border-radius:25px;}div#n2-ss-2 .n-uc-lUiAy9EkOJGy-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-VDwb0SIWwYwC-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-VDwb0SIWwYwC-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-0Tkd5Z4faFYa-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-0Tkd5Z4faFYa-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-XoZdal5bHZ4X-inner{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n-uc-XoZdal5bHZ4X-inner:HOVER{border-width:0px 0px 0px 0px ;border-style:solid;border-color:RGBA(255,255,255,1);}div#n2-ss-2 .n2-style-6679a19c901d61fb802720533bbad114-heading{background: RGBA(255,255,255,0);opacity:1;padding:0px 0px 0px 0px ;box-shadow: none;border: 0px solid RGBA(0,0,0,1);border-radius:0px;}div#n2-ss-2 .n2-style-740810c64ca26d6de5660a795a1e1c7e-dot{background: RGBA(255,255,255,0);opacity:1;padding:5px 5px 5px 5px ;box-shadow: none;border: 1px solid RGBA(191,231,156,1);border-radius:50px;margin:4px;}div#n2-ss-2 .n2-style-740810c64ca26d6de5660a795a1e1c7e-dot.n2-active, div#n2-ss-2 .n2-style-740810c64ca26d6de5660a795a1e1c7e-dot:HOVER, div#n2-ss-2 .n2-style-740810c64ca26d6de5660a795a1e1c7e-dot:FOCUS{background: #bfe79c;border: 1px solid RGBA(191,231,156,1);}div#n2-ss-2 .n2-style-89e6829493f6425211df0e3f6998e151-simple{background: RGBA(255,255,255,0);opacity:1;padding:0px 0px 0px 0px ;box-shadow: none;border: 0px solid RGBA(0,0,0,1);border-radius:0px;}div#n2-ss-2 .n2-ss-slide-limiter{max-width:1200px;}div#n2-ss-2 .n-uc-TUL7hXMlmFK0{padding:10px 10px 10px 10px}div#n2-ss-2 .n-uc-nKRCIy02H7yj-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-2 .n-uc-nKRCIy02H7yj{align-self:center;}div#n2-ss-2 .n-uc-xoojVSI0adbV-inner{padding:30px 30px 30px 30px}div#n2-ss-2 .n-uc-xoojVSI0adbV-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-2 .n-uc-xoojVSI0adbV-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-2 .n-uc-18884cca7b173-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-2 .n-uc-18884cca7b173{max-width: 90px;width:10.4%}div#n2-ss-2 .n-uc-516GNNX1WKjW-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-2 .n-uc-516GNNX1WKjW{max-width: 875px;width:79.1%}div#n2-ss-2 .n-uc-18bb74596be36-inner{padding:10px 10px 10px 10px;justify-content:center}div#n2-ss-2 .n-uc-18bb74596be36{width:10.4%}div#n2-ss-2 .n-uc-meZ647OfuRU4{padding:10px 10px 10px 10px}div#n2-ss-2 .n-uc-qu0xE6cYInXL-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-2 .n-uc-qu0xE6cYInXL{align-self:center;}div#n2-ss-2 .n-uc-tOzfrgJ0YGit-inner{padding:30px 30px 30px 30px}div#n2-ss-2 .n-uc-tOzfrgJ0YGit-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-2 .n-uc-tOzfrgJ0YGit-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-2 .n-uc-2nSst61EjB08-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-2 .n-uc-2nSst61EjB08{max-width: 90px;width:10.4%}div#n2-ss-2 .n-uc-4TkuKmXTMz1R-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-2 .n-uc-4TkuKmXTMz1R{max-width: 875px;width:79.1%}div#n2-ss-2 .n-uc-EfoewzNOJSA9-inner{padding:10px 10px 10px 10px;justify-content:center}div#n2-ss-2 .n-uc-EfoewzNOJSA9{width:10.4%}div#n2-ss-2 .n-uc-jqKC4ezJMIFQ{padding:10px 10px 10px 10px}div#n2-ss-2 .n-uc-PGRWiY3TcL45-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-2 .n-uc-PGRWiY3TcL45{align-self:center;}div#n2-ss-2 .n-uc-c2hKyvbaHtQi-inner{padding:30px 30px 30px 30px}div#n2-ss-2 .n-uc-c2hKyvbaHtQi-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-2 .n-uc-c2hKyvbaHtQi-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-2 .n-uc-CxZQeHNSOHFF-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-2 .n-uc-CxZQeHNSOHFF{max-width: 90px;width:10.4%}div#n2-ss-2 .n-uc-1LPrIH3eRRTY-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-2 .n-uc-1LPrIH3eRRTY{max-width: 875px;width:79.1%}div#n2-ss-2 .n-uc-Xo71dHLeOzf5-inner{padding:10px 10px 10px 10px;justify-content:center}div#n2-ss-2 .n-uc-Xo71dHLeOzf5{width:10.4%}div#n2-ss-2 .n-uc-WfqyA8mB1pZV{padding:10px 10px 10px 10px}div#n2-ss-2 .n-uc-QcGCrwbbrXwf-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-2 .n-uc-QcGCrwbbrXwf{align-self:center;}div#n2-ss-2 .n-uc-tF2d5GqZNoBN-inner{padding:30px 30px 30px 30px}div#n2-ss-2 .n-uc-tF2d5GqZNoBN-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-2 .n-uc-tF2d5GqZNoBN-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-2 .n-uc-C61UVW5jq2Ad-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-2 .n-uc-C61UVW5jq2Ad{max-width: 90px;width:10.4%}div#n2-ss-2 .n-uc-X1X9OcwJV1cn-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-2 .n-uc-X1X9OcwJV1cn{max-width: 875px;width:79.1%}div#n2-ss-2 .n-uc-sbSKE1h5VfEB-inner{padding:10px 10px 10px 10px;justify-content:center}div#n2-ss-2 .n-uc-sbSKE1h5VfEB{width:10.4%}div#n2-ss-2 .n-uc-xdcb7XKGXt84{padding:10px 10px 10px 10px}div#n2-ss-2 .n-uc-DZOUySzp5w5Y-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-2 .n-uc-DZOUySzp5w5Y{align-self:center;}div#n2-ss-2 .n-uc-iNlf5ZMnmtHh-inner{padding:30px 30px 30px 30px}div#n2-ss-2 .n-uc-iNlf5ZMnmtHh-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-2 .n-uc-iNlf5ZMnmtHh-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-2 .n-uc-Dj1houCE1WtJ-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-2 .n-uc-Dj1houCE1WtJ{max-width: 90px;width:10.4%}div#n2-ss-2 .n-uc-OtEYoDQKptE7-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-2 .n-uc-OtEYoDQKptE7{max-width: 875px;width:79.1%}div#n2-ss-2 .n-uc-3FiM9XP6Wz8I-inner{padding:10px 10px 10px 10px;justify-content:center}div#n2-ss-2 .n-uc-3FiM9XP6Wz8I{width:10.4%}div#n2-ss-2 .n-uc-QBz0tGwFAOt4{padding:10px 10px 10px 10px}div#n2-ss-2 .n-uc-nzqhItQFNjj7-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-2 .n-uc-nzqhItQFNjj7{align-self:center;}div#n2-ss-2 .n-uc-EA9CBkBvFAh4-inner{padding:30px 30px 30px 30px}div#n2-ss-2 .n-uc-EA9CBkBvFAh4-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-2 .n-uc-EA9CBkBvFAh4-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-2 .n-uc-1YWfEGrpoLAX-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-2 .n-uc-1YWfEGrpoLAX{max-width: 90px;width:10.4%}div#n2-ss-2 .n-uc-hH2nXCxlJ3Y0-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-2 .n-uc-hH2nXCxlJ3Y0{max-width: 875px;width:79.1%}div#n2-ss-2 .n-uc-tvZ0rZOWgupd-inner{padding:10px 10px 10px 10px;justify-content:center}div#n2-ss-2 .n-uc-tvZ0rZOWgupd{width:10.4%}div#n2-ss-2 .n-uc-tWvRxo0D3NcU{padding:10px 10px 10px 10px}div#n2-ss-2 .n-uc-TYz0krkQcdIg-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-2 .n-uc-TYz0krkQcdIg{align-self:center;}div#n2-ss-2 .n-uc-lUiAy9EkOJGy-inner{padding:30px 30px 30px 30px}div#n2-ss-2 .n-uc-lUiAy9EkOJGy-inner > .n2-ss-layer-row-inner{width:calc(100% + 21px);margin:-10px;flex-wrap:nowrap;}div#n2-ss-2 .n-uc-lUiAy9EkOJGy-inner > .n2-ss-layer-row-inner > .n2-ss-layer[data-sstype=\\\"col\\\"]{margin:10px}div#n2-ss-2 .n-uc-VDwb0SIWwYwC-inner{padding:10px 10px 10px 10px;text-align:center;--ssselfalign:center;;justify-content:center}div#n2-ss-2 .n-uc-VDwb0SIWwYwC{max-width: 90px;width:10.4%}div#n2-ss-2 .n-uc-0Tkd5Z4faFYa-inner{padding:30px 30px 30px 30px;justify-content:center}div#n2-ss-2 .n-uc-0Tkd5Z4faFYa{max-width: 875px;width:79.1%}div#n2-ss-2 .n-uc-XoZdal5bHZ4X-inner{padding:10px 10px 10px 10px;justify-content:center}div#n2-ss-2 .n-uc-XoZdal5bHZ4X{width:10.4%}div#n2-ss-2 .nextend-arrow img{width: 32px}@media (min-width: 1200px){div#n2-ss-2 [data-hide-desktopportrait=\\\"1\\\"]{display: none !important;}}@media (orientation: landscape) and (max-width: 1199px) and (min-width: 901px),(orientation: portrait) and (max-width: 1199px) and (min-width: 701px){div#n2-ss-2 .n-uc-xoojVSI0adbV-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-2 .n-uc-18884cca7b173{width:10.4%}div#n2-ss-2 .n-uc-516GNNX1WKjW{width:79.1%}div#n2-ss-2 .n-uc-18bb74596be36{width:10.4%}div#n2-ss-2 .n-uc-tOzfrgJ0YGit-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-2 .n-uc-2nSst61EjB08{width:10.4%}div#n2-ss-2 .n-uc-4TkuKmXTMz1R{width:79.1%}div#n2-ss-2 .n-uc-EfoewzNOJSA9{width:10.4%}div#n2-ss-2 .n-uc-c2hKyvbaHtQi-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-2 .n-uc-CxZQeHNSOHFF{width:10.4%}div#n2-ss-2 .n-uc-1LPrIH3eRRTY{width:79.1%}div#n2-ss-2 .n-uc-Xo71dHLeOzf5{width:10.4%}div#n2-ss-2 .n-uc-tF2d5GqZNoBN-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-2 .n-uc-C61UVW5jq2Ad{width:10.4%}div#n2-ss-2 .n-uc-X1X9OcwJV1cn{width:79.1%}div#n2-ss-2 .n-uc-sbSKE1h5VfEB{width:10.4%}div#n2-ss-2 .n-uc-iNlf5ZMnmtHh-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-2 .n-uc-Dj1houCE1WtJ{width:10.4%}div#n2-ss-2 .n-uc-OtEYoDQKptE7{width:79.1%}div#n2-ss-2 .n-uc-3FiM9XP6Wz8I{width:10.4%}div#n2-ss-2 .n-uc-EA9CBkBvFAh4-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-2 .n-uc-1YWfEGrpoLAX{width:10.4%}div#n2-ss-2 .n-uc-hH2nXCxlJ3Y0{width:79.1%}div#n2-ss-2 .n-uc-tvZ0rZOWgupd{width:10.4%}div#n2-ss-2 .n-uc-lUiAy9EkOJGy-inner > .n2-ss-layer-row-inner{flex-wrap:nowrap;}div#n2-ss-2 .n-uc-VDwb0SIWwYwC{width:10.4%}div#n2-ss-2 .n-uc-0Tkd5Z4faFYa{width:79.1%}div#n2-ss-2 .n-uc-XoZdal5bHZ4X{width:10.4%}div#n2-ss-2 [data-hide-tabletportrait=\\\"1\\\"]{display: none !important;}}@media (orientation: landscape) and (max-width: 900px),(orientation: portrait) and (max-width: 700px){div#n2-ss-2 .n-uc-xoojVSI0adbV-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-2 .n-uc-18884cca7b173{width:calc(100% - 20px)}div#n2-ss-2 .n-uc-516GNNX1WKjW{width:calc(100% - 20px)}div#n2-ss-2 .n-uc-18bb74596be36{width:calc(100% - 20px)}div#n2-ss-2 .n-uc-tOzfrgJ0YGit-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-2 .n-uc-2nSst61EjB08{width:calc(100% - 20px)}div#n2-ss-2 .n-uc-4TkuKmXTMz1R{width:calc(100% - 20px)}div#n2-ss-2 .n-uc-EfoewzNOJSA9{width:calc(100% - 20px)}div#n2-ss-2 .n-uc-c2hKyvbaHtQi-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-2 .n-uc-CxZQeHNSOHFF{width:calc(100% - 20px)}div#n2-ss-2 .n-uc-1LPrIH3eRRTY{width:calc(100% - 20px)}div#n2-ss-2 .n-uc-Xo71dHLeOzf5{width:calc(100% - 20px)}div#n2-ss-2 .n-uc-tF2d5GqZNoBN-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-2 .n-uc-C61UVW5jq2Ad{width:calc(100% - 20px)}div#n2-ss-2 .n-uc-X1X9OcwJV1cn{width:calc(100% - 20px)}div#n2-ss-2 .n-uc-sbSKE1h5VfEB{width:calc(100% - 20px)}div#n2-ss-2 .n-uc-iNlf5ZMnmtHh-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-2 .n-uc-Dj1houCE1WtJ{width:calc(100% - 20px)}div#n2-ss-2 .n-uc-OtEYoDQKptE7{width:calc(100% - 20px)}div#n2-ss-2 .n-uc-3FiM9XP6Wz8I{width:calc(100% - 20px)}div#n2-ss-2 .n-uc-EA9CBkBvFAh4-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-2 .n-uc-1YWfEGrpoLAX{width:calc(100% - 20px)}div#n2-ss-2 .n-uc-hH2nXCxlJ3Y0{width:calc(100% - 20px)}div#n2-ss-2 .n-uc-tvZ0rZOWgupd{width:calc(100% - 20px)}div#n2-ss-2 .n-uc-lUiAy9EkOJGy-inner > .n2-ss-layer-row-inner{flex-wrap:wrap;}div#n2-ss-2 .n-uc-VDwb0SIWwYwC{width:calc(100% - 20px)}div#n2-ss-2 .n-uc-0Tkd5Z4faFYa{width:calc(100% - 20px)}div#n2-ss-2 .n-uc-XoZdal5bHZ4X{width:calc(100% - 20px)}div#n2-ss-2 [data-hide-mobileportrait=\\\"1\\\"]{display: none !important;}div#n2-ss-2 .nextend-arrow img{width: 16px}}\"},\"globalInline\":[]},\"less\":{\"staticGroupPreload\":[],\"staticGroup\":[],\"files\":[],\"urls\":[],\"codes\":[],\"firstCodes\":[],\"inline\":[],\"globalInline\":[]},\"js\":{\"staticGroupPreload\":[],\"staticGroup\":{\"smartslider-frontend\":\"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/smart-slider-3\\/Public\\/SmartSlider3\\/Application\\/Frontend\\/Assets\\/dist\\/smartslider-frontend.min.js\",\"ss-simple\":\"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/smart-slider-3\\/Public\\/SmartSlider3\\/Slider\\/SliderType\\/Simple\\/Assets\\/dist\\/ss-simple.min.js\",\"w-arrow-image\":\"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/smart-slider-3\\/Public\\/SmartSlider3\\/Widget\\/Arrow\\/ArrowImage\\/Assets\\/dist\\/w-arrow-image.min.js\",\"w-bullet\":\"\\/home\\/bowattu\\/www\\/wp-content\\/plugins\\/smart-slider-3\\/Public\\/SmartSlider3\\/Widget\\/Bullet\\/Assets\\/dist\\/w-bullet.min.js\"},\"files\":[],\"urls\":[],\"codes\":[],\"firstCodes\":[],\"inline\":[\"_N2.r([\\\"documentReady\\\",\\\"smartslider-frontend\\\",\\\"SmartSliderWidgetArrowImage\\\",\\\"SmartSliderWidgetBulletTransition\\\",\\\"ss-simple\\\"],function(){new _N2.SmartSliderSimple(\'n2-ss-2\', {\\\"admin\\\":false,\\\"background.video.mobile\\\":1,\\\"loadingTime\\\":2000,\\\"alias\\\":{\\\"id\\\":0,\\\"smoothScroll\\\":0,\\\"slideSwitch\\\":0,\\\"scroll\\\":1},\\\"align\\\":\\\"normal\\\",\\\"isDelayed\\\":0,\\\"responsive\\\":{\\\"mediaQueries\\\":{\\\"all\\\":false,\\\"desktopportrait\\\":[\\\"(min-width: 1200px)\\\"],\\\"tabletportrait\\\":[\\\"(orientation: landscape) and (max-width: 1199px) and (min-width: 901px)\\\",\\\"(orientation: portrait) and (max-width: 1199px) and (min-width: 701px)\\\"],\\\"mobileportrait\\\":[\\\"(orientation: landscape) and (max-width: 900px)\\\",\\\"(orientation: portrait) and (max-width: 700px)\\\"]},\\\"base\\\":{\\\"slideOuterWidth\\\":1200,\\\"slideOuterHeight\\\":480,\\\"sliderWidth\\\":1200,\\\"sliderHeight\\\":480,\\\"slideWidth\\\":1200,\\\"slideHeight\\\":480},\\\"hideOn\\\":{\\\"desktopLandscape\\\":false,\\\"desktopPortrait\\\":false,\\\"tabletLandscape\\\":false,\\\"tabletPortrait\\\":false,\\\"mobileLandscape\\\":false,\\\"mobilePortrait\\\":false},\\\"onResizeEnabled\\\":true,\\\"type\\\":\\\"auto\\\",\\\"sliderHeightBasedOn\\\":\\\"real\\\",\\\"focusUser\\\":1,\\\"focusEdge\\\":\\\"auto\\\",\\\"breakpoints\\\":[{\\\"device\\\":\\\"tabletPortrait\\\",\\\"type\\\":\\\"max-screen-width\\\",\\\"portraitWidth\\\":1199,\\\"landscapeWidth\\\":1199},{\\\"device\\\":\\\"mobilePortrait\\\",\\\"type\\\":\\\"max-screen-width\\\",\\\"portraitWidth\\\":700,\\\"landscapeWidth\\\":900}],\\\"enabledDevices\\\":{\\\"desktopLandscape\\\":0,\\\"desktopPortrait\\\":1,\\\"tabletLandscape\\\":0,\\\"tabletPortrait\\\":1,\\\"mobileLandscape\\\":0,\\\"mobilePortrait\\\":1},\\\"sizes\\\":{\\\"desktopPortrait\\\":{\\\"width\\\":1200,\\\"height\\\":480,\\\"max\\\":3000,\\\"min\\\":1200},\\\"tabletPortrait\\\":{\\\"width\\\":701,\\\"height\\\":280,\\\"customHeight\\\":false,\\\"max\\\":1199,\\\"min\\\":701},\\\"mobilePortrait\\\":{\\\"width\\\":320,\\\"height\\\":128,\\\"customHeight\\\":false,\\\"max\\\":900,\\\"min\\\":320}},\\\"overflowHiddenPage\\\":0,\\\"focus\\\":{\\\"offsetTop\\\":\\\"#wpadminbar\\\",\\\"offsetBottom\\\":\\\"\\\"}},\\\"controls\\\":{\\\"mousewheel\\\":0,\\\"touch\\\":\\\"horizontal\\\",\\\"keyboard\\\":1,\\\"blockCarouselInteraction\\\":1},\\\"playWhenVisible\\\":1,\\\"playWhenVisibleAt\\\":0.5,\\\"lazyLoad\\\":0,\\\"lazyLoadNeighbor\\\":0,\\\"blockrightclick\\\":0,\\\"maintainSession\\\":0,\\\"autoplay\\\":{\\\"enabled\\\":0,\\\"start\\\":1,\\\"duration\\\":8000,\\\"autoplayLoop\\\":1,\\\"allowReStart\\\":0,\\\"pause\\\":{\\\"click\\\":1,\\\"mouse\\\":\\\"0\\\",\\\"mediaStarted\\\":1},\\\"resume\\\":{\\\"click\\\":0,\\\"mouse\\\":\\\"0\\\",\\\"mediaEnded\\\":1,\\\"slidechanged\\\":0},\\\"interval\\\":1,\\\"intervalModifier\\\":\\\"loop\\\",\\\"intervalSlide\\\":\\\"current\\\"},\\\"perspective\\\":1500,\\\"layerMode\\\":{\\\"playOnce\\\":0,\\\"playFirstLayer\\\":1,\\\"mode\\\":\\\"skippable\\\",\\\"inAnimation\\\":\\\"mainInEnd\\\"},\\\"bgAnimations\\\":0,\\\"mainanimation\\\":{\\\"type\\\":\\\"horizontal\\\",\\\"duration\\\":800,\\\"delay\\\":0,\\\"ease\\\":\\\"easeOutQuad\\\",\\\"shiftedBackgroundAnimation\\\":0},\\\"carousel\\\":1,\\\"initCallbacks\\\":function(){new _N2.SmartSliderWidgetArrowImage(this);new _N2.SmartSliderWidgetBulletTransition(this, {\\\"area\\\":10,\\\"dotClasses\\\":\\\"n2-style-740810c64ca26d6de5660a795a1e1c7e-dot \\\",\\\"mode\\\":\\\"\\\",\\\"action\\\":\\\"click\\\"});}});});\"],\"globalInline\":[]},\"googleFonts\":{\"staticGroupPreload\":[],\"staticGroup\":[],\"files\":{\"Roboto\":[\"300\",\"400\"]},\"urls\":[],\"codes\":[],\"firstCodes\":[],\"inline\":[],\"globalInline\":[]},\"image\":{\"images\":[\"\\/\\/www.bowatts-beaujolais.fr\\/wp-content\\/uploads\\/2025\\/09\\/Bulle-temoignage-large.png\"]}}}","0","1");

INSERT IGNORE INTO `mod119_nextend2_smartslider3_sliders` VALUES 
("1",NULL,"Tutorial Slider","simple","{\"aria-label\":\"Slider\",\"alias-id\":\"\",\"alias-smoothscroll\":\"\",\"alias-slideswitch\":\"\",\"background\":\"\",\"background-fixed\":\"0\",\"background-size\":\"cover\",\"background-color\":\"FFFFFF00\",\"backgroundVideoMp4\":\"\",\"backgroundVideoMuted\":\"1\",\"backgroundVideoLoop\":\"1\",\"backgroundVideoMode\":\"fill\",\"align\":\"normal\",\"margin\":\"0|*|0|*|0|*|0\",\"padding\":\"0|*|0|*|0|*|0\",\"perspective\":\"1000\",\"border-width\":\"0\",\"border-color\":\"3E3E3Eff\",\"border-radius\":\"0\",\"slider-preset\":\"\",\"slider-css\":\"\",\"width\":\"1200\",\"height\":\"600\",\"mobileportrait\":\"1\",\"mobilelandscape\":\"1\",\"tabletportrait\":\"1\",\"tabletlandscape\":\"1\",\"desktopportrait\":\"1\",\"desktoplandscape\":\"1\",\"responsiveLimitSlideWidth\":\"1\",\"responsiveSlideWidthDesktopLandscape\":\"0\",\"responsiveSlideWidthMaxDesktopLandscape\":\"1600\",\"responsiveSlideWidth\":\"0\",\"responsiveSlideWidthMax\":\"3000\",\"responsiveSlideWidthTabletLandscape\":\"0\",\"responsiveSlideWidthMaxTabletLandscape\":\"1200\",\"responsiveSlideWidthTablet\":\"0\",\"responsiveSlideWidthMaxTablet\":\"3000\",\"responsiveSlideWidthMobileLandscape\":\"0\",\"responsiveSlideWidthMaxMobileLandscape\":\"740\",\"responsiveSlideWidthMobile\":\"0\",\"responsiveSlideWidthMaxMobile\":\"480\",\"responsive-breakpoint-desktop-portrait\":\"1440\",\"responsive-breakpoint-desktop-portrait-landscape\":\"1440\",\"responsive-breakpoint-tablet-landscape\":\"1300\",\"responsive-breakpoint-tablet-landscape-landscape\":\"1300\",\"responsive-breakpoint-tablet-portrait\":\"1199\",\"responsive-breakpoint-tablet-portrait-landscape\":\"1199\",\"responsive-breakpoint-mobile-landscape\":\"900\",\"responsive-breakpoint-mobile-landscape-landscape\":\"1050\",\"responsive-breakpoint-mobile-portrait\":\"700\",\"responsive-breakpoint-mobile-portrait-landscape\":\"900\",\"responsive-breakpoint-desktop-landscape-enabled\":\"0\",\"responsive-breakpoint-tablet-landscape-enabled\":\"0\",\"responsive-breakpoint-tablet-portrait-enabled\":\"1\",\"responsive-breakpoint-mobile-landscape-enabled\":\"0\",\"responsive-breakpoint-mobile-portrait-enabled\":\"1\",\"responsive-breakpoint-global\":\"0\",\"breakpoints-orientation\":\"portrait\",\"responsive-mode\":\"fullwidth\",\"responsiveSliderHeightMin\":\"0\",\"responsiveForceFull\":\"1\",\"responsiveForceFullOverflowX\":\"body\",\"responsiveForceFullHorizontalSelector\":\"body\",\"slider-size-override\":\"0\",\"slider-size-override-mobile-portrait\":\"0\",\"mobile-portrait-width\":\"320\",\"mobile-portrait-height\":\"568\",\"slider-size-override-mobile-landscape\":\"0\",\"mobile-landscape-width\":\"568\",\"mobile-landscape-height\":\"320\",\"slider-size-override-tablet-portrait\":\"0\",\"tablet-portrait-width\":\"768\",\"tablet-portrait-height\":\"1024\",\"slider-size-override-tablet-landscape\":\"0\",\"tablet-landscape-width\":\"1024\",\"tablet-landscape-height\":\"768\",\"slider-size-override-desktop-landscape\":\"0\",\"desktop-landscape-width\":\"1440\",\"desktop-landscape-height\":\"900\",\"controlsTouch\":\"horizontal\",\"controlsScroll\":\"0\",\"controlsKeyboard\":\"1\",\"widget-arrow-enabled\":\"0\",\"widgetarrow\":\"imageEmpty\",\"widget-arrow-previous\":\"thin-horizontal.svg\",\"widget-arrow-previous-image\":\"\",\"widget-arrow-previous-color\":\"ffffffcc\",\"widget-arrow-previous-hover\":\"1\",\"widget-arrow-previous-hover-color\":\"ffffffff\",\"widget-arrow-mirror\":\"1\",\"widget-arrow-next\":\"thin-horizontal.svg\",\"widget-arrow-next-image\":\"\",\"widget-arrow-next-color\":\"ffffffcc\",\"widget-arrow-next-hover\":\"0\",\"widget-arrow-next-hover-color\":\"ffffffcc\",\"widget-arrow-style\":\"\",\"widget-arrow-previous-position-mode\":\"simple\",\"widget-arrow-previous-position-area\":\"6\",\"widget-arrow-previous-position-stack\":\"1\",\"widget-arrow-previous-position-offset\":\"15\",\"widget-arrow-previous-position-horizontal\":\"left\",\"widget-arrow-previous-position-horizontal-position\":\"0\",\"widget-arrow-previous-position-horizontal-unit\":\"px\",\"widget-arrow-previous-position-vertical\":\"top\",\"widget-arrow-previous-position-vertical-position\":\"0\",\"widget-arrow-previous-position-vertical-unit\":\"px\",\"widget-arrow-next-position-mode\":\"simple\",\"widget-arrow-next-position-area\":\"7\",\"widget-arrow-next-position-stack\":\"1\",\"widget-arrow-next-position-offset\":\"15\",\"widget-arrow-next-position-horizontal\":\"left\",\"widget-arrow-next-position-horizontal-position\":\"0\",\"widget-arrow-next-position-horizontal-unit\":\"px\",\"widget-arrow-next-position-vertical\":\"top\",\"widget-arrow-next-position-vertical-position\":\"0\",\"widget-arrow-next-position-vertical-unit\":\"px\",\"widget-arrow-animation\":\"fade\",\"widget-arrow-previous-alt\":\"previous arrow\",\"widget-arrow-next-alt\":\"next arrow\",\"widget-arrow-base64\":\"1\",\"widget-arrow-display-hover\":\"0\",\"widget-arrow-display-mobileportrait\":\"0\",\"widget-arrow-display-mobilelandscape\":\"0\",\"widget-arrow-display-tabletportrait\":\"1\",\"widget-arrow-display-tabletlandscape\":\"1\",\"widget-arrow-display-desktopportrait\":\"1\",\"widget-arrow-display-desktoplandscape\":\"1\",\"widget-arrow-exclude-slides\":\"\",\"widget-bullet-enabled\":\"1\",\"widgetbullet\":\"transition\",\"widget-bullet-position-mode\":\"simple\",\"widget-bullet-position-area\":\"10\",\"widget-bullet-position-stack\":\"1\",\"widget-bullet-position-offset\":\"5\",\"widget-bullet-position-horizontal\":\"left\",\"widget-bullet-position-horizontal-position\":\"0\",\"widget-bullet-position-horizontal-unit\":\"px\",\"widget-bullet-position-vertical\":\"top\",\"widget-bullet-position-vertical-position\":\"0\",\"widget-bullet-position-vertical-unit\":\"px\",\"widget-bullet-action\":\"click\",\"widget-bullet-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"00000000\\\",\\\"opacity\\\":100,\\\"padding\\\":\\\"5|*|5|*|5|*|5|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"2|*|solid|*|ffffffcc\\\",\\\"borderradius\\\":\\\"50\\\",\\\"extra\\\":\\\"margin: 4px;\\\"},{\\\"extra\\\":\\\"\\\",\\\"backgroundcolor\\\":\\\"ffffffcc\\\",\\\"border\\\":\\\"2|*|solid|*|ffffffcc\\\"}]}\",\"widget-bullet-bar\":\"\",\"widget-bullet-bar-full-size\":\"0\",\"widget-bullet-align\":\"center\",\"widget-bullet-orientation\":\"auto\",\"widget-bullet-thumbnail-show-image\":\"0\",\"widget-bullet-thumbnail-width\":\"60\",\"widget-bullet-thumbnail-height\":\"60\",\"widget-bullet-thumbnail-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"00000080\\\",\\\"padding\\\":\\\"3|*|3|*|3|*|3|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"3\\\",\\\"extra\\\":\\\"margin: 5px;\\\"}]}\",\"widget-bullet-thumbnail-side\":\"before\",\"widget-bullet-display-hover\":\"0\",\"widget-bullet-display-mobileportrait\":\"1\",\"widget-bullet-display-mobilelandscape\":\"1\",\"widget-bullet-display-tabletportrait\":\"1\",\"widget-bullet-display-tabletlandscape\":\"1\",\"widget-bullet-display-desktopportrait\":\"1\",\"widget-bullet-display-desktoplandscape\":\"1\",\"widget-bullet-exclude-slides\":\"\",\"widget-bar-enabled\":\"0\",\"widgetbar\":\"horizontal\",\"widget-bar-position-mode\":\"simple\",\"widget-bar-position-area\":\"10\",\"widget-bar-position-stack\":\"1\",\"widget-bar-position-offset\":\"30\",\"widget-bar-position-horizontal\":\"left\",\"widget-bar-position-horizontal-position\":\"0\",\"widget-bar-position-horizontal-unit\":\"px\",\"widget-bar-position-vertical\":\"top\",\"widget-bar-position-vertical-position\":\"0\",\"widget-bar-position-vertical-unit\":\"px\",\"widget-bar-animate\":\"0\",\"widget-bar-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000ab\\\",\\\"padding\\\":\\\"5|*|20|*|5|*|20|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"40\\\",\\\"extra\\\":\\\"\\\"}]}\",\"widget-bar-show-title\":\"1\",\"widget-bar-font-title\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000c7\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"bold\\\":0,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"extra\\\":\\\"vertical-align: middle;\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"google(@import url(http://fonts.googleapis.com/css?family=Raleway);),Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-bar-show-description\":\"1\",\"widget-bar-font-description\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000c7\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"bold\\\":0,\\\"italic\\\":1,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"extra\\\":\\\"vertical-align: middle;\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"Raleway,Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-bar-slide-count\":\"0\",\"widget-bar-width\":\"100%\",\"widget-bar-full-width\":\"0\",\"widget-bar-separator\":\" - \",\"widget-bar-align\":\"center\",\"widget-bar-display-hover\":\"0\",\"widget-bar-display-mobileportrait\":\"1\",\"widget-bar-display-mobilelandscape\":\"1\",\"widget-bar-display-tabletportrait\":\"1\",\"widget-bar-display-tabletlandscape\":\"1\",\"widget-bar-display-desktopportrait\":\"1\",\"widget-bar-display-desktoplandscape\":\"1\",\"widget-bar-exclude-slides\":\"\",\"widget-thumbnail-enabled\":\"0\",\"widgetthumbnail\":\"default\",\"widget-thumbnail-show-image\":\"1\",\"widget-thumbnail-width\":\"100\",\"widget-thumbnail-height\":\"60\",\"widget-thumbnail-position-mode\":\"simple\",\"widget-thumbnail-position-area\":\"12\",\"widget-thumbnail-position-stack\":\"1\",\"widget-thumbnail-position-offset\":\"0\",\"widget-thumbnail-position-horizontal\":\"left\",\"widget-thumbnail-position-horizontal-position\":\"0\",\"widget-thumbnail-position-horizontal-unit\":\"px\",\"widget-thumbnail-position-vertical\":\"top\",\"widget-thumbnail-position-vertical-position\":\"0\",\"widget-thumbnail-position-vertical-unit\":\"px\",\"widget-thumbnail-action\":\"click\",\"widget-thumbnail-align-content\":\"start\",\"widget-thumbnail-style-bar\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"242424ff\\\",\\\"padding\\\":\\\"3|*|3|*|3|*|3|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"0\\\",\\\"extra\\\":\\\"\\\"}]}\",\"widget-thumbnail-style-slides\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"00000000\\\",\\\"padding\\\":\\\"0|*|0|*|0|*|0|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|ffffff00\\\",\\\"borderradius\\\":\\\"0\\\",\\\"opacity\\\":\\\"40\\\",\\\"extra\\\":\\\"margin: 3px;\\ntransition: all 0.4s;\\nbackground-size: cover;\\\"},{\\\"border\\\":\\\"0|*|solid|*|ffffffcc\\\",\\\"opacity\\\":\\\"100\\\",\\\"extra\\\":\\\"\\\"}]}\",\"widget-thumbnail-title-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000ab\\\",\\\"padding\\\":\\\"3|*|10|*|3|*|10|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"0\\\",\\\"extra\\\":\\\"bottom: 0;\\nleft: 0;\\\"}]}\",\"widget-thumbnail-title\":\"0\",\"widget-thumbnail-title-font\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"12||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ab\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.2\\\",\\\"bold\\\":0,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"google(@import url(http://fonts.googleapis.com/css?family=Raleway);),Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-thumbnail-description\":\"0\",\"widget-thumbnail-description-font\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"12||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ab\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"bold\\\":0,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"google(@import url(http://fonts.googleapis.com/css?family=Raleway);),Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-thumbnail-caption-placement\":\"overlay\",\"widget-thumbnail-caption-size\":\"100\",\"widget-thumbnail-arrow\":\"1\",\"widget-thumbnail-arrow-width\":\"26\",\"widget-thumbnail-arrow-offset\":\"0\",\"widget-thumbnail-arrow-prev-alt\":\"previous arrow\",\"widget-thumbnail-arrow-next-alt\":\"next arrow\",\"widget-thumbnail-arrow-image\":\"\",\"widget-thumbnail-group\":\"1\",\"widget-thumbnail-invert-group-direction\":\"0\",\"widget-thumbnail-orientation\":\"auto\",\"widget-thumbnail-size\":\"100%\",\"widget-thumbnail-display-hover\":\"0\",\"widget-thumbnail-display-mobileportrait\":\"1\",\"widget-thumbnail-display-mobilelandscape\":\"1\",\"widget-thumbnail-display-tabletportrait\":\"1\",\"widget-thumbnail-display-tabletlandscape\":\"1\",\"widget-thumbnail-display-desktopportrait\":\"1\",\"widget-thumbnail-display-desktoplandscape\":\"1\",\"widget-thumbnail-exclude-slides\":\"\",\"widget-shadow-enabled\":\"0\",\"widgetshadow\":\"shadow\",\"widget-shadow-shadow\":\"dark.png\",\"widget-shadow-shadow-image\":\"\",\"widget-shadow-width\":\"100%\",\"widget-shadow-display-mobileportrait\":\"1\",\"widget-shadow-display-mobilelandscape\":\"1\",\"widget-shadow-display-tabletportrait\":\"1\",\"widget-shadow-display-tabletlandscape\":\"1\",\"widget-shadow-display-desktopportrait\":\"1\",\"widget-shadow-display-desktoplandscape\":\"1\",\"widget-shadow-exclude-slides\":\"\",\"widget-fullscreen-enabled\":\"0\",\"widgetfullscreen\":\"image\",\"widget-fullscreen-tonormal\":\"full1.svg\",\"widget-fullscreen-tonormal-image\":\"\",\"widget-fullscreen-tonormal-color\":\"ffffffcc\",\"widget-fullscreen-mirror\":\"1\",\"widget-fullscreen-tofull\":\"full1.svg\",\"widget-fullscreen-tofull-image\":\"\",\"widget-fullscreen-tofull-color\":\"ffffffcc\",\"widget-fullscreen-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000ab\\\",\\\"padding\\\":\\\"10|*|10|*|10|*|10|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"3\\\",\\\"extra\\\":\\\"\\\"},{\\\"backgroundcolor\\\":\\\"000000ab\\\"}]}\",\"widget-fullscreen-position-mode\":\"simple\",\"widget-fullscreen-position-area\":\"4\",\"widget-fullscreen-position-stack\":\"1\",\"widget-fullscreen-position-offset\":\"15\",\"widget-fullscreen-position-horizontal\":\"left\",\"widget-fullscreen-position-horizontal-position\":\"0\",\"widget-fullscreen-position-horizontal-unit\":\"px\",\"widget-fullscreen-position-vertical\":\"top\",\"widget-fullscreen-position-vertical-position\":\"0\",\"widget-fullscreen-position-vertical-unit\":\"px\",\"widget-fullscreen-responsive-desktop\":\"1\",\"widget-fullscreen-responsive-tablet\":\"0.7\",\"widget-fullscreen-responsive-mobile\":\"0.5\",\"widget-fullscreen-display-hover\":\"0\",\"widget-fullscreen-display-mobileportrait\":\"1\",\"widget-fullscreen-display-mobilelandscape\":\"1\",\"widget-fullscreen-display-tabletportrait\":\"1\",\"widget-fullscreen-display-tabletlandscape\":\"1\",\"widget-fullscreen-display-desktopportrait\":\"1\",\"widget-fullscreen-display-desktoplandscape\":\"1\",\"widget-fullscreen-exclude-slides\":\"\",\"widget-html-enabled\":\"0\",\"widgethtml\":\"html\",\"widget-html-position-mode\":\"simple\",\"widget-html-position-area\":\"2\",\"widget-html-position-stack\":\"1\",\"widget-html-position-offset\":\"0\",\"widget-html-position-horizontal\":\"left\",\"widget-html-position-horizontal-position\":\"0\",\"widget-html-position-horizontal-unit\":\"px\",\"widget-html-position-vertical\":\"top\",\"widget-html-position-vertical-position\":\"0\",\"widget-html-position-vertical-unit\":\"px\",\"widget-html-code\":\"\",\"widget-html-display-hover\":\"0\",\"widget-html-display-mobileportrait\":\"1\",\"widget-html-display-mobilelandscape\":\"1\",\"widget-html-display-tabletportrait\":\"1\",\"widget-html-display-tabletlandscape\":\"1\",\"widget-html-display-desktopportrait\":\"1\",\"widget-html-display-desktoplandscape\":\"1\",\"widget-html-exclude-slides\":\"\",\"animation\":\"fade\",\"animation-duration\":\"500\",\"animation-delay\":\"0\",\"animation-easing\":\"easeOutQuad\",\"carousel\":\"1\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"normal\",\"animation-shifted-background-animation\":\"auto\",\"kenburns-animation\":\"50|*|50|*|\",\"kenburns-animation-speed\":\"default\",\"kenburns-animation-strength\":\"default\",\"shape-divider\":\"\",\"particle\":\"\",\"playfirstlayer\":\"1\",\"playonce\":\"0\",\"layer-animation-play-in\":\"end\",\"layer-animation-play-mode\":\"skippable\",\"parallax-enabled\":\"1\",\"parallax-enabled-mobile\":\"0\",\"parallax-3d\":\"0\",\"parallax-animate\":\"1\",\"parallax-horizontal\":\"mouse\",\"parallax-vertical\":\"mouse\",\"parallax-mouse-origin\":\"slider\",\"parallax-scroll-move\":\"both\",\"autoplay\":\"0\",\"autoplayDuration\":\"8000\",\"autoplayStart\":\"1\",\"autoplayAllowReStart\":\"0\",\"autoplayLoop\":\"1\",\"autoplayfinish\":\"1|*|loop|*|current\",\"loop-single-slide\":\"0\",\"autoplayStopClick\":\"1\",\"autoplayStopMouse\":\"0\",\"autoplayStopMedia\":\"1\",\"autoplayResumeClick\":\"0\",\"autoplayResumeMouse\":\"0\",\"autoplayResumeMedia\":\"1\",\"widget-autoplay-enabled\":\"0\",\"widgetautoplay\":\"image\",\"widget-autoplay-play\":\"small-light.svg\",\"widget-autoplay-play-image\":\"\",\"widget-autoplay-play-color\":\"ffffffcc\",\"widget-autoplay-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000ab\\\",\\\"padding\\\":\\\"10|*|10|*|10|*|10|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"3\\\",\\\"extra\\\":\\\"\\\"},{\\\"backgroundcolor\\\":\\\"000000ab\\\"}]}\",\"widget-autoplay-mirror\":\"1\",\"widget-autoplay-pause\":\"small-light.svg\",\"widget-autoplay-pause-image\":\"\",\"widget-autoplay-pause-color\":\"ffffffcc\",\"widget-autoplay-responsive-desktop\":\"1\",\"widget-autoplay-responsive-tablet\":\"0.7\",\"widget-autoplay-responsive-mobile\":\"0.5\",\"widget-autoplay-position-mode\":\"simple\",\"widget-autoplay-position-area\":\"4\",\"widget-autoplay-position-stack\":\"1\",\"widget-autoplay-position-offset\":\"15\",\"widget-autoplay-position-horizontal\":\"left\",\"widget-autoplay-position-horizontal-position\":\"0\",\"widget-autoplay-position-horizontal-unit\":\"px\",\"widget-autoplay-position-vertical\":\"top\",\"widget-autoplay-position-vertical-position\":\"0\",\"widget-autoplay-position-vertical-unit\":\"px\",\"widget-autoplay-display-hover\":\"0\",\"widget-autoplay-display-mobileportrait\":\"1\",\"widget-autoplay-display-mobilelandscape\":\"1\",\"widget-autoplay-display-tabletportrait\":\"1\",\"widget-autoplay-display-tabletlandscape\":\"1\",\"widget-autoplay-display-desktopportrait\":\"1\",\"widget-autoplay-display-desktoplandscape\":\"1\",\"widget-autoplay-exclude-slides\":\"\",\"widget-indicator-enabled\":\"0\",\"widgetindicator\":\"pie\",\"widget-indicator-position-mode\":\"simple\",\"widget-indicator-position-area\":\"4\",\"widget-indicator-position-stack\":\"1\",\"widget-indicator-position-offset\":\"15\",\"widget-indicator-position-horizontal\":\"left\",\"widget-indicator-position-horizontal-position\":\"0\",\"widget-indicator-position-horizontal-unit\":\"px\",\"widget-indicator-position-vertical\":\"top\",\"widget-indicator-position-vertical-position\":\"0\",\"widget-indicator-position-vertical-unit\":\"px\",\"widget-indicator-size\":\"25\",\"widget-indicator-thickness\":\"30\",\"widget-indicator-track\":\"000000ab\",\"widget-indicator-bar\":\"ffffffff\",\"widget-indicator-style\":\"\",\"widget-indicator-display-hover\":\"0\",\"widget-indicator-display-mobileportrait\":\"1\",\"widget-indicator-display-mobilelandscape\":\"1\",\"widget-indicator-display-tabletportrait\":\"1\",\"widget-indicator-display-tabletlandscape\":\"1\",\"widget-indicator-display-desktopportrait\":\"1\",\"widget-indicator-display-desktoplandscape\":\"1\",\"widget-indicator-exclude-slides\":\"\",\"imageload\":\"0\",\"imageloadNeighborSlides\":\"0\",\"optimize-scale\":\"0\",\"optimize-quality\":\"70\",\"optimize-thumbnail-scale\":\"0\",\"optimize-thumbnail-quality\":\"70\",\"optimize-slide-width-normal\":\"1920\",\"optimizeThumbnailWidth\":\"100\",\"optimizeThumbnailHeight\":\"60\",\"layer-image-optimize\":\"0\",\"layer-image-width-tablet\":\"800\",\"layer-image-width-mobile\":\"425\",\"layer-image-base64\":\"0\",\"layer-image-base64-size\":\"50\",\"slides-background-video-mobile\":\"1\",\"playWhenVisible\":\"1\",\"playWhenVisibleAt\":\"50\",\"dependency\":\"\",\"delay\":\"0\",\"is-delayed\":\"0\",\"backgroundMode\":\"fill\",\"slide-css\":\"\",\"randomize\":\"0\",\"randomizeFirst\":\"0\",\"randomize-cache\":\"1\",\"variations\":\"5\",\"reverse-slides\":\"0\",\"maximumslidecount\":\"1000\",\"maintain-session\":\"0\",\"global-lightbox\":\"0\",\"global-lightbox-label\":\"0\",\"slide-background-parallax\":\"0\",\"slide-background-parallax-strength\":\"50\",\"bg-parallax-tablet\":\"0\",\"bg-parallax-mobile\":\"0\",\"blockrightclick\":\"0\",\"controlsBlockCarouselInteraction\":\"1\",\"clear-both\":\"1\",\"clear-both-after\":\"1\",\"overflow-hidden-page\":\"0\",\"responsiveFocusUser\":\"1\",\"responsiveFocusEdge\":\"auto\",\"classes\":\"\",\"custom-css-codes\":\"\",\"callbacks\":\"\",\"related-posts\":\"\"}","published","2020-02-25 13:53:41","https://smartslider3.com/wp-content/uploads/slider404/tutorialsliderthumbnail-1.png","3"),
("2",NULL,"Témoignages Bôwatts","simple","{\"thumbnail\":\"\",\"aria-label\":\"\",\"alias-id\":\"\",\"alias-smoothscroll\":\"\",\"alias-slideswitch\":\"\",\"alias-slideswitch-scroll\":\"1\",\"align\":\"normal\",\"margin\":\"0|*|0|*|0|*|0\",\"width\":\"1200\",\"height\":\"480\",\"responsiveLimitSlideWidth\":\"1\",\"responsiveSlideWidth\":\"0\",\"responsiveSlideWidthMax\":\"3000\",\"responsiveSlideWidthTablet\":\"0\",\"responsiveSlideWidthMaxTablet\":\"3000\",\"responsiveSlideWidthMobile\":\"0\",\"responsiveSlideWidthMaxMobile\":\"480\",\"responsive-breakpoint-tablet-portrait\":\"1199\",\"responsive-breakpoint-tablet-portrait-landscape\":\"1199\",\"responsive-breakpoint-mobile-portrait\":\"700\",\"responsive-breakpoint-mobile-portrait-landscape\":\"900\",\"responsive-breakpoint-tablet-portrait-enabled\":\"1\",\"responsive-breakpoint-mobile-portrait-enabled\":\"1\",\"responsive-breakpoint-global\":\"0\",\"breakpoints-orientation\":\"portrait\",\"responsive-mode\":\"auto\",\"responsiveScaleDown\":\"1\",\"responsiveScaleUp\":\"1\",\"responsiveSliderHeightMin\":\"0\",\"controlsTouch\":\"horizontal\",\"controlsScroll\":\"0\",\"controlsKeyboard\":\"1\",\"widget-arrow-enabled\":\"1\",\"widgetarrow\":\"imageEmpty\",\"widget-arrow-previous\":\"simple-horizontal.svg\",\"widget-arrow-previous-color\":\"1b212758\",\"widget-arrow-previous-hover\":\"0\",\"widget-arrow-previous-hover-color\":\"ffffffcc\",\"widget-arrow-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"ffffff00\\\",\\\"opacity\\\":100,\\\"padding\\\":\\\"0|*|0|*|0|*|0|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"0\\\",\\\"extra\\\":\\\"\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"widget-arrow-previous-position-area\":\"6\",\"widget-arrow-previous-position-stack\":\"1\",\"widget-arrow-previous-position-offset\":\"15\",\"widget-arrow-next-position-area\":\"7\",\"widget-arrow-next-position-stack\":\"1\",\"widget-arrow-next-position-offset\":\"15\",\"widget-arrow-previous-alt\":\"previous arrow\",\"widget-arrow-next-alt\":\"next arrow\",\"widget-arrow-base64\":\"1\",\"widget-arrow-desktop-image-width\":\"32\",\"widget-arrow-tablet-image-width\":\"32\",\"widget-arrow-mobile-image-width\":\"16\",\"widget-arrow-display-hover\":\"0\",\"widget-arrow-display-mobileportrait\":\"0\",\"widget-arrow-display-tabletportrait\":\"1\",\"widget-arrow-display-desktopportrait\":\"1\",\"widget-bullet-enabled\":\"1\",\"widgetbullet\":\"transition\",\"widget-bullet-position-area\":\"10\",\"widget-bullet-position-stack\":\"1\",\"widget-bullet-position-offset\":\"10\",\"widget-bullet-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"ffffff00\\\",\\\"opacity\\\":100,\\\"padding\\\":\\\"5|*|5|*|5|*|5|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"1|*|solid|*|bfe79cff\\\",\\\"borderradius\\\":\\\"50\\\",\\\"extra\\\":\\\"margin: 4px;\\\"},{\\\"extra\\\":\\\"\\\",\\\"backgroundcolor\\\":\\\"bfe79cff\\\",\\\"border\\\":\\\"1|*|solid|*|bfe79cff\\\"}]}\",\"widget-bullet-bar\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"ffffff00\\\",\\\"opacity\\\":100,\\\"padding\\\":\\\"0|*|0|*|0|*|0|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"0\\\",\\\"extra\\\":\\\"\\\"}]}\",\"widget-bullet-aria-label\":\"Choose slide to display.\",\"widget-bullet-thumbnail-show-image\":\"0\",\"widget-bullet-thumbnail-width\":\"60\",\"widget-bullet-thumbnail-height\":\"60\",\"widget-bullet-thumbnail-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"00000080\\\",\\\"padding\\\":\\\"3|*|3|*|3|*|3|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"3\\\",\\\"extra\\\":\\\"margin: 5px;\\\"}]}\",\"widget-bullet-thumbnail-side\":\"before\",\"widget-bullet-display-hover\":\"0\",\"widget-bullet-display-mobileportrait\":\"1\",\"widget-bullet-display-tabletportrait\":\"1\",\"widget-bullet-display-desktopportrait\":\"1\",\"widget-bar-enabled\":\"0\",\"widgetbar\":\"horizontal\",\"widget-bar-position-area\":\"10\",\"widget-bar-position-stack\":\"1\",\"widget-bar-position-offset\":\"30\",\"widget-bar-animate\":\"0\",\"widget-bar-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000ab\\\",\\\"padding\\\":\\\"5|*|20|*|5|*|20|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"40\\\",\\\"extra\\\":\\\"\\\"}]}\",\"widget-bar-show-title\":\"1\",\"widget-bar-font-title\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000c7\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"bold\\\":0,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"extra\\\":\\\"vertical-align: middle;\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"Raleway,Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-bar-show-description\":\"1\",\"widget-bar-font-description\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000c7\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"bold\\\":0,\\\"italic\\\":1,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"extra\\\":\\\"vertical-align: middle;\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"Raleway,Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-bar-slide-count\":\"0\",\"widget-bar-full-width\":\"0\",\"widget-bar-separator\":\" - \",\"widget-bar-align\":\"center\",\"widget-bar-display-hover\":\"0\",\"widget-bar-display-mobileportrait\":\"1\",\"widget-bar-display-tabletportrait\":\"1\",\"widget-bar-display-desktopportrait\":\"1\",\"widget-thumbnail-enabled\":\"0\",\"widgetthumbnail\":\"default\",\"widget-thumbnail-width\":\"100\",\"widget-thumbnail-height\":\"60\",\"widget-thumbnail-tablet-width\":\"100\",\"widget-thumbnail-tablet-height\":\"60\",\"widget-thumbnail-mobile-width\":\"100\",\"widget-thumbnail-mobile-height\":\"60\",\"widget-thumbnail-position-area\":\"12\",\"widget-thumbnail-position-stack\":\"1\",\"widget-thumbnail-position-offset\":\"0\",\"widget-thumbnail-align-content\":\"start\",\"widget-thumbnail-style-bar\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"242424ff\\\",\\\"padding\\\":\\\"3|*|3|*|3|*|3|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"0\\\",\\\"extra\\\":\\\"\\\"}]}\",\"widget-thumbnail-style-slides\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"00000000\\\",\\\"padding\\\":\\\"0|*|0|*|0|*|0|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|ffffff00\\\",\\\"borderradius\\\":\\\"0\\\",\\\"opacity\\\":\\\"40\\\",\\\"extra\\\":\\\"margin: 3px;\\\\ntransition: all 0.4s;\\\"},{\\\"border\\\":\\\"0|*|solid|*|ffffffcc\\\",\\\"opacity\\\":\\\"100\\\",\\\"extra\\\":\\\"\\\"}]}\",\"widget-thumbnail-title-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000ab\\\",\\\"padding\\\":\\\"3|*|10|*|3|*|10|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"0\\\",\\\"extra\\\":\\\"bottom: 0;\\\\nleft: 0;\\\"}]}\",\"widget-thumbnail-title\":\"0\",\"widget-thumbnail-title-font\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"12||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ab\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.2\\\",\\\"bold\\\":0,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"Raleway,Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-thumbnail-description\":\"0\",\"widget-thumbnail-description-font\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"12||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ab\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"bold\\\":0,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"Raleway,Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-thumbnail-caption-placement\":\"overlay\",\"widget-thumbnail-caption-size\":\"100\",\"widget-thumbnail-display-hover\":\"0\",\"widget-thumbnail-display-mobileportrait\":\"0\",\"widget-thumbnail-display-tabletportrait\":\"1\",\"widget-thumbnail-display-desktopportrait\":\"1\",\"widget-shadow-enabled\":\"0\",\"widgetshadow\":\"shadow\",\"widget-shadow-shadow\":\"dark.png\",\"widget-shadow-display-mobileportrait\":\"0\",\"widget-shadow-display-tabletportrait\":\"1\",\"widget-shadow-display-desktopportrait\":\"1\",\"animation\":\"horizontal\",\"animation-duration\":\"800\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"normal\",\"autoplay\":\"0\",\"autoplayDuration\":\"8000\",\"autoplayStopClick\":\"1\",\"autoplayStopMouse\":\"0\",\"autoplayStopMedia\":\"1\",\"autoplayResumeClick\":\"0\",\"autoplayResumeMouse\":\"0\",\"autoplayResumeMedia\":\"1\",\"widget-autoplay-enabled\":\"0\",\"widgetautoplay\":\"image\",\"widget-autoplay-play\":\"small-light.svg\",\"widget-autoplay-play-color\":\"ffffffcc\",\"widget-autoplay-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000ab\\\",\\\"padding\\\":\\\"10|*|10|*|10|*|10|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"3\\\",\\\"extra\\\":\\\"\\\"},{\\\"backgroundcolor\\\":\\\"000000ab\\\"}]}\",\"widget-autoplay-desktop-image-width\":\"16\",\"widget-autoplay-tablet-image-width\":\"16\",\"widget-autoplay-mobile-image-width\":\"8\",\"widget-autoplay-position-area\":\"4\",\"widget-autoplay-position-stack\":\"1\",\"widget-autoplay-position-offset\":\"15\",\"widget-autoplay-display-hover\":\"0\",\"widget-autoplay-display-mobileportrait\":\"1\",\"widget-autoplay-display-tabletportrait\":\"1\",\"widget-autoplay-display-desktopportrait\":\"1\",\"loading-type\":\"\",\"delay\":\"0\",\"playWhenVisible\":\"1\",\"playWhenVisibleAt\":\"50\",\"optimize-scale\":\"0\",\"optimize-quality\":\"70\",\"optimize-slide-width-normal\":\"1920\",\"optimize-thumbnail-scale\":\"0\",\"optimize-thumbnail-quality\":\"70\",\"optimizeThumbnailWidth\":\"100\",\"optimizeThumbnailHeight\":\"60\",\"backgroundMode\":\"fill\",\"backgroundBlurFit\":\"7\",\"controlsBlockCarouselInteraction\":\"1\",\"clear-both\":\"1\",\"clear-both-after\":\"1\",\"overflow-hidden-page\":\"0\",\"responsiveFocusUser\":\"1\",\"responsiveFocusEdge\":\"auto\",\"is-delayed\":\"0\",\"legacy-font-scale\":\"0\",\"classes\":\"\",\"custom-css-codes\":\"\",\"loading-time\":\"2000\",\"related-posts\":\"\",\"version\":\"3.5.1.29\"}","published","2025-09-04 17:56:31","","2"),
("3",NULL,"Témoignages Bôwatts PRO","simple","{\"thumbnail\":\"\",\"aria-label\":\"\",\"alias-id\":\"\",\"alias-smoothscroll\":\"\",\"alias-slideswitch\":\"\",\"alias-slideswitch-scroll\":\"1\",\"align\":\"normal\",\"margin\":\"0|*|0|*|0|*|0\",\"width\":\"1200\",\"height\":\"480\",\"responsiveLimitSlideWidth\":\"1\",\"responsiveSlideWidth\":\"0\",\"responsiveSlideWidthMax\":\"3000\",\"responsiveSlideWidthTablet\":\"0\",\"responsiveSlideWidthMaxTablet\":\"3000\",\"responsiveSlideWidthMobile\":\"0\",\"responsiveSlideWidthMaxMobile\":\"480\",\"responsive-breakpoint-tablet-portrait\":\"1199\",\"responsive-breakpoint-tablet-portrait-landscape\":\"1199\",\"responsive-breakpoint-mobile-portrait\":\"700\",\"responsive-breakpoint-mobile-portrait-landscape\":\"900\",\"responsive-breakpoint-tablet-portrait-enabled\":\"1\",\"responsive-breakpoint-mobile-portrait-enabled\":\"1\",\"responsive-breakpoint-global\":\"0\",\"breakpoints-orientation\":\"portrait\",\"responsive-mode\":\"auto\",\"responsiveScaleDown\":\"1\",\"responsiveScaleUp\":\"1\",\"responsiveSliderHeightMin\":\"0\",\"controlsTouch\":\"horizontal\",\"controlsScroll\":\"0\",\"controlsKeyboard\":\"1\",\"widget-arrow-enabled\":\"1\",\"widgetarrow\":\"imageEmpty\",\"widget-arrow-previous\":\"simple-horizontal.svg\",\"widget-arrow-previous-color\":\"1b212758\",\"widget-arrow-previous-hover\":\"0\",\"widget-arrow-previous-hover-color\":\"ffffffcc\",\"widget-arrow-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"ffffff00\\\",\\\"opacity\\\":100,\\\"padding\\\":\\\"0|*|0|*|0|*|0|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"0\\\",\\\"extra\\\":\\\"\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"widget-arrow-previous-position-area\":\"6\",\"widget-arrow-previous-position-stack\":\"1\",\"widget-arrow-previous-position-offset\":\"15\",\"widget-arrow-next-position-area\":\"7\",\"widget-arrow-next-position-stack\":\"1\",\"widget-arrow-next-position-offset\":\"15\",\"widget-arrow-previous-alt\":\"previous arrow\",\"widget-arrow-next-alt\":\"next arrow\",\"widget-arrow-base64\":\"1\",\"widget-arrow-desktop-image-width\":\"32\",\"widget-arrow-tablet-image-width\":\"32\",\"widget-arrow-mobile-image-width\":\"16\",\"widget-arrow-display-hover\":\"0\",\"widget-arrow-display-mobileportrait\":\"0\",\"widget-arrow-display-tabletportrait\":\"1\",\"widget-arrow-display-desktopportrait\":\"1\",\"widget-bullet-enabled\":\"1\",\"widgetbullet\":\"transition\",\"widget-bullet-position-area\":\"10\",\"widget-bullet-position-stack\":\"1\",\"widget-bullet-position-offset\":\"10\",\"widget-bullet-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"ffffff00\\\",\\\"opacity\\\":100,\\\"padding\\\":\\\"5|*|5|*|5|*|5|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"1|*|solid|*|bfe79cff\\\",\\\"borderradius\\\":\\\"50\\\",\\\"extra\\\":\\\"margin: 4px;\\\"},{\\\"extra\\\":\\\"\\\",\\\"backgroundcolor\\\":\\\"bfe79cff\\\"}]}\",\"widget-bullet-bar\":\"\",\"widget-bullet-aria-label\":\"Choose slide to display.\",\"widget-bullet-thumbnail-show-image\":\"0\",\"widget-bullet-thumbnail-width\":\"60\",\"widget-bullet-thumbnail-height\":\"60\",\"widget-bullet-thumbnail-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"00000080\\\",\\\"padding\\\":\\\"3|*|3|*|3|*|3|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"3\\\",\\\"extra\\\":\\\"margin: 5px;\\\"}]}\",\"widget-bullet-thumbnail-side\":\"before\",\"widget-bullet-display-hover\":\"0\",\"widget-bullet-display-mobileportrait\":\"1\",\"widget-bullet-display-tabletportrait\":\"1\",\"widget-bullet-display-desktopportrait\":\"1\",\"widget-bar-enabled\":\"0\",\"widgetbar\":\"horizontal\",\"widget-bar-position-area\":\"10\",\"widget-bar-position-stack\":\"1\",\"widget-bar-position-offset\":\"30\",\"widget-bar-animate\":\"0\",\"widget-bar-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000ab\\\",\\\"padding\\\":\\\"5|*|20|*|5|*|20|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"40\\\",\\\"extra\\\":\\\"\\\"}]}\",\"widget-bar-show-title\":\"1\",\"widget-bar-font-title\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000c7\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"bold\\\":0,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"extra\\\":\\\"vertical-align: middle;\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"Raleway,Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-bar-show-description\":\"1\",\"widget-bar-font-description\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000c7\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"bold\\\":0,\\\"italic\\\":1,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"extra\\\":\\\"vertical-align: middle;\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"Raleway,Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-bar-slide-count\":\"0\",\"widget-bar-full-width\":\"0\",\"widget-bar-separator\":\" - \",\"widget-bar-align\":\"center\",\"widget-bar-display-hover\":\"0\",\"widget-bar-display-mobileportrait\":\"1\",\"widget-bar-display-tabletportrait\":\"1\",\"widget-bar-display-desktopportrait\":\"1\",\"widget-thumbnail-enabled\":\"0\",\"widgetthumbnail\":\"default\",\"widget-thumbnail-width\":\"100\",\"widget-thumbnail-height\":\"60\",\"widget-thumbnail-tablet-width\":\"100\",\"widget-thumbnail-tablet-height\":\"60\",\"widget-thumbnail-mobile-width\":\"100\",\"widget-thumbnail-mobile-height\":\"60\",\"widget-thumbnail-position-area\":\"12\",\"widget-thumbnail-position-stack\":\"1\",\"widget-thumbnail-position-offset\":\"0\",\"widget-thumbnail-align-content\":\"start\",\"widget-thumbnail-style-bar\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"242424ff\\\",\\\"padding\\\":\\\"3|*|3|*|3|*|3|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"0\\\",\\\"extra\\\":\\\"\\\"}]}\",\"widget-thumbnail-style-slides\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"00000000\\\",\\\"padding\\\":\\\"0|*|0|*|0|*|0|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|ffffff00\\\",\\\"borderradius\\\":\\\"0\\\",\\\"opacity\\\":\\\"40\\\",\\\"extra\\\":\\\"margin: 3px;\\\\ntransition: all 0.4s;\\\"},{\\\"border\\\":\\\"0|*|solid|*|ffffffcc\\\",\\\"opacity\\\":\\\"100\\\",\\\"extra\\\":\\\"\\\"}]}\",\"widget-thumbnail-title-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000ab\\\",\\\"padding\\\":\\\"3|*|10|*|3|*|10|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"0\\\",\\\"extra\\\":\\\"bottom: 0;\\\\nleft: 0;\\\"}]}\",\"widget-thumbnail-title\":\"0\",\"widget-thumbnail-title-font\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"12||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ab\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.2\\\",\\\"bold\\\":0,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"Raleway,Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-thumbnail-description\":\"0\",\"widget-thumbnail-description-font\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"12||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ab\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"bold\\\":0,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"Raleway,Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-thumbnail-caption-placement\":\"overlay\",\"widget-thumbnail-caption-size\":\"100\",\"widget-thumbnail-display-hover\":\"0\",\"widget-thumbnail-display-mobileportrait\":\"0\",\"widget-thumbnail-display-tabletportrait\":\"1\",\"widget-thumbnail-display-desktopportrait\":\"1\",\"widget-shadow-enabled\":\"0\",\"widgetshadow\":\"shadow\",\"widget-shadow-shadow\":\"dark.png\",\"widget-shadow-display-mobileportrait\":\"0\",\"widget-shadow-display-tabletportrait\":\"1\",\"widget-shadow-display-desktopportrait\":\"1\",\"animation\":\"horizontal\",\"animation-duration\":\"800\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"normal\",\"autoplay\":\"0\",\"autoplayDuration\":\"8000\",\"autoplayStopClick\":\"1\",\"autoplayStopMouse\":\"0\",\"autoplayStopMedia\":\"1\",\"autoplayResumeClick\":\"0\",\"autoplayResumeMouse\":\"0\",\"autoplayResumeMedia\":\"1\",\"widget-autoplay-enabled\":\"0\",\"widgetautoplay\":\"image\",\"widget-autoplay-play\":\"small-light.svg\",\"widget-autoplay-play-color\":\"ffffffcc\",\"widget-autoplay-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000ab\\\",\\\"padding\\\":\\\"10|*|10|*|10|*|10|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"3\\\",\\\"extra\\\":\\\"\\\"},{\\\"backgroundcolor\\\":\\\"000000ab\\\"}]}\",\"widget-autoplay-desktop-image-width\":\"16\",\"widget-autoplay-tablet-image-width\":\"16\",\"widget-autoplay-mobile-image-width\":\"8\",\"widget-autoplay-position-area\":\"4\",\"widget-autoplay-position-stack\":\"1\",\"widget-autoplay-position-offset\":\"15\",\"widget-autoplay-display-hover\":\"0\",\"widget-autoplay-display-mobileportrait\":\"1\",\"widget-autoplay-display-tabletportrait\":\"1\",\"widget-autoplay-display-desktopportrait\":\"1\",\"loading-type\":\"\",\"delay\":\"0\",\"playWhenVisible\":\"1\",\"playWhenVisibleAt\":\"50\",\"optimize-scale\":\"0\",\"optimize-quality\":\"70\",\"optimize-slide-width-normal\":\"1920\",\"optimize-thumbnail-scale\":\"0\",\"optimize-thumbnail-quality\":\"70\",\"optimizeThumbnailWidth\":\"100\",\"optimizeThumbnailHeight\":\"60\",\"backgroundMode\":\"fill\",\"backgroundBlurFit\":\"7\",\"controlsBlockCarouselInteraction\":\"1\",\"clear-both\":\"1\",\"clear-both-after\":\"1\",\"overflow-hidden-page\":\"0\",\"responsiveFocusUser\":\"1\",\"responsiveFocusEdge\":\"auto\",\"is-delayed\":\"0\",\"legacy-font-scale\":\"0\",\"classes\":\"\",\"custom-css-codes\":\"\",\"loading-time\":\"2000\",\"related-posts\":\"\",\"version\":\"3.5.1.29\"}","published","2025-09-04 17:58:39","","1"),
("4",NULL,"Presse Bowatts","simple","{\"thumbnail\":\"\",\"aria-label\":\"\",\"alias-id\":\"\",\"alias-smoothscroll\":\"\",\"alias-slideswitch\":\"\",\"alias-slideswitch-scroll\":\"1\",\"align\":\"normal\",\"margin\":\"0|*|0|*|0|*|0\",\"width\":\"1200\",\"height\":\"480\",\"responsiveLimitSlideWidth\":\"1\",\"responsiveSlideWidth\":\"0\",\"responsiveSlideWidthMax\":\"3000\",\"responsiveSlideWidthTablet\":\"0\",\"responsiveSlideWidthMaxTablet\":\"3000\",\"responsiveSlideWidthMobile\":\"0\",\"responsiveSlideWidthMaxMobile\":\"480\",\"responsive-breakpoint-tablet-portrait\":\"1199\",\"responsive-breakpoint-tablet-portrait-landscape\":\"1199\",\"responsive-breakpoint-mobile-portrait\":\"700\",\"responsive-breakpoint-mobile-portrait-landscape\":\"900\",\"responsive-breakpoint-tablet-portrait-enabled\":\"1\",\"responsive-breakpoint-mobile-portrait-enabled\":\"1\",\"responsive-breakpoint-global\":\"0\",\"breakpoints-orientation\":\"portrait\",\"responsive-mode\":\"auto\",\"responsiveScaleDown\":\"1\",\"responsiveScaleUp\":\"1\",\"responsiveSliderHeightMin\":\"0\",\"controlsTouch\":\"horizontal\",\"controlsScroll\":\"0\",\"controlsKeyboard\":\"1\",\"widget-arrow-enabled\":\"1\",\"widgetarrow\":\"imageEmpty\",\"widget-arrow-previous\":\"simple-horizontal.svg\",\"widget-arrow-previous-color\":\"ffffffff\",\"widget-arrow-previous-hover\":\"0\",\"widget-arrow-previous-hover-color\":\"ffffffcc\",\"widget-arrow-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"ffffff00\\\",\\\"opacity\\\":100,\\\"padding\\\":\\\"0|*|0|*|0|*|0|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"0\\\",\\\"extra\\\":\\\"\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"widget-arrow-previous-position-area\":\"6\",\"widget-arrow-previous-position-stack\":\"1\",\"widget-arrow-previous-position-offset\":\"15\",\"widget-arrow-next-position-area\":\"7\",\"widget-arrow-next-position-stack\":\"1\",\"widget-arrow-next-position-offset\":\"15\",\"widget-arrow-previous-alt\":\"previous arrow\",\"widget-arrow-next-alt\":\"next arrow\",\"widget-arrow-base64\":\"1\",\"widget-arrow-desktop-image-width\":\"32\",\"widget-arrow-tablet-image-width\":\"32\",\"widget-arrow-mobile-image-width\":\"16\",\"widget-arrow-display-hover\":\"0\",\"widget-arrow-display-mobileportrait\":\"0\",\"widget-arrow-display-tabletportrait\":\"1\",\"widget-arrow-display-desktopportrait\":\"1\",\"widget-bullet-enabled\":\"1\",\"widgetbullet\":\"transition\",\"widget-bullet-position-area\":\"10\",\"widget-bullet-position-stack\":\"1\",\"widget-bullet-position-offset\":\"10\",\"widget-bullet-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"ffffff00\\\",\\\"opacity\\\":100,\\\"padding\\\":\\\"5|*|5|*|5|*|5|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"1|*|solid|*|ffffffff\\\",\\\"borderradius\\\":\\\"50\\\",\\\"extra\\\":\\\"margin: 4px;\\\"},{\\\"extra\\\":\\\"\\\",\\\"backgroundcolor\\\":\\\"bfe79cff\\\",\\\"border\\\":\\\"1|*|solid|*|bfe79cff\\\"}]}\",\"widget-bullet-bar\":\"\",\"widget-bullet-aria-label\":\"Choose slide to display.\",\"widget-bullet-thumbnail-show-image\":\"0\",\"widget-bullet-thumbnail-width\":\"60\",\"widget-bullet-thumbnail-height\":\"60\",\"widget-bullet-thumbnail-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"00000080\\\",\\\"padding\\\":\\\"3|*|3|*|3|*|3|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"3\\\",\\\"extra\\\":\\\"margin: 5px;\\\"}]}\",\"widget-bullet-thumbnail-side\":\"before\",\"widget-bullet-display-hover\":\"0\",\"widget-bullet-display-mobileportrait\":\"1\",\"widget-bullet-display-tabletportrait\":\"1\",\"widget-bullet-display-desktopportrait\":\"1\",\"widget-bar-enabled\":\"0\",\"widgetbar\":\"horizontal\",\"widget-bar-position-area\":\"10\",\"widget-bar-position-stack\":\"1\",\"widget-bar-position-offset\":\"30\",\"widget-bar-animate\":\"0\",\"widget-bar-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000ab\\\",\\\"padding\\\":\\\"5|*|20|*|5|*|20|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"40\\\",\\\"extra\\\":\\\"\\\"}]}\",\"widget-bar-show-title\":\"1\",\"widget-bar-font-title\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000c7\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"bold\\\":0,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"extra\\\":\\\"vertical-align: middle;\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"Raleway,Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-bar-show-description\":\"1\",\"widget-bar-font-description\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000c7\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"bold\\\":0,\\\"italic\\\":1,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"extra\\\":\\\"vertical-align: middle;\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"Raleway,Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-bar-slide-count\":\"0\",\"widget-bar-full-width\":\"0\",\"widget-bar-separator\":\" - \",\"widget-bar-align\":\"center\",\"widget-bar-display-hover\":\"0\",\"widget-bar-display-mobileportrait\":\"1\",\"widget-bar-display-tabletportrait\":\"1\",\"widget-bar-display-desktopportrait\":\"1\",\"widget-thumbnail-enabled\":\"0\",\"widgetthumbnail\":\"default\",\"widget-thumbnail-width\":\"100\",\"widget-thumbnail-height\":\"60\",\"widget-thumbnail-tablet-width\":\"100\",\"widget-thumbnail-tablet-height\":\"60\",\"widget-thumbnail-mobile-width\":\"100\",\"widget-thumbnail-mobile-height\":\"60\",\"widget-thumbnail-position-area\":\"12\",\"widget-thumbnail-position-stack\":\"1\",\"widget-thumbnail-position-offset\":\"0\",\"widget-thumbnail-align-content\":\"start\",\"widget-thumbnail-style-bar\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"242424ff\\\",\\\"padding\\\":\\\"3|*|3|*|3|*|3|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"0\\\",\\\"extra\\\":\\\"\\\"}]}\",\"widget-thumbnail-style-slides\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"00000000\\\",\\\"padding\\\":\\\"0|*|0|*|0|*|0|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|ffffff00\\\",\\\"borderradius\\\":\\\"0\\\",\\\"opacity\\\":\\\"40\\\",\\\"extra\\\":\\\"margin: 3px;\\\\ntransition: all 0.4s;\\\"},{\\\"border\\\":\\\"0|*|solid|*|ffffffcc\\\",\\\"opacity\\\":\\\"100\\\",\\\"extra\\\":\\\"\\\"}]}\",\"widget-thumbnail-title-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000ab\\\",\\\"padding\\\":\\\"3|*|10|*|3|*|10|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"0\\\",\\\"extra\\\":\\\"bottom: 0;\\\\nleft: 0;\\\"}]}\",\"widget-thumbnail-title\":\"0\",\"widget-thumbnail-title-font\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"12||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ab\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.2\\\",\\\"bold\\\":0,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"Raleway,Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-thumbnail-description\":\"0\",\"widget-thumbnail-description-font\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"12||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ab\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"bold\\\":0,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"Raleway,Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-thumbnail-caption-placement\":\"overlay\",\"widget-thumbnail-caption-size\":\"100\",\"widget-thumbnail-display-hover\":\"0\",\"widget-thumbnail-display-mobileportrait\":\"0\",\"widget-thumbnail-display-tabletportrait\":\"1\",\"widget-thumbnail-display-desktopportrait\":\"1\",\"widget-shadow-enabled\":\"0\",\"widgetshadow\":\"shadow\",\"widget-shadow-shadow\":\"dark.png\",\"widget-shadow-display-mobileportrait\":\"0\",\"widget-shadow-display-tabletportrait\":\"1\",\"widget-shadow-display-desktopportrait\":\"1\",\"animation\":\"horizontal\",\"animation-duration\":\"800\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"normal\",\"autoplay\":\"0\",\"autoplayDuration\":\"8000\",\"autoplayStopClick\":\"1\",\"autoplayStopMouse\":\"0\",\"autoplayStopMedia\":\"1\",\"autoplayResumeClick\":\"0\",\"autoplayResumeMouse\":\"0\",\"autoplayResumeMedia\":\"1\",\"widget-autoplay-enabled\":\"0\",\"widgetautoplay\":\"image\",\"widget-autoplay-play\":\"small-light.svg\",\"widget-autoplay-play-color\":\"ffffffcc\",\"widget-autoplay-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000ab\\\",\\\"padding\\\":\\\"10|*|10|*|10|*|10|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"3\\\",\\\"extra\\\":\\\"\\\"},{\\\"backgroundcolor\\\":\\\"000000ab\\\"}]}\",\"widget-autoplay-desktop-image-width\":\"16\",\"widget-autoplay-tablet-image-width\":\"16\",\"widget-autoplay-mobile-image-width\":\"8\",\"widget-autoplay-position-area\":\"4\",\"widget-autoplay-position-stack\":\"1\",\"widget-autoplay-position-offset\":\"15\",\"widget-autoplay-display-hover\":\"0\",\"widget-autoplay-display-mobileportrait\":\"1\",\"widget-autoplay-display-tabletportrait\":\"1\",\"widget-autoplay-display-desktopportrait\":\"1\",\"loading-type\":\"\",\"delay\":\"0\",\"playWhenVisible\":\"1\",\"playWhenVisibleAt\":\"50\",\"optimize-scale\":\"0\",\"optimize-quality\":\"70\",\"optimize-slide-width-normal\":\"1920\",\"optimize-thumbnail-scale\":\"0\",\"optimize-thumbnail-quality\":\"70\",\"optimizeThumbnailWidth\":\"100\",\"optimizeThumbnailHeight\":\"60\",\"backgroundMode\":\"fill\",\"backgroundBlurFit\":\"7\",\"controlsBlockCarouselInteraction\":\"1\",\"clear-both\":\"1\",\"clear-both-after\":\"1\",\"overflow-hidden-page\":\"0\",\"responsiveFocusUser\":\"1\",\"responsiveFocusEdge\":\"auto\",\"is-delayed\":\"0\",\"legacy-font-scale\":\"0\",\"classes\":\"\",\"custom-css-codes\":\"\",\"loading-time\":\"2000\",\"related-posts\":\"\",\"version\":\"3.5.1.29\"}","published","2025-09-04 17:59:10","","0");

INSERT IGNORE INTO `mod119_nextend2_smartslider3_sliders_xref` VALUES 
("0","2","0"),
("0","3","1"),
("0","4","2");

INSERT IGNORE INTO `mod119_nextend2_smartslider3_slides` VALUES 
("1","Slide Background","1","1970-01-01 00:00:00","1970-01-01 00:00:00","1","0","[{\"type\":\"content\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitmaxwidth\":1120,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitselfalign\":\"center\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-IbNOabpfT5aE\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"verticalalign\":\"center\",\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"10|*|0|*|10|*|0|*|px\",\"desktopportraitgutter\":0,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitpadding\":\"10|*|0|*|10|*|0|*|px\",\"tabletportraitgutter\":20,\"mobileportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"mobileportraitgutter\":20,\"mobileportraitwrapafter\":1,\"mobileportraitmaxwidth\":400,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-dtwtw9DVCwgQ\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffff00\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"1|*|1|*|1|*|1\",\"borderstyle\":\"none\",\"bordercolor\":\"FFFFFFFF\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Row\",\"namesynced\":1,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"left\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10|*|px\",\"desktopportraitorder\":0,\"tabletportraitpadding\":\"10|*|0|*|10|*|0|*|px\",\"mobileportraitinneralign\":\"left\",\"mobileportraitpadding\":\"10|*|0|*|10|*|0|*|px\",\"mobileportraitorder\":2,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-Fjvyu081qJeK\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"verticalalign\":\"center\",\"colwidth\":\"2/5\",\"href\":\"\",\"href-target\":\"_self\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Column\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":80,\"mobileportraitfontsize\":60,\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Jeans Store Interior\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"36||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.2\\\",\\\"weight\\\":1,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"01. Slide Background\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":80,\"mobileportraitfontsize\":70,\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Lorem ipsum dolor sit amet, consect\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffb0\\\",\\\"size\\\":\\\"24||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"weight\\\":300,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"Every slide includes a background, which can be a picture or solid color.\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"20|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":100,\"mobileportraitfontsize\":80,\"mobileportraitmargin\":\"10|*|0|*|0|*|0|*|px\",\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Latest Project\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffdb\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":1,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"1px\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"uppercase\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"Step 1\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":90,\"mobileportraitfontsize\":70,\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Text\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffb0\\\",\\\"size\\\":\\\"18||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.6\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content\":\"To change the background click on the label bar and in the layer window select the style tab.\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"20|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":100,\"mobileportraitfontsize\":80,\"mobileportraitmargin\":\"10|*|0|*|0|*|0|*|px\",\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Latest Project\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffdb\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":1,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"1px\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"uppercase\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"Step 2\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":90,\"mobileportraitfontsize\":70,\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Text\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffb0\\\",\\\"size\\\":\\\"18||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.6\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content\":\"Choose a source from the background top tab then upload an image or pick a background color.\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"20|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":80,\"mobileportraitfontsize\":80,\"mobileportraitmargin\":\"10|*|0|*|0|*|0|*|px\",\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Read More\",\"namesynced\":1,\"item\":{\"type\":\"button\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":1,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"center\\\",\\\"letterspacing\\\":\\\"1px\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"0568f6ff\\\"}]}\",\"style\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"backgroundcolor\\\":\\\"0568f6ff\\\",\\\"opacity\\\":100,\\\"padding\\\":\\\"1|*|2|*|1|*|2|*|em\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"5\\\"},{\\\"extra\\\":\\\"\\\",\\\"backgroundcolor\\\":\\\"ffffffff\\\"}]}\",\"content\":\"Next Slide\",\"nowrap\":\"1\",\"fullwidth\":\"0\",\"href\":\"NextSlide[]\",\"href-target\":\"_self\",\"href-rel\":\"\",\"class\":\"\",\"icon\":\"\",\"iconsize\":\"100\",\"iconspacing\":\"30\",\"iconplacement\":\"left\"}}}]},{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"left\",\"desktopportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitorder\":0,\"mobileportraitinneralign\":\"center\",\"mobileportraitorder\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-LnImbm1HgUAv\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"verticalalign\":\"center\",\"colwidth\":\"3/5\",\"href\":\"\",\"href-target\":\"_self\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Column\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitmaxwidth\":300,\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Image\",\"namesynced\":1,\"item\":{\"type\":\"image\",\"values\":{\"image\":\"https://smartslider3.com/wp-content/uploads/slider424/background.png\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"size\":\"auto|*|auto\",\"alt\":\"\",\"title\":\"\",\"href-class\":\"\"}}}]}]}]}]","","https://smartslider3.com/wp-content/uploads/slider424/slidebackground.jpg","{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"10|*|60|*|10|*|60\",\"tabletportraitpadding\":\"10|*|50|*|10|*|50\",\"mobileportraitpadding\":\"10|*|10|*|35|*|10\",\"record-slides\":0,\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"\",\"background-type\":\"image\",\"backgroundColor\":\"ffffff00\",\"backgroundGradient\":\"off\",\"backgroundColorEnd\":\"ffffff00\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"https://smartslider3.com/wp-content/uploads/slider424/slide1.png\",\"backgroundFocusX\":50,\"backgroundFocusY\":50,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.4.0\"}","1","0"),
("2","Build & Design","1","1970-01-01 00:00:00","1970-01-01 00:00:00","1","0","[{\"type\":\"content\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitmaxwidth\":1120,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitselfalign\":\"center\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-TPnUuKlAWVoC\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"verticalalign\":\"center\",\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"10|*|0|*|10|*|0|*|px\",\"desktopportraitgutter\":0,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitpadding\":\"10|*|0|*|10|*|0|*|px\",\"tabletportraitgutter\":20,\"mobileportraitinneralign\":\"inherit\",\"mobileportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"mobileportraitgutter\":20,\"mobileportraitwrapafter\":1,\"mobileportraitmaxwidth\":400,\"mobileportraitselfalign\":\"inherit\",\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-NmnNQvKK01kO\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffff00\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"1|*|1|*|1|*|1\",\"borderstyle\":\"none\",\"bordercolor\":\"FFFFFFFF\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Row\",\"namesynced\":1,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"left\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10|*|px\",\"desktopportraitorder\":0,\"tabletportraitpadding\":\"10|*|0|*|10|*|0|*|px\",\"mobileportraitmaxwidth\":0,\"mobileportraitinneralign\":\"left\",\"mobileportraitpadding\":\"10|*|0|*|10|*|0|*|px\",\"mobileportraitorder\":2,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-R5Jkk06Nmzr4\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"verticalalign\":\"center\",\"colwidth\":\"2/5\",\"href\":\"\",\"href-target\":\"_self\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Column\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":80,\"mobileportraitfontsize\":60,\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Jeans Store Interior\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"36||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.2\\\",\\\"weight\\\":1,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"02. Build & Design\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":80,\"mobileportraitfontsize\":70,\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Lorem ipsum dolor sit amet, consect\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffb0\\\",\\\"size\\\":\\\"24||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"weight\\\":300,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"Build any layout with layers and customize your designs limitlessly.\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"20|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":100,\"mobileportraitfontsize\":80,\"mobileportraitmargin\":\"10|*|0|*|0|*|0|*|px\",\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Latest Project\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffdb\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":1,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"1px\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"uppercase\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"Step 1\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":90,\"mobileportraitfontsize\":70,\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Text\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffb0\\\",\\\"size\\\":\\\"18||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.6\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content\":\"To add a layer, click the green plus button in the left sidebar and select the type of layer.\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"20|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":100,\"mobileportraitfontsize\":80,\"mobileportraitmargin\":\"10|*|0|*|0|*|0|*|px\",\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Latest Project\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffdb\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":1,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"1px\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"uppercase\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"Step 2\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":90,\"mobileportraitfontsize\":70,\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Text\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffb0\\\",\\\"size\\\":\\\"18||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.6\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content\":\"Select any layer and you can edit its content and style properties in the layer window.\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"20|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":80,\"mobileportraitfontsize\":80,\"mobileportraitmargin\":\"10|*|0|*|0|*|0|*|px\",\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Read More\",\"namesynced\":1,\"item\":{\"type\":\"button\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":1,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"center\\\",\\\"letterspacing\\\":\\\"1px\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"0568f6ff\\\"}]}\",\"style\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"backgroundcolor\\\":\\\"0568f6ff\\\",\\\"opacity\\\":100,\\\"padding\\\":\\\"1|*|2|*|1|*|2|*|em\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"5\\\"},{\\\"extra\\\":\\\"\\\",\\\"backgroundcolor\\\":\\\"ffffffff\\\"}]}\",\"content\":\"Next Slide\",\"nowrap\":\"1\",\"fullwidth\":\"0\",\"href\":\"NextSlide[]\",\"href-target\":\"_self\",\"href-rel\":\"\",\"class\":\"\",\"icon\":\"\",\"iconsize\":\"100\",\"iconspacing\":\"30\",\"iconplacement\":\"left\"}}}]},{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"left\",\"desktopportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitorder\":0,\"mobileportraitinneralign\":\"center\",\"mobileportraitorder\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-iYi6ZKk8yeVp\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"verticalalign\":\"center\",\"colwidth\":\"3/5\",\"href\":\"\",\"href-target\":\"_self\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Column\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitmaxwidth\":300,\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Image\",\"namesynced\":1,\"item\":{\"type\":\"image\",\"values\":{\"image\":\"https://smartslider3.com/wp-content/uploads/slider424/buildanddesign.png\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"size\":\"auto|*|auto\",\"alt\":\"\",\"title\":\"\",\"href-class\":\"\"}}}]}]}]}]","","https://smartslider3.com/wp-content/uploads/slider424/buildanddesign.jpg","{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"10|*|60|*|10|*|60\",\"tabletportraitpadding\":\"10|*|50|*|10|*|50\",\"mobileportraitpadding\":\"10|*|10|*|35|*|10\",\"record-slides\":0,\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"\",\"background-type\":\"image\",\"backgroundColor\":\"ffffff00\",\"backgroundGradient\":\"off\",\"backgroundColorEnd\":\"ffffff00\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"https://smartslider3.com/wp-content/uploads/slider424/slide2.png\",\"backgroundFocusX\":50,\"backgroundFocusY\":50,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.4.0\"}","2","0"),
("3","Maquette témoignage","2","1970-01-01 00:00:00","1970-01-01 00:00:00","0","0","[{\"type\":\"content\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitselfalign\":\"center\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-fcSUEGhpzUuk\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffff00\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitgutter\":20,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitwrapafter\":1,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-I7Pq55oHYACB\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffffff\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"borderradius\":25,\"boxshadow\":\"0|*|0|*|0|*|0|*|ffffffff\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Rang\\u00e9e\",\"namesynced\":1,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"center\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-rGrNUGdGJunY\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"3/10\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":215,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-aKkauLTnrUUc\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Image\",\"namesynced\":1,\"item\":{\"type\":\"image\",\"values\":{\"size\":\"200|*|200\",\"href\":\"#\",\"style\":\"\",\"image\":\"$upload$/slider2/elus.png\",\"alt\":\"\",\"title\":\"\",\"href-target\":\"_self\",\"href-rel\":\"\",\"href-class\":\"\",\"cssclass\":\"\",\"image-optimize\":\"1\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-1b10434faf71b\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"href\":\"#\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffcc\\\",\\\"size\\\":\\\"15||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-kdK6cgdM1Dmb\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"href\":\"#\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"83e0c7ff\\\",\\\"size\\\":\\\"20||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"PATRICK\",\"title\":\"\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-103f823f0b350\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"href\":\"#\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffcc\\\",\\\"size\\\":\\\"5||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-108a9b902aed9\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"content\":\"adh\\u00e9rent B\\u00f4Watts, utilisateur de nrLINK\\nFrance 3 RA\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"16||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\"}}}]},{\"type\":\"col\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-WEeqpBWnPTVn\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"7/10\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-16762e75b7c99\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"href\":\"#\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"83e0c7ff\\\",\\\"size\\\":\\\"20||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"ON SE PREND TR\\u00c8S VITE AU JEU\",\"title\":\"\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-xPDBdsKdDuR1\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"href\":\"#\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffcc\\\",\\\"size\\\":\\\"25||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":1,\"split-text-animation-in\":\"\",\"split-text-delay-in\":0,\"split-text-animation-out\":\"\",\"split-text-delay-out\":0,\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-89jNcgijARCT\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"content\":\"\\u00ab Cet objet nous permet de prendre conscience de la consommation que l\\u2019on a et de faire attention, explique Patrick. Au d\\u00e9but, je trouvais \\u00e7a un peu gadget et finalement, on se prend tr\\u00e8s vite au jeu. \\u00bb\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"16||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\"}}}]}]}]}]","","","{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"record-slides\":0,\"thumbnailAlt\":\"\",\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"kenburns-animation\":\"50|*|50|*|\",\"kenburns-animation-speed\":\"default\",\"kenburns-animation-strength\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"\",\"aria-label\":\"\",\"background-type\":\"color\",\"backgroundColor\":\"ffffff00\",\"backgroundGradient\":\"off\",\"backgroundColorEnd\":\"ffffff00\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"\",\"backgroundFocusX\":50,\"backgroundFocusY\":50,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundBlurFit\":7,\"backgroundVideoMp4\":\"\",\"backgroundVideoOpacity\":100,\"backgroundVideoLoop\":1,\"backgroundVideoReset\":1,\"backgroundVideoMode\":\"fill\",\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.1.17\"}","1","0"),
("4","Bernard","2","1970-01-01 00:00:00","1970-01-01 00:00:00","0","0","[{\"type\":\"content\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitselfalign\":\"center\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-141hX0X8h9WY\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffff00\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitgutter\":20,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitwrapafter\":1,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-7lIRm6FkWaik\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffffff\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"borderradius\":25,\"boxshadow\":\"0|*|0|*|0|*|0|*|ffffffff\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Rang\\u00e9e\",\"namesynced\":1,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":90,\"desktopportraitinneralign\":\"center\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-qvWtZwkCuUvD\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"5/48\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[]},{\"type\":\"col\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":875,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-OH8QBpYRE8iE\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"19/24\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-jDQ1hezqxtca\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"21||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content\":\"\\u00ab Nous avons pu b\\u00e9n\\u00e9ficier des -10% en passant chez B\\u00f4Watts et fixer une mensualit\\u00e9 \\u00e0 39\\u20ac. A bout d\'un an, nous avons re\\u00e7u un remboursement de 600\\u20ac donc cela fait + de 1000\\u20ac de baisse du co\\u00fbt de l\'\\u00e9lectricit\\u00e9 en un an par rapport \\u00e0 un total de 4500\\u20ac sur l\'ann\\u00e9e ! \\u00bb\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-wUmPA1LRWeP3\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffcc\\\",\\\"size\\\":\\\"15||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-QxDxvSEA648G\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"heading\":\"Bernard \\u00e0 Belleville-en-Beaujolais\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"83e0c7ff\\\",\\\"size\\\":\\\"20||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"title\":\"\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-ImqAIXhpMHOg\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffcc\\\",\\\"size\\\":\\\"5||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-iZDIwlT4qhHJ\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"16||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content\":\"abonn\\u00e9 B\\u00f4Watts depuis le 01/03/2024\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}}]},{\"type\":\"col\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-cJkHVNH3ogcx\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"5/48\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[]}]}]}]","abonné","","{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"record-slides\":0,\"thumbnailAlt\":\"\",\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"kenburns-animation\":\"50|*|50|*|\",\"kenburns-animation-speed\":\"default\",\"kenburns-animation-strength\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"\",\"aria-label\":\"\",\"background-type\":\"color\",\"backgroundColor\":\"ffffff00\",\"backgroundGradient\":\"off\",\"backgroundColorEnd\":\"ffffff00\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"\",\"backgroundFocusX\":50,\"backgroundFocusY\":50,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundBlurFit\":7,\"backgroundVideoMp4\":\"\",\"backgroundVideoOpacity\":100,\"backgroundVideoLoop\":1,\"backgroundVideoReset\":1,\"backgroundVideoMode\":\"fill\",\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.1.26\"}","2","0"),
("5","Abonnée BôWatts","2","1970-01-01 00:00:00","1970-01-01 00:00:00","0","0","[{\"type\":\"content\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitselfalign\":\"center\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-86LLegAFtj2C\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffff00\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitgutter\":20,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitwrapafter\":1,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-LIhnax5JwS03\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffffff\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"borderradius\":25,\"boxshadow\":\"0|*|0|*|0|*|0|*|ffffffff\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Rang\\u00e9e\",\"namesynced\":1,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":90,\"desktopportraitinneralign\":\"center\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-q8AeIRp7cO0H\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"5/48\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[]},{\"type\":\"col\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":875,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-EwUE12rI0Uyf\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"19/24\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-imyeAm0zQ32e\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"21||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content\":\"\\u00ab \\u00cates-vous satisfaite de votre offre B\\u00f4Watts ?\\n- Ah oui, c\'est sensationnel ! \\u00bb\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-As59d8sXfWKS\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffcc\\\",\\\"size\\\":\\\"15||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-7qgSKzh8ogXo\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"heading\":\"Abonn\\u00e9e B\\u00f4Watts\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"83e0c7ff\\\",\\\"size\\\":\\\"20||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"title\":\"\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-l8YkNpd6GU8A\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffcc\\\",\\\"size\\\":\\\"5||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-DGDiBvJ0brDD\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"content\":\"Propos recueillis sur un stand \\u00e0 Belleville-en-Beaujolais le 3/06/2025\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"16||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}}]},{\"type\":\"col\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-wWGpVduGg4WO\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"5/48\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[]}]}]}]","abonnée","","{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"record-slides\":0,\"thumbnailAlt\":\"\",\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"kenburns-animation\":\"50|*|50|*|\",\"kenburns-animation-speed\":\"default\",\"kenburns-animation-strength\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"\",\"aria-label\":\"\",\"background-type\":\"color\",\"backgroundColor\":\"ffffff00\",\"backgroundGradient\":\"off\",\"backgroundColorEnd\":\"ffffff00\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"\",\"backgroundFocusX\":50,\"backgroundFocusY\":50,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundBlurFit\":7,\"backgroundVideoMp4\":\"\",\"backgroundVideoOpacity\":100,\"backgroundVideoLoop\":1,\"backgroundVideoReset\":1,\"backgroundVideoMode\":\"fill\",\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.1.26\"}","3","0"),
("6","Abonnée BôWatts","2","1970-01-01 00:00:00","1970-01-01 00:00:00","1","0","[{\"type\":\"content\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitselfalign\":\"center\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-nKRCIy02H7yj\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffff00\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitgutter\":20,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitwrapafter\":1,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-xoojVSI0adbV\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffff00\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"borderradius\":25,\"boxshadow\":\"0|*|0|*|0|*|0|*|ffffffff\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Rang\\u00e9e\",\"namesynced\":1,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":90,\"desktopportraitinneralign\":\"center\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-18884cca7b173\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"5/48\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[]},{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":875,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-516GNNX1WKjW\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"19/24\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-0msWP5c3A1G1\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"content\":\"\\u00ab Le nrLINK, c\'est super pour se rendre compte de sa consommation. Cet hiver, nous avons fait une raclette entre amis et quand j\'ai vu la consommation instantan\\u00e9e alors que tout le monde avait termin\\u00e9 de manger, nous avons vite d\\u00e9branch\\u00e9 les appareils ! \\u00bb\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"21||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.2\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-1jiNZ8Z1nVhQ\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffff00\\\",\\\"size\\\":\\\"15||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":1,\"split-text-animation-in\":\"\",\"split-text-delay-in\":0,\"split-text-animation-out\":\"\",\"split-text-delay-out\":0,\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-fcrJcVFl69yu\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"00000080\\\",\\\"size\\\":\\\"20||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"Abonn\\u00e9e B\\u00f4Watts\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":1,\"split-text-animation-in\":\"\",\"split-text-delay-in\":0,\"split-text-animation-out\":\"\",\"split-text-delay-out\":0,\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-nej3pCS1iYGe\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffff00\\\",\\\"size\\\":\\\"5||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":1,\"split-text-animation-in\":\"\",\"split-text-delay-in\":0,\"split-text-animation-out\":\"\",\"split-text-delay-out\":0,\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-NjMLgRyjDRS0\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"16||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content\":\"Propos recueillis devant l\'\\u00e9cole Dumoulin \\u00e0 Belleville le 9/06/2025\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}}]},{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-18bb74596be36\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"5/48\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[]}]}]}]","abonnée","$upload$/2025/09/Bulle-temoignage-large.png","{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"record-slides\":0,\"thumbnailAlt\":\"\",\"thumbnailTitle\":\"\",\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"\",\"aria-label\":\"\",\"background-type\":\"image\",\"backgroundColor\":\"ffffff00\",\"backgroundGradient\":\"off\",\"backgroundColorEnd\":\"ffffff00\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"$upload$/2025/09/Bulle-temoignage-large.png\",\"backgroundFocusX\":50,\"backgroundFocusY\":50,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundBlurFit\":7,\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.1.29\"}","4","0"),
("7","Laure","2","1970-01-01 00:00:00","1970-01-01 00:00:00","0","0","[{\"type\":\"content\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitselfalign\":\"center\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-WU6E0xLqFif8\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffff00\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitgutter\":20,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitwrapafter\":1,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-mGGr7aWLchqx\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffffff\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"borderradius\":25,\"boxshadow\":\"0|*|0|*|0|*|0|*|ffffffff\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Rang\\u00e9e\",\"namesynced\":1,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":90,\"desktopportraitinneralign\":\"center\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-vMLdcRSbY49Z\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"5/48\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[]},{\"type\":\"col\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":875,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-2rQfyXGqGQOO\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"19/24\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-QHmJw4qs16xW\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"21||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content\":\"\\u00ab Je suis ravie d\\u2019\\u00eatre chez B\\u00f4Watts et je n\\u2019en partirai pas. J\\u2019ai fait \\u00e9norm\\u00e9ment d\\u2019\\u00e9conomies, plus de 50\\u20ac/mois. Je recommande \\u00e0 100%. \\u00bb\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-9vV0FWYHy07Y\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffcc\\\",\\\"size\\\":\\\"15||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-lUKX2JuuGkOI\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"heading\":\"LAURE  \\u00e0 Belleville-en-Beaujolais\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"83e0c7ff\\\",\\\"size\\\":\\\"20||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"title\":\"\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-mSaxeaZjVFOx\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffcc\\\",\\\"size\\\":\\\"5||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-NBQFPOmLe4iS\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"16||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content\":\"abonn\\u00e9e B\\u00f4Watts depuis le 13/11/2024\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}}]},{\"type\":\"col\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-GcajxjYmhxlN\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"5/48\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[]}]}]}]","abonnée","","{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"record-slides\":0,\"thumbnailAlt\":\"\",\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"kenburns-animation\":\"50|*|50|*|\",\"kenburns-animation-speed\":\"default\",\"kenburns-animation-strength\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"\",\"aria-label\":\"\",\"background-type\":\"color\",\"backgroundColor\":\"ffffff00\",\"backgroundGradient\":\"off\",\"backgroundColorEnd\":\"ffffff00\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"\",\"backgroundFocusX\":50,\"backgroundFocusY\":50,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundBlurFit\":7,\"backgroundVideoMp4\":\"\",\"backgroundVideoOpacity\":100,\"backgroundVideoLoop\":1,\"backgroundVideoReset\":1,\"backgroundVideoMode\":\"fill\",\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.1.26\"}","5","0"),
("8","Marie","2","1970-01-01 00:00:00","1970-01-01 00:00:00","0","0","[{\"type\":\"content\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitselfalign\":\"center\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-Nd0xiHFMIJjw\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffff00\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitgutter\":20,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitwrapafter\":1,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-p1mCmfyMHSqr\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffffff\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"borderradius\":25,\"boxshadow\":\"0|*|0|*|0|*|0|*|ffffffff\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Rang\\u00e9e\",\"namesynced\":1,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":90,\"desktopportraitinneralign\":\"center\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-z0mDbnCmZIGR\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"5/48\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[]},{\"type\":\"col\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":875,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-NOBhGHhvwU15\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"19/24\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-lMSIOjZ0VuzF\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"21||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content\":\"\\u00ab D\'entr\\u00e9e de jeu en passant chez B\\u00f4Watts j\'ai \\u00e9conomis\\u00e9 30\\u20ac/mois et un an apr\\u00e8s ma mensualit\\u00e9 a encore baiss\\u00e9 de 20\\u20ac.\\nEn plus, le petit bo\\u00eetier permet de se rendre compte de la consommation par poste : l\'ordi consomme finalement beaucoup moins que le four par exemple. \\u00bb\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-DgKWki4iGwug\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffcc\\\",\\\"size\\\":\\\"15||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-2cZqEKigC5t5\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"heading\":\"Marie \\u00e0 Lanci\\u00e9\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"83e0c7ff\\\",\\\"size\\\":\\\"20||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"title\":\"\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-IdpTjJXBfE0y\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffcc\\\",\\\"size\\\":\\\"5||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-ahtTks68RaxM\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"16||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content\":\"abonn\\u00e9e B\\u00f4Watts depuis le 18/01/2024\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}}]},{\"type\":\"col\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-1DJq8vUunUd8\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"5/48\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[]}]}]}]","abonnée","","{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"record-slides\":0,\"thumbnailAlt\":\"\",\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"kenburns-animation\":\"50|*|50|*|\",\"kenburns-animation-speed\":\"default\",\"kenburns-animation-strength\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"\",\"aria-label\":\"\",\"background-type\":\"color\",\"backgroundColor\":\"ffffff00\",\"backgroundGradient\":\"off\",\"backgroundColorEnd\":\"ffffff00\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"\",\"backgroundFocusX\":50,\"backgroundFocusY\":50,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundBlurFit\":7,\"backgroundVideoMp4\":\"\",\"backgroundVideoOpacity\":100,\"backgroundVideoLoop\":1,\"backgroundVideoReset\":1,\"backgroundVideoMode\":\"fill\",\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.1.26\"}","6","0"),
("9","Rémi","2","1970-01-01 00:00:00","1970-01-01 00:00:00","1","0","[{\"type\":\"content\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitselfalign\":\"center\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-qu0xE6cYInXL\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffff00\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitgutter\":20,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitwrapafter\":1,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-tOzfrgJ0YGit\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffff00\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"borderradius\":25,\"boxshadow\":\"0|*|0|*|0|*|0|*|ffffffff\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Rang\\u00e9e\",\"namesynced\":1,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":90,\"desktopportraitinneralign\":\"center\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-2nSst61EjB08\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"5/48\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[]},{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":875,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-4TkuKmXTMz1R\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"19/24\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-GKFdrGFZsAP4\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"content\":\"\\u00ab Tr\\u00e8s heureux d\\u2019apprendre que ce projet commence \\u00e0 porter ses fruits. Avec cette annonce d\\u2019une baisse  de 10% sur la facture, clairement je ne regrette pas de faire partie de ce mouvement depuis le d\\u00e9but ! \\u00bb\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"21||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.2\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-R0o7SXBFmX3h\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffff00\\\",\\\"size\\\":\\\"15||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":1,\"split-text-animation-in\":\"\",\"split-text-delay-in\":0,\"split-text-animation-out\":\"\",\"split-text-delay-out\":0,\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-lmSBM12Et3es\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"00000080\\\",\\\"size\\\":\\\"20||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"REMI \\u00e0 Saint-Georges-De-Reneins\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":1,\"split-text-animation-in\":\"\",\"split-text-delay-in\":0,\"split-text-animation-out\":\"\",\"split-text-delay-out\":0,\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-n4TUsL7tNxAC\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffff00\\\",\\\"size\\\":\\\"5||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":1,\"split-text-animation-in\":\"\",\"split-text-delay-in\":0,\"split-text-animation-out\":\"\",\"split-text-delay-out\":0,\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-haZ5cqwwax3m\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"16||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content\":\"adh\\u00e9rent B\\u00f4Watts depuis 20 mai 2023\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}}]},{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-EfoewzNOJSA9\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"5/48\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[]}]}]}]","","$upload$/2025/09/Bulle-temoignage-large.png","{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"record-slides\":0,\"thumbnailAlt\":\"\",\"thumbnailTitle\":\"\",\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"\",\"aria-label\":\"\",\"background-type\":\"image\",\"backgroundColor\":\"ffffff00\",\"backgroundGradient\":\"off\",\"backgroundColorEnd\":\"ffffff00\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"$upload$/2025/09/Bulle-temoignage-large.png\",\"backgroundFocusX\":50,\"backgroundFocusY\":50,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundBlurFit\":7,\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.1.29\"}","7","0");

INSERT IGNORE INTO `mod119_nextend2_smartslider3_slides` VALUES 
("10","Patrick","2","1970-01-01 00:00:00","1970-01-01 00:00:00","1","0","[{\"type\":\"content\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitselfalign\":\"center\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-PGRWiY3TcL45\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffff00\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitgutter\":20,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitwrapafter\":1,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-c2hKyvbaHtQi\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffff00\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"borderradius\":25,\"boxshadow\":\"0|*|0|*|0|*|0|*|ffffffff\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Rang\\u00e9e\",\"namesynced\":1,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":90,\"desktopportraitinneralign\":\"center\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-CxZQeHNSOHFF\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"5/48\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[]},{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":875,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-1LPrIH3eRRTY\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"19/24\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-JHrnHSx9mDBC\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"content\":\"\\u201cCet objet nous permet de prendre conscience de la consommation que l\\u2019on a et de faire attention, explique Patrick. Au d\\u00e9but, je trouvais \\u00e7a un peu gadget et finalement, on se prend tr\\u00e8s vite au jeu.\\u201d\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"21||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.2\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-Vj2iZyhb90BM\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffff00\\\",\\\"size\\\":\\\"15||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":1,\"split-text-animation-in\":\"\",\"split-text-delay-in\":0,\"split-text-animation-out\":\"\",\"split-text-delay-out\":0,\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-6hCAxmPrcZpl\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"00000080\\\",\\\"size\\\":\\\"20||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"PATRICK\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":1,\"split-text-animation-in\":\"\",\"split-text-delay-in\":0,\"split-text-animation-out\":\"\",\"split-text-delay-out\":0,\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-k4TVueiCYUi0\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffff00\\\",\\\"size\\\":\\\"5||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":1,\"split-text-animation-in\":\"\",\"split-text-delay-in\":0,\"split-text-animation-out\":\"\",\"split-text-delay-out\":0,\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-RmmPyFjrMw5A\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"16||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content\":\"adh\\u00e9rent B\\u00f4Watts, utilisateur de nrLINK\\nFrance 3 RA\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}}]},{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-Xo71dHLeOzf5\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"5/48\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[]}]}]}]","","$upload$/2025/09/Bulle-temoignage-large.png","{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"record-slides\":0,\"thumbnailAlt\":\"\",\"thumbnailTitle\":\"\",\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"\",\"aria-label\":\"\",\"background-type\":\"image\",\"backgroundColor\":\"ffffff00\",\"backgroundGradient\":\"off\",\"backgroundColorEnd\":\"ffffff00\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"$upload$/2025/09/Bulle-temoignage-large.png\",\"backgroundFocusX\":50,\"backgroundFocusY\":50,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundBlurFit\":7,\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.1.29\"}","8","0"),
("11","Jacky Menichon","2","1970-01-01 00:00:00","1970-01-01 00:00:00","1","0","[{\"type\":\"content\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitselfalign\":\"center\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-QcGCrwbbrXwf\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffff00\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitgutter\":20,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitwrapafter\":1,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-tF2d5GqZNoBN\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffff00\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"borderradius\":25,\"boxshadow\":\"0|*|0|*|0|*|0|*|ffffffff\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Rang\\u00e9e\",\"namesynced\":1,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":90,\"desktopportraitinneralign\":\"center\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-C61UVW5jq2Ad\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"5/48\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[]},{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":875,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-X1X9OcwJV1cn\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"19/24\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-ZAydCK6u20IZ\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"content\":\"\\u201cPour le consommateur, c\\u2019est la promesse d\\u2019un gain de 10 \\u00e0 20% sur la facture d\\u2019\\u00e9lectricit\\u00e9, anticipe Jacky Menichon, qui esp\\u00e8re convaincre assez rapidement 2000 familles et entreprises.\\u201d\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"21||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.2\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-GKwbLUjvkkaI\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffff00\\\",\\\"size\\\":\\\"15||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":1,\"split-text-animation-in\":\"\",\"split-text-delay-in\":0,\"split-text-animation-out\":\"\",\"split-text-delay-out\":0,\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-ghNUPRAx4d4I\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"00000080\\\",\\\"size\\\":\\\"20||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"JACKY MENICHON\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":1,\"split-text-animation-in\":\"\",\"split-text-delay-in\":0,\"split-text-animation-out\":\"\",\"split-text-delay-out\":0,\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-AwRn8trMR0gz\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffff00\\\",\\\"size\\\":\\\"5||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":1,\"split-text-animation-in\":\"\",\"split-text-delay-in\":0,\"split-text-animation-out\":\"\",\"split-text-delay-out\":0,\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-xLu2KLsXcETE\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"content\":\"Pr\\u00e9sident de la CCSB, Maire de Lanci\\u00e9\\nLes Echos.fr 1er juin 2023\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"16||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}}]},{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-sbSKE1h5VfEB\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"5/48\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[]}]}]}]","","$upload$/2025/09/Bulle-temoignage-large.png","{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"record-slides\":0,\"thumbnailAlt\":\"\",\"thumbnailTitle\":\"\",\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"\",\"aria-label\":\"\",\"background-type\":\"image\",\"backgroundColor\":\"ffffff00\",\"backgroundGradient\":\"off\",\"backgroundColorEnd\":\"ffffff00\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"$upload$/2025/09/Bulle-temoignage-large.png\",\"backgroundFocusX\":50,\"backgroundFocusY\":50,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundBlurFit\":7,\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.1.29\"}","9","0"),
("12","Frédéric Pronchéry","2","1970-01-01 00:00:00","1970-01-01 00:00:00","1","0","[{\"type\":\"content\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitselfalign\":\"center\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-DZOUySzp5w5Y\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffff00\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitgutter\":20,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitwrapafter\":1,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-iNlf5ZMnmtHh\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffff00\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"borderradius\":25,\"boxshadow\":\"0|*|0|*|0|*|0|*|ffffffff\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Rang\\u00e9e\",\"namesynced\":1,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":90,\"desktopportraitinneralign\":\"center\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-Dj1houCE1WtJ\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"5/48\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[]},{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":875,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-OtEYoDQKptE7\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"19/24\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-g9CXb4EOKV0e\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"content\":\"\\u201cOn a bien vu \\u00e0 travers les \\u00e9v\\u00e8nements g\\u00e9opolitiques, cette derni\\u00e8re crise de l\\u2019\\u00e9nergie, on la subit totalement et \\u00e7a c\\u2019est pas supportable. Il faut que les collectivit\\u00e9s locales offrent d\\u2019autres solutions aux administr\\u00e9s.\\u201d\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"21||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.2\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-0MIic8ur7h7F\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffff00\\\",\\\"size\\\":\\\"15||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":1,\"split-text-animation-in\":\"\",\"split-text-delay-in\":0,\"split-text-animation-out\":\"\",\"split-text-delay-out\":0,\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-mzqHXjRbgmzx\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"00000080\\\",\\\"size\\\":\\\"20||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"FR\\u00c9D\\u00c9RIC PRONCH\\u00c9RY\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":1,\"split-text-animation-in\":\"\",\"split-text-delay-in\":0,\"split-text-animation-out\":\"\",\"split-text-delay-out\":0,\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-2uUYTyQREQNJ\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffff00\\\",\\\"size\\\":\\\"5||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":1,\"split-text-animation-in\":\"\",\"split-text-delay-in\":0,\"split-text-animation-out\":\"\",\"split-text-delay-out\":0,\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-wMwUzBrA3D0d\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"content\":\"Maire de Belleville-en-Beaujolais, Vice-pr\\u00e9sident de la CCSB\\nM6\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"16||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}}]},{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-3FiM9XP6Wz8I\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"5/48\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[]}]}]}]","","$upload$/2025/09/Bulle-temoignage-large.png","{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"record-slides\":0,\"thumbnailAlt\":\"\",\"thumbnailTitle\":\"\",\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"\",\"aria-label\":\"\",\"background-type\":\"image\",\"backgroundColor\":\"ffffff00\",\"backgroundGradient\":\"off\",\"backgroundColorEnd\":\"ffffff00\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"$upload$/2025/09/Bulle-temoignage-large.png\",\"backgroundFocusX\":50,\"backgroundFocusY\":50,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundBlurFit\":7,\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.1.29\"}","10","0"),
("13","Laura Steen","2","1970-01-01 00:00:00","1970-01-01 00:00:00","1","0","[{\"type\":\"content\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitselfalign\":\"center\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-nzqhItQFNjj7\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffff00\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitgutter\":20,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitwrapafter\":1,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-EA9CBkBvFAh4\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffff00\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"borderradius\":25,\"boxshadow\":\"0|*|0|*|0|*|0|*|ffffffff\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Rang\\u00e9e\",\"namesynced\":1,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":90,\"desktopportraitinneralign\":\"center\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-1YWfEGrpoLAX\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"5/48\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[]},{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":875,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-hH2nXCxlJ3Y0\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"19/24\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-kourHcf3ca86\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"content\":\"\\u201cUn capteur intelligent pour r\\u00e9duire ses consommations d\\u2019\\u00e9nergie.\\u201d\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"21||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.2\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-cIX6Ng0IZLEW\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffff00\\\",\\\"size\\\":\\\"15||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":1,\"split-text-animation-in\":\"\",\"split-text-delay-in\":0,\"split-text-animation-out\":\"\",\"split-text-delay-out\":0,\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-vOiZ8JiNqqU5\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"00000080\\\",\\\"size\\\":\\\"20||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"LAURA STEEN\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":1,\"split-text-animation-in\":\"\",\"split-text-delay-in\":0,\"split-text-animation-out\":\"\",\"split-text-delay-out\":0,\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-y2kclte5Q7oD\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffff00\\\",\\\"size\\\":\\\"5||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":1,\"split-text-animation-in\":\"\",\"split-text-delay-in\":0,\"split-text-animation-out\":\"\",\"split-text-delay-out\":0,\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-P9qqV4bFq6pt\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"16||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content\":\"Journaliste au Progr\\u00e8s\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}}]},{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-tvZ0rZOWgupd\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"5/48\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[]}]}]}]","","$upload$/2025/09/Bulle-temoignage-large.png","{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"record-slides\":0,\"thumbnailAlt\":\"\",\"thumbnailTitle\":\"\",\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"\",\"aria-label\":\"\",\"background-type\":\"image\",\"backgroundColor\":\"ffffff00\",\"backgroundGradient\":\"off\",\"backgroundColorEnd\":\"ffffff00\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"$upload$/2025/09/Bulle-temoignage-large.png\",\"backgroundFocusX\":50,\"backgroundFocusY\":50,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundBlurFit\":7,\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.1.29\"}","11","0"),
("14","Claire Aicardi","2","1970-01-01 00:00:00","1970-01-01 00:00:00","1","0","[{\"type\":\"content\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitselfalign\":\"center\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-TYz0krkQcdIg\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffff00\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitgutter\":20,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitwrapafter\":1,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-lUiAy9EkOJGy\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffff00\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"borderradius\":25,\"boxshadow\":\"0|*|0|*|0|*|0|*|ffffffff\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Rang\\u00e9e\",\"namesynced\":1,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":90,\"desktopportraitinneralign\":\"center\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-VDwb0SIWwYwC\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"5/48\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[]},{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":875,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-0Tkd5Z4faFYa\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"19/24\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-MpUbyIr8BO0O\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"content\":\"\\u201cAu Royaume-Uni, 9 millions de foyers sont d\\u00e9j\\u00e0 \\u00e9quip\\u00e9s. En France 10 000 capteurs ont \\u00e9t\\u00e9 install\\u00e9s \\u00e0 ce jour. MyEM travaille avec des fournisseurs et nrLINK devrait notamment b\\u00e9n\\u00e9ficier aux clients en situation de pr\\u00e9carit\\u00e9.\\u201d\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"21||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.2\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-GlD5k25tfduP\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffff00\\\",\\\"size\\\":\\\"15||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":1,\"split-text-animation-in\":\"\",\"split-text-delay-in\":0,\"split-text-animation-out\":\"\",\"split-text-delay-out\":0,\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-23RMv2MvPmeU\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"00000080\\\",\\\"size\\\":\\\"20||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"CLAIRE AICARDI\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":1,\"split-text-animation-in\":\"\",\"split-text-delay-in\":0,\"split-text-animation-out\":\"\",\"split-text-delay-out\":0,\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-srGVogr5D5zO\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffff00\\\",\\\"size\\\":\\\"5||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":1,\"split-text-animation-in\":\"\",\"split-text-delay-in\":0,\"split-text-animation-out\":\"\",\"split-text-delay-out\":0,\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-mJfnEzCiUSR8\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"16||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content\":\"Europ\'Energies\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}}]},{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-XoZdal5bHZ4X\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"5/48\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[]}]}]}]","","$upload$/2025/09/Bulle-temoignage-large.png","{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"record-slides\":0,\"thumbnailAlt\":\"\",\"thumbnailTitle\":\"\",\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"\",\"aria-label\":\"\",\"background-type\":\"image\",\"backgroundColor\":\"ffffff00\",\"backgroundGradient\":\"off\",\"backgroundColorEnd\":\"ffffff00\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"$upload$/2025/09/Bulle-temoignage-large.png\",\"backgroundFocusX\":50,\"backgroundFocusY\":50,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundBlurFit\":7,\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.1.29\"}","12","0"),
("15","Maquette témoignage","3","1970-01-01 00:00:00","1970-01-01 00:00:00","0","0","[{\"type\":\"content\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitselfalign\":\"center\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-AG4HX3wHLi27\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffff00\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitgutter\":20,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitwrapafter\":1,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-Ci3Wih6u0TAB\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffffff\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"borderradius\":25,\"boxshadow\":\"0|*|0|*|0|*|0|*|ffffffff\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Rang\\u00e9e\",\"namesynced\":1,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"center\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-79YFipyqC0Zq\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"3/10\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":215,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-dR0UJ7xdAnZz\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Image\",\"namesynced\":1,\"item\":{\"type\":\"image\",\"values\":{\"size\":\"200|*|200\",\"href\":\"#\",\"style\":\"\",\"image\":\"$upload$/slider3/elus.png\",\"alt\":\"\",\"title\":\"\",\"href-target\":\"_self\",\"href-rel\":\"\",\"href-class\":\"\",\"cssclass\":\"\",\"image-optimize\":\"1\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-cYF9Jv9bgU2E\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"href\":\"#\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffcc\\\",\\\"size\\\":\\\"15||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-rctakIc3QDm9\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"href\":\"#\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"83e0c7ff\\\",\\\"size\\\":\\\"20||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"PATRICK\",\"title\":\"\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-mtjRCKKuW0vF\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"href\":\"#\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffcc\\\",\\\"size\\\":\\\"5||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-ip9lDd8n2PJo\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"content\":\"adh\\u00e9rent B\\u00f4Watts, utilisateur de nrLINK\\nFrance 3 RA\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"16||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\"}}}]},{\"type\":\"col\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-MJkj2npRDHKX\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"7/10\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-XLsNDhAYwCiP\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"href\":\"#\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"83e0c7ff\\\",\\\"size\\\":\\\"20||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"ON SE PREND TR\\u00c8S VITE AU JEU\",\"title\":\"\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-t3P14EBWysIe\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"href\":\"#\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffcc\\\",\\\"size\\\":\\\"25||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":1,\"split-text-animation-in\":\"\",\"split-text-delay-in\":0,\"split-text-animation-out\":\"\",\"split-text-delay-out\":0,\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-agcI9paC5mWL\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"content\":\"\\u00ab Cet objet nous permet de prendre conscience de la consommation que l\\u2019on a et de faire attention, explique Patrick. Au d\\u00e9but, je trouvais \\u00e7a un peu gadget et finalement, on se prend tr\\u00e8s vite au jeu. \\u00bb\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"16||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\"}}}]}]}]}]","","","{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"record-slides\":0,\"thumbnailAlt\":\"\",\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"kenburns-animation\":\"50|*|50|*|\",\"kenburns-animation-speed\":\"default\",\"kenburns-animation-strength\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"\",\"aria-label\":\"\",\"background-type\":\"color\",\"backgroundColor\":\"ffffff00\",\"backgroundGradient\":\"off\",\"backgroundColorEnd\":\"ffffff00\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"\",\"backgroundFocusX\":50,\"backgroundFocusY\":50,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundBlurFit\":7,\"backgroundVideoMp4\":\"\",\"backgroundVideoOpacity\":100,\"backgroundVideoLoop\":1,\"backgroundVideoReset\":1,\"backgroundVideoMode\":\"fill\",\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.1.17\"}","1","0"),
("16","Jonathan","3","1970-01-01 00:00:00","1970-01-01 00:00:00","1","0","[{\"type\":\"content\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitselfalign\":\"center\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-vv24EkXdn4Kk\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffff00\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitgutter\":20,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitwrapafter\":1,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-redmqLyBnZ8V\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffff00\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"borderradius\":25,\"boxshadow\":\"0|*|0|*|0|*|0|*|ffffffff\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Rang\\u00e9e\",\"namesynced\":1,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":90,\"desktopportraitinneralign\":\"center\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-qygGxRTn7Vd2\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"5/48\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[]},{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":875,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-zuCxfw7WUDXC\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"19/24\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-f1oRKMFRgVV2\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"content\":\"\\u00ab J\'ai d\\u00e9m\\u00e9nag\\u00e9 mon entreprise le 3 f\\u00e9vrier et j\'ai pu b\\u00e9n\\u00e9ficier d\'un contrat d\'\\u00e9lectricit\\u00e9 chez B\\u00f4Watts PRO directement. Tout s\'est pass\\u00e9 tr\\u00e8s facilement par \\u00e9changes de mails et par t\\u00e9l\\u00e9phone. \\u00bb\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"21||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.2\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-sKUpuebqF7yM\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffff00\\\",\\\"size\\\":\\\"15||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":1,\"split-text-animation-in\":\"\",\"split-text-delay-in\":0,\"split-text-animation-out\":\"\",\"split-text-delay-out\":0,\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-F7pDPpxpA0nx\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1b212758\\\",\\\"size\\\":\\\"20||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"Jonathan, Entreprise L.A.C.S. \\u00e0 Saint-Lager\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":1,\"split-text-animation-in\":\"\",\"split-text-delay-in\":0,\"split-text-animation-out\":\"\",\"split-text-delay-out\":0,\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-fvS2TwHyBmwz\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffff00\\\",\\\"size\\\":\\\"5||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":1,\"split-text-animation-in\":\"\",\"split-text-delay-in\":0,\"split-text-animation-out\":\"\",\"split-text-delay-out\":0,\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-nbX37i8UspqY\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"16||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content\":\"abonn\\u00e9 B\\u00f4Watts PRO depuis le 03/02/2025\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}}]},{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-kzRm7pp17G2M\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"5/48\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[]}]}]}]","abonné PRO","$upload$/2025/09/Bulle-temoignage-large.png","{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"record-slides\":0,\"thumbnailAlt\":\"\",\"thumbnailTitle\":\"\",\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"\",\"aria-label\":\"\",\"background-type\":\"image\",\"backgroundColor\":\"ffffff00\",\"backgroundGradient\":\"off\",\"backgroundColorEnd\":\"ffffff00\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"$upload$/2025/09/Bulle-temoignage-large.png\",\"backgroundFocusX\":40,\"backgroundFocusY\":41,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundBlurFit\":7,\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.1.29\"}","2","0"),
("17","Jacky Menichon","3","1970-01-01 00:00:00","1970-01-01 00:00:00","0","0","[{\"type\":\"content\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitselfalign\":\"center\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-fDqXZdGBCfaL\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffff00\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitgutter\":20,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitwrapafter\":1,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-HMG7Tqz5hCzG\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffffff\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"borderradius\":25,\"boxshadow\":\"0|*|0|*|0|*|0|*|ffffffff\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Rang\\u00e9e\",\"namesynced\":1,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":90,\"desktopportraitinneralign\":\"center\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-IyQ7sGEmtUpq\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"5/48\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[]},{\"type\":\"col\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":875,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-qjIt5sLkQcFW\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"19/24\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-D4MU5z1ohGbI\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"content\":\"\\u201cPour le consommateur, c\\u2019est la promesse d\\u2019un gain de 10 \\u00e0 20% sur la facture d\\u2019\\u00e9lectricit\\u00e9, anticipe Jacky Menichon, qui esp\\u00e8re convaincre assez rapdiment 2000 familles et entreprises.\\u201d\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"21||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-uk83sKQ1YmMs\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"href\":\"#\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffcc\\\",\\\"size\\\":\\\"15||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-uFvXvQNnxiAS\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"heading\":\"JACKY MENICHON\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"83e0c7ff\\\",\\\"size\\\":\\\"20||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"title\":\"\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-ZRrhlhSvtkEd\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"href\":\"#\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffcc\\\",\\\"size\\\":\\\"5||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-gxwP7UiXhaiR\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"content\":\"Pr\\u00e9sident de la CCB, Maire de Lanci\\u00e9\\nLes Echos.fr 1er juin 2023\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"16||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}}]},{\"type\":\"col\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-zZwn343vG4mT\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"5/48\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[]}]}]}]","","","{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"record-slides\":0,\"thumbnailAlt\":\"\",\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"kenburns-animation\":\"50|*|50|*|\",\"kenburns-animation-speed\":\"default\",\"kenburns-animation-strength\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"\",\"aria-label\":\"\",\"background-type\":\"color\",\"backgroundColor\":\"ffffff00\",\"backgroundGradient\":\"off\",\"backgroundColorEnd\":\"ffffff00\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"\",\"backgroundFocusX\":50,\"backgroundFocusY\":50,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundBlurFit\":7,\"backgroundVideoMp4\":\"\",\"backgroundVideoOpacity\":100,\"backgroundVideoLoop\":1,\"backgroundVideoReset\":1,\"backgroundVideoMode\":\"fill\",\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.1.17\"}","10","0"),
("18","Frédéric Pronchéry","3","1970-01-01 00:00:00","1970-01-01 00:00:00","0","0","[{\"type\":\"content\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitselfalign\":\"center\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-KKBNugmjofpo\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffff00\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitgutter\":20,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitwrapafter\":1,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-Q8tIqgACKW1o\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffffff\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"borderradius\":25,\"boxshadow\":\"0|*|0|*|0|*|0|*|ffffffff\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Rang\\u00e9e\",\"namesynced\":1,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":90,\"desktopportraitinneralign\":\"center\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-0nhW7L1STDGy\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"5/48\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[]},{\"type\":\"col\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":875,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-DWPtQtsw7s0Q\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"19/24\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-PTcgeEQhZAUc\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"content\":\"\\u201cOn a bien vu \\u00e0 travers les \\u00e9v\\u00e8nements g\\u00e9opolitiques, cette derni\\u00e8re crise de l\\u2019\\u00e9nerg\\u00e9tique, on la subit totalement et \\u00e7a c\\u2019est pas supportable. Il faut que les collectivit\\u00e9s locales offrent d\\u2019autres solutions aux administr\\u00e9s.\\u201d\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"21||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-Nn86GrAGKEf6\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffcc\\\",\\\"size\\\":\\\"15||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-h92eIobYELjn\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"heading\":\"FR\\u00c9D\\u00c9RIC PRONCH\\u00c9RY\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"83e0c7ff\\\",\\\"size\\\":\\\"20||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"title\":\"\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-d2QOA3RwmRds\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffcc\\\",\\\"size\\\":\\\"5||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-HIMNVhPxA0px\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"content\":\"Maire de Belleville\\nM6\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"16||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}}]},{\"type\":\"col\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-LpmBh5BJvzUp\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"5/48\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[]}]}]}]","","","{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"record-slides\":0,\"thumbnailAlt\":\"\",\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"kenburns-animation\":\"50|*|50|*|\",\"kenburns-animation-speed\":\"default\",\"kenburns-animation-strength\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"\",\"aria-label\":\"\",\"background-type\":\"color\",\"backgroundColor\":\"ffffff00\",\"backgroundGradient\":\"off\",\"backgroundColorEnd\":\"ffffff00\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"\",\"backgroundFocusX\":50,\"backgroundFocusY\":50,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundBlurFit\":7,\"backgroundVideoMp4\":\"\",\"backgroundVideoOpacity\":100,\"backgroundVideoLoop\":1,\"backgroundVideoReset\":1,\"backgroundVideoMode\":\"fill\",\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.1.17\"}","11","0"),
("19","Le Patriote Beaujolais","4","1970-01-01 00:00:00","1970-01-01 00:00:00","1","0","[{\"type\":\"content\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitselfalign\":\"center\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-Jusw96xYSoGe\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffff00\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitgutter\":20,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitwrapafter\":1,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-wzPL84mmwFaD\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffffff\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"borderradius\":25,\"boxshadow\":\"0|*|0|*|0|*|0|*|ffffffff\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Rang\\u00e9e\",\"namesynced\":1,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"center\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-ShosrPydObk2\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"3/10\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"left\",\"id\":\"\",\"uniqueclass\":\"n-uc-170b88588adcc\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Image\",\"namesynced\":1,\"item\":{\"type\":\"image\",\"values\":{\"image\":\"$upload$/2025/10/Banque-des-territoires-600x300-1.webp\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"size\":\"auto|*|auto\",\"alt\":\"\",\"title\":\"\",\"href-class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-bwUJF98DK2nL\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"heading\":\"B\\u00f4Watts, une marque d\\u2019\\u00e9lectricit\\u00e9 verte intercommunale\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"83e0c7ff\\\",\\\"size\\\":\\\"20||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"center\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\"}}}]},{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-ORECRe2u8DYI\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"7/10\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-jsUVCoNIkYMQ\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"content\":\"<b>B\\u00f4Watts, une marque d\\u2019\\u00e9lectricit\\u00e9 verte intercommunale</b>\\nTerritoire \\u00e0 \\u00e9nergie positive depuis 2016, engag\\u00e9e dans la r\\u00e9novation \\u00e9nerg\\u00e9tique des logements particuliers et des b\\u00e2timents publics et dans la production d\\u2019\\u00e9nergie photovolta\\u00efque, la communaut\\u00e9 de communes Sa\\u00f4ne Beaujolais a lanc\\u00e9 en 2024 B\\u00f4Watts, sa marque maison d\\u2019\\u00e9nergie verte. Les habitants abonn\\u00e9s b\\u00e9n\\u00e9ficient d\\u2019un tarif tr\\u00e8s avantageux. \",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"16||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-lwG2MoN13KNw\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffcc\\\",\\\"size\\\":\\\"25||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":1,\"split-text-animation-in\":\"\",\"split-text-delay-in\":0,\"split-text-animation-out\":\"\",\"split-text-delay-out\":0,\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"left\",\"id\":\"\",\"uniqueclass\":\"n-uc-x8I7RffUc2CH\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Bouton\",\"namesynced\":1,\"item\":{\"type\":\"button\",\"values\":{\"content\":\"LIRE L\'ARTICLE\",\"font\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"14||px\\\",\\\"align\\\":\\\"center\\\"}, {\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"backgroundcolor\\\":\\\"83e0c7ff\\\",\\\"opacity\\\":100,\\\"padding\\\":\\\"10|*|30|*|10|*|30|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"99\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"fullwidth\":\"0\",\"nowrap\":\"1\",\"href\":\"https://www.banquedesterritoires.fr/experience/belleville-en-beaujolais-une-marque-delectricite-verte-intercommunale-69\",\"href-target\":\"_blank\",\"href-rel\":\"\"}}}]}]}]}]","","","{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"record-slides\":0,\"thumbnailAlt\":\"\",\"thumbnailTitle\":\"\",\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"\",\"aria-label\":\"\",\"background-type\":\"color\",\"backgroundColor\":\"ffffff00\",\"backgroundGradient\":\"off\",\"backgroundColorEnd\":\"ffffff00\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"\",\"backgroundFocusX\":50,\"backgroundFocusY\":50,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundBlurFit\":7,\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.1.29\"}","1","0");

INSERT IGNORE INTO `mod119_nextend2_smartslider3_slides` VALUES 
("20","Le Progrès","4","1970-01-01 00:00:00","1970-01-01 00:00:00","1","0","[{\"type\":\"content\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitselfalign\":\"center\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-NYorwtFsfIg2\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffff00\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitgutter\":20,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitwrapafter\":1,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-6iWktuDWUTUT\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffffff\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"borderradius\":25,\"boxshadow\":\"0|*|0|*|0|*|0|*|ffffffff\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Rang\\u00e9e\",\"namesynced\":1,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"center\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-O5hKrhfJRsL9\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"3/10\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"left\",\"id\":\"\",\"uniqueclass\":\"n-uc-eOvzlZOiSZ4X\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Image\",\"namesynced\":1,\"item\":{\"type\":\"image\",\"values\":{\"style\":\"\",\"image\":\"$upload$/slider4/logo-le-progres.png\",\"alt\":\"\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"href-class\":\"\",\"size\":\"auto|*|auto\",\"cssclass\":\"\",\"image-optimize\":\"1\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-KRnqrtyIVnLU\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"83e0c7ff\\\",\\\"size\\\":\\\"20||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"center\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"DEVENEZ CLIENT DE B\\u00d4WATTS,  LA MARQUE LOCALE D\'\\u00c9LECTRICIT\\u00c9 VERTE\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}}]},{\"type\":\"col\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-yD0hFF5H3aJb\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"7/10\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-CLtd4yqKhMkw\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"content\":\"<b>B\\u00f4Watts : la marque locale d\\u2019\\u00e9lectricit\\u00e9 verte baisse ses tarifs</b>\\n974 abonn\\u00e9s, B\\u00f4Watts esp\\u00e8re bien les multiplier par deux d\\u2019ici la fin de l\\u2019ann\\u00e9e 2025. Chez les professionnels, Corcelles a \\u00e9t\\u00e9 la premi\\u00e8re mairie test.\\n\\nhttps://www.leprogres.fr/societe/2025/03/23/bowatts-la-marque-locale-d-electricite-verte-baisse-ses-tarifs\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"16||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-u5l4ARAhiEZg\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffcc\\\",\\\"size\\\":\\\"25||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":1,\"split-text-animation-in\":\"\",\"split-text-delay-in\":0,\"split-text-animation-out\":\"\",\"split-text-delay-out\":0,\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"left\",\"id\":\"\",\"uniqueclass\":\"n-uc-tXSsZT4bAblq\",\"generatorvisible\":\"\",\"generatorvisible2\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Bouton\",\"namesynced\":1,\"item\":{\"type\":\"button\",\"values\":{\"content\":\"LIRE L\'ARTICLE\",\"font\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"14||px\\\",\\\"align\\\":\\\"center\\\"}, {\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"backgroundcolor\\\":\\\"83e0c7ff\\\",\\\"opacity\\\":100,\\\"padding\\\":\\\"10|*|30|*|10|*|30|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"99\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"fullwidth\":\"0\",\"nowrap\":\"1\",\"href\":\"https://www.bowatts-beaujolais.fr/wp-content/uploads/2025/03/Capture-decran-2025-03-25-181015.png\",\"href-target\":\"_blank\",\"href-rel\":\"\",\"icon\":\"\",\"iconsize\":\"100\",\"iconspacing\":\"30\",\"iconplacement\":\"left\",\"class\":\"\"}}}]}]}]}]","","","{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"record-slides\":0,\"thumbnailAlt\":\"\",\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"kenburns-animation\":\"50|*|50|*|\",\"kenburns-animation-speed\":\"default\",\"kenburns-animation-strength\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"\",\"aria-label\":\"\",\"background-type\":\"color\",\"backgroundColor\":\"ffffff00\",\"backgroundGradient\":\"off\",\"backgroundColorEnd\":\"ffffff00\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"\",\"backgroundFocusX\":50,\"backgroundFocusY\":50,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundBlurFit\":7,\"backgroundVideoMp4\":\"\",\"backgroundVideoOpacity\":100,\"backgroundVideoLoop\":1,\"backgroundVideoReset\":1,\"backgroundVideoMode\":\"fill\",\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.1.26\"}","3","0"),
("21","Le Patriote Beaujolais","4","1970-01-01 00:00:00","1970-01-01 00:00:00","1","0","[{\"type\":\"content\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitselfalign\":\"center\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-QGsvr4nKnhxV\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffff00\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitgutter\":20,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitwrapafter\":1,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-8jWkyo145xk4\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffffff\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"borderradius\":25,\"boxshadow\":\"0|*|0|*|0|*|0|*|ffffffff\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Rang\\u00e9e\",\"namesynced\":1,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"center\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-tfInrQkuYeyB\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"3/10\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"left\",\"id\":\"\",\"uniqueclass\":\"n-uc-9IFmUlf4XbGn\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Image\",\"namesynced\":1,\"item\":{\"type\":\"image\",\"values\":{\"image\":\"$upload$/slider4/logo-le-patriote.png\",\"style\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"size\":\"auto|*|auto\",\"alt\":\"\",\"title\":\"\",\"image-optimize\":\"1\",\"href-class\":\"\",\"cssclass\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-WyaVS4VEHJpC\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"heading\":\"B\\u00f4Watts, marque d\\u00e9pos\\u00e9e\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"83e0c7ff\\\",\\\"size\\\":\\\"20||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"center\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"title\":\"\",\"class\":\"\"}}}]},{\"type\":\"col\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-oUTqtu5Bx0m9\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"7/10\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-lVf56OgOv2jE\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"content\":\"Cette marque d\'\\u00e9lectricit\\u00e9 verte, lanc\\u00e9e en mai 2023 dans le Beaujolais, a \\u00e9t\\u00e9 d\\u00e9pos\\u00e9e aupr\\u00e8s de l\'Institu national de la propri\\u00e9t\\u00e9 industrielle (Inpi).\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"16||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-fW0HpDfT6EEk\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"href\":\"#\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffcc\\\",\\\"size\\\":\\\"25||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":1,\"split-text-animation-in\":\"\",\"split-text-delay-in\":0,\"split-text-animation-out\":\"\",\"split-text-delay-out\":0,\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"left\",\"id\":\"\",\"uniqueclass\":\"n-uc-6DvM3twj8dJa\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Bouton\",\"namesynced\":1,\"item\":{\"type\":\"button\",\"values\":{\"content\":\"LIRE L\'ARTICLE\",\"font\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"14||px\\\",\\\"align\\\":\\\"center\\\"}, {\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"backgroundcolor\\\":\\\"83e0c7ff\\\",\\\"opacity\\\":100,\\\"padding\\\":\\\"10|*|30|*|10|*|30|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"99\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"fullwidth\":\"0\",\"nowrap\":\"1\",\"href\":\"https://www.bowatts-beaujolais.fr/wp-content/uploads/2024/01/2023-12-28_BoWatts_Le_Patriote.pdf\",\"href-target\":\"_blank\",\"href-rel\":\"\",\"icon\":\"\",\"iconsize\":\"100\",\"iconspacing\":\"30\",\"iconplacement\":\"left\",\"class\":\"\"}}}]}]}]}]","","","{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"record-slides\":0,\"thumbnailAlt\":\"\",\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"kenburns-animation\":\"50|*|50|*|\",\"kenburns-animation-speed\":\"default\",\"kenburns-animation-strength\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"\",\"aria-label\":\"\",\"background-type\":\"color\",\"backgroundColor\":\"ffffff00\",\"backgroundGradient\":\"off\",\"backgroundColorEnd\":\"ffffff00\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"\",\"backgroundFocusX\":50,\"backgroundFocusY\":50,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundBlurFit\":7,\"backgroundVideoMp4\":\"\",\"backgroundVideoOpacity\":100,\"backgroundVideoLoop\":1,\"backgroundVideoReset\":1,\"backgroundVideoMode\":\"fill\",\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.1.19\"}","4","0"),
("22","Le Progrès","4","1970-01-01 00:00:00","1970-01-01 00:00:00","1","0","[{\"type\":\"content\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitselfalign\":\"center\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-HzISys8QTySd\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffff00\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitgutter\":20,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitwrapafter\":1,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-8Q6WQLiNXqjv\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffffff\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"borderradius\":25,\"boxshadow\":\"0|*|0|*|0|*|0|*|ffffffff\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Rang\\u00e9e\",\"namesynced\":1,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"center\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-gQUuNwHW7NwW\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"3/10\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"left\",\"id\":\"\",\"uniqueclass\":\"n-uc-kZA5FKK36NpU\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Image\",\"namesynced\":1,\"item\":{\"type\":\"image\",\"values\":{\"image\":\"$upload$/slider4/logo-le-progres.png\",\"style\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"size\":\"auto|*|auto\",\"alt\":\"\",\"title\":\"\",\"image-optimize\":\"1\",\"href-class\":\"\",\"cssclass\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-DteoNMZaf8BU\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"heading\":\"DEVENEZ CLIENT DE B\\u00d4WATTS,  LA MARQUE LOCALE D\'\\u00c9LECTRICIT\\u00c9 VERTE\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"83e0c7ff\\\",\\\"size\\\":\\\"20||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"center\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"title\":\"\",\"class\":\"\"}}}]},{\"type\":\"col\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-VHIxZkm97nGW\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"7/10\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-nAn3uxwkPfOD\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"content\":\"La Communaut\\u00e9 de Communes Sa\\u00f4ne Beaujolais a mis en place une marque locale d\'\\u00e9lectricit\\u00e9 verte pour les 35 communes de son secteur, en partenariat avec la start-up lyonnaise My Energy Manager et le fournisseur d\'\\u00e9lectricit\\u00e9 Alpiq.\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"16||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-EaErqGGo1FTv\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"href\":\"#\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffcc\\\",\\\"size\\\":\\\"25||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":1,\"split-text-animation-in\":\"\",\"split-text-delay-in\":0,\"split-text-animation-out\":\"\",\"split-text-delay-out\":0,\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"left\",\"id\":\"\",\"uniqueclass\":\"n-uc-ToDNf5T7VQXr\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Bouton\",\"namesynced\":1,\"item\":{\"type\":\"button\",\"values\":{\"content\":\"LIRE L\'ARTICLE\",\"font\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"14||px\\\",\\\"align\\\":\\\"center\\\"}, {\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"backgroundcolor\\\":\\\"83e0c7ff\\\",\\\"opacity\\\":100,\\\"padding\\\":\\\"10|*|30|*|10|*|30|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"99\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"fullwidth\":\"0\",\"nowrap\":\"1\",\"href\":\"https://www.bowatts-beaujolais.fr/wp-content/uploads/2024/01/20240101_BoWatts_LeProgres.pdf\",\"href-target\":\"_blank\",\"href-rel\":\"\",\"icon\":\"\",\"iconsize\":\"100\",\"iconspacing\":\"30\",\"iconplacement\":\"left\",\"class\":\"\"}}}]}]}]}]","","","{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"record-slides\":0,\"thumbnailAlt\":\"\",\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"kenburns-animation\":\"50|*|50|*|\",\"kenburns-animation-speed\":\"default\",\"kenburns-animation-strength\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"\",\"aria-label\":\"\",\"background-type\":\"color\",\"backgroundColor\":\"ffffff00\",\"backgroundGradient\":\"off\",\"backgroundColorEnd\":\"ffffff00\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"\",\"backgroundFocusX\":50,\"backgroundFocusY\":50,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundBlurFit\":7,\"backgroundVideoMp4\":\"\",\"backgroundVideoOpacity\":100,\"backgroundVideoLoop\":1,\"backgroundVideoReset\":1,\"backgroundVideoMode\":\"fill\",\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.1.19\"}","5","0"),
("23","Tribune de Lyon","4","1970-01-01 00:00:00","1970-01-01 00:00:00","1","0","[{\"type\":\"content\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitselfalign\":\"center\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-Dq0fAWQhWFPL\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffff00\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitgutter\":20,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitwrapafter\":1,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-ftGPoJPnvEPx\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffffff\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"borderradius\":25,\"boxshadow\":\"0|*|0|*|0|*|0|*|ffffffff\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Rang\\u00e9e\",\"namesynced\":1,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"center\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-6IWaBI9MWbyr\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"3/10\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"left\",\"id\":\"\",\"uniqueclass\":\"n-uc-ENRBE3qSLSKD\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Image\",\"namesynced\":1,\"item\":{\"type\":\"image\",\"values\":{\"style\":\"\",\"image\":\"$upload$/slider4/bowatts-_0002_tribunedelyon.jpg\",\"alt\":\"\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"href-class\":\"\",\"size\":\"auto|*|auto\",\"cssclass\":\"\",\"image-optimize\":1}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-yohnPdQiAvSE\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"83e0c7ff\\\",\\\"size\\\":\\\"20||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"center\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"LE BEAUJOLAIS LANCE B\\u00d4WATTS, SA MARQUE D\'\\u00c9LECTRICIT\\u00c9 VERTE\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}}]},{\"type\":\"col\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-8DbpjM8yUThq\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"7/10\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-42XiIgrar6Gm\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"16||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content\":\"La communaut\\u00e9 de communes Sa\\u00f4ne Beaujolais a lanc\\u00e9 ce mardi 9 mai la commercialisation de B\\u00f4watts, sa propre marque d\\u2019\\u00e9nergie \\u00e0 destination de ses habitants. La promesse : \\u00ab un tarif 7\\u2009% inf\\u00e9rieur \\u00e0 n\\u2019importe quelle offre verte actuellement, et le m\\u00eame prix que n\\u2019importe quelle \\u00e9nergie grise, r\\u00e9sume Fr\\u00e9d\\u00e9ric Pronchery, vice-pr\\u00e9sident de la collectivit\\u00e9 et maire de Belleville-en-Beaujolais. Et ceux qui disposent d\\u2019un compteur Linky se verront fournir un bo\\u00eetier de donn\\u00e9es connect\\u00e9 qui permet de suivre sa consommation en temps r\\u00e9el et d\\u2019esp\\u00e9rer effectuer des \\u00e9conomies de 20\\u2009%. \\u00bb\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-pJMLvxwVCGz8\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffcc\\\",\\\"size\\\":\\\"25||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":1,\"split-text-animation-in\":\"\",\"split-text-delay-in\":0,\"split-text-animation-out\":\"\",\"split-text-delay-out\":0,\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"left\",\"id\":\"\",\"uniqueclass\":\"n-uc-Wc6v9TMMyqE0\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Bouton\",\"namesynced\":1,\"item\":{\"type\":\"button\",\"values\":{\"content\":\"LIRE L\'ARTICLE\",\"font\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"14||px\\\",\\\"align\\\":\\\"center\\\"}, {\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"backgroundcolor\\\":\\\"83e0c7ff\\\",\\\"opacity\\\":100,\\\"padding\\\":\\\"10|*|30|*|10|*|30|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"99\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"fullwidth\":\"0\",\"nowrap\":\"1\",\"href\":\"https://cdn.reputation.onclusive.com/t/snxTwJqrl-f9HExBc4sEC93Gi8rQXKKw-pdf-zC/FR80078440_986526790_src\",\"href-target\":\"_blank\",\"href-rel\":\"\",\"icon\":\"\",\"iconsize\":\"100\",\"iconspacing\":\"30\",\"iconplacement\":\"left\",\"class\":\"\"}}}]}]}]}]","","","{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"record-slides\":0,\"thumbnailAlt\":\"\",\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"kenburns-animation\":\"50|*|50|*|\",\"kenburns-animation-speed\":\"default\",\"kenburns-animation-strength\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"\",\"aria-label\":\"\",\"background-type\":\"color\",\"backgroundColor\":\"ffffff00\",\"backgroundGradient\":\"off\",\"backgroundColorEnd\":\"ffffff00\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"\",\"backgroundFocusX\":50,\"backgroundFocusY\":50,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundBlurFit\":7,\"backgroundVideoMp4\":\"\",\"backgroundVideoOpacity\":100,\"backgroundVideoLoop\":1,\"backgroundVideoReset\":1,\"backgroundVideoMode\":\"fill\",\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.1.17\"}","6","0"),
("24","Lemoniteur.fr","4","1970-01-01 00:00:00","1970-01-01 00:00:00","1","0","[{\"type\":\"content\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitselfalign\":\"center\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-QPAxjmSPz3pP\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffff00\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitgutter\":20,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitwrapafter\":1,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-sJpu30IwJmP6\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffffff\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"borderradius\":25,\"boxshadow\":\"0|*|0|*|0|*|0|*|ffffffff\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Rang\\u00e9e\",\"namesynced\":1,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"center\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-RfdLt5uvaKRv\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"3/10\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"center\",\"id\":\"\",\"uniqueclass\":\"n-uc-ocG84Ak7DWgb\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Image\",\"namesynced\":1,\"item\":{\"type\":\"image\",\"values\":{\"image\":\"$upload$/slider4/bowatts-_0030_lemoniteur.jpg\",\"style\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"size\":\"180|*|180\",\"alt\":\"\",\"title\":\"\",\"image-optimize\":\"1\",\"href-class\":\"\",\"cssclass\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-gNiRfK7NASQf\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"heading\":\"\\nRh\\u00f4ne : \\u00e9lectricit\\u00e9 verte\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"83e0c7ff\\\",\\\"size\\\":\\\"20||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"center\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"uppercase\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"title\":\"\",\"class\":\"\"}}}]},{\"type\":\"col\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-COwEvHIHNKBd\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"7/10\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-oLQcCoqVVjFC\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"16||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content\":\"La communaut\\u00e9 de communes Sa\\u00f4ne-Beaujolais, qui repr\\u00e9sente 35 communes totalisant 45 000 habitants, a cr\\u00e9\\u00e9 sa boucle locale d\'\\u00e9lectricit\\u00e9 verte en partenariat avec la start-up lyonnaise My Energy Manager. Elle ambitionne ainsi de proposer aux administr\\u00e9s d\'acheter l\'\\u00e9lectricit\\u00e9 produite \\u00e0 un tarif n\\u00e9goci\\u00e9 et de devenir un territoire \\u00e0 \\u00e9nergie positive.\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-tt2SkxsLcCdx\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffcc\\\",\\\"size\\\":\\\"25||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":1,\"split-text-animation-in\":\"\",\"split-text-delay-in\":0,\"split-text-animation-out\":\"\",\"split-text-delay-out\":0,\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"left\",\"id\":\"\",\"uniqueclass\":\"n-uc-SiZ3TgDeCU6I\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Bouton\",\"namesynced\":1,\"item\":{\"type\":\"button\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"14||px\\\",\\\"align\\\":\\\"center\\\"}, {\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"backgroundcolor\\\":\\\"83e0c7ff\\\",\\\"opacity\\\":100,\\\"padding\\\":\\\"10|*|30|*|10|*|30|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"99\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"content\":\"LIRE L\'ARTICLE\",\"nowrap\":\"1\",\"fullwidth\":\"0\",\"href\":\"https://www.lemoniteur.fr/article/rhone-electricite-verte.2272602\",\"href-target\":\"_blank\",\"href-rel\":\"\",\"class\":\"\",\"icon\":\"\",\"iconsize\":\"100\",\"iconspacing\":\"30\",\"iconplacement\":\"left\"}}}]}]}]}]","","","{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"record-slides\":0,\"thumbnailAlt\":\"\",\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"kenburns-animation\":\"50|*|50|*|\",\"kenburns-animation-speed\":\"default\",\"kenburns-animation-strength\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"\",\"aria-label\":\"\",\"background-type\":\"color\",\"backgroundColor\":\"ffffff00\",\"backgroundGradient\":\"off\",\"backgroundColorEnd\":\"ffffff00\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"\",\"backgroundFocusX\":50,\"backgroundFocusY\":50,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundBlurFit\":7,\"backgroundVideoMp4\":\"\",\"backgroundVideoOpacity\":100,\"backgroundVideoLoop\":1,\"backgroundVideoReset\":1,\"backgroundVideoMode\":\"fill\",\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.1.17\"}","7","0"),
("25","M6","4","1970-01-01 00:00:00","1970-01-01 00:00:00","1","0","[{\"type\":\"content\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitselfalign\":\"center\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-NaYkMjqM49SN\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffff00\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitgutter\":20,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitwrapafter\":1,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-KbSFYzu5wgDO\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffffff\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"borderradius\":25,\"boxshadow\":\"0|*|0|*|0|*|0|*|ffffffff\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Rang\\u00e9e\",\"namesynced\":1,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"center\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-UUss8im1qUxE\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"3/10\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"center\",\"id\":\"\",\"uniqueclass\":\"n-uc-ey4DfnaEHmNx\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Image\",\"namesynced\":1,\"item\":{\"type\":\"image\",\"values\":{\"style\":\"\",\"image\":\"$upload$/slider4/bowatts-_0017_m6.jpg\",\"alt\":\"\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"href-class\":\"\",\"size\":\"auto|*|auto\",\"cssclass\":\"\",\"image-optimize\":\"1\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-5ENqwdYiYuon\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"heading\":\"Le 12H45\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"83e0c7ff\\\",\\\"size\\\":\\\"20||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"center\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"uppercase\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"title\":\"\",\"class\":\"\"}}}]},{\"type\":\"col\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-BQZpX8cuPbq1\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"7/10\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-oxsPCv2iBEiB\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"000000ff\\\",\\\"size\\\":\\\"16||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto,Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content\":\"Un projet de loi sur l\'industrie verte a \\u00e9t\\u00e9 pr\\u00e9sent\\u00e9 en conseil des ministres. Pour la premi\\u00e8re fois en France, une collectivit\\u00e9 lance sa marque locale d\'\\u00e9lectricit\\u00e9 verte, le tout \\u00e0 des tarifs tr\\u00e8s attractifs.\\nReportage d\'Eric Herv\\u00e9.\\nInterview de Fr\\u00e9d\\u00e9ric Pronch\\u00e9ry, vice-pr\\u00e9sident de la communaut\\u00e9 de communes de Belleville-en-Beaujolais. Pr\\u00e8s des autoroutes, il souhaite massifier les panneaux photovolta\\u00efques. \\nInterview d\'Anthony Parsons, directeur My Energy Manager.\\nInterview de Patrick Nasl\\u00e8s, testeur de Bowatts.\\nInterview d\' Olivier Puit, pr\\u00e9sident d\'Alpiq France.\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-2ixWwKobJY9j\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d&#039;en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffcc\\\",\\\"size\\\":\\\"25||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":800,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"B\\u00f4watts\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":1,\"split-text-animation-in\":\"\",\"split-text-delay-in\":0,\"split-text-animation-out\":\"\",\"split-text-delay-out\":0,\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"left\",\"id\":\"\",\"uniqueclass\":\"n-uc-SS2SDV3lgG98\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Bouton\",\"namesynced\":1,\"item\":{\"type\":\"button\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"14||px\\\",\\\"align\\\":\\\"center\\\"}, {\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"backgroundcolor\\\":\\\"83e0c7ff\\\",\\\"opacity\\\":100,\\\"padding\\\":\\\"10|*|30|*|10|*|30|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"99\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"content\":\"LIRE L\'ARTICLE\",\"nowrap\":\"1\",\"fullwidth\":\"0\",\"href\":\"https://media.reputation.onclusive.com/stream?vdmcrypt=KIea9k0rYXrRPN2eso0XN3jf4JHpBWwCuqk%2f%2f%2bf7G1Ee9x2Owzd69SKGpQQsM0TZ%2flNAEzUM%2bAQLrlUc22HH51PgkUuYkRYd4YLivc2HYOPkm9%2bD1xNicaV%2fp9Ao4BwdVXtlIKbxZyog%2fSAXpfC%2fsP%2bv38XPai4ldx8dkfpMGT0BELMOYB5oh4hXaO%2bpFAP17DI3mFCf9GhVMgnvITsuxU8tZ1Ur8sFaO4xcpnheq85F1kB68Kl59abmh0y2y7HJU3Sl45p9gCO7wbArU37lOX7xDzBCuwqdp0O6Zeg1vO%2fDqi1gFMbyBmN8EwllbT0A\",\"href-target\":\"_blank\",\"href-rel\":\"\",\"class\":\"\",\"icon\":\"\",\"iconsize\":\"100\",\"iconspacing\":\"30\",\"iconplacement\":\"left\"}}}]}]}]}]","","","{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"record-slides\":0,\"thumbnailAlt\":\"\",\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"kenburns-animation\":\"50|*|50|*|\",\"kenburns-animation-speed\":\"default\",\"kenburns-animation-strength\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"\",\"aria-label\":\"\",\"background-type\":\"color\",\"backgroundColor\":\"ffffff00\",\"backgroundGradient\":\"off\",\"backgroundColorEnd\":\"ffffff00\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"\",\"backgroundFocusX\":50,\"backgroundFocusY\":50,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundBlurFit\":7,\"backgroundVideoMp4\":\"\",\"backgroundVideoOpacity\":100,\"backgroundVideoLoop\":1,\"backgroundVideoReset\":1,\"backgroundVideoMode\":\"fill\",\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.1.17\"}","8","0"),
("26","La Provence","4","1970-01-01 00:00:00","1970-01-01 00:00:00","1","0","[{\"type\":\"content\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitselfalign\":\"center\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-ixVTkdV7ehzm\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffff00\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"30|*|30|*|30|*|30\",\"desktopportraitgutter\":20,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitwrapafter\":1,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-AprBa6jj1Lfk\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffffff\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"borderradius\":25,\"boxshadow\":\"0|*|0|*|0|*|0|*|ffffffff\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Rang\\u00e9e\",\"namesynced\":1,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"animv2\":\"\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"center\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-8r8DVCj9SmXL\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"mouseenter\":\"\",\"click\":\"\",\"mouseleave\":\"\",\"play\":\"\",\"pause\":\"\",\"stop\":\"\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"